/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.dump;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.dump.Compare;
import de.independit.scheduler.server.dump.DumpGrant;
import de.independit.scheduler.server.dump.DumpGroupGeneric;
import de.independit.scheduler.server.dump.DumpUser;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.repository.SDMSGroup;
import de.independit.scheduler.server.repository.SDMSMember;
import de.independit.scheduler.server.repository.SDMSMemberTable;
import java.util.Collections;
import java.util.Vector;

class DumpGroup
extends DumpGroupGeneric {
    public static final String __version = "@(#) $Id: DumpGroup.java,v 2.3.14.1 2013/03/14 10:24:12 ronald Exp $";
    private Vector usrList;

    DumpGroup(SystemEnvironment systemEnvironment, SDMSGroup sDMSGroup) throws SDMSException {
        super(systemEnvironment, sDMSGroup);
    }

    @Override
    final void collect(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector vector = SDMSMemberTable.idx_gId.getVector(systemEnvironment, this.gId);
        int n = vector.size();
        this.usrList = new Vector(n);
        for (int i = 0; i < n; ++i) {
            SDMSMember sDMSMember = (SDMSMember)vector.get(i);
            Long l = sDMSMember.getUId(systemEnvironment);
            this.usrList.add(DumpUser.getDumpedName(systemEnvironment, l));
        }
        Collections.sort(this.usrList, Compare.ObjectNames);
        DumpGrant.getDumpedList(systemEnvironment, this.gId);
    }

    @Override
    final void render(String string) {
        super.render(string);
        if (!this.usrList.isEmpty()) {
            DumpGroup.println("\t// users = (");
            DumpGroup.println("\t//\t" + DumpGroup.join(",\n\t//\t", this.usrList) + ')');
        }
    }
}

