/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.dump;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.dump.Compare;
import de.independit.scheduler.server.dump.Dump;
import de.independit.scheduler.server.dump.DumpNamedResource;
import de.independit.scheduler.server.dump.DumpResourceStateDefinition;
import de.independit.scheduler.server.dump.DumpResourceStateMappingProfile;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSResourceReqStates;
import de.independit.scheduler.server.repository.SDMSResourceReqStatesTable;
import de.independit.scheduler.server.repository.SDMSResourceRequirement;
import de.independit.scheduler.server.repository.SDMSResourceRequirementTable;
import java.util.Collections;
import java.util.Vector;

class DumpResourceRequirement {
    public static final String __version = "@(#) $Id: DumpResourceRequirement.java,v 2.3.18.1 2013/03/14 10:24:13 ronald Exp $";
    private static SDMSResourceRequirement rr;

    private static final String getResName(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = rr.getNrId(systemEnvironment);
        return DumpNamedResource.getDumpedName(systemEnvironment, l);
    }

    private static final Integer getUsage(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = rr.getNrId(systemEnvironment);
        SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, l);
        return sDMSNamedResource.getUsage(systemEnvironment);
    }

    private static final String getAmount(SystemEnvironment systemEnvironment) throws SDMSException {
        return rr.getAmount(systemEnvironment).toString();
    }

    private static final String getLockmode(SystemEnvironment systemEnvironment) throws SDMSException {
        return rr.getLockmodeAsString(systemEnvironment).toLowerCase();
    }

    private static final String getStateMapping(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = rr.getRsmpId(systemEnvironment);
        if (l == null) {
            return "none";
        }
        return DumpResourceStateMappingProfile.getDumpedName(systemEnvironment, l);
    }

    private static final String getKeep(SystemEnvironment systemEnvironment) throws SDMSException {
        return rr.getKeepModeAsString(systemEnvironment).toLowerCase();
    }

    private static final String getSticky(SystemEnvironment systemEnvironment) throws SDMSException {
        return rr.getIsSticky(systemEnvironment) != false ? "sticky" : "nosticky";
    }

    private static final String getExpired(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = rr.getExpiredAmount(systemEnvironment);
        if (n == null) {
            return "none";
        }
        String string = rr.getExpiredBaseAsString(systemEnvironment);
        return Dump.intervalText(n, string);
    }

    private static final String getStates(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = rr.getId(systemEnvironment);
        Vector vector = SDMSResourceReqStatesTable.idx_rrId.getVector(systemEnvironment, l);
        if (vector.isEmpty()) {
            return "none";
        }
        int n = vector.size();
        Vector<String> vector2 = new Vector<String>(n);
        for (int i = 0; i < n; ++i) {
            SDMSResourceReqStates sDMSResourceReqStates = (SDMSResourceReqStates)vector.get(i);
            Long l2 = sDMSResourceReqStates.getRsdId(systemEnvironment);
            vector2.add(DumpResourceStateDefinition.getDumpedName(systemEnvironment, l2));
        }
        Collections.sort(vector2, Compare.Lexically);
        return "(\n\t\t\t\t\t" + Dump.join(",\n\t\t\t\t\t", vector2) + ')';
    }

    static final Vector getList(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        Vector vector = SDMSResourceRequirementTable.idx_seId.getVector(systemEnvironment, l);
        int n = vector.size();
        Vector vector2 = new Vector(n);
        for (int i = 0; i < n; ++i) {
            rr = (SDMSResourceRequirement)vector.get(i);
            Vector<String> vector3 = new Vector<String>();
            vector3.add(DumpResourceRequirement.getResName(systemEnvironment));
            Integer n2 = DumpResourceRequirement.getUsage(systemEnvironment);
            switch (n2) {
                case 1: {
                    break;
                }
                case 2: {
                    String string = DumpResourceRequirement.getAmount(systemEnvironment);
                    if (string != null) {
                        vector3.add("amount = " + string);
                    }
                    vector3.add(DumpResourceRequirement.getKeep(systemEnvironment));
                    break;
                }
                case 4: {
                    String string = DumpResourceRequirement.getAmount(systemEnvironment);
                    if (string != null) {
                        vector3.add("amount = " + string);
                    }
                    vector3.add("lockmode = " + DumpResourceRequirement.getLockmode(systemEnvironment));
                    vector3.add("state_mapping = " + DumpResourceRequirement.getStateMapping(systemEnvironment));
                    vector3.add(DumpResourceRequirement.getKeep(systemEnvironment));
                    vector3.add(DumpResourceRequirement.getSticky(systemEnvironment));
                    vector3.add("expired = " + DumpResourceRequirement.getExpired(systemEnvironment));
                    vector3.add("states = " + DumpResourceRequirement.getStates(systemEnvironment));
                    break;
                }
                case 8: {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "04207162129", "unexpected CATEGORY usage"));
                }
                default: {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "04207162118", "Unknown resource usage: $1", n2));
                }
            }
            vector2.add(vector3);
        }
        Collections.sort(vector2, Compare.Lexically_Vect0);
        return vector2;
    }

    private DumpResourceRequirement() {
    }
}

