/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.dump;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.dump.Compare;
import de.independit.scheduler.server.dump.DumpResourceStateDefinition;
import de.independit.scheduler.server.dump.DumpResourceStateProfileGeneric;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.repository.SDMSResourceState;
import de.independit.scheduler.server.repository.SDMSResourceStateProfile;
import de.independit.scheduler.server.repository.SDMSResourceStateTable;
import java.util.Collections;
import java.util.Vector;

class DumpResourceStateProfile
extends DumpResourceStateProfileGeneric {
    public static final String __version = "@(#) $Id: DumpResourceStateProfile.java,v 2.3.14.1 2013/03/14 10:24:14 ronald Exp $";
    private Vector stateDefs;
    private String initialState;

    DumpResourceStateProfile(SystemEnvironment systemEnvironment, SDMSResourceStateProfile sDMSResourceStateProfile) throws SDMSException {
        super(systemEnvironment, sDMSResourceStateProfile);
    }

    private final void loadStates(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector vector = SDMSResourceStateTable.idx_rspId.getVector(systemEnvironment, this.rspId);
        int n = vector.size();
        this.stateDefs = new Vector(n);
        for (int i = 0; i < n; ++i) {
            SDMSResourceState sDMSResourceState = (SDMSResourceState)vector.get(i);
            Long l = sDMSResourceState.getRsdId(systemEnvironment);
            this.stateDefs.add(DumpResourceStateDefinition.getDumpedName(systemEnvironment, l));
        }
        Collections.sort(this.stateDefs, Compare.Lexically);
    }

    private final void loadInitialState(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.rsp.getInitialRsdId(systemEnvironment);
        if (l != null) {
            this.initialState = DumpResourceStateDefinition.getDumpedName(systemEnvironment, l);
        }
    }

    @Override
    final void collect(SystemEnvironment systemEnvironment) throws SDMSException {
        this.loadStates(systemEnvironment);
        this.loadInitialState(systemEnvironment);
    }

    @Override
    final void render(String string) {
        DumpResourceStateProfile.println(string + " resource_state_profile " + this.getName());
        DumpResourceStateProfile.println("\twith");
        DumpResourceStateProfile.println("\t\tstates = (");
        DumpResourceStateProfile.print("\t\t\t" + DumpResourceStateProfile.join(",\n\t\t\t", this.stateDefs) + ")");
        if (this.initialState != null) {
            DumpResourceStateProfile.println(',');
            DumpResourceStateProfile.print("\t\tinitial_state = " + this.initialState);
        }
        DumpResourceStateProfile.println(';');
    }
}

