/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.exception;

import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.util.SDMSThread;

public class SDMSException
extends Exception {
    public static final String __version = "@(#) $Id: SDMSException.java,v 2.2.18.1 2013/03/14 10:24:17 ronald Exp $";
    public static boolean debug = false;
    protected SDMSMessage m;

    public SDMSException() {
        if (debug) {
            SDMSThread.doTrace(null, this.toString(), this.getStackTrace(), 3);
        }
        if (this.checkTrace()) {
            this.printStackTrace();
        }
    }

    public SDMSException(String string) {
        super(string);
        if (debug) {
            SDMSThread.doTrace(null, string, this.getStackTrace(), 3);
        }
        if (this.checkTrace()) {
            this.printStackTrace();
        }
    }

    public SDMSException(SDMSMessage sDMSMessage) {
        this.m = sDMSMessage;
        if (debug) {
            SDMSThread.doTrace(null, sDMSMessage.toString(), this.getStackTrace(), 3);
        }
        if (this.checkTrace()) {
            this.printStackTrace();
        }
    }

    private boolean checkTrace() {
        long l = this.getExceptionNumber();
        try {
            SDMSThread sDMSThread = (SDMSThread)Thread.currentThread();
            if ((sDMSThread.exceptionsToTrace & l) != 0L) {
                return true;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return false;
    }

    public static void toggleDebug() {
        debug = !debug;
    }

    public static void debugOn() {
        debug = true;
    }

    public static void debugOff() {
        debug = false;
    }

    public String errNumber() {
        if (this.m != null) {
            return this.m.errNumber();
        }
        return "-1";
    }

    @Override
    public String toString() {
        if (this.m != null) {
            return this.m.toString();
        }
        return super.toString();
    }

    public SDMSMessage toSDMSMessage() {
        return this.m;
    }

    public void setMessage(SDMSMessage sDMSMessage) {
        this.m = sDMSMessage;
    }

    public int getExceptionNumber() {
        return 2048;
    }
}

