/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.locking;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.DeadlockException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.InterruptedLockException;
import de.independit.scheduler.server.exception.NotMyDeadlockException;
import de.independit.scheduler.server.locking.LockingSystemSynchronized;
import de.independit.scheduler.server.locking.ObjectLock;
import de.independit.scheduler.server.util.SDMSThread;
import java.util.HashSet;
import java.util.Vector;

public class LockingSystem {
    public static int DEBUG_ALL = 1;
    public static int DEBUG_WAIT_AND_NOTIFY = 2;
    public static int DEBUG_RELEASE = 4;
    public static int DEBUG_DEADLOCK_DETECTION = 8;
    public static int DEBUG_SPECIAL = 16;
    public static int DEBUG_STACK_TRACES = 32;
    public static int DEBUG_FREE = 64;
    public static int debug = 0;
    public static long DEADLOCK_TIMEOUT_MS = 0L;
    private static Object deadlockDetectionLock = new Object();
    private static SDMSThread deadlockDetectionThread = null;
    private static int deadlockDetectionWaitCount = 0;

    public static void lock(SystemEnvironment systemEnvironment, Object object, int n) throws DeadlockException, InterruptedLockException {
        SDMSThread sDMSThread = systemEnvironment.thread;
        if (sDMSThread.lastSerializationException != null) {
            System.out.println("Unhandled SerializationException " + sDMSThread.lastSerializationException.toString() + " in Thread " + Thread.currentThread().getName());
            System.out.println("StackTrace:");
            new Exception().printStackTrace();
            System.out.println("StackTrace of unhandled Exception:");
            sDMSThread.lastSerializationException.printStackTrace();
            System.exit(0);
        }
        if ((debug & DEBUG_ALL) != 0) {
            System.out.println(Thread.currentThread().getName() + ":LockingSystem.lock(" + ObjectLock.objectToShortString(object) + ", mode = " + n + ")");
        }
        ObjectLock objectLock = LockingSystemSynchronized.getLock(systemEnvironment, object, n);
        if (objectLock.wait) {
            try {
                objectLock.syncLock.doWait(systemEnvironment);
                if (objectLock.wait) {
                    System.out.println("doWait() returned with ObjectLockWait Flag still set in Thread " + Thread.currentThread().getName());
                    new Exception().printStackTrace();
                    System.exit(0);
                }
            }
            catch (DeadlockException deadlockException) {
                sDMSThread.lastSerializationException = deadlockException;
                LockingSystemSynchronized.resetWait(sDMSThread);
                throw deadlockException;
            }
            catch (InterruptedException interruptedException) {
                InterruptedLockException interruptedLockException = new InterruptedLockException();
                sDMSThread.lastSerializationException = interruptedLockException;
                LockingSystemSynchronized.resetWait(sDMSThread);
                throw new InterruptedLockException();
            }
        }
    }

    protected static void deadlockDetection(SystemEnvironment systemEnvironment, SDMSThread sDMSThread) throws DeadlockException, NotMyDeadlockException {
        LockingSystem.startDeadlockDetection(sDMSThread);
        if ((debug & (DEBUG_ALL | DEBUG_DEADLOCK_DETECTION)) != 0) {
            System.out.println(Thread.currentThread().getName() + ":DeadlockDetection started");
        }
        try {
            LockingSystemSynchronized.deadlockDetection(systemEnvironment, sDMSThread, new HashSet<SDMSThread>());
        }
        catch (NotMyDeadlockException notMyDeadlockException) {
            LockingSystem.endDeadlockDetection();
            throw notMyDeadlockException;
        }
        catch (DeadlockException deadlockException) {
            String string = ObjectLock.getStackTrace();
            DeadlockException.countAndTraceDeadlock(string);
            throw deadlockException;
        }
        if ((debug & (DEBUG_ALL | DEBUG_DEADLOCK_DETECTION)) != 0) {
            System.out.println(Thread.currentThread().getName() + ":DeadlockDetection finished");
        }
        LockingSystem.endDeadlockDetection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startDeadlockDetection(SDMSThread sDMSThread) {
        if ((debug & (DEBUG_ALL | DEBUG_DEADLOCK_DETECTION)) != 0) {
            System.out.println(Thread.currentThread().getName() + ":startDeadlockDetection check for running deadlock detection");
        }
        Object object = deadlockDetectionLock;
        synchronized (object) {
            if (deadlockDetectionThread != null) {
                if ((debug & (DEBUG_ALL | DEBUG_DEADLOCK_DETECTION)) != 0) {
                    System.out.println(Thread.currentThread().getName() + ":startDeadlockDetection start wait for running deadlock detection");
                }
                try {
                    ++deadlockDetectionWaitCount;
                    deadlockDetectionLock.wait();
                    if ((debug & (DEBUG_ALL | DEBUG_DEADLOCK_DETECTION)) != 0) {
                        System.out.println(Thread.currentThread().getName() + ":startDeadlockDetection end wait for running deadlock detection");
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    --deadlockDetectionWaitCount;
                }
            }
            deadlockDetectionThread = sDMSThread;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void endDeadlockDetection() {
        Object object = deadlockDetectionLock;
        synchronized (object) {
            deadlockDetectionThread = null;
            if (deadlockDetectionWaitCount > 0) {
                if ((debug & (DEBUG_ALL | DEBUG_DEADLOCK_DETECTION)) != 0) {
                    System.out.println(Thread.currentThread().getName() + ":endDeadlockDetection notify waiting deadlock detection");
                }
                deadlockDetectionLock.notify();
            } else if ((debug & (DEBUG_ALL | DEBUG_DEADLOCK_DETECTION)) != 0) {
                System.out.println(Thread.currentThread().getName() + ":endDeadlockDetection no waiting deadlock detection");
            }
        }
    }

    public static void release(SystemEnvironment systemEnvironment) throws FatalException {
        systemEnvironment.thread.lastSerializationException = null;
        LockingSystem.notifyLocks(systemEnvironment, LockingSystemSynchronized.release(systemEnvironment));
        if (deadlockDetectionThread == systemEnvironment.thread) {
            if ((debug & (DEBUG_ALL | DEBUG_DEADLOCK_DETECTION)) != 0) {
                System.out.println(Thread.currentThread().getName() + ":release closing deadlock detection");
            }
            LockingSystem.endDeadlockDetection();
        }
    }

    public static void releaseSubTxLocks(SystemEnvironment systemEnvironment, long l) throws FatalException {
        LockingSystem.notifyLocks(systemEnvironment, LockingSystemSynchronized.releaseSubTxLocks(systemEnvironment, l));
    }

    public static void release(SystemEnvironment systemEnvironment, Object object) throws FatalException {
        LockingSystem.notifyLocks(systemEnvironment, LockingSystemSynchronized.release(systemEnvironment, object));
    }

    public static void releaseToCheckPoint(SystemEnvironment systemEnvironment, Object object, long l) throws FatalException {
        LockingSystem.notifyLocks(systemEnvironment, LockingSystemSynchronized.releaseToCheckPoint(systemEnvironment, object, l));
    }

    private static void notifyLocks(SystemEnvironment systemEnvironment, Vector<ObjectLock> vector) {
        if (vector == null) {
            return;
        }
        for (ObjectLock objectLock : vector) {
            objectLock.syncLock.doNotify(systemEnvironment);
        }
    }
}

