/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.WithItem;
import de.independit.scheduler.server.repository.SDMSEnvironment;
import de.independit.scheduler.server.repository.SDMSEnvironmentTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSNamedEnvironment;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import java.util.Vector;

public class AlterEnvironment
extends Node {
    public static final String __version = "@(#) $Id: AlterEnvironment.java,v 2.7.14.1 2013/03/14 10:24:19 ronald Exp $";
    private ObjectURL url;
    private Vector resourceList;
    private Boolean add;
    private boolean noerr;

    public AlterEnvironment(ObjectURL objectURL, boolean bl, Vector vector, Boolean bl2) {
        this.url = objectURL;
        this.add = bl;
        this.resourceList = vector;
        this.noerr = bl2;
    }

    public AlterEnvironment(ObjectURL objectURL, Vector vector, Boolean bl) {
        this.url = objectURL;
        this.resourceList = vector;
        this.add = null;
        this.noerr = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSNamedEnvironment sDMSNamedEnvironment;
        try {
            sDMSNamedEnvironment = (SDMSNamedEnvironment)this.url.resolve(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            if (this.noerr) {
                this.result.setFeedback(new SDMSMessage(systemEnvironment, "03311122352", "No Environment altered"));
                return;
            }
            throw notFoundException;
        }
        Long l = sDMSNamedEnvironment.getId(systemEnvironment);
        if (this.add == null) {
            if (this.resourceList != null) {
                int n;
                Vector vector = SDMSEnvironmentTable.idx_neId.getVector(systemEnvironment, l);
                for (n = 0; n < vector.size(); ++n) {
                    SDMSEnvironment sDMSEnvironment = (SDMSEnvironment)vector.get(n);
                    sDMSEnvironment.delete(systemEnvironment);
                }
                for (n = 0; n < this.resourceList.size(); ++n) {
                    WithItem withItem = (WithItem)this.resourceList.get(n);
                    String string = (String)withItem.value;
                    if (string != null && string.trim().equals("")) {
                        string = null;
                    }
                    SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getNamedResource(systemEnvironment, (Vector)((Object)withItem.key));
                    SDMSEnvironmentTable.table.create(systemEnvironment, l, sDMSNamedResource.getId(systemEnvironment), string);
                }
            }
        } else if (this.add.booleanValue()) {
            for (int i = 0; i < this.resourceList.size(); ++i) {
                WithItem withItem = (WithItem)this.resourceList.get(i);
                String string = (String)withItem.value;
                if (string != null && string.trim().equals("")) {
                    string = null;
                }
                SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getNamedResource(systemEnvironment, (Vector)((Object)withItem.key));
                SDMSEnvironmentTable.table.create(systemEnvironment, l, sDMSNamedResource.getId(systemEnvironment), string);
            }
        } else {
            for (int i = 0; i < this.resourceList.size(); ++i) {
                SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getNamedResource(systemEnvironment, (Vector)this.resourceList.get(i));
                Long l2 = sDMSNamedResource.getId(systemEnvironment);
                SDMSEnvironment sDMSEnvironment = SDMSEnvironmentTable.idx_neId_nrId_getUnique(systemEnvironment, new SDMSKey(l, l2));
                Vector vector = SDMSSchedulingEntityTable.idx_neId.getVector(systemEnvironment, l);
                int n = 0;
                while (i < vector.size()) {
                    SDMSSchedulingEntity sDMSSchedulingEntity = (SDMSSchedulingEntity)vector.get(n);
                    if (sDMSSchedulingEntity.checkParameterRI(systemEnvironment, l2)) {
                        throw new CommonErrorException(new SDMSMessage(systemEnvironment, "0340911291423", "A parameter of Resource $1 is referenced by $2", sDMSNamedResource.pathString(systemEnvironment), sDMSSchedulingEntity.pathString(systemEnvironment)));
                    }
                    ++n;
                }
                sDMSEnvironment.delete(systemEnvironment);
            }
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03201230216", "Environment altered"));
    }
}

