/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.ManipObjectMonitor;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSInstanceValue;
import de.independit.scheduler.server.repository.SDMSInstanceValueTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSMemberTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSObjectInstance;
import de.independit.scheduler.server.repository.SDMSObjectInstanceProxyGeneric;
import de.independit.scheduler.server.repository.SDMSObjectInstanceTable;
import de.independit.scheduler.server.repository.SDMSObjectMonitor;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import de.independit.scheduler.server.repository.SDMSUser;
import de.independit.scheduler.server.repository.SDMSUserTable;
import de.independit.scheduler.server.repository.SDMSWatchType;
import de.independit.scheduler.server.repository.SDMSWatchTypeParameter;
import de.independit.scheduler.server.repository.SDMSWatchTypeParameterTable;
import de.independit.scheduler.server.repository.SDMSWatchTypeTable;
import de.independit.scheduler.server.util.PathVector;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;

public class AlterObjectMonitor
extends ManipObjectMonitor {
    public static final String __version = "@(#) $Id: AlterObjectMonitor.java,v 2.1.4.3 2013/03/20 06:42:57 ronald Exp $";
    private ObjectURL url;
    private WithHash with;
    private boolean noerr;
    private Vector doiv = null;
    private Vector noiv = null;
    private Vector coiv = null;
    private Vector roiv = null;

    public AlterObjectMonitor(ObjectURL objectURL, WithHash withHash, Boolean bl) {
        this.url = objectURL;
        this.with = withHash;
        this.noerr = bl;
    }

    public AlterObjectMonitor(ObjectURL objectURL, WithHash withHash, Boolean bl, boolean bl2) {
        this.url = objectURL;
        this.with = withHash;
        this.noerr = bl;
        this.cmdtype = 4;
    }

    protected boolean setInstanceVariables(SystemEnvironment systemEnvironment, SDMSWatchType sDMSWatchType, SDMSObjectInstance sDMSObjectInstance, WithHash withHash) throws SDMSException {
        boolean bl = false;
        Iterator iterator = withHash.keySet().iterator();
        Long l = sDMSWatchType.getId(systemEnvironment);
        Long l2 = sDMSObjectInstance.getId(systemEnvironment);
        while (iterator.hasNext()) {
            SDMSWatchTypeParameter sDMSWatchTypeParameter;
            String string = (String)iterator.next();
            String string2 = (String)withHash.get(string);
            if (string2 != null) {
                string2 = "=" + string2;
            }
            boolean bl2 = (sDMSWatchTypeParameter = SDMSWatchTypeParameterTable.idx_wtId_name_getUnique(systemEnvironment, new SDMSKey(l, (Comparable)((Object)string)))).getType(systemEnvironment) == 2;
            Long l3 = sDMSWatchTypeParameter.getId(systemEnvironment);
            try {
                SDMSInstanceValue sDMSInstanceValue = SDMSInstanceValueTable.idx_oiId_wtpId_getUnique(systemEnvironment, new SDMSKey(l2, l3));
                String string3 = sDMSInstanceValue.getValue(systemEnvironment);
                if (string3 == null && string2 != null) {
                    sDMSInstanceValue.setValue(systemEnvironment, string2);
                    if (!bl2) continue;
                    bl = true;
                    continue;
                }
                if (string3 == null || string3.equals(string2)) continue;
                sDMSInstanceValue.setValue(systemEnvironment, string2);
                if (!bl2) continue;
                bl = true;
            }
            catch (NotFoundException notFoundException) {
                SDMSInstanceValueTable.table.create(systemEnvironment, string2, l2, l3);
                if (!bl2) continue;
                bl = true;
            }
        }
        return bl;
    }

    protected void processInstances(SystemEnvironment systemEnvironment, WithHash withHash, SDMSObjectMonitor sDMSObjectMonitor, SDMSWatchType sDMSWatchType, Vector vector) throws SDMSException {
        Object object;
        this.doiv = new Vector();
        this.coiv = new Vector();
        this.noiv = new Vector();
        this.roiv = new Vector();
        Date date = new Date();
        Long l = date.getTime();
        Long l2 = sDMSObjectMonitor.getId(systemEnvironment);
        Vector vector2 = SDMSObjectInstanceTable.idx_omId.getVector(systemEnvironment, l2);
        for (int i = 0; i < vector2.size(); ++i) {
            Object object2 = (SDMSObjectInstance)vector2.get(i);
            object = ((SDMSObjectInstanceProxyGeneric)object2).getUniqueName(systemEnvironment);
            if (withHash.containsKey(object)) {
                if (withHash.get(object) != null) {
                    if (((SDMSObjectInstanceProxyGeneric)object2).getRemoveTs(systemEnvironment) != null) {
                        ((SDMSObjectInstanceProxyGeneric)object2).setRemoveTs(systemEnvironment, null);
                        this.setInstanceVariables(systemEnvironment, sDMSWatchType, (SDMSObjectInstance)object2, (WithHash)withHash.get(object));
                        this.roiv.add(object2);
                    } else if (this.setInstanceVariables(systemEnvironment, sDMSWatchType, (SDMSObjectInstance)object2, (WithHash)withHash.get(object))) {
                        ((SDMSObjectInstanceProxyGeneric)object2).setModifyTs(systemEnvironment, l);
                        this.coiv.add(object2);
                    }
                }
                withHash.remove(object);
                continue;
            }
            if (((SDMSObjectInstanceProxyGeneric)object2).getRemoveTs(systemEnvironment) != null) continue;
            ((SDMSObjectInstanceProxyGeneric)object2).setRemoveTs(systemEnvironment, l);
            this.doiv.add(object2);
        }
        for (Object object2 : withHash.keySet()) {
            if (withHash.get(object2) == null) continue;
            object = SDMSObjectInstanceTable.table.create(systemEnvironment, (String)object2, l2, null, null);
            this.setInstanceVariables(systemEnvironment, sDMSWatchType, (SDMSObjectInstance)object, (WithHash)withHash.get(object2));
            this.noiv.add(object);
        }
    }

    protected void alterByJob(SystemEnvironment systemEnvironment, SDMSObjectMonitor sDMSObjectMonitor, SDMSWatchType sDMSWatchType, Vector vector) throws SDMSException {
        WithHash withHash = this.with;
        this.processInstances(systemEnvironment, withHash, sDMSObjectMonitor, sDMSWatchType, vector);
        SDMSSubmittedEntity sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, this.env.uid());
        sDMSObjectMonitor.trigger(systemEnvironment, this.noiv, this.coiv, this.doiv, this.roiv, sDMSSubmittedEntity);
    }

    protected void alterByOperator(SystemEnvironment systemEnvironment, SDMSObjectMonitor sDMSObjectMonitor, SDMSWatchType sDMSWatchType, Vector vector) throws SDMSException {
        WithHash withHash;
        Comparable comparable;
        Object object;
        Long l = this.env.uid();
        SDMSUser sDMSUser = SDMSUserTable.getObject(systemEnvironment, l);
        if (this.with.containsKey("GROUP")) {
            object = (String)this.with.get("GROUP");
            Long l2 = SDMSGroupTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)object, SDMSConstants.lZERO)).getId(systemEnvironment);
            if (!SDMSMemberTable.idx_gId_uId.containsKey(systemEnvironment, new SDMSKey(l2, l)) && !SDMSMemberTable.idx_gId_uId.containsKey(systemEnvironment, new SDMSKey(SDMSObject.adminGId, l))) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02108241539", "User $1 does not belong to Group $2", sDMSUser.getName(systemEnvironment), object));
            }
            sDMSObjectMonitor.setOwnerId(systemEnvironment, l2);
        }
        if ((object = (Integer)this.with.get("RECREATE")) != null) {
            sDMSObjectMonitor.setRecreateHandling(systemEnvironment, (Integer)object);
        }
        Long l3 = null;
        PathVector pathVector = (PathVector)this.with.get("WATCHER");
        if (pathVector != null) {
            comparable = SDMSSchedulingEntityTable.get(systemEnvironment, pathVector, null);
            l3 = comparable.getId(systemEnvironment);
            sDMSObjectMonitor.setWatchSeId(systemEnvironment, l3);
        } else if (this.with.containsKey("WATCHER")) {
            sDMSObjectMonitor.setWatchSeId(systemEnvironment, null);
        }
        comparable = sDMSObjectMonitor.getId(systemEnvironment);
        WithHash withHash2 = (WithHash)this.with.get("PARAMETERS");
        this.processParams(systemEnvironment, withHash2, vector, (Long)comparable, sDMSWatchType);
        WithHash withHash3 = (WithHash)this.with.get("DELETE");
        Integer n = null;
        Integer n2 = null;
        if (withHash3 != null) {
            n = (Integer)withHash3.get("MULT");
            n2 = (Integer)withHash3.get("INTERVAL");
        }
        if (this.with.containsKey("DELETE")) {
            sDMSObjectMonitor.setDeleteAmount(systemEnvironment, n);
            sDMSObjectMonitor.setDeleteBase(systemEnvironment, n2);
        }
        WithHash withHash4 = (WithHash)this.with.get("EVENT");
        Integer n3 = null;
        Integer n4 = null;
        if (withHash4 != null) {
            n3 = (Integer)withHash4.get("MULT");
            n4 = (Integer)withHash4.get("INTERVAL");
        }
        if (this.with.containsKey("EVENT")) {
            sDMSObjectMonitor.setEventDeleteAmount(systemEnvironment, n3);
            sDMSObjectMonitor.setEventDeleteBase(systemEnvironment, n4);
        }
        if ((withHash = (WithHash)this.with.get("INSTANCE")) != null) {
            this.processInstances(systemEnvironment, withHash, sDMSObjectMonitor, sDMSWatchType, vector);
        }
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSObjectMonitor sDMSObjectMonitor;
        systemEnvironment.checkFeatureAvailability("OBJECT_MONITOR");
        try {
            sDMSObjectMonitor = (SDMSObjectMonitor)this.url.resolve(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            if (this.noerr) {
                this.result.setFeedback(new SDMSMessage(systemEnvironment, "02108241806", "No Object Type altered"));
                return;
            }
            throw notFoundException;
        }
        Long l = sDMSObjectMonitor.getWtId(systemEnvironment);
        SDMSWatchType sDMSWatchType = SDMSWatchTypeTable.getObject(systemEnvironment, l);
        Vector vector = SDMSWatchTypeParameterTable.idx_wtId.getVector(systemEnvironment, l);
        if (systemEnvironment.cEnv.isJob()) {
            this.alterByJob(systemEnvironment, sDMSObjectMonitor, sDMSWatchType, vector);
        } else {
            this.alterByOperator(systemEnvironment, sDMSObjectMonitor, sDMSWatchType, vector);
        }
        sDMSObjectMonitor.purgeInstances(systemEnvironment, 0L);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "02108241807", "Object Type altered"));
    }
}

