/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.ScopeConfig;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import java.util.Vector;

public class MoveScope
extends Node {
    public static final String __version = "@(#) $Id: MoveScope.java,v 2.3.2.1 2013/03/14 10:24:41 ronald Exp $";
    private Vector path1 = null;
    private String name1 = null;
    private Vector name2;
    private ObjectURL url;
    private String newName;

    public MoveScope(ObjectURL objectURL, Vector vector) {
        this.url = objectURL;
        this.name2 = vector;
        this.newName = null;
    }

    public MoveScope(ObjectURL objectURL, String string) {
        this.url = objectURL;
        this.name2 = null;
        this.newName = string;
    }

    private void moveScope(SystemEnvironment systemEnvironment, SDMSScope sDMSScope) throws SDMSException {
        Long l;
        String string;
        SDMSScope sDMSScope2;
        Long l2 = sDMSScope.getId(systemEnvironment);
        Long l3 = sDMSScope.getParentId(systemEnvironment);
        try {
            sDMSScope2 = SDMSScopeTable.getScope(systemEnvironment, this.name2);
            string = sDMSScope.getName(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            string = (String)this.name2.remove(this.name2.size() - 1);
            sDMSScope2 = SDMSScopeTable.getScope(systemEnvironment, this.name2);
        }
        Long l4 = sDMSScope2.getId(systemEnvironment);
        if (sDMSScope2.getType(systemEnvironment) == 2) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03201291039", "A scope cannot be moved below a Server"));
        }
        if (l4.equals(l2)) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03201291038", "A Scope cannot be moved below itself"));
        }
        while ((l = sDMSScope2.getParentId(systemEnvironment)) != null) {
            if (l.equals(l2)) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03201291037", "A Scope cannot be moved below itself"));
            }
            sDMSScope2 = SDMSScopeTable.getObject(systemEnvironment, l);
        }
        sDMSScope.set_ParentIdName(systemEnvironment, l4, string);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03201291036", "Scope moved"));
    }

    private void renameScope(SystemEnvironment systemEnvironment, SDMSScope sDMSScope) throws SDMSException {
        sDMSScope.setName(systemEnvironment, this.newName);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03112161152", "Scope renamed"));
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSScope sDMSScope = (SDMSScope)this.url.resolve(systemEnvironment);
        if (this.newName == null) {
            this.moveScope(systemEnvironment, sDMSScope);
        } else {
            this.renameScope(systemEnvironment, sDMSScope);
        }
        ScopeConfig.markAltered(systemEnvironment, sDMSScope);
        SystemEnvironment.sched.notifyChange(systemEnvironment, sDMSScope, 13);
    }
}

