/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.DeadlockException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.locking.LockingSystemSynchronized;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.repository.SDMSExitStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSHierarchyInstance;
import de.independit.scheduler.server.repository.SDMSHierarchyInstanceTable;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSRunnableQueueTable;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.repository.SDMSUserTable;
import de.independit.scheduler.server.repository.SDMSVersions;
import de.independit.scheduler.server.util.SDMSThread;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class RunTest
extends Node {
    private int testid;
    private Long objectId;
    private String str;
    private String str2;

    public RunTest(Integer n) {
        this.testid = n;
        this.str = null;
        this.str2 = null;
    }

    public RunTest(Integer n, String string) {
        this.testid = n;
        this.str = string;
        this.str2 = null;
    }

    public RunTest(Integer n, Long l) {
        this.testid = n;
        this.str = null;
        this.str2 = null;
        this.objectId = l;
    }

    public RunTest(Integer n, String string, Long l) {
        this.testid = n;
        this.str = string;
        this.str2 = null;
        this.objectId = l;
        this.txMode = 2;
    }

    public RunTest(Integer n, String string, boolean bl) {
        this.testid = n;
        this.str = string;
        this.str2 = null;
        if (bl) {
            this.txMode = 1;
        }
    }

    public RunTest(Integer n, String string, String string2, boolean bl) {
        this.testid = n;
        this.str = string;
        this.str2 = string2;
        if (bl) {
            this.txMode = 1;
        }
    }

    @Override
    public void getLock() {
        SystemEnvironment.getSharedLock();
    }

    @Override
    public void releaseLock() {
        SystemEnvironment.releaseSharedLock();
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        if (!SystemEnvironment.runMode.toUpperCase().equals("TEST")) {
            return;
        }
        switch (this.testid) {
            case 1: {
                this.do_test1(systemEnvironment);
                break;
            }
            case 2: {
                this.do_test2(systemEnvironment);
                break;
            }
            case 3: {
                this.do_test3(systemEnvironment);
                break;
            }
            case 4: {
                this.do_test4(systemEnvironment);
                break;
            }
            case 5: {
                this.do_test5(systemEnvironment);
                break;
            }
            case 6: {
                this.do_test6(systemEnvironment);
                break;
            }
            case 7: {
                this.do_test7(systemEnvironment);
                break;
            }
            case 8: {
                this.do_test8(systemEnvironment);
                break;
            }
            case 9: {
                this.do_test9(systemEnvironment);
                break;
            }
            case 10: {
                this.do_test10(systemEnvironment);
                break;
            }
            case 11: {
                this.do_test11(systemEnvironment);
                break;
            }
            case 12: {
                this.do_test12(systemEnvironment);
                break;
            }
            case 13: {
                this.do_test13(systemEnvironment);
                break;
            }
            case 14: {
                this.do_test14(systemEnvironment);
                break;
            }
        }
    }

    private void do_test1(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = Long.valueOf(this.str);
        System.out.println("start release of " + l);
        SDMSSubmittedEntityTable.getObject(systemEnvironment, l).releaseMaster(systemEnvironment);
    }

    private void do_test2(SystemEnvironment systemEnvironment) throws SDMSException {
        try {
            Thread.sleep(300000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void do_test3(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSRunnableQueueTable sDMSRunnableQueueTable = (SDMSRunnableQueueTable)SystemEnvironment.repository.getTable(systemEnvironment, "RUNNABLE_QUEUE");
        sDMSRunnableQueueTable.dump(systemEnvironment);
    }

    private void do_test4(SystemEnvironment systemEnvironment) throws SDMSException {
        if (this.str == null) {
            SDMSUserTable.idx_name.dumpIndex(systemEnvironment);
        } else if (this.str.equals("user")) {
            SDMSUserTable.idx_name.dumpIndex(systemEnvironment);
        } else if (this.str.equals("named_resource")) {
            SDMSNamedResourceTable.idx_name.dumpIndex(systemEnvironment);
        } else if (this.str.equals("exit_state_definition")) {
            SDMSExitStateDefinitionTable.idx_name.dumpIndex(systemEnvironment);
        } else {
            SDMSUserTable.idx_name.dumpIndex(systemEnvironment);
        }
    }

    private void do_test5(SystemEnvironment systemEnvironment) throws SDMSException {
    }

    private void do_test6(SystemEnvironment systemEnvironment) throws SDMSException {
        SystemEnvironment.sched.notifyChange(systemEnvironment, (SDMSScope)null, 4);
    }

    private void do_test7(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = null;
        if (l.intValue() == 0) {
            SDMSThread.doTrace(this.env, "x = " + l, 0);
        }
    }

    private void do_test8(SystemEnvironment systemEnvironment) throws SDMSException {
        throw new RuntimeException("Absichtlicher Crash");
    }

    private void do_test9(SystemEnvironment systemEnvironment) throws SDMSException {
        long l = Long.MAX_VALUE;
        long l2 = Long.MAX_VALUE;
        SDMSOutputContainer sDMSOutputContainer = null;
        Vector<String> vector = new Vector<String>();
        Vector<Serializable> vector2 = new Vector<Serializable>();
        vector.add("sysEnv.roTxList.first(sysEnv)");
        vector2.add(Long.valueOf(systemEnvironment.roTxList.first(systemEnvironment)));
        vector.add("sysEnv.seVersionList.first(sysEnv)");
        vector2.add(Long.valueOf(systemEnvironment.seVersionList.first(systemEnvironment)));
        vector.add("VERSIONED_PURGE_SET");
        Vector<String> vector3 = new Vector<String>();
        Vector vector4 = new Vector();
        HashMap hashMap = systemEnvironment.vPurgeSet.stat();
        vector3.add("SIZE");
        vector4.add(hashMap.get("SIZE"));
        vector2.add(new SDMSOutputContainer(systemEnvironment, null, vector3, vector4));
        vector.add("NONVERSIONED_PURGE_SET");
        vector3 = new Vector();
        vector4 = new Vector();
        hashMap = systemEnvironment.nvPurgeSet.stat();
        vector3.add("SIZE");
        vector4.add(hashMap.get("SIZE"));
        vector2.add(new SDMSOutputContainer(systemEnvironment, null, vector3, vector4));
        vector.add("TABLES");
        Vector<String> vector5 = new Vector<String>();
        vector5.add("TABLE_NAME");
        vector5.add("COUNT_IDS");
        vector5.add("COUNT_VERSIONS");
        vector5.add("LOW_VERSION");
        vector5.add("MAX_VERSIONS");
        SDMSOutputContainer sDMSOutputContainer2 = new SDMSOutputContainer(systemEnvironment, null, vector5);
        long l3 = Long.MAX_VALUE;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        Iterator iterator = SystemEnvironment.repository.getTableIterator(systemEnvironment);
        while (iterator.hasNext()) {
            SDMSTable sDMSTable = (SDMSTable)iterator.next();
            Vector<Object> vector6 = new Vector<Object>();
            vector6.add(sDMSTable.tableName());
            hashMap = sDMSTable.stat(systemEnvironment);
            long l7 = (Long)hashMap.get("ID_COUNT");
            vector6.add(l7);
            l4 += l7;
            long l8 = (Long)hashMap.get("VERSION_COUNT");
            vector6.add(l8);
            l6 += l8;
            long l9 = (Long)hashMap.get("LOW_VERSION");
            if (l9 == Long.MAX_VALUE) {
                vector6.add("Long.MAX_VALUE");
            } else {
                vector6.add(l9);
            }
            if (l9 < l3) {
                l3 = l9;
            }
            long l10 = (Long)hashMap.get("MAX_VERSIONS");
            vector6.add(l10);
            if (l10 > l5) {
                l5 = l10;
            }
            sDMSOutputContainer2.addData(systemEnvironment, vector6);
        }
        Collections.sort(sDMSOutputContainer2.dataset, sDMSOutputContainer2.getComparator(systemEnvironment, 0));
        vector2.add(sDMSOutputContainer2);
        sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, new SDMSMessage(systemEnvironment, "03212191002", "Memory Data Statistics"), vector, vector2);
        this.result.setOutputContainer(sDMSOutputContainer);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03212191003", "Memory Data Statistics shown"));
    }

    private void do_test10(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSTable sDMSTable = SystemEnvironment.repository.getTableByName(this.str);
        if (sDMSTable == null) {
            this.result.setFeedback(new SDMSMessage(systemEnvironment, "03212191007", "Table " + this.str + " not found!"));
            return;
        }
        SDMSVersions sDMSVersions = sDMSTable.getVersions(this.objectId);
        if (sDMSVersions == null) {
            boolean bl = sDMSTable.contains(this.objectId);
            this.result.setFeedback(new SDMSMessage(systemEnvironment, "03212191008", "Object with id " + this.objectId + "(contains = " + bl + ") not found!"));
            return;
        }
        System.out.println(sDMSVersions.toString());
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03212191006", "Versions dumped to stdout"));
    }

    private void do_test11(SystemEnvironment systemEnvironment) throws SDMSException {
        LockingSystemSynchronized.dump();
    }

    private void do_test12(SystemEnvironment systemEnvironment) throws SDMSException {
        Map.Entry<String, Long>[] entryArray = DeadlockException.getStackTraces(10);
        SDMSOutputContainer sDMSOutputContainer = null;
        Vector<String> vector = new Vector<String>();
        Vector<SDMSOutputContainer> vector2 = new Vector<SDMSOutputContainer>();
        vector.add("Stack Traces");
        Vector<String> vector3 = new Vector<String>();
        vector3.add("Stack Trace");
        vector3.add("Count");
        SDMSOutputContainer sDMSOutputContainer2 = new SDMSOutputContainer(systemEnvironment, null, vector3);
        for (int i = 0; i < entryArray.length; ++i) {
            if (entryArray[i] == null) continue;
            Vector<Object> vector4 = new Vector<Object>();
            vector4.add(entryArray[i].getKey());
            vector4.add(entryArray[i].getValue());
            sDMSOutputContainer2.addData(systemEnvironment, vector4);
        }
        vector2.add(sDMSOutputContainer2);
        sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, new SDMSMessage(systemEnvironment, "03212191004", "Deadlock Stack Traces"), vector, vector2);
        this.result.setOutputContainer(sDMSOutputContainer);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03212191005", "Deadlock Stack Traces shown"));
    }

    private boolean repairSmeCounts(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, HashSet hashSet) throws SDMSException {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n19 = sDMSSubmittedEntity.getCntSubmitted(systemEnvironment);
        int n20 = sDMSSubmittedEntity.getCntDependencyWait(systemEnvironment);
        int n21 = sDMSSubmittedEntity.getCntSynchronizeWait(systemEnvironment);
        int n22 = sDMSSubmittedEntity.getCntResourceWait(systemEnvironment);
        int n23 = sDMSSubmittedEntity.getCntRunnable(systemEnvironment);
        int n24 = sDMSSubmittedEntity.getCntStarting(systemEnvironment);
        int n25 = sDMSSubmittedEntity.getCntStarted(systemEnvironment);
        int n26 = sDMSSubmittedEntity.getCntRunning(systemEnvironment);
        int n27 = sDMSSubmittedEntity.getCntToKill(systemEnvironment);
        int n28 = sDMSSubmittedEntity.getCntKilled(systemEnvironment);
        int n29 = sDMSSubmittedEntity.getCntCancelled(systemEnvironment);
        int n30 = sDMSSubmittedEntity.getCntFinished(systemEnvironment);
        int n31 = sDMSSubmittedEntity.getCntFinal(systemEnvironment);
        int n32 = sDMSSubmittedEntity.getCntBrokenActive(systemEnvironment);
        int n33 = sDMSSubmittedEntity.getCntBrokenFinished(systemEnvironment);
        int n34 = sDMSSubmittedEntity.getCntError(systemEnvironment);
        int n35 = sDMSSubmittedEntity.getCntUnreachable(systemEnvironment);
        int n36 = sDMSSubmittedEntity.getCntRestartable(systemEnvironment);
        Vector vector = SDMSHierarchyInstanceTable.idx_parentId.getVector(systemEnvironment, sDMSSubmittedEntity.getId(systemEnvironment));
        for (int i = 0; i < vector.size(); ++i) {
            SDMSHierarchyInstance sDMSHierarchyInstance = (SDMSHierarchyInstance)vector.get(i);
            Long l = sDMSHierarchyInstance.getId(systemEnvironment);
            if (hashSet.contains(l)) continue;
            hashSet.add(l);
            SDMSSubmittedEntity sDMSSubmittedEntity2 = SDMSSubmittedEntityTable.getObject(systemEnvironment, sDMSHierarchyInstance.getChildId(systemEnvironment));
            bl = bl || this.repairSmeCounts(systemEnvironment, sDMSSubmittedEntity2, hashSet);
            n += sDMSSubmittedEntity2.getCntSubmitted(systemEnvironment).intValue();
            n2 += sDMSSubmittedEntity2.getCntDependencyWait(systemEnvironment).intValue();
            n3 += sDMSSubmittedEntity2.getCntSynchronizeWait(systemEnvironment).intValue();
            n4 += sDMSSubmittedEntity2.getCntResourceWait(systemEnvironment).intValue();
            n5 += sDMSSubmittedEntity2.getCntRunnable(systemEnvironment).intValue();
            n6 += sDMSSubmittedEntity2.getCntStarting(systemEnvironment).intValue();
            n7 += sDMSSubmittedEntity2.getCntStarted(systemEnvironment).intValue();
            n8 += sDMSSubmittedEntity2.getCntRunning(systemEnvironment).intValue();
            n9 += sDMSSubmittedEntity2.getCntToKill(systemEnvironment).intValue();
            n10 += sDMSSubmittedEntity2.getCntKilled(systemEnvironment).intValue();
            n11 += sDMSSubmittedEntity2.getCntCancelled(systemEnvironment).intValue();
            n12 += sDMSSubmittedEntity2.getCntFinished(systemEnvironment).intValue();
            n13 += sDMSSubmittedEntity2.getCntFinal(systemEnvironment).intValue();
            n14 += sDMSSubmittedEntity2.getCntBrokenActive(systemEnvironment).intValue();
            n15 += sDMSSubmittedEntity2.getCntBrokenFinished(systemEnvironment).intValue();
            n16 += sDMSSubmittedEntity2.getCntError(systemEnvironment).intValue();
            n17 += sDMSSubmittedEntity2.getCntUnreachable(systemEnvironment).intValue();
            n18 += sDMSSubmittedEntity2.getCntRestartable(systemEnvironment).intValue();
            int n37 = sDMSSubmittedEntity2.getState(systemEnvironment);
            switch (n37) {
                case 0: {
                    ++n;
                    break;
                }
                case 1: {
                    ++n2;
                    break;
                }
                case 2: {
                    ++n3;
                    break;
                }
                case 3: {
                    ++n4;
                    break;
                }
                case 4: {
                    ++n5;
                    break;
                }
                case 5: {
                    ++n6;
                    break;
                }
                case 6: {
                    ++n7;
                    break;
                }
                case 7: {
                    ++n8;
                    break;
                }
                case 8: {
                    ++n9;
                    break;
                }
                case 9: {
                    ++n10;
                    break;
                }
                case 10: {
                    ++n11;
                    break;
                }
                case 11: {
                    ++n12;
                    break;
                }
                case 12: {
                    ++n13;
                    break;
                }
                case 13: {
                    ++n14;
                    break;
                }
                case 14: {
                    ++n15;
                    break;
                }
                case 15: {
                    ++n16;
                    break;
                }
                case 16: {
                    ++n17;
                }
            }
            if (!sDMSSubmittedEntity2.getJobIsRestartable(systemEnvironment).booleanValue()) continue;
            ++n18;
        }
        if (n != n19) {
            sDMSSubmittedEntity.setCntSubmitted(systemEnvironment, n);
            bl = true;
        }
        if (n2 != n20) {
            sDMSSubmittedEntity.setCntDependencyWait(systemEnvironment, n2);
            bl = true;
        }
        if (n3 != n21) {
            sDMSSubmittedEntity.setCntSynchronizeWait(systemEnvironment, n3);
            bl = true;
        }
        if (n4 != n22) {
            sDMSSubmittedEntity.setCntResourceWait(systemEnvironment, n4);
            bl = true;
        }
        if (n5 != n23) {
            sDMSSubmittedEntity.setCntRunnable(systemEnvironment, n5);
            bl = true;
        }
        if (n6 != n24) {
            sDMSSubmittedEntity.setCntStarting(systemEnvironment, n6);
            bl = true;
        }
        if (n7 != n25) {
            sDMSSubmittedEntity.setCntStarted(systemEnvironment, n7);
            bl = true;
        }
        if (n8 != n26) {
            sDMSSubmittedEntity.setCntRunning(systemEnvironment, n8);
            bl = true;
        }
        if (n9 != n27) {
            sDMSSubmittedEntity.setCntToKill(systemEnvironment, n9);
            bl = true;
        }
        if (n10 != n28) {
            sDMSSubmittedEntity.setCntKilled(systemEnvironment, n10);
            bl = true;
        }
        if (n11 != n29) {
            sDMSSubmittedEntity.setCntCancelled(systemEnvironment, n11);
            bl = true;
        }
        if (n12 != n30) {
            sDMSSubmittedEntity.setCntFinished(systemEnvironment, n12);
            bl = true;
        }
        if (n13 != n31) {
            sDMSSubmittedEntity.setCntFinal(systemEnvironment, n13);
            bl = true;
        }
        if (n14 != n32) {
            sDMSSubmittedEntity.setCntBrokenActive(systemEnvironment, n14);
            bl = true;
        }
        if (n15 != n33) {
            sDMSSubmittedEntity.setCntBrokenFinished(systemEnvironment, n15);
            bl = true;
        }
        if (n16 != n34) {
            sDMSSubmittedEntity.setCntError(systemEnvironment, n16);
            bl = true;
        }
        if (n17 != n35) {
            sDMSSubmittedEntity.setCntUnreachable(systemEnvironment, n17);
            bl = true;
        }
        if (n18 != n36) {
            sDMSSubmittedEntity.setCntRestartable(systemEnvironment, n18);
            bl = true;
        }
        sDMSSubmittedEntity.setCntWarn(systemEnvironment, 0);
        if (bl) {
            System.out.println("------------------------------------------------------------");
            System.out.println("Setting following values for sme " + sDMSSubmittedEntity.getId(systemEnvironment) + ":");
            System.out.println("fixSubmitted = " + n + " (old = " + n19 + ")");
            System.out.println("fixDependencyWait = " + n2 + " (old = " + n20 + ")");
            System.out.println("fixSynchronizeWait = " + n3 + " (old = " + n21 + ")");
            System.out.println("fixResourceWait = " + n4 + " (old = " + n22 + ")");
            System.out.println("fixRunnable = " + n5 + " (old = " + n23 + ")");
            System.out.println("fixStarting = " + n6 + " (old = " + n24 + ")");
            System.out.println("fixStarted = " + n7 + " (old = " + n25 + ")");
            System.out.println("fixRunning = " + n8 + " (old = " + n26 + ")");
            System.out.println("fixToKill = " + n9 + " (old = " + n27 + ")");
            System.out.println("fixKilled = " + n10 + " (old = " + n28 + ")");
            System.out.println("fixCancelled = " + n11 + " (old = " + n29 + ")");
            System.out.println("fixFinished = " + n12 + " (old = " + n30 + ")");
            System.out.println("fixFinal = " + n13 + " (old = " + n31 + ")");
            System.out.println("fixBrokenActive = " + n14 + " (old = " + n32 + ")");
            System.out.println("fixBrokenFinished = " + n15 + " (old = " + n33 + ")");
            System.out.println("fixError = " + n16 + " (old = " + n34 + ")");
            System.out.println("fixUnreachable = " + n17 + " (old = " + n35 + ")");
            System.out.println("fixRestartable = " + n18 + " (old = " + n36 + ")");
        }
        return bl;
    }

    private void tryFinalize(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
        Vector vector = SDMSHierarchyInstanceTable.idx_parentId.getVector(systemEnvironment, sDMSSubmittedEntity.getId(systemEnvironment));
        for (int i = 0; i < vector.size(); ++i) {
            SDMSHierarchyInstance sDMSHierarchyInstance = (SDMSHierarchyInstance)vector.get(i);
            SDMSSubmittedEntity sDMSSubmittedEntity2 = SDMSSubmittedEntityTable.getObject(systemEnvironment, sDMSHierarchyInstance.getChildId(systemEnvironment));
            this.tryFinalize(systemEnvironment, sDMSSubmittedEntity2);
        }
        if (sDMSSubmittedEntity.getIsCancelled(systemEnvironment).booleanValue() && sDMSSubmittedEntity.getState(systemEnvironment) == 11) {
            sDMSSubmittedEntity.doDeferredCancel(systemEnvironment);
        }
    }

    private void do_test13(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSSubmittedEntity sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, this.objectId);
        Long l = sDMSSubmittedEntity.getSeVersion(systemEnvironment);
        HashSet hashSet = new HashSet();
        if (this.repairSmeCounts(systemEnvironment, sDMSSubmittedEntity, hashSet)) {
            this.tryFinalize(systemEnvironment, sDMSSubmittedEntity);
            this.result.setFeedback(new SDMSMessage(systemEnvironment, "03711230834", "SME " + this.objectId + " fixed"));
        } else {
            this.result.setFeedback(new SDMSMessage(systemEnvironment, "03711230835", "SME " + this.objectId + " OK"));
        }
    }

    private void disableSme(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSSubmittedEntity sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, l);
        if (sDMSSubmittedEntity.getIsDisabled(systemEnvironment).booleanValue()) {
            return;
        }
        sDMSSubmittedEntity.setIsDisabled(systemEnvironment, Boolean.TRUE);
        sDMSSubmittedEntity.setState(systemEnvironment, SDMSConstants.SME_DEPENDENCY_WAIT);
        sDMSSubmittedEntity.checkDependencies(systemEnvironment);
        Vector vector = SDMSHierarchyInstanceTable.idx_parentId.getVector(systemEnvironment, l);
        for (SDMSHierarchyInstance sDMSHierarchyInstance : vector) {
            Long l2 = sDMSHierarchyInstance.getChildId(systemEnvironment);
            this.disableSme(systemEnvironment, l2);
        }
    }

    private void do_test14(SystemEnvironment systemEnvironment) throws SDMSException {
        this.disableSme(systemEnvironment, this.objectId);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03711230836", "SME " + this.objectId + " disabled"));
    }
}

