/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.jobserver.Config;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.output.SDMSOutputLabel;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.ResourceTreeLister;
import de.independit.scheduler.server.parser.ScopeConfig;
import de.independit.scheduler.server.parser.ScopeParameter;
import de.independit.scheduler.server.parser.ShowCommented;
import de.independit.scheduler.server.repository.SDMSGroup;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.repository.SDMSUserTable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;

public class ShowScope
extends ShowCommented {
    public static final String __version = "@(#) $Id: ShowScope.java,v 2.13.2.2 2013/06/18 09:49:38 ronald Exp $";
    ObjectURL url;
    SDMSScope s;
    Long sId = null;
    HashSet resourceExpandList;

    public ShowScope(ObjectURL objectURL, HashSet hashSet) {
        this.url = objectURL;
        this.resourceExpandList = hashSet;
        this.txMode = 1;
        this.auditFlag = false;
    }

    private void fillHeader(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        vector.add("ID");
        vector.add("NAME");
        vector.add("OWNER");
        vector.add("TYPE");
        vector.add("INHERIT_PRIVS");
        vector.add("IS_TERMINATE");
        vector.add("IS_SUSPENDED");
        vector.add("IS_ENABLED");
        vector.add("IS_REGISTERED");
        vector.add("IS_CONNECTED");
        vector.add("HAS_ALTERED_CONFIG");
        vector.add("STATE");
        vector.add("PID");
        vector.add("NODE");
        vector.add("IDLE");
        vector.add("ERRMSG");
        vector.add("COMMENT");
        vector.add("COMMENTTYPE");
        vector.add("CREATOR");
        vector.add("CREATE_TIME");
        vector.add("CHANGER");
        vector.add("CHANGE_TIME");
        vector.add("PRIVS");
        vector.add("RESOURCES");
        vector.add("CONFIG");
        vector.add("CONFIG_ENVMAPPING");
        vector.add("PARAMETERS");
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSOutputContainer sDMSOutputContainer = null;
        Vector vector = new Vector();
        Date date = new Date();
        this.fillHeader(systemEnvironment, vector);
        this.s = (SDMSScope)this.url.resolve(systemEnvironment);
        if (!this.s.checkPrivileges(systemEnvironment, 0x10000000L)) {
            throw new AccessViolationException(new SDMSMessage(systemEnvironment, "034020411725", "Insufficient privileges"));
        }
        this.sId = this.s.getId(systemEnvironment);
        Vector<Object> vector2 = new Vector<Object>();
        vector2.add(this.sId);
        vector2.add(this.s.pathVector(systemEnvironment));
        SDMSGroup sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, this.s.getOwnerId(systemEnvironment));
        vector2.add(sDMSGroup.getName(systemEnvironment));
        vector2.add(this.s.getTypeAsString(systemEnvironment));
        vector2.add(new SDMSPrivilege(systemEnvironment, this.s.getInheritPrivs(systemEnvironment)).toString());
        vector2.add(this.s.getIsTerminate(systemEnvironment));
        vector2.add(this.s.getIsSuspended(systemEnvironment));
        vector2.add(this.s.getIsEnabled(systemEnvironment));
        vector2.add(this.s.getIsRegistered(systemEnvironment));
        vector2.add(this.s.isConnected(systemEnvironment));
        vector2.add(this.s.getHasAlteredConfig(systemEnvironment));
        vector2.add(this.s.getState(systemEnvironment));
        vector2.add(this.s.getPid(systemEnvironment));
        vector2.add(this.s.getNode(systemEnvironment));
        vector2.add(this.s.getIdle(systemEnvironment));
        vector2.add(this.s.getErrmsg(systemEnvironment));
        vector2.add(this.getCommentContainer(systemEnvironment, this.sId));
        vector2.add(this.getCommentInfoType(systemEnvironment, this.sId));
        try {
            vector2.add(SDMSUserTable.getObject(systemEnvironment, this.s.getCreatorUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector2.add("unknown");
        }
        date.setTime(this.s.getCreateTs(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format(date));
        try {
            try {
                vector2.add(SDMSUserTable.getObject(systemEnvironment, this.s.getChangerUId(systemEnvironment)).getName(systemEnvironment));
            }
            catch (NotFoundException notFoundException) {
                vector2.add(SDMSScopeTable.getObject(systemEnvironment, this.s.getChangerUId(systemEnvironment)).pathString(systemEnvironment));
            }
        }
        catch (NotFoundException notFoundException) {
            vector2.add("unknown");
        }
        date.setTime(this.s.getChangeTs(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format(date));
        vector2.add(this.s.getPrivileges(systemEnvironment).toString());
        this.add_resources(systemEnvironment, this.s, vector2);
        this.collectConfig(systemEnvironment, vector2);
        vector2.add(ScopeParameter.getRecursive(systemEnvironment, this.s));
        sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, new SDMSMessage(systemEnvironment, "03201291430", "Scope"), vector, vector2);
        this.result.setOutputContainer(sDMSOutputContainer);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03201291503", (this.s.getType(systemEnvironment) == 2 ? "Job Server" : "Scope") + " shown"));
    }

    private void add_resources(SystemEnvironment systemEnvironment, SDMSScope sDMSScope, Vector vector) throws SDMSException {
        ResourceTreeLister resourceTreeLister = new ResourceTreeLister(systemEnvironment, null, sDMSScope.getId(systemEnvironment));
        Vector<SDMSProxy> vector2 = new Vector<SDMSProxy>();
        vector2.add(SDMSNamedResourceTable.idx_parentId_name.getUnique(systemEnvironment, new SDMSKey(null, (Comparable)((Object)"RESOURCE"))));
        vector.add(resourceTreeLister.list(systemEnvironment, vector2, this.resourceExpandList));
    }

    private void fillConfigHeaders(SystemEnvironment systemEnvironment, Vector vector, Vector vector2) throws SDMSException {
        vector.add("KEY");
        vector.add("VALUE");
        vector.add("LOCAL");
        vector.add("ANCESTOR_SCOPE");
        vector.add("ANCESTOR_VALUE");
        vector2.add("KEY");
        vector2.add("VALUE");
        vector2.add("LOCAL");
        vector2.add("ANCESTOR_SCOPE");
        vector2.add("ANCESTOR_VALUE");
    }

    private void collectConfig(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        Vector<Boolean> vector2;
        Object object;
        int n;
        Vector vector3 = new Vector();
        Vector vector4 = new Vector();
        this.fillConfigHeaders(systemEnvironment, vector3, vector4);
        SDMSOutputContainer sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, "List of Effective Scope Config", vector3);
        SDMSOutputContainer sDMSOutputContainer2 = new SDMSOutputContainer(systemEnvironment, "List of Effective Scope Environment Mapping Config", vector4);
        SDMSOutputContainer sDMSOutputContainer3 = ScopeConfig.get(systemEnvironment, this.s);
        Vector vector5 = (Vector)sDMSOutputContainer3.dataset.get(0);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("DYNAMIC");
        hashSet.add("ENV");
        hashSet.add("NAME_PATTERN_");
        if (sDMSOutputContainer3 != null) {
            n = sDMSOutputContainer3.desc.size();
            for (int i = 0; i < n; i += 1) {
                Object object2;
                int n2;
                object = ((SDMSOutputLabel)sDMSOutputContainer3.desc.get((int)i)).name;
                if (ScopeConfig.isInternalEntry((String)object)) continue;
                if (((String)object).startsWith("NAME_PATTERN_")) {
                    hashSet.add("NAME_PATTERN_");
                } else {
                    hashSet.add((String)object);
                }
                vector2 = vector5.get(i);
                if (((String)object).equals("ENV")) {
                    this.collectEnvMapping(systemEnvironment, sDMSOutputContainer2, (HashMap)((Object)vector2));
                    continue;
                }
                if (((String)object).equals("DYNAMIC")) continue;
                Long l = null;
                Long l2 = null;
                String string = "";
                String string2 = "." + (String)object;
                String string3 = ":" + (String)object;
                String string4 = ";" + (String)object;
                for (n2 = 0; n2 < n; n2 += 1) {
                    object2 = ((SDMSOutputLabel)sDMSOutputContainer3.desc.get((int)n2)).name;
                    if (((String)object2).equals(string2)) {
                        l = (Long)vector5.get(n2);
                        continue;
                    }
                    if (((String)object2).equals(string3)) {
                        l2 = (Long)vector5.get(n2);
                        continue;
                    }
                    if (!((String)object2).equals(string4)) continue;
                    string = vector5.get(n2).toString();
                }
                if (l == null) continue;
                n2 = l == this.sId ? 1 : 0;
                object2 = ((String)object).equals("REPOPASS") ? "***" : vector2;
                Vector<Object> vector6 = new Vector<Object>();
                vector6.add(object);
                vector6.add(object2);
                vector6.add(n2 != 0);
                if (n2) {
                    if (l2 == null) {
                        Object object3 = Config.getDefaultValue((String)object);
                        if (object3 != null) {
                            vector6.add("DEFAULT");
                            vector6.add(object3.toString());
                        } else {
                            vector6.add("");
                            vector6.add("");
                        }
                    } else {
                        vector6.add(this.getScopePath(systemEnvironment, l2));
                        vector6.add(string);
                    }
                } else {
                    vector6.add(this.getScopePath(systemEnvironment, l));
                    vector6.add(object2);
                }
                sDMSOutputContainer.addData(systemEnvironment, vector6);
            }
        }
        for (n = 0; n < Config.ALL_VALUES.length; n += 1) {
            String string = Config.ALL_VALUES[n];
            if (hashSet.contains(string)) continue;
            object = null;
            for (int i = 0; i < Config.defaultKeys.length; ++i) {
                if (!string.equals(Config.defaultKeys[i])) continue;
                object = Config.defaultValues[i];
                break;
            }
            vector2 = new Vector<String>();
            vector2.add((Boolean)((Object)string));
            vector2.add((Boolean)(object == null ? "" : object));
            if (object != null) {
                vector2.add(Boolean.FALSE);
                vector2.add((Boolean)((Object)"DEFAULT"));
                vector2.add((Boolean)object);
            } else {
                vector2.add(Boolean.TRUE);
                vector2.add((Boolean)((Object)""));
                vector2.add((Boolean)((Object)""));
            }
            sDMSOutputContainer.addData(systemEnvironment, vector2);
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 0));
        vector.add(sDMSOutputContainer);
        Collections.sort(sDMSOutputContainer2.dataset, sDMSOutputContainer2.getComparator(systemEnvironment, 0));
        vector.add(sDMSOutputContainer2);
    }

    private String getScopePath(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l == null) {
            return "";
        }
        SDMSScope sDMSScope = SDMSScopeTable.getObject(systemEnvironment, l);
        return sDMSScope.pathVector(systemEnvironment).toString();
    }

    private final void collectEnvMapping(SystemEnvironment systemEnvironment, SDMSOutputContainer sDMSOutputContainer, HashMap hashMap) throws SDMSException {
        Vector vector = new Vector(hashMap.keySet());
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)vector.get(i);
            if (ScopeConfig.isInternalEntry(string)) continue;
            String string2 = (String)hashMap.get(string);
            Long l = (Long)hashMap.get("." + string);
            boolean bl = l == this.sId;
            Long l2 = (Long)hashMap.get(":" + string);
            String string3 = ";" + string;
            String string4 = hashMap.containsKey(string3) ? (String)hashMap.get(";" + string) : "";
            Vector<Object> vector2 = new Vector<Object>();
            vector2.add(string);
            vector2.add(string2);
            vector2.add(bl);
            vector2.add(this.getScopePath(systemEnvironment, bl ? l2 : l));
            vector2.add(bl ? string4 : string2);
            sDMSOutputContainer.addData(systemEnvironment, vector2);
        }
    }
}

