/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.repository.SDMSResourceAllocation;
import de.independit.scheduler.server.repository.SDMSResourceAllocationTable;
import de.independit.scheduler.server.repository.SDMSRunnableQueue;
import de.independit.scheduler.server.repository.SDMSRunnableQueueTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import java.util.Iterator;

public class RepositoryChecker {
    private static boolean checked = false;

    public static void checkRepository(SystemEnvironment systemEnvironment) throws SDMSException {
        if (checked) {
            return;
        }
        RepositoryChecker.checkRunnableQueue(systemEnvironment);
        RepositoryChecker.checkResourceAllocation(systemEnvironment);
        checked = true;
    }

    private static boolean smeDead(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        boolean bl = false;
        if (l < 0L) {
            l = -l.longValue();
        }
        try {
            SDMSSubmittedEntity sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, l);
            Integer n = sDMSSubmittedEntity.getState(systemEnvironment);
            if (n == 12 || n == 10) {
                bl = true;
            } else {
                l = sDMSSubmittedEntity.getMasterId(systemEnvironment);
                n = (sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, l)).getState(systemEnvironment);
                if (n == 12 || n == 10) {
                    bl = true;
                }
            }
        }
        catch (NotFoundException notFoundException) {
            bl = true;
        }
        return bl;
    }

    private static void checkRunnableQueue(SystemEnvironment systemEnvironment) throws SDMSException {
        Iterator iterator = SDMSRunnableQueueTable.table.iterator(systemEnvironment);
        while (iterator.hasNext()) {
            SDMSRunnableQueue sDMSRunnableQueue = (SDMSRunnableQueue)iterator.next();
            if (!RepositoryChecker.smeDead(systemEnvironment, sDMSRunnableQueue.getSmeId(systemEnvironment))) continue;
            sDMSRunnableQueue.delete(systemEnvironment);
        }
    }

    private static void checkResourceAllocation(SystemEnvironment systemEnvironment) throws SDMSException {
        Iterator iterator = SDMSResourceAllocationTable.table.iterator(systemEnvironment);
        while (iterator.hasNext()) {
            SDMSResourceAllocation sDMSResourceAllocation = (SDMSResourceAllocation)iterator.next();
            if (!RepositoryChecker.smeDead(systemEnvironment, sDMSResourceAllocation.getSmeId(systemEnvironment))) continue;
            sDMSResourceAllocation.delete(systemEnvironment);
        }
    }
}

