/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSAuditTrail;
import de.independit.scheduler.server.repository.SDMSAuditTrailGeneric;
import de.independit.scheduler.server.repository.SDMSAuditTrailTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSRepository;
import de.independit.scheduler.server.repository.SDMSTable;
import java.util.HashMap;
import java.util.Vector;

public class SDMSAuditTrailProxyGeneric
extends SDMSProxy {
    public static final int ENVIRONMENT = 1;
    public static final int EVENT = 18;
    public static final int EXIT_STATE_DEFINITION = 2;
    public static final int EXIT_STATE_PROFILE = 3;
    public static final int EXIT_STATE_MAPPING = 4;
    public static final int EXIT_STATE_TRANSLATION = 5;
    public static final int FOLDER = 6;
    public static final int FOOTPRINT = 7;
    public static final int GROUP = 21;
    public static final int INTERVAL = 19;
    public static final int JOB = 17;
    public static final int JOB_DEFINITION = 9;
    public static final int NAMED_RESOURCE = 10;
    public static final int RESOURCE = 11;
    public static final int RESOURCE_STATE_DEFINITION = 13;
    public static final int RESOURCE_STATE_MAPPING = 12;
    public static final int RESOURCE_STATE_PROFILE = 14;
    public static final int SCHEDULE = 20;
    public static final int SCOPE = 15;
    public static final int TRIGGER = 16;
    public static final int USER = 8;
    public static final int RERUN = 1;
    public static final int RERUN_RECURSIVE = 2;
    public static final int CANCEL = 3;
    public static final int SUSPEND = 4;
    public static final int RESUME = 5;
    public static final int SET_STATE = 6;
    public static final int SET_EXIT_STATE = 7;
    public static final int IGNORE_DEPENDENCY = 8;
    public static final int IGNORE_DEP_RECURSIVE = 9;
    public static final int IGNORE_RESOURCE = 10;
    public static final int KILL = 11;
    public static final int ALTER_RUN_PROGRAM = 12;
    public static final int ALTER_RERUN_PROGRAM = 13;
    public static final int COMMENT_JOB = 14;
    public static final int SUBMITTED = 15;
    public static final int TRIGGER_FAILED = 16;
    public static final int TRIGGER_SUBMIT = 17;
    public static final int JOB_RESTARTABLE = 18;
    public static final int CHANGE_PRIORITY = 19;
    public static final int RENICE = 20;
    public static final int SUBMIT_SUSPENDED = 21;
    public static final int IGNORE_NAMED_RESOURCE = 22;
    public static final int TIMEOUT = 23;
    public static final int SET_RESOURCE_STATE = 24;
    public static final int JOB_IN_ERROR = 25;
    public static final int CLEAR_WARNING = 26;
    public static final int SET_WARNING = 27;
    public static final int JOB_UNREACHABLE = 28;
    public static final int SET_PARAMETERS = 29;
    public static final int DISABLE = 30;
    public static final int ENABLE = 31;
    public static final int CLONE = 32;
    public static final int APPROVE = 33;
    public static final int REJECT = 34;
    public static final int APPROVAL_REQUEST = 35;
    public static final int REVIEW_REQUEST = 36;
    public static final int KILL_RECURSIVE = 37;
    public static final long privilegeMask = 0x10000101L;
    public static final int actionInfo_size = 1024;
    public static final int actionComment_size = 1024;
    private static SDMSTable[] masterTables = null;

    protected SDMSAuditTrailProxyGeneric(SDMSObject sDMSObject) {
        super(sDMSObject);
    }

    protected static SDMSAuditTrail getProxy(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) {
        int n = SDMSAuditTrailTable.table.tableIndex;
        SDMSProxy sDMSProxy = SDMSRepository.getProxy(n);
        if (sDMSProxy == null) {
            sDMSProxy = new SDMSAuditTrail(sDMSObject);
        } else {
            sDMSProxy.initProxy(sDMSObject);
        }
        systemEnvironment.tx.addUsedProxy(n, sDMSProxy);
        return (SDMSAuditTrail)sDMSProxy;
    }

    public Long getUserId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSAuditTrailGeneric)this.object).getUserId(systemEnvironment);
    }

    public void setUserId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSAuditTrailGeneric)this.object).setUserId(systemEnvironment, l);
    }

    public Long getTs(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSAuditTrailGeneric)this.object).getTs(systemEnvironment);
    }

    public void setTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSAuditTrailGeneric)this.object).setTs(systemEnvironment, l);
    }

    public Long getTxId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSAuditTrailGeneric)this.object).getTxId(systemEnvironment);
    }

    public void setTxId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSAuditTrailGeneric)this.object).setTxId(systemEnvironment, l);
    }

    public Integer getAction(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSAuditTrailGeneric)this.object).getAction(systemEnvironment);
    }

    public String getActionAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSAuditTrailGeneric)this.object).getActionAsString(systemEnvironment);
    }

    public void setAction(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSAuditTrailGeneric)this.object).setAction(systemEnvironment, n);
    }

    public Integer getObjectType(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSAuditTrailGeneric)this.object).getObjectType(systemEnvironment);
    }

    public String getObjectTypeAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSAuditTrailGeneric)this.object).getObjectTypeAsString(systemEnvironment);
    }

    public void setObjectType(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSAuditTrailGeneric)this.object).setObjectType(systemEnvironment, n);
    }

    public Long getObjectId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSAuditTrailGeneric)this.object).getObjectId(systemEnvironment);
    }

    public void setObjectId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSAuditTrailGeneric)this.object).setObjectId(systemEnvironment, l);
    }

    public Long getOriginId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSAuditTrailGeneric)this.object).getOriginId(systemEnvironment);
    }

    public void setOriginId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSAuditTrailGeneric)this.object).setOriginId(systemEnvironment, l);
    }

    public Boolean getIsSetWarning(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSAuditTrailGeneric)this.object).getIsSetWarning(systemEnvironment);
    }

    public void setIsSetWarning(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSAuditTrailGeneric)this.object).setIsSetWarning(systemEnvironment, bl);
    }

    public String getActionInfo(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSAuditTrailGeneric)this.object).getActionInfo(systemEnvironment);
    }

    public void setActionInfo(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSAuditTrailGeneric)this.object).setActionInfo(systemEnvironment, string);
    }

    public static int getActionInfoMaxLength() {
        return 1024;
    }

    public Long getInfoId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSAuditTrailGeneric)this.object).getInfoId(systemEnvironment);
    }

    public void setInfoId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSAuditTrailGeneric)this.object).setInfoId(systemEnvironment, l);
    }

    public String getActionComment(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSAuditTrailGeneric)this.object).getActionComment(systemEnvironment);
    }

    public void setActionComment(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSAuditTrailGeneric)this.object).setActionComment(systemEnvironment, string);
    }

    public static int getActionCommentMaxLength() {
        return 1024;
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSAuditTrailGeneric)this.object).getCreatorUId(systemEnvironment);
    }

    private void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSAuditTrailGeneric)this.object).setCreatorUId(systemEnvironment, l);
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSAuditTrailGeneric)this.object).getCreateTs(systemEnvironment);
    }

    private void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSAuditTrailGeneric)this.object).setCreateTs(systemEnvironment, l);
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSAuditTrailGeneric)this.object).getChangerUId(systemEnvironment);
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSAuditTrailGeneric)this.object).setChangerUId(systemEnvironment, l);
    }

    protected SDMSAuditTrail setChangerUIdNoCheck(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        this.touchMaster(systemEnvironment);
        ((SDMSAuditTrailGeneric)this.object).setChangerUId(systemEnvironment, l);
        return (SDMSAuditTrail)this;
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSAuditTrailGeneric)this.object).getChangeTs(systemEnvironment);
    }

    private void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSAuditTrailGeneric)this.object).setChangeTs(systemEnvironment, l);
    }

    protected SDMSAuditTrail setChangeTsNoCheck(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        this.touchMaster(systemEnvironment);
        ((SDMSAuditTrailGeneric)this.object).setChangeTs(systemEnvironment, l);
        return (SDMSAuditTrail)this;
    }

    @Override
    public SDMSKey getSortKey(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSKey sDMSKey = null;
        Long l = this.getId(systemEnvironment);
        if (systemEnvironment.tx.sortKeyMap == null) {
            systemEnvironment.tx.sortKeyMap = new HashMap();
        } else {
            sDMSKey = (SDMSKey)systemEnvironment.tx.sortKeyMap.get(l);
        }
        if (sDMSKey != null) {
            return sDMSKey;
        }
        boolean bl = false;
        sDMSKey = new SDMSKey();
        sDMSKey.add(this.getObjectId(systemEnvironment));
        sDMSKey.add(this.getTs(systemEnvironment));
        systemEnvironment.tx.sortKeyMap.put(l, sDMSKey);
        return sDMSKey;
    }

    @Override
    public void delete(SystemEnvironment systemEnvironment) throws SDMSException {
        this.touchMaster(systemEnvironment);
        super.delete(systemEnvironment);
    }

    @Override
    public final boolean checkPrivileges(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        return (this.getPrivileges(systemEnvironment, l, true, null) & l) == l;
    }

    @Override
    public long getPrivilegeMask() {
        return 0x10000101L;
    }

    @Override
    public final SDMSPrivilege getPrivileges(SystemEnvironment systemEnvironment) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 0x10000101L, false, null));
    }

    @Override
    public final SDMSPrivilege getPrivilegesForGroups(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 0x10000101L, false, vector));
    }

    @Override
    public long getPrivileges(SystemEnvironment systemEnvironment, long l, boolean bl, Vector vector) throws SDMSException {
        if (vector == null) {
            Vector vector2 = new Vector();
        } else {
            Vector vector3 = vector;
        }
        long l2 = 0L;
        l2 = l;
        SDMSTable sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "SUBMITTED_ENTITY");
        try {
            SDMSProxy sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            long l3 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000101L, false, vector);
            if ((l3 & 0x100L) == 256L) {
                l3 |= 0x10000011L;
            }
            l2 &= l3;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return l2;
    }

    @Override
    public SDMSMessage accessViolationMessage(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        SDMSMessage sDMSMessage = new SDMSMessage(systemEnvironment, string, "Insufficient privileges accessing AuditTrail $1", this.getId(systemEnvironment));
        return sDMSMessage;
    }

    void touchMaster(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSTable sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "SUBMITTED_ENTITY");
        try {
            SDMSProxy sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            sDMSProxy.touch(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Override
    protected void touch(SystemEnvironment systemEnvironment) throws SDMSException {
        this.setChangerUIdNoCheck(systemEnvironment, systemEnvironment.cEnv.uid());
        this.setChangeTsNoCheck(systemEnvironment, systemEnvironment.txTime());
    }

    public void print() {
        ((SDMSAuditTrailGeneric)this.object).print();
    }
}

