/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SDMSSQLException;
import de.independit.scheduler.server.repository.SDMSEntityVariable;
import de.independit.scheduler.server.repository.SDMSEntityVariableTableGeneric;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SDMSEntityVariableGeneric
extends SDMSObject
implements Cloneable {
    public static final int nr_id = 1;
    public static final int nr_smeId = 2;
    public static final int nr_name = 3;
    public static final int nr_value = 4;
    public static final int nr_isLocal = 5;
    public static final int nr_evLink = 6;
    public static final int nr_isLong = 7;
    public static final int nr_creatorUId = 8;
    public static final int nr_createTs = 9;
    public static final int nr_changerUId = 10;
    public static final int nr_changeTs = 11;
    public static String tableName = "ENTITY_VARIABLE";
    protected Long smeId;
    protected String name;
    protected String value;
    protected Boolean isLocal;
    protected Long evLink;
    protected Boolean isLong;
    protected Long creatorUId;
    protected Long createTs;
    protected Long changerUId;
    protected Long changeTs;
    private static PreparedStatement[] pUpdate = new PreparedStatement[128];
    private static PreparedStatement[] pDelete = new PreparedStatement[128];
    private static PreparedStatement[] pInsert = new PreparedStatement[128];

    public SDMSEntityVariableGeneric(SystemEnvironment systemEnvironment, Long l, String string, String string2, Boolean bl, Long l2, Boolean bl2, Long l3, Long l4, Long l5, Long l6) throws SDMSException {
        super(systemEnvironment, SDMSEntityVariableTableGeneric.table);
        this.smeId = l;
        if (string != null && string.length() > 64) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(EntityVariable) Length of $1 exceeds maximum length $2", "name", "64"));
        }
        this.name = string;
        if (string2 != null && string2.length() > 256) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(EntityVariable) Length of $1 exceeds maximum length $2", "value", "256"));
        }
        this.value = string2;
        this.isLocal = bl;
        this.evLink = l2;
        this.isLong = bl2;
        this.creatorUId = l3;
        this.createTs = l4;
        this.changerUId = l5;
        this.changeTs = l6;
    }

    public Long getSmeId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.smeId;
    }

    public void setSmeId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.smeId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(EntityVariable) Change of system object not allowed"));
            }
            SDMSEntityVariableGeneric sDMSEntityVariableGeneric = (SDMSEntityVariableGeneric)this.change(systemEnvironment);
            sDMSEntityVariableGeneric.smeId = l;
            sDMSEntityVariableGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSEntityVariableGeneric.changeTs = systemEnvironment.txTime();
            sDMSEntityVariableGeneric.versions.table.index(systemEnvironment, sDMSEntityVariableGeneric, 3L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public String getName(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.name;
    }

    public void setName(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (this.name.equals(string)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(EntityVariable) Change of system object not allowed"));
            }
            SDMSEntityVariableGeneric sDMSEntityVariableGeneric = (SDMSEntityVariableGeneric)this.change(systemEnvironment);
            if (string != null && string.length() > 64) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(EntityVariable) Length of $1 exceeds maximum length $2", "name", "64"));
            }
            sDMSEntityVariableGeneric.name = string;
            sDMSEntityVariableGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSEntityVariableGeneric.changeTs = systemEnvironment.txTime();
            sDMSEntityVariableGeneric.versions.table.index(systemEnvironment, sDMSEntityVariableGeneric, 2L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public String getValue(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.value;
    }

    public void setValue(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.value)) {
            return;
        }
        if (string == null && this.value == null) {
            return;
        }
        SDMSEntityVariableGeneric sDMSEntityVariableGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(EntityVariable) Change of system object not allowed"));
        }
        if (sDMSEntityVariableGeneric.versions.o_v == null || sDMSEntityVariableGeneric.versions.o_v.size() == 0 || sDMSEntityVariableGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSEntityVariableGeneric = (SDMSEntityVariableGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 256) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(EntityVariable) Length of $1 exceeds maximum length $2", "value", "256"));
        }
        sDMSEntityVariableGeneric.value = string;
        sDMSEntityVariableGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSEntityVariableGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSEntityVariableGeneric != this) {
            sDMSEntityVariableGeneric.versions.table.index(systemEnvironment, sDMSEntityVariableGeneric, 0L);
        }
    }

    public Boolean getIsLocal(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isLocal;
    }

    public void setIsLocal(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.isLocal.equals(bl)) {
            return;
        }
        SDMSEntityVariableGeneric sDMSEntityVariableGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(EntityVariable) Change of system object not allowed"));
        }
        if (sDMSEntityVariableGeneric.versions.o_v == null || sDMSEntityVariableGeneric.versions.o_v.size() == 0 || sDMSEntityVariableGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSEntityVariableGeneric = (SDMSEntityVariableGeneric)this.change(systemEnvironment);
        }
        sDMSEntityVariableGeneric.isLocal = bl;
        sDMSEntityVariableGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSEntityVariableGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSEntityVariableGeneric != this) {
            sDMSEntityVariableGeneric.versions.table.index(systemEnvironment, sDMSEntityVariableGeneric, 0L);
        }
    }

    public Long getEvLink(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.evLink;
    }

    public void setEvLink(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.evLink)) {
            return;
        }
        if (l == null && this.evLink == null) {
            return;
        }
        SDMSEntityVariableGeneric sDMSEntityVariableGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(EntityVariable) Change of system object not allowed"));
        }
        if (sDMSEntityVariableGeneric.versions.o_v == null || sDMSEntityVariableGeneric.versions.o_v.size() == 0 || sDMSEntityVariableGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSEntityVariableGeneric = (SDMSEntityVariableGeneric)this.change(systemEnvironment);
        }
        sDMSEntityVariableGeneric.evLink = l;
        sDMSEntityVariableGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSEntityVariableGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSEntityVariableGeneric != this) {
            sDMSEntityVariableGeneric.versions.table.index(systemEnvironment, sDMSEntityVariableGeneric, 0L);
        }
    }

    public Boolean getIsLong(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isLong;
    }

    public void setIsLong(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.isLong.equals(bl)) {
            return;
        }
        SDMSEntityVariableGeneric sDMSEntityVariableGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(EntityVariable) Change of system object not allowed"));
        }
        if (sDMSEntityVariableGeneric.versions.o_v == null || sDMSEntityVariableGeneric.versions.o_v.size() == 0 || sDMSEntityVariableGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSEntityVariableGeneric = (SDMSEntityVariableGeneric)this.change(systemEnvironment);
        }
        sDMSEntityVariableGeneric.isLong = bl;
        sDMSEntityVariableGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSEntityVariableGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSEntityVariableGeneric != this) {
            sDMSEntityVariableGeneric.versions.table.index(systemEnvironment, sDMSEntityVariableGeneric, 0L);
        }
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.creatorUId;
    }

    void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.creatorUId.equals(l)) {
            return;
        }
        SDMSEntityVariableGeneric sDMSEntityVariableGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(EntityVariable) Change of system object not allowed"));
        }
        if (sDMSEntityVariableGeneric.versions.o_v == null || sDMSEntityVariableGeneric.versions.o_v.size() == 0 || sDMSEntityVariableGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSEntityVariableGeneric = (SDMSEntityVariableGeneric)this.change(systemEnvironment);
        }
        sDMSEntityVariableGeneric.creatorUId = l;
        sDMSEntityVariableGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSEntityVariableGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSEntityVariableGeneric != this) {
            sDMSEntityVariableGeneric.versions.table.index(systemEnvironment, sDMSEntityVariableGeneric, 0L);
        }
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.createTs;
    }

    void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.createTs.equals(l)) {
            return;
        }
        SDMSEntityVariableGeneric sDMSEntityVariableGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(EntityVariable) Change of system object not allowed"));
        }
        if (sDMSEntityVariableGeneric.versions.o_v == null || sDMSEntityVariableGeneric.versions.o_v.size() == 0 || sDMSEntityVariableGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSEntityVariableGeneric = (SDMSEntityVariableGeneric)this.change(systemEnvironment);
        }
        sDMSEntityVariableGeneric.createTs = l;
        sDMSEntityVariableGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSEntityVariableGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSEntityVariableGeneric != this) {
            sDMSEntityVariableGeneric.versions.table.index(systemEnvironment, sDMSEntityVariableGeneric, 0L);
        }
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changerUId;
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSEntityVariableGeneric sDMSEntityVariableGeneric = this;
        if (sDMSEntityVariableGeneric.versions.o_v == null || sDMSEntityVariableGeneric.versions.o_v.size() == 0 || sDMSEntityVariableGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSEntityVariableGeneric = (SDMSEntityVariableGeneric)this.change(systemEnvironment);
        }
        sDMSEntityVariableGeneric.changerUId = l;
        sDMSEntityVariableGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSEntityVariableGeneric != this) {
            sDMSEntityVariableGeneric.versions.table.index(systemEnvironment, sDMSEntityVariableGeneric, 0L);
        }
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changeTs;
    }

    void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.changeTs.equals(l)) {
            return;
        }
        SDMSEntityVariableGeneric sDMSEntityVariableGeneric = this;
        if (sDMSEntityVariableGeneric.versions.o_v == null || sDMSEntityVariableGeneric.versions.o_v.size() == 0 || sDMSEntityVariableGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSEntityVariableGeneric = (SDMSEntityVariableGeneric)this.change(systemEnvironment);
        }
        sDMSEntityVariableGeneric.changeTs = l;
        sDMSEntityVariableGeneric.changerUId = systemEnvironment.cEnv.uid();
        if (sDMSEntityVariableGeneric != this) {
            sDMSEntityVariableGeneric.versions.table.index(systemEnvironment, sDMSEntityVariableGeneric, 0L);
        }
    }

    public SDMSEntityVariableGeneric set_SmeIdName(SystemEnvironment systemEnvironment, Long l, String string) throws SDMSException {
        SDMSEntityVariableGeneric sDMSEntityVariableGeneric;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141637", "(EntityVariable) Change of system object not allowed"));
            }
            sDMSEntityVariableGeneric = (SDMSEntityVariableGeneric)this.change(systemEnvironment);
            sDMSEntityVariableGeneric.smeId = l;
            if (string != null && string.length() > 64) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01201290026", "(EntityVariable) Length of $1 exceeds maximum length $2", "changeTs", "64"));
            }
            sDMSEntityVariableGeneric.name = string;
            sDMSEntityVariableGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSEntityVariableGeneric.changeTs = systemEnvironment.txTime();
            sDMSEntityVariableGeneric.versions.table.index(systemEnvironment, sDMSEntityVariableGeneric);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        return sDMSEntityVariableGeneric;
    }

    @Override
    protected SDMSProxy toProxy(SystemEnvironment systemEnvironment) {
        return new SDMSEntityVariable(this);
    }

    protected SDMSEntityVariableGeneric(Long l, Long l2, String string, String string2, Boolean bl, Long l3, Boolean bl2, Long l4, Long l5, Long l6, Long l7, long l8, long l9) {
        this.id = l;
        this.smeId = l2;
        this.name = string;
        this.value = string2;
        this.isLocal = bl;
        this.evLink = l3;
        this.isLong = bl2;
        this.creatorUId = l4;
        this.createTs = l5;
        this.changerUId = l6;
        this.changeTs = l7;
        this.validFrom = l8;
        this.validTo = l9;
    }

    protected String tableName() {
        return tableName;
    }

    @Override
    protected void insertDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pInsert[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "INSERT INTO " + string2 + "ENTITY_VARIABLE" + string3 + " (ID, " + string2 + "SME_ID" + string3 + ", " + string2 + "NAME" + string3 + ", " + string2 + "VALUE" + string3 + ", " + string2 + "IS_LOCAL" + string3 + ", " + string2 + "EV_LINK" + string3 + ", " + string2 + "IS_LONG" + string3 + ", " + string2 + "CREATOR_U_ID" + string3 + ", " + string2 + "CREATE_TS" + string3 + ", " + string2 + "CHANGER_U_ID" + string3 + ", " + string2 + "CHANGE_TS" + string3 + ") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                SDMSEntityVariableGeneric.pInsert[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181952", "EntityVariable: $1\n$2", string, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pInsert[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.setLong(2, this.smeId);
            preparedStatement.setString(3, this.name);
            if (this.value == null) {
                preparedStatement.setNull(4, 12);
            } else {
                preparedStatement.setString(4, this.value);
            }
            preparedStatement.setInt(5, this.isLocal != false ? 1 : 0);
            if (this.evLink == null) {
                preparedStatement.setNull(6, 4);
            } else {
                preparedStatement.setLong(6, this.evLink);
            }
            preparedStatement.setInt(7, this.isLong != false ? 1 : 0);
            preparedStatement.setLong(8, this.creatorUId);
            preparedStatement.setLong(9, this.createTs);
            preparedStatement.setLong(10, this.changerUId);
            preparedStatement.setLong(11, this.changeTs);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181954", "EntityVariable: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    @Override
    protected void deleteDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pDelete[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "DELETE FROM " + string2 + "ENTITY_VARIABLE" + string3 + " WHERE ID = ?";
                SDMSEntityVariableGeneric.pDelete[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182001", "EntityVariable: $1\n$2", string, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pDelete[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182002", "EntityVariable: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    @Override
    protected void updateDBObject(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        if (pUpdate[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "UPDATE " + string2 + "ENTITY_VARIABLE" + string3 + " SET " + string2 + "SME_ID" + string3 + " = ? , " + string2 + "NAME" + string3 + " = ? , " + string2 + "VALUE" + string3 + " = ? , " + string2 + "IS_LOCAL" + string3 + " = ? , " + string2 + "EV_LINK" + string3 + " = ? , " + string2 + "IS_LONG" + string3 + " = ? , " + string2 + "CREATOR_U_ID" + string3 + " = ? , " + string2 + "CREATE_TS" + string3 + " = ? , " + string2 + "CHANGER_U_ID" + string3 + " = ? , " + string2 + "CHANGE_TS" + string3 + " = ? WHERE ID = ?";
                SDMSEntityVariableGeneric.pUpdate[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182005", "EntityVariable: $1\n$2", string, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pUpdate[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.smeId);
            preparedStatement.setString(2, this.name);
            if (this.value == null) {
                preparedStatement.setNull(3, 12);
            } else {
                preparedStatement.setString(3, this.value);
            }
            preparedStatement.setInt(4, this.isLocal != false ? 1 : 0);
            if (this.evLink == null) {
                preparedStatement.setNull(5, 4);
            } else {
                preparedStatement.setLong(5, this.evLink);
            }
            preparedStatement.setInt(6, this.isLong != false ? 1 : 0);
            preparedStatement.setLong(7, this.creatorUId);
            preparedStatement.setLong(8, this.createTs);
            preparedStatement.setLong(9, this.changerUId);
            preparedStatement.setLong(10, this.changeTs);
            preparedStatement.setLong(11, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182006", "EntityVariable: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    @Override
    public void print() {
        SDMSThread.doTrace(null, "Type : EntityVariable", 2);
        SDMSThread.doTrace(null, "id : " + this.id, 2);
        SDMSThread.doTrace(null, "smeId : " + this.smeId, 2);
        SDMSThread.doTrace(null, "name : " + this.name, 2);
        SDMSThread.doTrace(null, "value : " + this.value, 2);
        SDMSThread.doTrace(null, "isLocal : " + this.isLocal, 2);
        SDMSThread.doTrace(null, "evLink : " + this.evLink, 2);
        SDMSThread.doTrace(null, "isLong : " + this.isLong, 2);
        SDMSThread.doTrace(null, "creatorUId : " + this.creatorUId, 2);
        SDMSThread.doTrace(null, "createTs : " + this.createTs, 2);
        SDMSThread.doTrace(null, "changerUId : " + this.changerUId, 2);
        SDMSThread.doTrace(null, "changeTs : " + this.changeTs, 2);
        SDMSThread.doTrace(null, "validFrom : " + this.validFrom, 2);
        SDMSThread.doTrace(null, "validTo : " + this.validTo, 2);
        this.dumpVersions(2);
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        String string = new String(stringBuffer);
        String string2 = string + "id : " + this.id + "\n" + string + "smeId      : " + this.smeId + "\n" + string + "name       : " + this.name + "\n" + string + "value      : " + this.value + "\n" + string + "isLocal    : " + this.isLocal + "\n" + string + "evLink     : " + this.evLink + "\n" + string + "isLong     : " + this.isLong + "\n" + string + "creatorUId : " + this.creatorUId + "\n" + string + "createTs   : " + this.createTs + "\n" + string + "changerUId : " + this.changerUId + "\n" + string + "changeTs   : " + this.changeTs + "\n" + string + "validFrom : " + this.validFrom + "\n" + string + "validTo : " + this.validTo + "\n";
        return string2;
    }

    public String toString() {
        String string = this.toString(0);
        return string;
    }
}

