/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSExitStateMapping;
import de.independit.scheduler.server.repository.SDMSExitStateMappingGeneric;
import de.independit.scheduler.server.repository.SDMSExitStateMappingTable;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSExitStateMappingTableGeneric
extends SDMSTable {
    public static final String tableName = "EXIT_STATE_MAPPING";
    public static SDMSExitStateMappingTable table = null;
    public static final String[] columnNames = new String[]{"ID", "ESMP_ID", "ESD_ID", "ECR_START", "ECR_END", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_esmpId;
    public static SDMSIndex idx_esdId;
    public static SDMSIndex idx_esmpId_esdId;

    public SDMSExitStateMappingTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "ExitStateMapping"));
        }
        table = (SDMSExitStateMappingTable)this;
        table = (SDMSExitStateMappingTable)this;
        this.isVersioned = true;
        idx_esmpId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "esmpId");
        idx_esdId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "esdId");
        idx_esmpId_esdId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "esmpId_esdId");
    }

    public SDMSExitStateMapping create(SystemEnvironment systemEnvironment, Long l, Long l2, Integer n, Integer n2) throws SDMSException {
        SDMSExitStateMapping sDMSExitStateMapping;
        Long l3 = systemEnvironment.cEnv.uid();
        Long l4 = systemEnvironment.txTime();
        Long l5 = systemEnvironment.cEnv.uid();
        Long l6 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "ExitStateMapping"));
        }
        this.validate(systemEnvironment, l, l2, n, n2, l3, l4, l5, l6);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSExitStateMappingGeneric sDMSExitStateMappingGeneric = new SDMSExitStateMappingGeneric(systemEnvironment, l, l2, n, n2, l3, l4, l5, l6);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSExitStateMappingGeneric.versions, true);
            table.put(systemEnvironment, sDMSExitStateMappingGeneric.id, sDMSExitStateMappingGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSExitStateMapping = (SDMSExitStateMapping)sDMSExitStateMappingGeneric.toProxy(systemEnvironment);
            sDMSExitStateMapping.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSExitStateMapping sDMSExitStateMapping2 = (SDMSExitStateMapping)sDMSExitStateMappingGeneric.toProxy(systemEnvironment);
            sDMSExitStateMapping2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSExitStateMapping)) {
            throw new AccessViolationException(sDMSExitStateMapping.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        sDMSExitStateMapping.touchMaster(systemEnvironment);
        return sDMSExitStateMapping;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSExitStateMapping sDMSExitStateMapping) throws SDMSException {
        return sDMSExitStateMapping.checkPrivileges(systemEnvironment, 1L);
    }

    protected void validate(SystemEnvironment systemEnvironment, Long l, Long l2, Integer n, Integer n2, Long l3, Long l4, Long l5, Long l6) throws SDMSException {
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Integer n;
        Integer n2;
        Long l7;
        Long l8;
        Long l9;
        try {
            l9 = resultSet.getLong(1);
            l8 = resultSet.getLong(2);
            l7 = resultSet.getLong(3);
            n2 = resultSet.getInt(4);
            if (resultSet.wasNull()) {
                n2 = null;
            }
            n = resultSet.getInt(5);
            if (resultSet.wasNull()) {
                n = null;
            }
            l6 = resultSet.getLong(6);
            l5 = resultSet.getLong(7);
            l4 = resultSet.getLong(8);
            l3 = resultSet.getLong(9);
            l2 = resultSet.getLong(10);
            l = resultSet.getLong(11);
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "ExitStateMapping: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSExitStateMappingGeneric(l9, l8, l7, n2, n, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID, " + string + "ESMP_ID" + string2 + ", " + string + "ESD_ID" + string2 + ", " + string + "ECR_START" + string2 + ", " + string + "ECR_END" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + ", VALID_FROM, VALID_TO  FROM " + string + this.tableName() + string2 + " WHERE VALID_TO >= " + (bl ? "CAST ('" + systemEnvironment.lowestActiveVersion + "' AS DECIMAL)" : "" + systemEnvironment.lowestActiveVersion) + "");
        while (resultSet.next()) {
            try {
                if (this.loadObject(systemEnvironment, resultSet)) {
                    ++n2;
                }
                ++n;
            }
            catch (Exception exception) {
                SDMSThread.doTrace(null, "Exception caught while loading table " + this.tableName() + ", ID = " + Long.valueOf(resultSet.getLong(1)), -1);
                throw exception;
            }
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_esmpId.check(((SDMSExitStateMappingGeneric)sDMSObject).esmpId, sDMSObject);
        string = string + "idx_esmpId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_esdId.check(((SDMSExitStateMappingGeneric)sDMSObject).esdId, sDMSObject);
        string = string + "idx_esdId: " + (bl ? "ok" : "missing") + "\n";
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSExitStateMappingGeneric)sDMSObject).esmpId);
        sDMSKey.add(((SDMSExitStateMappingGeneric)sDMSObject).esdId);
        bl = idx_esmpId_esdId.check(sDMSKey, sDMSObject);
        string = string + "idx_esmpId_esdId: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_esmpId.put(systemEnvironment, ((SDMSExitStateMappingGeneric)sDMSObject).esmpId, sDMSObject, (1L & l) != 0L);
        idx_esdId.put(systemEnvironment, ((SDMSExitStateMappingGeneric)sDMSObject).esdId, sDMSObject, (2L & l) != 0L);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSExitStateMappingGeneric)sDMSObject).esmpId);
        sDMSKey.add(((SDMSExitStateMappingGeneric)sDMSObject).esdId);
        idx_esmpId_esdId.put(systemEnvironment, sDMSKey, sDMSObject, (4L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_esmpId.remove(systemEnvironment, ((SDMSExitStateMappingGeneric)sDMSObject).esmpId, sDMSObject);
        idx_esdId.remove(systemEnvironment, ((SDMSExitStateMappingGeneric)sDMSObject).esdId, sDMSObject);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSExitStateMappingGeneric)sDMSObject).esmpId);
        sDMSKey.add(((SDMSExitStateMappingGeneric)sDMSObject).esdId);
        idx_esmpId_esdId.remove(systemEnvironment, sDMSKey, sDMSObject);
    }

    public static SDMSExitStateMapping getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSExitStateMapping)table.get(systemEnvironment, l);
    }

    public static SDMSExitStateMapping getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSExitStateMapping)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSExitStateMapping getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSExitStateMapping)table.get(systemEnvironment, l, l2);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

