/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSGrant;
import de.independit.scheduler.server.repository.SDMSGrantGeneric;
import de.independit.scheduler.server.repository.SDMSGrantTable;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSGrantTableGeneric
extends SDMSTable {
    public static final String tableName = "GRANTS";
    public static SDMSGrantTable table = null;
    public static final String[] columnNames = new String[]{"ID", "OBJECT_ID", "G_ID", "OBJECT_TYPE", "PRIVS", "DELETE_VERSION", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_objectId;
    public static SDMSIndex idx_gId;
    public static SDMSIndex idx_objectId_gId;

    public SDMSGrantTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "Grant"));
        }
        table = (SDMSGrantTable)this;
        table = (SDMSGrantTable)this;
        this.isVersioned = false;
        idx_objectId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "objectId");
        idx_gId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "gId");
        idx_objectId_gId = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "objectId_gId");
    }

    public SDMSGrant create(SystemEnvironment systemEnvironment, Long l, Long l2, Integer n, Long l3, Long l4) throws SDMSException {
        SDMSGrant sDMSGrant;
        Long l5 = systemEnvironment.cEnv.uid();
        Long l6 = systemEnvironment.txTime();
        Long l7 = systemEnvironment.cEnv.uid();
        Long l8 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "Grant"));
        }
        this.validate(systemEnvironment, l, l2, n, l3, l4, l5, l6, l7, l8);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSGrantGeneric sDMSGrantGeneric = new SDMSGrantGeneric(systemEnvironment, l, l2, n, l3, l4, l5, l6, l7, l8);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSGrantGeneric.versions, true);
            table.put(systemEnvironment, sDMSGrantGeneric.id, sDMSGrantGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSGrant = (SDMSGrant)sDMSGrantGeneric.toProxy(systemEnvironment);
            sDMSGrant.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSGrant sDMSGrant2 = (SDMSGrant)sDMSGrantGeneric.toProxy(systemEnvironment);
            sDMSGrant2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSGrant)) {
            throw new AccessViolationException(sDMSGrant.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        sDMSGrant.touchMaster(systemEnvironment);
        return sDMSGrant;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSGrant sDMSGrant) throws SDMSException {
        return sDMSGrant.checkPrivileges(systemEnvironment, 1L);
    }

    protected void validate(SystemEnvironment systemEnvironment, Long l, Long l2, Integer n, Long l3, Long l4, Long l5, Long l6, Long l7, Long l8) throws SDMSException {
        if (!SDMSGrantGeneric.checkObjectType(n)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "Grant: $1 $2", "objectType", n));
        }
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Long l7;
        Long l8;
        Integer n;
        Long l9;
        Long l10;
        Long l11;
        try {
            l11 = resultSet.getLong(1);
            l10 = resultSet.getLong(2);
            l9 = resultSet.getLong(3);
            n = resultSet.getInt(4);
            l8 = resultSet.getLong(5);
            l7 = resultSet.getLong(6);
            if (resultSet.wasNull()) {
                l7 = null;
            }
            l6 = resultSet.getLong(7);
            l5 = resultSet.getLong(8);
            l4 = resultSet.getLong(9);
            l3 = resultSet.getLong(10);
            l2 = 0L;
            l = Long.MAX_VALUE;
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "Grant: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSGrantGeneric(l11, l10, l9, n, l8, l7, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID, " + string + "OBJECT_ID" + string2 + ", " + string + "G_ID" + string2 + ", " + string + "OBJECT_TYPE" + string2 + ", " + string + "PRIVS" + string2 + ", " + string + "DELETE_VERSION" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + " FROM " + string + this.tableName() + string2 + "");
        while (resultSet.next()) {
            try {
                if (this.loadObject(systemEnvironment, resultSet)) {
                    ++n2;
                }
                ++n;
            }
            catch (Exception exception) {
                SDMSThread.doTrace(null, "Exception caught while loading table " + this.tableName() + ", ID = " + Long.valueOf(resultSet.getLong(1)), -1);
                throw exception;
            }
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_objectId.check(((SDMSGrantGeneric)sDMSObject).objectId, sDMSObject);
        string = string + "idx_objectId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_gId.check(((SDMSGrantGeneric)sDMSObject).gId, sDMSObject);
        string = string + "idx_gId: " + (bl ? "ok" : "missing") + "\n";
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSGrantGeneric)sDMSObject).objectId);
        sDMSKey.add(((SDMSGrantGeneric)sDMSObject).gId);
        bl = idx_objectId_gId.check(sDMSKey, sDMSObject);
        string = string + "idx_objectId_gId: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_objectId.put(systemEnvironment, ((SDMSGrantGeneric)sDMSObject).objectId, sDMSObject, (1L & l) != 0L);
        idx_gId.put(systemEnvironment, ((SDMSGrantGeneric)sDMSObject).gId, sDMSObject, (2L & l) != 0L);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSGrantGeneric)sDMSObject).objectId);
        sDMSKey.add(((SDMSGrantGeneric)sDMSObject).gId);
        idx_objectId_gId.put(systemEnvironment, sDMSKey, sDMSObject, (4L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_objectId.remove(systemEnvironment, ((SDMSGrantGeneric)sDMSObject).objectId, sDMSObject);
        idx_gId.remove(systemEnvironment, ((SDMSGrantGeneric)sDMSObject).gId, sDMSObject);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSGrantGeneric)sDMSObject).objectId);
        sDMSKey.add(((SDMSGrantGeneric)sDMSObject).gId);
        idx_objectId_gId.remove(systemEnvironment, sDMSKey, sDMSObject);
    }

    public static SDMSGrant getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSGrant)table.get(systemEnvironment, l);
    }

    public static SDMSGrant getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSGrant)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSGrant getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSGrant)table.get(systemEnvironment, l, l2);
    }

    public static SDMSGrant idx_objectId_gId_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSGrant)idx_objectId_gId.getUnique(systemEnvironment, object);
    }

    public static SDMSGrant idx_objectId_gId_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSGrant)idx_objectId_gId.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSGrant idx_objectId_gId_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSGrant)idx_objectId_gId.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

