/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSNiceProfileEntry;
import de.independit.scheduler.server.repository.SDMSNiceProfileEntryGeneric;
import de.independit.scheduler.server.repository.SDMSNiceProfileEntryTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSNiceProfileEntryTableGeneric
extends SDMSTable {
    public static final String tableName = "NICE_PROFILE_ENTRY";
    public static SDMSNiceProfileEntryTable table = null;
    public static final String[] columnNames = new String[]{"ID", "NP_ID", "PREFERENCE", "FOLDER_ID", "IS_SUSPENDED", "RENICE", "IS_ACTIVE", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_npId;
    public static SDMSIndex idx_folderId;

    public SDMSNiceProfileEntryTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "NiceProfileEntry"));
        }
        table = (SDMSNiceProfileEntryTable)this;
        table = (SDMSNiceProfileEntryTable)this;
        this.isVersioned = false;
        idx_npId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "npId");
        idx_folderId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "folderId");
    }

    public SDMSNiceProfileEntry create(SystemEnvironment systemEnvironment, Long l, Integer n, Long l2, Integer n2, Integer n3, Boolean bl) throws SDMSException {
        SDMSNiceProfileEntry sDMSNiceProfileEntry;
        Long l3 = systemEnvironment.cEnv.uid();
        Long l4 = systemEnvironment.txTime();
        Long l5 = systemEnvironment.cEnv.uid();
        Long l6 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "NiceProfileEntry"));
        }
        this.validate(systemEnvironment, l, n, l2, n2, n3, bl, l3, l4, l5, l6);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSNiceProfileEntryGeneric sDMSNiceProfileEntryGeneric = new SDMSNiceProfileEntryGeneric(systemEnvironment, l, n, l2, n2, n3, bl, l3, l4, l5, l6);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSNiceProfileEntryGeneric.versions, true);
            table.put(systemEnvironment, sDMSNiceProfileEntryGeneric.id, sDMSNiceProfileEntryGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSNiceProfileEntry = (SDMSNiceProfileEntry)sDMSNiceProfileEntryGeneric.toProxy(systemEnvironment);
            sDMSNiceProfileEntry.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSNiceProfileEntry sDMSNiceProfileEntry2 = (SDMSNiceProfileEntry)sDMSNiceProfileEntryGeneric.toProxy(systemEnvironment);
            sDMSNiceProfileEntry2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSNiceProfileEntry)) {
            throw new AccessViolationException(sDMSNiceProfileEntry.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        sDMSNiceProfileEntry.touchMaster(systemEnvironment);
        return sDMSNiceProfileEntry;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSNiceProfileEntry sDMSNiceProfileEntry) throws SDMSException {
        return sDMSNiceProfileEntry.checkPrivileges(systemEnvironment, 1L);
    }

    protected void validate(SystemEnvironment systemEnvironment, Long l, Integer n, Long l2, Integer n2, Integer n3, Boolean bl, Long l3, Long l4, Long l5, Long l6) throws SDMSException {
        if (!SDMSNiceProfileEntryGeneric.checkIsSuspended(n2)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "NiceProfileEntry: $1 $2", "isSuspended", n2));
        }
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Boolean bl;
        Integer n;
        Integer n2;
        Long l7;
        Integer n3;
        Long l8;
        Long l9;
        try {
            l9 = resultSet.getLong(1);
            l8 = resultSet.getLong(2);
            n3 = resultSet.getInt(3);
            l7 = resultSet.getLong(4);
            if (resultSet.wasNull()) {
                l7 = null;
            }
            n2 = resultSet.getInt(5);
            n = resultSet.getInt(6);
            bl = resultSet.getInt(7) != 0;
            l6 = resultSet.getLong(8);
            l5 = resultSet.getLong(9);
            l4 = resultSet.getLong(10);
            l3 = resultSet.getLong(11);
            l2 = 0L;
            l = Long.MAX_VALUE;
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "NiceProfileEntry: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSNiceProfileEntryGeneric(l9, l8, n3, l7, n2, n, bl, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID, " + string + "NP_ID" + string2 + ", " + string + "PREFERENCE" + string2 + ", " + string + "FOLDER_ID" + string2 + ", " + string + "IS_SUSPENDED" + string2 + ", " + string + "RENICE" + string2 + ", " + string + "IS_ACTIVE" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + " FROM " + string + this.tableName() + string2 + "");
        while (resultSet.next()) {
            try {
                if (this.loadObject(systemEnvironment, resultSet)) {
                    ++n2;
                }
                ++n;
            }
            catch (Exception exception) {
                SDMSThread.doTrace(null, "Exception caught while loading table " + this.tableName() + ", ID = " + Long.valueOf(resultSet.getLong(1)), -1);
                throw exception;
            }
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_npId.check(((SDMSNiceProfileEntryGeneric)sDMSObject).npId, sDMSObject);
        string = string + "idx_npId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_folderId.check(((SDMSNiceProfileEntryGeneric)sDMSObject).folderId, sDMSObject);
        string = string + "idx_folderId: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_npId.put(systemEnvironment, ((SDMSNiceProfileEntryGeneric)sDMSObject).npId, sDMSObject, (1L & l) != 0L);
        idx_folderId.put(systemEnvironment, ((SDMSNiceProfileEntryGeneric)sDMSObject).folderId, sDMSObject, (2L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_npId.remove(systemEnvironment, ((SDMSNiceProfileEntryGeneric)sDMSObject).npId, sDMSObject);
        idx_folderId.remove(systemEnvironment, ((SDMSNiceProfileEntryGeneric)sDMSObject).folderId, sDMSObject);
    }

    public static SDMSNiceProfileEntry getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSNiceProfileEntry)table.get(systemEnvironment, l);
    }

    public static SDMSNiceProfileEntry getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSNiceProfileEntry)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSNiceProfileEntry getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSNiceProfileEntry)table.get(systemEnvironment, l, l2);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

