/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SDMSSQLException;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSObjectMonitor;
import de.independit.scheduler.server.repository.SDMSObjectMonitorTableGeneric;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SDMSObjectMonitorGeneric
extends SDMSObject
implements Cloneable {
    public static final int NONE = 0;
    public static final int CREATE = 1;
    public static final int CHANGE = 2;
    public static final int MINUTE = 0;
    public static final int HOUR = 1;
    public static final int DAY = 2;
    public static final int WEEK = 3;
    public static final int MONTH = 4;
    public static final int YEAR = 5;
    public static final int nr_id = 1;
    public static final int nr_name = 2;
    public static final int nr_ownerId = 3;
    public static final int nr_wtId = 4;
    public static final int nr_recreateHandling = 5;
    public static final int nr_watchSeId = 6;
    public static final int nr_deleteAmount = 7;
    public static final int nr_deleteBase = 8;
    public static final int nr_eventDeleteAmount = 9;
    public static final int nr_eventDeleteBase = 10;
    public static final int nr_creatorUId = 11;
    public static final int nr_createTs = 12;
    public static final int nr_changerUId = 13;
    public static final int nr_changeTs = 14;
    public static String tableName = "OBJECT_MONITOR";
    protected String name;
    protected Long ownerId;
    protected Long wtId;
    protected Integer recreateHandling;
    protected Long watchSeId;
    protected Integer deleteAmount;
    protected Integer deleteBase;
    protected Integer eventDeleteAmount;
    protected Integer eventDeleteBase;
    protected Long creatorUId;
    protected Long createTs;
    protected Long changerUId;
    protected Long changeTs;
    private static PreparedStatement[] pUpdate = new PreparedStatement[128];
    private static PreparedStatement[] pDelete = new PreparedStatement[128];
    private static PreparedStatement[] pInsert = new PreparedStatement[128];

    public SDMSObjectMonitorGeneric(SystemEnvironment systemEnvironment, String string, Long l, Long l2, Integer n, Long l3, Integer n2, Integer n3, Integer n4, Integer n5, Long l4, Long l5, Long l6, Long l7) throws SDMSException {
        super(systemEnvironment, SDMSObjectMonitorTableGeneric.table);
        if (string != null && string.length() > 64) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(ObjectMonitor) Length of $1 exceeds maximum length $2", "name", "64"));
        }
        this.name = string;
        this.ownerId = l;
        this.wtId = l2;
        this.recreateHandling = n;
        this.watchSeId = l3;
        this.deleteAmount = n2;
        this.deleteBase = n3;
        this.eventDeleteAmount = n4;
        this.eventDeleteBase = n5;
        this.creatorUId = l4;
        this.createTs = l5;
        this.changerUId = l6;
        this.changeTs = l7;
    }

    public String getName(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.name;
    }

    public void setName(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (this.name.equals(string)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ObjectMonitor) Change of system object not allowed"));
            }
            SDMSObjectMonitorGeneric sDMSObjectMonitorGeneric = (SDMSObjectMonitorGeneric)this.change(systemEnvironment);
            if (string != null && string.length() > 64) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(ObjectMonitor) Length of $1 exceeds maximum length $2", "name", "64"));
            }
            sDMSObjectMonitorGeneric.name = string;
            sDMSObjectMonitorGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSObjectMonitorGeneric.changeTs = systemEnvironment.txTime();
            sDMSObjectMonitorGeneric.versions.table.index(systemEnvironment, sDMSObjectMonitorGeneric, 1L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getOwnerId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.ownerId;
    }

    public void setOwnerId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.ownerId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            SDMSObjectMonitorGeneric sDMSObjectMonitorGeneric = (SDMSObjectMonitorGeneric)this.change(systemEnvironment);
            sDMSObjectMonitorGeneric.ownerId = l;
            sDMSObjectMonitorGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSObjectMonitorGeneric.changeTs = systemEnvironment.txTime();
            sDMSObjectMonitorGeneric.versions.table.index(systemEnvironment, sDMSObjectMonitorGeneric, 2L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getWtId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.wtId;
    }

    public void setWtId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.wtId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ObjectMonitor) Change of system object not allowed"));
            }
            SDMSObjectMonitorGeneric sDMSObjectMonitorGeneric = (SDMSObjectMonitorGeneric)this.change(systemEnvironment);
            sDMSObjectMonitorGeneric.wtId = l;
            sDMSObjectMonitorGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSObjectMonitorGeneric.changeTs = systemEnvironment.txTime();
            sDMSObjectMonitorGeneric.versions.table.index(systemEnvironment, sDMSObjectMonitorGeneric, 4L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Integer getRecreateHandling(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.recreateHandling;
    }

    public String getRecreateHandlingAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getRecreateHandling(systemEnvironment);
        switch (n) {
            case 0: {
                return "NONE";
            }
            case 1: {
                return "CREATE";
            }
            case 2: {
                return "CHANGE";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown ObjectMonitor.recreateHandling: $1", this.getRecreateHandling(systemEnvironment)));
    }

    public void setRecreateHandling(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.recreateHandling.equals(n)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ObjectMonitor) Change of system object not allowed"));
            }
            SDMSObjectMonitorGeneric sDMSObjectMonitorGeneric = (SDMSObjectMonitorGeneric)this.change(systemEnvironment);
            sDMSObjectMonitorGeneric.recreateHandling = n;
            sDMSObjectMonitorGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSObjectMonitorGeneric.changeTs = systemEnvironment.txTime();
            sDMSObjectMonitorGeneric.versions.table.index(systemEnvironment, sDMSObjectMonitorGeneric, 8L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getWatchSeId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.watchSeId;
    }

    public void setWatchSeId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.watchSeId)) {
            return;
        }
        if (l == null && this.watchSeId == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ObjectMonitor) Change of system object not allowed"));
            }
            SDMSObjectMonitorGeneric sDMSObjectMonitorGeneric = (SDMSObjectMonitorGeneric)this.change(systemEnvironment);
            sDMSObjectMonitorGeneric.watchSeId = l;
            sDMSObjectMonitorGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSObjectMonitorGeneric.changeTs = systemEnvironment.txTime();
            sDMSObjectMonitorGeneric.versions.table.index(systemEnvironment, sDMSObjectMonitorGeneric, 16L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Integer getDeleteAmount(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.deleteAmount;
    }

    public void setDeleteAmount(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.deleteAmount)) {
            return;
        }
        if (n == null && this.deleteAmount == null) {
            return;
        }
        SDMSObjectMonitorGeneric sDMSObjectMonitorGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ObjectMonitor) Change of system object not allowed"));
        }
        if (sDMSObjectMonitorGeneric.versions.o_v == null || sDMSObjectMonitorGeneric.versions.o_v.size() == 0 || sDMSObjectMonitorGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSObjectMonitorGeneric = (SDMSObjectMonitorGeneric)this.change(systemEnvironment);
        }
        sDMSObjectMonitorGeneric.deleteAmount = n;
        sDMSObjectMonitorGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSObjectMonitorGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSObjectMonitorGeneric != this) {
            sDMSObjectMonitorGeneric.versions.table.index(systemEnvironment, sDMSObjectMonitorGeneric, 0L);
        }
    }

    public Integer getDeleteBase(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.deleteBase;
    }

    public String getDeleteBaseAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getDeleteBase(systemEnvironment);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "MINUTE";
            }
            case 1: {
                return "HOUR";
            }
            case 2: {
                return "DAY";
            }
            case 3: {
                return "WEEK";
            }
            case 4: {
                return "MONTH";
            }
            case 5: {
                return "YEAR";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown ObjectMonitor.deleteBase: $1", this.getDeleteBase(systemEnvironment)));
    }

    public void setDeleteBase(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.deleteBase)) {
            return;
        }
        if (n == null && this.deleteBase == null) {
            return;
        }
        SDMSObjectMonitorGeneric sDMSObjectMonitorGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ObjectMonitor) Change of system object not allowed"));
        }
        if (sDMSObjectMonitorGeneric.versions.o_v == null || sDMSObjectMonitorGeneric.versions.o_v.size() == 0 || sDMSObjectMonitorGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSObjectMonitorGeneric = (SDMSObjectMonitorGeneric)this.change(systemEnvironment);
        }
        sDMSObjectMonitorGeneric.deleteBase = n;
        sDMSObjectMonitorGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSObjectMonitorGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSObjectMonitorGeneric != this) {
            sDMSObjectMonitorGeneric.versions.table.index(systemEnvironment, sDMSObjectMonitorGeneric, 0L);
        }
    }

    public Integer getEventDeleteAmount(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.eventDeleteAmount;
    }

    public void setEventDeleteAmount(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.eventDeleteAmount)) {
            return;
        }
        if (n == null && this.eventDeleteAmount == null) {
            return;
        }
        SDMSObjectMonitorGeneric sDMSObjectMonitorGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ObjectMonitor) Change of system object not allowed"));
        }
        if (sDMSObjectMonitorGeneric.versions.o_v == null || sDMSObjectMonitorGeneric.versions.o_v.size() == 0 || sDMSObjectMonitorGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSObjectMonitorGeneric = (SDMSObjectMonitorGeneric)this.change(systemEnvironment);
        }
        sDMSObjectMonitorGeneric.eventDeleteAmount = n;
        sDMSObjectMonitorGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSObjectMonitorGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSObjectMonitorGeneric != this) {
            sDMSObjectMonitorGeneric.versions.table.index(systemEnvironment, sDMSObjectMonitorGeneric, 0L);
        }
    }

    public Integer getEventDeleteBase(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.eventDeleteBase;
    }

    public String getEventDeleteBaseAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getEventDeleteBase(systemEnvironment);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "MINUTE";
            }
            case 1: {
                return "HOUR";
            }
            case 2: {
                return "DAY";
            }
            case 3: {
                return "WEEK";
            }
            case 4: {
                return "MONTH";
            }
            case 5: {
                return "YEAR";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown ObjectMonitor.eventDeleteBase: $1", this.getEventDeleteBase(systemEnvironment)));
    }

    public void setEventDeleteBase(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.eventDeleteBase)) {
            return;
        }
        if (n == null && this.eventDeleteBase == null) {
            return;
        }
        SDMSObjectMonitorGeneric sDMSObjectMonitorGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ObjectMonitor) Change of system object not allowed"));
        }
        if (sDMSObjectMonitorGeneric.versions.o_v == null || sDMSObjectMonitorGeneric.versions.o_v.size() == 0 || sDMSObjectMonitorGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSObjectMonitorGeneric = (SDMSObjectMonitorGeneric)this.change(systemEnvironment);
        }
        sDMSObjectMonitorGeneric.eventDeleteBase = n;
        sDMSObjectMonitorGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSObjectMonitorGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSObjectMonitorGeneric != this) {
            sDMSObjectMonitorGeneric.versions.table.index(systemEnvironment, sDMSObjectMonitorGeneric, 0L);
        }
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.creatorUId;
    }

    void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.creatorUId.equals(l)) {
            return;
        }
        SDMSObjectMonitorGeneric sDMSObjectMonitorGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ObjectMonitor) Change of system object not allowed"));
        }
        if (sDMSObjectMonitorGeneric.versions.o_v == null || sDMSObjectMonitorGeneric.versions.o_v.size() == 0 || sDMSObjectMonitorGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSObjectMonitorGeneric = (SDMSObjectMonitorGeneric)this.change(systemEnvironment);
        }
        sDMSObjectMonitorGeneric.creatorUId = l;
        sDMSObjectMonitorGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSObjectMonitorGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSObjectMonitorGeneric != this) {
            sDMSObjectMonitorGeneric.versions.table.index(systemEnvironment, sDMSObjectMonitorGeneric, 0L);
        }
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.createTs;
    }

    void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.createTs.equals(l)) {
            return;
        }
        SDMSObjectMonitorGeneric sDMSObjectMonitorGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ObjectMonitor) Change of system object not allowed"));
        }
        if (sDMSObjectMonitorGeneric.versions.o_v == null || sDMSObjectMonitorGeneric.versions.o_v.size() == 0 || sDMSObjectMonitorGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSObjectMonitorGeneric = (SDMSObjectMonitorGeneric)this.change(systemEnvironment);
        }
        sDMSObjectMonitorGeneric.createTs = l;
        sDMSObjectMonitorGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSObjectMonitorGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSObjectMonitorGeneric != this) {
            sDMSObjectMonitorGeneric.versions.table.index(systemEnvironment, sDMSObjectMonitorGeneric, 0L);
        }
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changerUId;
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSObjectMonitorGeneric sDMSObjectMonitorGeneric = this;
        if (sDMSObjectMonitorGeneric.versions.o_v == null || sDMSObjectMonitorGeneric.versions.o_v.size() == 0 || sDMSObjectMonitorGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSObjectMonitorGeneric = (SDMSObjectMonitorGeneric)this.change(systemEnvironment);
        }
        sDMSObjectMonitorGeneric.changerUId = l;
        sDMSObjectMonitorGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSObjectMonitorGeneric != this) {
            sDMSObjectMonitorGeneric.versions.table.index(systemEnvironment, sDMSObjectMonitorGeneric, 0L);
        }
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changeTs;
    }

    void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.changeTs.equals(l)) {
            return;
        }
        SDMSObjectMonitorGeneric sDMSObjectMonitorGeneric = this;
        if (sDMSObjectMonitorGeneric.versions.o_v == null || sDMSObjectMonitorGeneric.versions.o_v.size() == 0 || sDMSObjectMonitorGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSObjectMonitorGeneric = (SDMSObjectMonitorGeneric)this.change(systemEnvironment);
        }
        sDMSObjectMonitorGeneric.changeTs = l;
        sDMSObjectMonitorGeneric.changerUId = systemEnvironment.cEnv.uid();
        if (sDMSObjectMonitorGeneric != this) {
            sDMSObjectMonitorGeneric.versions.table.index(systemEnvironment, sDMSObjectMonitorGeneric, 0L);
        }
    }

    @Override
    protected SDMSProxy toProxy(SystemEnvironment systemEnvironment) {
        return new SDMSObjectMonitor(this);
    }

    protected SDMSObjectMonitorGeneric(Long l, String string, Long l2, Long l3, Integer n, Long l4, Integer n2, Integer n3, Integer n4, Integer n5, Long l5, Long l6, Long l7, Long l8, long l9, long l10) {
        this.id = l;
        this.name = string;
        this.ownerId = l2;
        this.wtId = l3;
        this.recreateHandling = n;
        this.watchSeId = l4;
        this.deleteAmount = n2;
        this.deleteBase = n3;
        this.eventDeleteAmount = n4;
        this.eventDeleteBase = n5;
        this.creatorUId = l5;
        this.createTs = l6;
        this.changerUId = l7;
        this.changeTs = l8;
        this.validFrom = l9;
        this.validTo = l10;
    }

    protected String tableName() {
        return tableName;
    }

    @Override
    protected void insertDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pInsert[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "INSERT INTO " + string2 + "OBJECT_MONITOR" + string3 + " (ID, " + string2 + "NAME" + string3 + ", " + string2 + "OWNER_ID" + string3 + ", " + string2 + "WT_ID" + string3 + ", " + string2 + "RECREATE_HANDLING" + string3 + ", " + string2 + "WATCH_SE_ID" + string3 + ", " + string2 + "DELETE_AMOUNT" + string3 + ", " + string2 + "DELETE_BASE" + string3 + ", " + string2 + "EVENT_DELETE_AMOUNT" + string3 + ", " + string2 + "EVENT_DELETE_BASE" + string3 + ", " + string2 + "CREATOR_U_ID" + string3 + ", " + string2 + "CREATE_TS" + string3 + ", " + string2 + "CHANGER_U_ID" + string3 + ", " + string2 + "CHANGE_TS" + string3 + ") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                SDMSObjectMonitorGeneric.pInsert[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181952", "ObjectMonitor: $1\n$2", string, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pInsert[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.setString(2, this.name);
            preparedStatement.setLong(3, this.ownerId);
            preparedStatement.setLong(4, this.wtId);
            preparedStatement.setInt(5, this.recreateHandling);
            if (this.watchSeId == null) {
                preparedStatement.setNull(6, 4);
            } else {
                preparedStatement.setLong(6, this.watchSeId);
            }
            if (this.deleteAmount == null) {
                preparedStatement.setNull(7, 4);
            } else {
                preparedStatement.setInt(7, this.deleteAmount);
            }
            if (this.deleteBase == null) {
                preparedStatement.setNull(8, 4);
            } else {
                preparedStatement.setInt(8, this.deleteBase);
            }
            if (this.eventDeleteAmount == null) {
                preparedStatement.setNull(9, 4);
            } else {
                preparedStatement.setInt(9, this.eventDeleteAmount);
            }
            if (this.eventDeleteBase == null) {
                preparedStatement.setNull(10, 4);
            } else {
                preparedStatement.setInt(10, this.eventDeleteBase);
            }
            preparedStatement.setLong(11, this.creatorUId);
            preparedStatement.setLong(12, this.createTs);
            preparedStatement.setLong(13, this.changerUId);
            preparedStatement.setLong(14, this.changeTs);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181954", "ObjectMonitor: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    @Override
    protected void deleteDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pDelete[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "DELETE FROM " + string2 + "OBJECT_MONITOR" + string3 + " WHERE ID = ?";
                SDMSObjectMonitorGeneric.pDelete[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182001", "ObjectMonitor: $1\n$2", string, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pDelete[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182002", "ObjectMonitor: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    @Override
    protected void updateDBObject(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        if (pUpdate[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "UPDATE " + string2 + "OBJECT_MONITOR" + string3 + " SET " + string2 + "NAME" + string3 + " = ? , " + string2 + "OWNER_ID" + string3 + " = ? , " + string2 + "WT_ID" + string3 + " = ? , " + string2 + "RECREATE_HANDLING" + string3 + " = ? , " + string2 + "WATCH_SE_ID" + string3 + " = ? , " + string2 + "DELETE_AMOUNT" + string3 + " = ? , " + string2 + "DELETE_BASE" + string3 + " = ? , " + string2 + "EVENT_DELETE_AMOUNT" + string3 + " = ? , " + string2 + "EVENT_DELETE_BASE" + string3 + " = ? , " + string2 + "CREATOR_U_ID" + string3 + " = ? , " + string2 + "CREATE_TS" + string3 + " = ? , " + string2 + "CHANGER_U_ID" + string3 + " = ? , " + string2 + "CHANGE_TS" + string3 + " = ? WHERE ID = ?";
                SDMSObjectMonitorGeneric.pUpdate[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182005", "ObjectMonitor: $1\n$2", string, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pUpdate[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setString(1, this.name);
            preparedStatement.setLong(2, this.ownerId);
            preparedStatement.setLong(3, this.wtId);
            preparedStatement.setInt(4, this.recreateHandling);
            if (this.watchSeId == null) {
                preparedStatement.setNull(5, 4);
            } else {
                preparedStatement.setLong(5, this.watchSeId);
            }
            if (this.deleteAmount == null) {
                preparedStatement.setNull(6, 4);
            } else {
                preparedStatement.setInt(6, this.deleteAmount);
            }
            if (this.deleteBase == null) {
                preparedStatement.setNull(7, 4);
            } else {
                preparedStatement.setInt(7, this.deleteBase);
            }
            if (this.eventDeleteAmount == null) {
                preparedStatement.setNull(8, 4);
            } else {
                preparedStatement.setInt(8, this.eventDeleteAmount);
            }
            if (this.eventDeleteBase == null) {
                preparedStatement.setNull(9, 4);
            } else {
                preparedStatement.setInt(9, this.eventDeleteBase);
            }
            preparedStatement.setLong(10, this.creatorUId);
            preparedStatement.setLong(11, this.createTs);
            preparedStatement.setLong(12, this.changerUId);
            preparedStatement.setLong(13, this.changeTs);
            preparedStatement.setLong(14, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182006", "ObjectMonitor: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    public static boolean checkRecreateHandling(Integer n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkDeleteBase(Integer n) {
        if (n == null) {
            return true;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkEventDeleteBase(Integer n) {
        if (n == null) {
            return true;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void print() {
        SDMSThread.doTrace(null, "Type : ObjectMonitor", 2);
        SDMSThread.doTrace(null, "id : " + this.id, 2);
        SDMSThread.doTrace(null, "name : " + this.name, 2);
        SDMSThread.doTrace(null, "ownerId : " + this.ownerId, 2);
        SDMSThread.doTrace(null, "wtId : " + this.wtId, 2);
        SDMSThread.doTrace(null, "recreateHandling : " + this.recreateHandling, 2);
        SDMSThread.doTrace(null, "watchSeId : " + this.watchSeId, 2);
        SDMSThread.doTrace(null, "deleteAmount : " + this.deleteAmount, 2);
        SDMSThread.doTrace(null, "deleteBase : " + this.deleteBase, 2);
        SDMSThread.doTrace(null, "eventDeleteAmount : " + this.eventDeleteAmount, 2);
        SDMSThread.doTrace(null, "eventDeleteBase : " + this.eventDeleteBase, 2);
        SDMSThread.doTrace(null, "creatorUId : " + this.creatorUId, 2);
        SDMSThread.doTrace(null, "createTs : " + this.createTs, 2);
        SDMSThread.doTrace(null, "changerUId : " + this.changerUId, 2);
        SDMSThread.doTrace(null, "changeTs : " + this.changeTs, 2);
        SDMSThread.doTrace(null, "validFrom : " + this.validFrom, 2);
        SDMSThread.doTrace(null, "validTo : " + this.validTo, 2);
        this.dumpVersions(2);
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        String string = new String(stringBuffer);
        String string2 = string + "id : " + this.id + "\n" + string + "name              : " + this.name + "\n" + string + "ownerId           : " + this.ownerId + "\n" + string + "wtId              : " + this.wtId + "\n" + string + "recreateHandling  : " + this.recreateHandling + "\n" + string + "watchSeId         : " + this.watchSeId + "\n" + string + "deleteAmount      : " + this.deleteAmount + "\n" + string + "deleteBase        : " + this.deleteBase + "\n" + string + "eventDeleteAmount : " + this.eventDeleteAmount + "\n" + string + "eventDeleteBase   : " + this.eventDeleteBase + "\n" + string + "creatorUId        : " + this.creatorUId + "\n" + string + "createTs          : " + this.createTs + "\n" + string + "changerUId        : " + this.changerUId + "\n" + string + "changeTs          : " + this.changeTs + "\n" + string + "validFrom : " + this.validFrom + "\n" + string + "validTo : " + this.validTo + "\n";
        return string2;
    }

    public String toString() {
        String string = this.toString(0);
        return string;
    }
}

