/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSFolderTable;
import de.independit.scheduler.server.repository.SDMSGrant;
import de.independit.scheduler.server.repository.SDMSGrantProxyGeneric;
import de.independit.scheduler.server.repository.SDMSGrantTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSObjectCommentTable;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSRepository;
import de.independit.scheduler.server.repository.SDMSResource;
import de.independit.scheduler.server.repository.SDMSResourceGeneric;
import de.independit.scheduler.server.repository.SDMSResourceTable;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityProxyGeneric;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;

public class SDMSResourceProxyGeneric
extends SDMSProxy {
    public static final int REASON_AVAILABLE = 0;
    public static final int REASON_LOCKMODE = 1;
    public static final int REASON_AMOUNT = 2;
    public static final int REASON_STATE = 4;
    public static final int REASON_EXPIRE = 8;
    public static final int REASON_OFFLINE = 16;
    public static final long privilegeMask = 8858370329L;
    public static final int tag_size = 64;

    protected SDMSResourceProxyGeneric(SDMSObject sDMSObject) {
        super(sDMSObject);
    }

    protected static SDMSResource getProxy(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) {
        int n = SDMSResourceTable.table.tableIndex;
        SDMSProxy sDMSProxy = SDMSRepository.getProxy(n);
        if (sDMSProxy == null) {
            sDMSProxy = new SDMSResource(sDMSObject);
        } else {
            sDMSProxy.initProxy(sDMSObject);
        }
        systemEnvironment.tx.addUsedProxy(n, sDMSProxy);
        return (SDMSResource)sDMSProxy;
    }

    public Long getNrId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceGeneric)this.object).getNrId(systemEnvironment);
    }

    public void setNrId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSResourceGeneric)this.object).setNrId(systemEnvironment, l);
    }

    public Long getScopeId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceGeneric)this.object).getScopeId(systemEnvironment);
    }

    public void setScopeId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSResourceGeneric)this.object).setScopeId(systemEnvironment, l);
    }

    public Long getMasterId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceGeneric)this.object).getMasterId(systemEnvironment);
    }

    public void setMasterId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSResourceGeneric)this.object).setMasterId(systemEnvironment, l);
    }

    @Override
    public Long getOwnerId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceGeneric)this.object).getOwnerId(systemEnvironment);
    }

    public void setOwnerId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSResourceGeneric)this.object).setOwnerId(systemEnvironment, l);
    }

    public Long getLinkId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceGeneric)this.object).getLinkId(systemEnvironment);
    }

    public void setLinkId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSResourceGeneric)this.object).setLinkId(systemEnvironment, l);
    }

    public Long getManagerId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceGeneric)this.object).getManagerId(systemEnvironment);
    }

    public void setManagerId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSResourceGeneric)this.object).setManagerId(systemEnvironment, l);
    }

    public String getTag(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceGeneric)this.object).getTag(systemEnvironment);
    }

    public void setTag(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSResourceGeneric)this.object).setTag(systemEnvironment, string);
    }

    public static int getTagMaxLength() {
        return 64;
    }

    public Long getRsdId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceGeneric)this.object).getRsdId(systemEnvironment);
    }

    public void setRsdId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSResourceGeneric)this.object).setRsdId(systemEnvironment, l);
    }

    public Long getRsdTime(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceGeneric)this.object).getRsdTime(systemEnvironment);
    }

    public void setRsdTime(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSResourceGeneric)this.object).setRsdTime(systemEnvironment, l);
    }

    public Integer getDefinedAmount(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceGeneric)this.object).getDefinedAmount(systemEnvironment);
    }

    public void setDefinedAmount(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSResourceGeneric)this.object).setDefinedAmount(systemEnvironment, n);
    }

    public Integer getRequestableAmount(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceGeneric)this.object).getRequestableAmount(systemEnvironment);
    }

    public void setRequestableAmount(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSResourceGeneric)this.object).setRequestableAmount(systemEnvironment, n);
    }

    public Integer getAmount(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceGeneric)this.object).getAmount(systemEnvironment);
    }

    public void setAmount(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSResourceGeneric)this.object).setAmount(systemEnvironment, n);
    }

    public Integer getFreeAmount(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceGeneric)this.object).getFreeAmount(systemEnvironment);
    }

    public void setFreeAmount(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSResourceGeneric)this.object).setFreeAmount(systemEnvironment, n);
    }

    public Boolean getIsOnline(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceGeneric)this.object).getIsOnline(systemEnvironment);
    }

    public void setIsOnline(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSResourceGeneric)this.object).setIsOnline(systemEnvironment, bl);
    }

    public Float getFactor(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceGeneric)this.object).getFactor(systemEnvironment);
    }

    public void setFactor(SystemEnvironment systemEnvironment, Float f) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSResourceGeneric)this.object).setFactor(systemEnvironment, f);
    }

    public Integer getTraceInterval(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceGeneric)this.object).getTraceInterval(systemEnvironment);
    }

    public void setTraceInterval(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSResourceGeneric)this.object).setTraceInterval(systemEnvironment, n);
    }

    public Integer getTraceBase(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceGeneric)this.object).getTraceBase(systemEnvironment);
    }

    public void setTraceBase(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSResourceGeneric)this.object).setTraceBase(systemEnvironment, n);
    }

    public Integer getTraceBaseMultiplier(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceGeneric)this.object).getTraceBaseMultiplier(systemEnvironment);
    }

    public void setTraceBaseMultiplier(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSResourceGeneric)this.object).setTraceBaseMultiplier(systemEnvironment, n);
    }

    public Float getTd0Avg(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceGeneric)this.object).getTd0Avg(systemEnvironment);
    }

    public void setTd0Avg(SystemEnvironment systemEnvironment, Float f) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSResourceGeneric)this.object).setTd0Avg(systemEnvironment, f);
    }

    public Float getTd1Avg(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceGeneric)this.object).getTd1Avg(systemEnvironment);
    }

    public void setTd1Avg(SystemEnvironment systemEnvironment, Float f) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSResourceGeneric)this.object).setTd1Avg(systemEnvironment, f);
    }

    public Float getTd2Avg(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceGeneric)this.object).getTd2Avg(systemEnvironment);
    }

    public void setTd2Avg(SystemEnvironment systemEnvironment, Float f) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSResourceGeneric)this.object).setTd2Avg(systemEnvironment, f);
    }

    public Float getLwAvg(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceGeneric)this.object).getLwAvg(systemEnvironment);
    }

    public void setLwAvg(SystemEnvironment systemEnvironment, Float f) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSResourceGeneric)this.object).setLwAvg(systemEnvironment, f);
    }

    public Long getLastEval(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceGeneric)this.object).getLastEval(systemEnvironment);
    }

    public void setLastEval(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSResourceGeneric)this.object).setLastEval(systemEnvironment, l);
    }

    public Long getLastWrite(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceGeneric)this.object).getLastWrite(systemEnvironment);
    }

    public void setLastWrite(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSResourceGeneric)this.object).setLastWrite(systemEnvironment, l);
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceGeneric)this.object).getCreatorUId(systemEnvironment);
    }

    private void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSResourceGeneric)this.object).setCreatorUId(systemEnvironment, l);
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceGeneric)this.object).getCreateTs(systemEnvironment);
    }

    private void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSResourceGeneric)this.object).setCreateTs(systemEnvironment, l);
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceGeneric)this.object).getChangerUId(systemEnvironment);
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSResourceGeneric)this.object).setChangerUId(systemEnvironment, l);
    }

    protected SDMSResource setChangerUIdNoCheck(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        ((SDMSResourceGeneric)this.object).setChangerUId(systemEnvironment, l);
        return (SDMSResource)this;
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceGeneric)this.object).getChangeTs(systemEnvironment);
    }

    private void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSResourceGeneric)this.object).setChangeTs(systemEnvironment, l);
    }

    protected SDMSResource setChangeTsNoCheck(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        ((SDMSResourceGeneric)this.object).setChangeTs(systemEnvironment, l);
        return (SDMSResource)this;
    }

    public SDMSResource set_NrIdScopeId(SystemEnvironment systemEnvironment, Long l, Long l2) throws SDMSException {
        this.checkRead(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181242"));
        }
        ((SDMSResourceGeneric)this.object).set_NrIdScopeId(systemEnvironment, l, l2);
        return (SDMSResource)this;
    }

    @Override
    public SDMSKey getSortKey(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSKey sDMSKey = null;
        Long l = this.getId(systemEnvironment);
        if (systemEnvironment.tx.sortKeyMap == null) {
            systemEnvironment.tx.sortKeyMap = new HashMap();
        } else {
            sDMSKey = (SDMSKey)systemEnvironment.tx.sortKeyMap.get(l);
        }
        if (sDMSKey != null) {
            return sDMSKey;
        }
        boolean bl = false;
        sDMSKey = new SDMSKey();
        bl = false;
        Long l2 = this.getNrId(systemEnvironment);
        if (!bl) {
            try {
                sDMSKey.add(SDMSNamedResourceTable.getObject(systemEnvironment, l2).getSortKey(systemEnvironment));
                bl = true;
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        bl = false;
        Long l3 = this.getScopeId(systemEnvironment);
        if (!bl) {
            try {
                sDMSKey.add(SDMSScopeTable.getObject(systemEnvironment, l3).getSortKey(systemEnvironment));
                bl = true;
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        if (!bl) {
            try {
                sDMSKey.add(SDMSFolderTable.getObject(systemEnvironment, l3).getSortKey(systemEnvironment));
                bl = true;
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        bl = false;
        Long l4 = this.getMasterId(systemEnvironment);
        if (!bl) {
            try {
                sDMSKey.add(SDMSSubmittedEntityTable.getObject(systemEnvironment, l4).getSortKey(systemEnvironment));
                bl = true;
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        systemEnvironment.tx.sortKeyMap.put(l, sDMSKey);
        return sDMSKey;
    }

    @Override
    public void delete(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSObjectCommentTable.dropComment(systemEnvironment, this.getId(systemEnvironment));
        Vector vector = SDMSGrantTable.idx_objectId.getVector(systemEnvironment, this.getId(systemEnvironment));
        for (int i = 0; i < vector.size(); ++i) {
            SDMSGrant sDMSGrant = (SDMSGrant)vector.get(i);
            sDMSGrant.delete(systemEnvironment);
        }
        super.delete(systemEnvironment);
    }

    @Override
    public final boolean checkPrivileges(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        return (this.getPrivileges(systemEnvironment, l, true, null) & l) == l;
    }

    @Override
    public long getPrivilegeMask() {
        return 8858370329L;
    }

    @Override
    public final SDMSPrivilege getPrivileges(SystemEnvironment systemEnvironment) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 8858370329L, false, null));
    }

    @Override
    public final SDMSPrivilege getPrivilegesForGroups(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 8858370329L, false, vector));
    }

    @Override
    public long getPrivileges(SystemEnvironment systemEnvironment, long l, boolean bl, Vector vector) throws SDMSException {
        Vector vector2 = vector == null ? new Vector() : vector;
        long l2 = 0L;
        if (systemEnvironment.cEnv.isUser() || systemEnvironment.cEnv.isJob()) {
            SDMSProxy sDMSProxy;
            if (systemEnvironment.cEnv.isJob()) {
                HashSet<Long> hashSet = new HashSet<Long>();
                sDMSProxy = SDMSSubmittedEntityTable.getObject(systemEnvironment, systemEnvironment.cEnv.uid());
                Long l3 = ((SDMSSubmittedEntityProxyGeneric)sDMSProxy).getOwnerId(systemEnvironment);
                hashSet.add(l3);
                hashSet.add(SDMSObject.publicGId);
                systemEnvironment.cEnv.pushGid(systemEnvironment, hashSet);
            }
            if (vector == null) {
                vector2.addAll(systemEnvironment.cEnv.gid());
            }
            if (vector2.contains(SDMSObject.adminGId)) {
                if (systemEnvironment.cEnv.isJob()) {
                    systemEnvironment.cEnv.popGid(systemEnvironment);
                }
                return l;
            }
            if (vector2.contains(this.getOwnerId(systemEnvironment))) {
                l2 = l & 0xFFFFFFFFFFFFFFFBL;
                if (l2 == l) {
                    if (systemEnvironment.cEnv.isJob()) {
                        systemEnvironment.cEnv.popGid(systemEnvironment);
                    }
                    return l2;
                }
            } else {
                for (int i = 0; i < vector2.size(); ++i) {
                    try {
                        sDMSProxy = SDMSGrantTable.idx_objectId_gId_getUnique(systemEnvironment, new SDMSKey(this.getId(systemEnvironment), (Long)vector2.get(i)));
                        l2 |= ((SDMSGrantProxyGeneric)sDMSProxy).getPrivs(systemEnvironment).longValue();
                        l2 = this.addImplicitPrivs(l2) & l;
                        if (l2 != l) continue;
                        if (systemEnvironment.cEnv.isJob()) {
                            systemEnvironment.cEnv.popGid(systemEnvironment);
                        }
                        return l2;
                    }
                    catch (NotFoundException notFoundException) {
                        // empty catch block
                    }
                }
            }
            if (systemEnvironment.cEnv.isJob()) {
                systemEnvironment.cEnv.popGid(systemEnvironment);
            }
        } else if (systemEnvironment.cEnv.isJobServer()) {
            l2 = l;
        }
        return l2;
    }

    @Override
    public SDMSMessage accessViolationMessage(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        SDMSMessage sDMSMessage = new SDMSMessage(systemEnvironment, string, "Insufficient privileges accessing Resource $1", this.getId(systemEnvironment));
        return sDMSMessage;
    }

    @Override
    protected void touch(SystemEnvironment systemEnvironment) throws SDMSException {
        this.setChangerUIdNoCheck(systemEnvironment, systemEnvironment.cEnv.uid());
        this.setChangeTsNoCheck(systemEnvironment, systemEnvironment.txTime());
    }

    public void print() {
        ((SDMSResourceGeneric)this.object).print();
    }
}

