/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.TimerThread;
import de.independit.scheduler.server.exception.DuplicateKeyException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.repository.SDMSCalendar;
import de.independit.scheduler.server.repository.SDMSCalendarTable;
import de.independit.scheduler.server.repository.SDMSEvent;
import de.independit.scheduler.server.repository.SDMSEventTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSOwnedObject;
import de.independit.scheduler.server.repository.SDMSSchedule;
import de.independit.scheduler.server.repository.SDMSScheduleTable;
import de.independit.scheduler.server.repository.SDMSScheduledEventProxyGeneric;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.timer.TimerDate;
import de.independit.scheduler.server.timer.TimerUnit;
import de.independit.scheduler.server.util.DateTime;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;

public class SDMSScheduledEvent
extends SDMSScheduledEventProxyGeneric
implements SDMSOwnedObject {
    public static final String __version = "SDMSScheduledEvent $Revision: 2.12.4.1 $ / @(#) $Id: SDMSScheduledEvent.java,v 2.12.4.1 2013/03/14 10:25:24 ronald Exp $";

    protected SDMSScheduledEvent(SDMSObject sDMSObject) {
        super(sDMSObject);
    }

    public String getName(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.getSceId(systemEnvironment);
        SDMSSchedule sDMSSchedule = SDMSScheduleTable.getObject(systemEnvironment, l);
        String string = sDMSSchedule.getName(systemEnvironment);
        Long l2 = this.getEvtId(systemEnvironment);
        SDMSEvent sDMSEvent = SDMSEventTable.getObject(systemEnvironment, l2);
        String string2 = sDMSEvent.getName(systemEnvironment);
        return string + '.' + string2;
    }

    public final boolean isReallyActive(SystemEnvironment systemEnvironment) throws SDMSException {
        boolean bl = this.getIsActive(systemEnvironment);
        if (bl) {
            Long l = this.getSceId(systemEnvironment);
            SDMSSchedule sDMSSchedule = SDMSScheduleTable.getObject(systemEnvironment, l);
            bl = sDMSSchedule.isReallyActive(systemEnvironment);
        }
        return bl;
    }

    @Override
    public String getURLName(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSSchedule sDMSSchedule = SDMSScheduleTable.getObject(systemEnvironment, this.getSceId(systemEnvironment));
        Long l = sDMSSchedule.getSeId(systemEnvironment);
        String string = null;
        if (l != null) {
            string = SDMSSchedulingEntityTable.getObject(systemEnvironment, l).pathString(systemEnvironment);
        }
        return this.getName(systemEnvironment) + (string == null ? "" : " (" + string + ")");
    }

    @Override
    public String getURL(SystemEnvironment systemEnvironment) throws SDMSException {
        return "scheduled event " + this.getURLName(systemEnvironment);
    }

    @Override
    public void delete(SystemEnvironment systemEnvironment) throws SDMSException {
        this.clearCalendar(systemEnvironment);
        super.delete(systemEnvironment);
    }

    public void clearCalendar(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.getId(systemEnvironment);
        Vector vector = SDMSCalendarTable.idx_scevId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSCalendar sDMSCalendar = (SDMSCalendar)vector.get(i);
            sDMSCalendar.delete(systemEnvironment);
        }
    }

    private void deleteCalendarItemsOutOfWindow(SystemEnvironment systemEnvironment, Vector vector, TimerDate timerDate, TimerDate timerDate2) throws SDMSException {
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            SDMSCalendar sDMSCalendar = (SDMSCalendar)iterator.next();
            Long l = sDMSCalendar.getStarttime(systemEnvironment);
            DateTime dateTime = new DateTime(l);
            TimerDate timerDate3 = new TimerDate(dateTime.toDate());
            if (!timerDate3.lt(timerDate) && !timerDate3.gt(timerDate2)) continue;
            iterator.remove();
            sDMSCalendar.delete(systemEnvironment);
        }
    }

    public Integer getEffectiveCalendarHorizon(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getCalendarHorizon(systemEnvironment);
        if (n == null) {
            return SystemEnvironment.defCalHorizon;
        }
        return n;
    }

    public TimerUnit getEffectiveSuspendLimit(SystemEnvironment systemEnvironment) throws SDMSException {
        TimerUnit timerUnit = new TimerUnit(this.getSuspendLimitMultiplier(systemEnvironment), this.getSuspendLimit(systemEnvironment));
        if (timerUnit.isINF()) {
            return new TimerUnit(SystemEnvironment.timerSuspendLimit, 0);
        }
        return timerUnit;
    }

    public void updateCalendar(SystemEnvironment systemEnvironment, Long l, SDMSSchedule sDMSSchedule) throws SDMSException {
        TimerDate timerDate = l == null ? null : new TimerDate(new DateTime(l).toDate());
        this.updateCalendar(systemEnvironment, timerDate, sDMSSchedule);
    }

    public void updateCalendar(SystemEnvironment systemEnvironment, TimerDate timerDate, SDMSSchedule sDMSSchedule) throws SDMSException {
        Comparable<Calendar> comparable;
        if (!this.getIsCalendar(systemEnvironment).booleanValue()) {
            return;
        }
        if (!this.getIsActive(systemEnvironment).booleanValue()) {
            return;
        }
        TimerDate timerDate2 = new TimerDate();
        if (timerDate == null) {
            comparable = SystemEnvironment.newGregorianCalendar();
            ((Calendar)comparable).setTimeInMillis(System.currentTimeMillis());
            ((Calendar)comparable).set(13, 0);
            ((Calendar)comparable).set(14, 0);
            timerDate2.set(TimerDate.fromMillis(((Calendar)comparable).getTimeInMillis()));
        } else {
            timerDate2 = timerDate;
        }
        comparable = this.getId(systemEnvironment);
        Integer n = this.getEffectiveCalendarHorizon(systemEnvironment);
        TimerDate timerDate3 = new TimerDate(timerDate2.plus(n * 24 * 60));
        Vector vector = SDMSCalendarTable.idx_scevId.getVector(systemEnvironment, comparable);
        this.deleteCalendarItemsOutOfWindow(systemEnvironment, vector, timerDate2, timerDate3);
        Comparator comparator = SDMSCalendar.getComparator(systemEnvironment);
        Collections.sort(vector, comparator);
        TimerDate timerDate4 = new TimerDate(timerDate3);
        timerDate3 = vector.size() > 0 ? new TimerDate(new DateTime(((SDMSCalendar)vector.get(vector.size() - 1)).getStarttime(systemEnvironment)).toDate()) : new TimerDate(timerDate2.plus(timerDate == null ? 0 : -1));
        TimerDate timerDate5 = new TimerDate(timerDate3);
        TimerDate timerDate6 = new TimerDate(timerDate5.plus(1));
        int n2 = vector.size();
        int n3 = SystemEnvironment.maxNumCalEntries;
        while (timerDate6.le(timerDate4) && n2 < n3 && (timerDate5 = sDMSSchedule.getNextTriggerDate(systemEnvironment, timerDate6)) != null && !timerDate5.isNaD()) {
            if (timerDate5.lt(timerDate4)) {
                try {
                    SDMSCalendarTable.table.create(systemEnvironment, (Long)comparable, TimerThread.dateToDateTimeLong(timerDate5));
                }
                catch (DuplicateKeyException duplicateKeyException) {
                    // empty catch block
                }
                ++n2;
            }
            timerDate6.set(timerDate5.plus(1));
        }
    }

    @Override
    public long getPrivileges(SystemEnvironment systemEnvironment, long l, boolean bl, Vector vector) throws SDMSException {
        long l2 = super.getPrivileges(systemEnvironment, l, bl, vector);
        if ((l2 & l) == l) {
            return l;
        }
        Long l3 = this.getSceId(systemEnvironment);
        SDMSSchedule sDMSSchedule = SDMSScheduleTable.getObject(systemEnvironment, l3);
        long l4 = sDMSSchedule.getPrivileges(systemEnvironment, l, false, vector);
        Long l5 = this.getEvtId(systemEnvironment);
        SDMSEvent sDMSEvent = SDMSEventTable.getObject(systemEnvironment, l5);
        long l6 = sDMSEvent.getPrivileges(systemEnvironment, l, false, vector);
        l2 |= l6;
        l2 |= l4;
        l2 = this.addImplicitPrivs(l2) & l;
        return l2;
    }
}

