/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSScopeGeneric;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class SDMSScopeTableGeneric
extends SDMSTable {
    public static final String tableName = "SCOPE";
    public static SDMSScopeTable table = null;
    public static final String[] columnNames = new String[]{"ID", "NAME", "OWNER_ID", "PARENT_ID", "TYPE", "IS_TERMINATE", "HAS_ALTEREDCONFIG", "IS_SUSPENDED", "IS_ENABLED", "IS_REGISTERED", "STATE", "PASSWD", "SALT", "METHOD", "PID", "NODE", "ERRMSG", "LAST_ACTIVE", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS", "INHERIT_PRIVS"};
    public static SDMSIndex idx_ownerId;
    public static SDMSIndex idx_parentId;
    public static SDMSIndex idx_type;
    public static SDMSIndex idx_node;
    public static SDMSIndex idx_parentId_name;

    public SDMSScopeTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "Scope"));
        }
        table = (SDMSScopeTable)this;
        table = (SDMSScopeTable)this;
        this.isVersioned = false;
        idx_ownerId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "ownerId");
        idx_parentId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "parentId");
        idx_type = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "type");
        idx_node = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "node");
        idx_parentId_name = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "parentId_name");
    }

    public SDMSScope create(SystemEnvironment systemEnvironment, String string, Long l, Long l2, Integer n, Boolean bl, Boolean bl2, Boolean bl3, Boolean bl4, Boolean bl5, Integer n2, String string2, String string3, Integer n3, String string4, String string5, String string6, Long l3, Long l4) throws SDMSException {
        SDMSScope sDMSScope;
        Long l5 = systemEnvironment.cEnv.uid();
        Long l6 = systemEnvironment.txTime();
        Long l7 = systemEnvironment.cEnv.uid();
        Long l8 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "Scope"));
        }
        this.validate(systemEnvironment, string, l, l2, n, bl, bl2, bl3, bl4, bl5, n2, string2, string3, n3, string4, string5, string6, l3, l5, l6, l7, l8, l4);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSScopeGeneric sDMSScopeGeneric = new SDMSScopeGeneric(systemEnvironment, string, l, l2, n, bl, bl2, bl3, bl4, bl5, n2, string2, string3, n3, string4, string5, string6, l3, l5, l6, l7, l8, l4);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSScopeGeneric.versions, true);
            table.put(systemEnvironment, sDMSScopeGeneric.id, sDMSScopeGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSScope = (SDMSScope)sDMSScopeGeneric.toProxy(systemEnvironment);
            sDMSScope.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSScope sDMSScope2 = (SDMSScope)sDMSScopeGeneric.toProxy(systemEnvironment);
            sDMSScope2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSScope)) {
            throw new AccessViolationException(sDMSScope.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        return sDMSScope;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSScope sDMSScope) throws SDMSException {
        Long l = sDMSScope.getParentId(systemEnvironment);
        SDMSScope sDMSScope2 = SDMSScopeTable.getObject(systemEnvironment, l);
        return sDMSScope2.checkPrivileges(systemEnvironment, 2L);
    }

    protected void validate(SystemEnvironment systemEnvironment, String string, Long l, Long l2, Integer n, Boolean bl, Boolean bl2, Boolean bl3, Boolean bl4, Boolean bl5, Integer n2, String string2, String string3, Integer n3, String string4, String string5, String string6, Long l3, Long l4, Long l5, Long l6, Long l7, Long l8) throws SDMSException {
        if (!SDMSScopeGeneric.checkType(n)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "Scope: $1 $2", "type", n));
        }
        if (!SDMSScopeGeneric.checkState(n2)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "Scope: $1 $2", "state", n2));
        }
        if (!SDMSScopeGeneric.checkMethod(n3)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "Scope: $1 $2", "method", n3));
        }
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Long l7;
        Long l8;
        String string;
        String string2;
        String string3;
        Integer n;
        String string4;
        String string5;
        Integer n2;
        Boolean bl;
        Boolean bl2;
        Boolean bl3;
        Boolean bl4;
        Boolean bl5;
        Integer n3;
        Long l9;
        Long l10;
        String string6;
        Long l11;
        try {
            l11 = resultSet.getLong(1);
            string6 = resultSet.getString(2);
            l10 = resultSet.getLong(3);
            l9 = resultSet.getLong(4);
            if (resultSet.wasNull()) {
                l9 = null;
            }
            n3 = resultSet.getInt(5);
            bl5 = resultSet.getInt(6) != 0;
            if (resultSet.wasNull()) {
                bl5 = null;
            }
            bl4 = resultSet.getInt(7) != 0;
            if (resultSet.wasNull()) {
                bl4 = null;
            }
            bl3 = resultSet.getInt(8) != 0;
            if (resultSet.wasNull()) {
                bl3 = null;
            }
            bl2 = resultSet.getInt(9) != 0;
            if (resultSet.wasNull()) {
                bl2 = null;
            }
            bl = resultSet.getInt(10) != 0;
            if (resultSet.wasNull()) {
                bl = null;
            }
            n2 = resultSet.getInt(11);
            if (resultSet.wasNull()) {
                n2 = null;
            }
            string5 = resultSet.getString(12);
            if (resultSet.wasNull()) {
                string5 = null;
            }
            string4 = resultSet.getString(13);
            if (resultSet.wasNull()) {
                string4 = null;
            }
            n = resultSet.getInt(14);
            string3 = resultSet.getString(15);
            if (resultSet.wasNull()) {
                string3 = null;
            }
            string2 = resultSet.getString(16);
            if (resultSet.wasNull()) {
                string2 = null;
            }
            string = resultSet.getString(17);
            if (resultSet.wasNull()) {
                string = null;
            }
            l8 = resultSet.getLong(18);
            if (resultSet.wasNull()) {
                l8 = null;
            }
            l7 = resultSet.getLong(19);
            l6 = resultSet.getLong(20);
            l5 = resultSet.getLong(21);
            l4 = resultSet.getLong(22);
            l3 = resultSet.getLong(23);
            l2 = 0L;
            l = Long.MAX_VALUE;
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "Scope: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSScopeGeneric(l11, string6, l10, l9, n3, bl5, bl4, bl3, bl2, bl, n2, string5, string4, n, string3, string2, string, l8, l7, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID, " + string + "NAME" + string2 + ", " + string + "OWNER_ID" + string2 + ", " + string + "PARENT_ID" + string2 + ", " + string + "TYPE" + string2 + ", " + string + "IS_TERMINATE" + string2 + ", " + string + "HAS_ALTEREDCONFIG" + string2 + ", " + string + "IS_SUSPENDED" + string2 + ", " + string + "IS_ENABLED" + string2 + ", " + string + "IS_REGISTERED" + string2 + ", " + string + "STATE" + string2 + ", " + string + "PASSWD" + string2 + ", " + string + "SALT" + string2 + ", " + string + "METHOD" + string2 + ", " + string + "PID" + string2 + ", " + string + "NODE" + string2 + ", " + string + "ERRMSG" + string2 + ", " + string + "LAST_ACTIVE" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + ", " + string + "INHERIT_PRIVS" + string2 + " FROM " + string + this.tableName() + string2 + "");
        while (resultSet.next()) {
            try {
                if (this.loadObject(systemEnvironment, resultSet)) {
                    ++n2;
                }
                ++n;
            }
            catch (Exception exception) {
                SDMSThread.doTrace(null, "Exception caught while loading table " + this.tableName() + ", ID = " + Long.valueOf(resultSet.getLong(1)), -1);
                throw exception;
            }
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_ownerId.check(((SDMSScopeGeneric)sDMSObject).ownerId, sDMSObject);
        string = string + "idx_ownerId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_parentId.check(((SDMSScopeGeneric)sDMSObject).parentId, sDMSObject);
        string = string + "idx_parentId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_type.check(((SDMSScopeGeneric)sDMSObject).type, sDMSObject);
        string = string + "idx_type: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_node.check(((SDMSScopeGeneric)sDMSObject).node, sDMSObject);
        string = string + "idx_node: " + (bl ? "ok" : "missing") + "\n";
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSScopeGeneric)sDMSObject).parentId);
        sDMSKey.add((Comparable)((Object)((SDMSScopeGeneric)sDMSObject).name));
        bl = idx_parentId_name.check(sDMSKey, sDMSObject);
        string = string + "idx_parentId_name: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_ownerId.put(systemEnvironment, ((SDMSScopeGeneric)sDMSObject).ownerId, sDMSObject, (1L & l) != 0L);
        idx_parentId.put(systemEnvironment, ((SDMSScopeGeneric)sDMSObject).parentId, sDMSObject, (2L & l) != 0L);
        idx_type.put(systemEnvironment, ((SDMSScopeGeneric)sDMSObject).type, sDMSObject, (4L & l) != 0L);
        idx_node.put(systemEnvironment, ((SDMSScopeGeneric)sDMSObject).node, sDMSObject, (8L & l) != 0L);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSScopeGeneric)sDMSObject).parentId);
        sDMSKey.add((Comparable)((Object)((SDMSScopeGeneric)sDMSObject).name));
        idx_parentId_name.put(systemEnvironment, sDMSKey, sDMSObject, (0x10L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_ownerId.remove(systemEnvironment, ((SDMSScopeGeneric)sDMSObject).ownerId, sDMSObject);
        idx_parentId.remove(systemEnvironment, ((SDMSScopeGeneric)sDMSObject).parentId, sDMSObject);
        idx_type.remove(systemEnvironment, ((SDMSScopeGeneric)sDMSObject).type, sDMSObject);
        idx_node.remove(systemEnvironment, ((SDMSScopeGeneric)sDMSObject).node, sDMSObject);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSScopeGeneric)sDMSObject).parentId);
        sDMSKey.add((Comparable)((Object)((SDMSScopeGeneric)sDMSObject).name));
        idx_parentId_name.remove(systemEnvironment, sDMSKey, sDMSObject);
    }

    public static SDMSScope getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSScope)table.get(systemEnvironment, l);
    }

    public static SDMSScope getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSScope)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSScope getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSScope)table.get(systemEnvironment, l, l2);
    }

    public static SDMSScope idx_parentId_name_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSScope)idx_parentId_name.getUnique(systemEnvironment, object);
    }

    public static SDMSScope idx_parentId_name_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSScope)idx_parentId_name.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSScope idx_parentId_name_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSScope)idx_parentId_name.getUnique(systemEnvironment, object, l);
    }

    public static Long pathToId(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        return SDMSScopeTableGeneric.getScope(systemEnvironment, vector).getId(systemEnvironment);
    }

    public static Long pathToIdForUpdate(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        return SDMSScopeTableGeneric.getScopeForUpdate(systemEnvironment, vector).getId(systemEnvironment);
    }

    public static SDMSScope getScope(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        Long l = null;
        SDMSScope sDMSScope = null;
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.get(i);
            sDMSScope = (SDMSScope)SDMSScopeTable.idx_parentId_name.getUnique(systemEnvironment, new SDMSKey(l, (Comparable)((Object)string)));
            l = sDMSScope.getId(systemEnvironment);
        }
        return sDMSScope;
    }

    public static SDMSScope getScopeForUpdate(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        Long l = null;
        SDMSScope sDMSScope = null;
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.get(i);
            sDMSScope = (SDMSScope)SDMSScopeTable.idx_parentId_name.getUniqueForUpdate(systemEnvironment, new SDMSKey(l, (Comparable)((Object)string)));
            l = sDMSScope.getId(systemEnvironment);
        }
        return sDMSScope;
    }

    public static Long pathToId(SystemEnvironment systemEnvironment, Vector vector, long l) throws SDMSException {
        return SDMSScopeTableGeneric.getScope(systemEnvironment, vector, l).getId(systemEnvironment);
    }

    public static SDMSScope getScope(SystemEnvironment systemEnvironment, Vector vector, long l) throws SDMSException {
        Long l2 = null;
        SDMSScope sDMSScope = null;
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.get(i);
            sDMSScope = (SDMSScope)SDMSScopeTable.idx_parentId_name.getUnique(systemEnvironment, new SDMSKey(l2, (Comparable)((Object)string)), l);
            l2 = sDMSScope.getId(systemEnvironment);
        }
        return sDMSScope;
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

