/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SDMSSQLException;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSWatchTypeParameter;
import de.independit.scheduler.server.repository.SDMSWatchTypeParameterTableGeneric;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SDMSWatchTypeParameterGeneric
extends SDMSObject
implements Cloneable {
    public static final int CONFIG = 1;
    public static final int VALUE = 2;
    public static final int INFO = 3;
    public static final int nr_id = 1;
    public static final int nr_name = 2;
    public static final int nr_defaultValue = 3;
    public static final int nr_wtId = 4;
    public static final int nr_isSubmitPar = 5;
    public static final int nr_type = 6;
    public static final int nr_creatorUId = 7;
    public static final int nr_createTs = 8;
    public static final int nr_changerUId = 9;
    public static final int nr_changeTs = 10;
    public static String tableName = "WATCH_TYPE_PARAMETER";
    protected String name;
    protected String defaultValue;
    protected Long wtId;
    protected Boolean isSubmitPar;
    protected Integer type;
    protected Long creatorUId;
    protected Long createTs;
    protected Long changerUId;
    protected Long changeTs;
    private static PreparedStatement[] pUpdate = new PreparedStatement[128];
    private static PreparedStatement[] pDelete = new PreparedStatement[128];
    private static PreparedStatement[] pInsert = new PreparedStatement[128];

    public SDMSWatchTypeParameterGeneric(SystemEnvironment systemEnvironment, String string, String string2, Long l, Boolean bl, Integer n, Long l2, Long l3, Long l4, Long l5) throws SDMSException {
        super(systemEnvironment, SDMSWatchTypeParameterTableGeneric.table);
        if (string != null && string.length() > 64) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(WatchTypeParameter) Length of $1 exceeds maximum length $2", "name", "64"));
        }
        this.name = string;
        if (string2 != null && string2.length() > 256) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(WatchTypeParameter) Length of $1 exceeds maximum length $2", "defaultValue", "256"));
        }
        this.defaultValue = string2;
        this.wtId = l;
        this.isSubmitPar = bl;
        this.type = n;
        this.creatorUId = l2;
        this.createTs = l3;
        this.changerUId = l4;
        this.changeTs = l5;
    }

    public String getName(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.name;
    }

    public void setName(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (this.name.equals(string)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(WatchTypeParameter) Change of system object not allowed"));
            }
            SDMSWatchTypeParameterGeneric sDMSWatchTypeParameterGeneric = (SDMSWatchTypeParameterGeneric)this.change(systemEnvironment);
            if (string != null && string.length() > 64) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(WatchTypeParameter) Length of $1 exceeds maximum length $2", "name", "64"));
            }
            sDMSWatchTypeParameterGeneric.name = string;
            sDMSWatchTypeParameterGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSWatchTypeParameterGeneric.changeTs = systemEnvironment.txTime();
            sDMSWatchTypeParameterGeneric.versions.table.index(systemEnvironment, sDMSWatchTypeParameterGeneric, 2L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public String getDefaultValue(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.defaultValue;
    }

    public void setDefaultValue(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.defaultValue)) {
            return;
        }
        if (string == null && this.defaultValue == null) {
            return;
        }
        SDMSWatchTypeParameterGeneric sDMSWatchTypeParameterGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(WatchTypeParameter) Change of system object not allowed"));
        }
        if (sDMSWatchTypeParameterGeneric.versions.o_v == null || sDMSWatchTypeParameterGeneric.versions.o_v.size() == 0 || sDMSWatchTypeParameterGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSWatchTypeParameterGeneric = (SDMSWatchTypeParameterGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 256) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(WatchTypeParameter) Length of $1 exceeds maximum length $2", "defaultValue", "256"));
        }
        sDMSWatchTypeParameterGeneric.defaultValue = string;
        sDMSWatchTypeParameterGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSWatchTypeParameterGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSWatchTypeParameterGeneric != this) {
            sDMSWatchTypeParameterGeneric.versions.table.index(systemEnvironment, sDMSWatchTypeParameterGeneric, 0L);
        }
    }

    public Long getWtId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.wtId;
    }

    public void setWtId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.wtId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(WatchTypeParameter) Change of system object not allowed"));
            }
            SDMSWatchTypeParameterGeneric sDMSWatchTypeParameterGeneric = (SDMSWatchTypeParameterGeneric)this.change(systemEnvironment);
            sDMSWatchTypeParameterGeneric.wtId = l;
            sDMSWatchTypeParameterGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSWatchTypeParameterGeneric.changeTs = systemEnvironment.txTime();
            sDMSWatchTypeParameterGeneric.versions.table.index(systemEnvironment, sDMSWatchTypeParameterGeneric, 3L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Boolean getIsSubmitPar(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isSubmitPar;
    }

    public void setIsSubmitPar(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.isSubmitPar.equals(bl)) {
            return;
        }
        SDMSWatchTypeParameterGeneric sDMSWatchTypeParameterGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(WatchTypeParameter) Change of system object not allowed"));
        }
        if (sDMSWatchTypeParameterGeneric.versions.o_v == null || sDMSWatchTypeParameterGeneric.versions.o_v.size() == 0 || sDMSWatchTypeParameterGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSWatchTypeParameterGeneric = (SDMSWatchTypeParameterGeneric)this.change(systemEnvironment);
        }
        sDMSWatchTypeParameterGeneric.isSubmitPar = bl;
        sDMSWatchTypeParameterGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSWatchTypeParameterGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSWatchTypeParameterGeneric != this) {
            sDMSWatchTypeParameterGeneric.versions.table.index(systemEnvironment, sDMSWatchTypeParameterGeneric, 0L);
        }
    }

    public Integer getType(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.type;
    }

    public String getTypeAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getType(systemEnvironment);
        switch (n) {
            case 1: {
                return "CONFIG";
            }
            case 2: {
                return "VALUE";
            }
            case 3: {
                return "INFO";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown WatchTypeParameter.type: $1", this.getType(systemEnvironment)));
    }

    public void setType(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.type.equals(n)) {
            return;
        }
        SDMSWatchTypeParameterGeneric sDMSWatchTypeParameterGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(WatchTypeParameter) Change of system object not allowed"));
        }
        if (sDMSWatchTypeParameterGeneric.versions.o_v == null || sDMSWatchTypeParameterGeneric.versions.o_v.size() == 0 || sDMSWatchTypeParameterGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSWatchTypeParameterGeneric = (SDMSWatchTypeParameterGeneric)this.change(systemEnvironment);
        }
        sDMSWatchTypeParameterGeneric.type = n;
        sDMSWatchTypeParameterGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSWatchTypeParameterGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSWatchTypeParameterGeneric != this) {
            sDMSWatchTypeParameterGeneric.versions.table.index(systemEnvironment, sDMSWatchTypeParameterGeneric, 0L);
        }
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.creatorUId;
    }

    void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.creatorUId.equals(l)) {
            return;
        }
        SDMSWatchTypeParameterGeneric sDMSWatchTypeParameterGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(WatchTypeParameter) Change of system object not allowed"));
        }
        if (sDMSWatchTypeParameterGeneric.versions.o_v == null || sDMSWatchTypeParameterGeneric.versions.o_v.size() == 0 || sDMSWatchTypeParameterGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSWatchTypeParameterGeneric = (SDMSWatchTypeParameterGeneric)this.change(systemEnvironment);
        }
        sDMSWatchTypeParameterGeneric.creatorUId = l;
        sDMSWatchTypeParameterGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSWatchTypeParameterGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSWatchTypeParameterGeneric != this) {
            sDMSWatchTypeParameterGeneric.versions.table.index(systemEnvironment, sDMSWatchTypeParameterGeneric, 0L);
        }
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.createTs;
    }

    void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.createTs.equals(l)) {
            return;
        }
        SDMSWatchTypeParameterGeneric sDMSWatchTypeParameterGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(WatchTypeParameter) Change of system object not allowed"));
        }
        if (sDMSWatchTypeParameterGeneric.versions.o_v == null || sDMSWatchTypeParameterGeneric.versions.o_v.size() == 0 || sDMSWatchTypeParameterGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSWatchTypeParameterGeneric = (SDMSWatchTypeParameterGeneric)this.change(systemEnvironment);
        }
        sDMSWatchTypeParameterGeneric.createTs = l;
        sDMSWatchTypeParameterGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSWatchTypeParameterGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSWatchTypeParameterGeneric != this) {
            sDMSWatchTypeParameterGeneric.versions.table.index(systemEnvironment, sDMSWatchTypeParameterGeneric, 0L);
        }
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changerUId;
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSWatchTypeParameterGeneric sDMSWatchTypeParameterGeneric = this;
        if (sDMSWatchTypeParameterGeneric.versions.o_v == null || sDMSWatchTypeParameterGeneric.versions.o_v.size() == 0 || sDMSWatchTypeParameterGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSWatchTypeParameterGeneric = (SDMSWatchTypeParameterGeneric)this.change(systemEnvironment);
        }
        sDMSWatchTypeParameterGeneric.changerUId = l;
        sDMSWatchTypeParameterGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSWatchTypeParameterGeneric != this) {
            sDMSWatchTypeParameterGeneric.versions.table.index(systemEnvironment, sDMSWatchTypeParameterGeneric, 0L);
        }
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changeTs;
    }

    void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.changeTs.equals(l)) {
            return;
        }
        SDMSWatchTypeParameterGeneric sDMSWatchTypeParameterGeneric = this;
        if (sDMSWatchTypeParameterGeneric.versions.o_v == null || sDMSWatchTypeParameterGeneric.versions.o_v.size() == 0 || sDMSWatchTypeParameterGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSWatchTypeParameterGeneric = (SDMSWatchTypeParameterGeneric)this.change(systemEnvironment);
        }
        sDMSWatchTypeParameterGeneric.changeTs = l;
        sDMSWatchTypeParameterGeneric.changerUId = systemEnvironment.cEnv.uid();
        if (sDMSWatchTypeParameterGeneric != this) {
            sDMSWatchTypeParameterGeneric.versions.table.index(systemEnvironment, sDMSWatchTypeParameterGeneric, 0L);
        }
    }

    public SDMSWatchTypeParameterGeneric set_WtIdName(SystemEnvironment systemEnvironment, Long l, String string) throws SDMSException {
        SDMSWatchTypeParameterGeneric sDMSWatchTypeParameterGeneric;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141637", "(WatchTypeParameter) Change of system object not allowed"));
            }
            sDMSWatchTypeParameterGeneric = (SDMSWatchTypeParameterGeneric)this.change(systemEnvironment);
            sDMSWatchTypeParameterGeneric.wtId = l;
            if (string != null && string.length() > 64) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01201290026", "(WatchTypeParameter) Length of $1 exceeds maximum length $2", "changeTs", "64"));
            }
            sDMSWatchTypeParameterGeneric.name = string;
            sDMSWatchTypeParameterGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSWatchTypeParameterGeneric.changeTs = systemEnvironment.txTime();
            sDMSWatchTypeParameterGeneric.versions.table.index(systemEnvironment, sDMSWatchTypeParameterGeneric);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        return sDMSWatchTypeParameterGeneric;
    }

    @Override
    protected SDMSProxy toProxy(SystemEnvironment systemEnvironment) {
        return new SDMSWatchTypeParameter(this);
    }

    protected SDMSWatchTypeParameterGeneric(Long l, String string, String string2, Long l2, Boolean bl, Integer n, Long l3, Long l4, Long l5, Long l6, long l7, long l8) {
        this.id = l;
        this.name = string;
        this.defaultValue = string2;
        this.wtId = l2;
        this.isSubmitPar = bl;
        this.type = n;
        this.creatorUId = l3;
        this.createTs = l4;
        this.changerUId = l5;
        this.changeTs = l6;
        this.validFrom = l7;
        this.validTo = l8;
    }

    protected String tableName() {
        return tableName;
    }

    @Override
    protected void insertDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pInsert[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "INSERT INTO " + string2 + "WATCH_TYPE_PARAMETER" + string3 + " (ID, " + string2 + "NAME" + string3 + ", " + string2 + "DEFAULTVALUE" + string3 + ", " + string2 + "WT_ID" + string3 + ", " + string2 + "IS_SUBMIT_PAR" + string3 + ", " + string2 + "TYPE" + string3 + ", " + string2 + "CREATOR_U_ID" + string3 + ", " + string2 + "CREATE_TS" + string3 + ", " + string2 + "CHANGER_U_ID" + string3 + ", " + string2 + "CHANGE_TS" + string3 + ") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                SDMSWatchTypeParameterGeneric.pInsert[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181952", "WatchTypeParameter: $1\n$2", string, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pInsert[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.setString(2, this.name);
            if (this.defaultValue == null) {
                preparedStatement.setNull(3, 12);
            } else {
                preparedStatement.setString(3, this.defaultValue);
            }
            preparedStatement.setLong(4, this.wtId);
            preparedStatement.setInt(5, this.isSubmitPar != false ? 1 : 0);
            preparedStatement.setInt(6, this.type);
            preparedStatement.setLong(7, this.creatorUId);
            preparedStatement.setLong(8, this.createTs);
            preparedStatement.setLong(9, this.changerUId);
            preparedStatement.setLong(10, this.changeTs);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181954", "WatchTypeParameter: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    @Override
    protected void deleteDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pDelete[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "DELETE FROM " + string2 + "WATCH_TYPE_PARAMETER" + string3 + " WHERE ID = ?";
                SDMSWatchTypeParameterGeneric.pDelete[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182001", "WatchTypeParameter: $1\n$2", string, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pDelete[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182002", "WatchTypeParameter: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    @Override
    protected void updateDBObject(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        if (pUpdate[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "UPDATE " + string2 + "WATCH_TYPE_PARAMETER" + string3 + " SET " + string2 + "NAME" + string3 + " = ? , " + string2 + "DEFAULTVALUE" + string3 + " = ? , " + string2 + "WT_ID" + string3 + " = ? , " + string2 + "IS_SUBMIT_PAR" + string3 + " = ? , " + string2 + "TYPE" + string3 + " = ? , " + string2 + "CREATOR_U_ID" + string3 + " = ? , " + string2 + "CREATE_TS" + string3 + " = ? , " + string2 + "CHANGER_U_ID" + string3 + " = ? , " + string2 + "CHANGE_TS" + string3 + " = ? WHERE ID = ?";
                SDMSWatchTypeParameterGeneric.pUpdate[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182005", "WatchTypeParameter: $1\n$2", string, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pUpdate[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setString(1, this.name);
            if (this.defaultValue == null) {
                preparedStatement.setNull(2, 12);
            } else {
                preparedStatement.setString(2, this.defaultValue);
            }
            preparedStatement.setLong(3, this.wtId);
            preparedStatement.setInt(4, this.isSubmitPar != false ? 1 : 0);
            preparedStatement.setInt(5, this.type);
            preparedStatement.setLong(6, this.creatorUId);
            preparedStatement.setLong(7, this.createTs);
            preparedStatement.setLong(8, this.changerUId);
            preparedStatement.setLong(9, this.changeTs);
            preparedStatement.setLong(10, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182006", "WatchTypeParameter: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    public static boolean checkType(Integer n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void print() {
        SDMSThread.doTrace(null, "Type : WatchTypeParameter", 2);
        SDMSThread.doTrace(null, "id : " + this.id, 2);
        SDMSThread.doTrace(null, "name : " + this.name, 2);
        SDMSThread.doTrace(null, "defaultValue : " + this.defaultValue, 2);
        SDMSThread.doTrace(null, "wtId : " + this.wtId, 2);
        SDMSThread.doTrace(null, "isSubmitPar : " + this.isSubmitPar, 2);
        SDMSThread.doTrace(null, "type : " + this.type, 2);
        SDMSThread.doTrace(null, "creatorUId : " + this.creatorUId, 2);
        SDMSThread.doTrace(null, "createTs : " + this.createTs, 2);
        SDMSThread.doTrace(null, "changerUId : " + this.changerUId, 2);
        SDMSThread.doTrace(null, "changeTs : " + this.changeTs, 2);
        SDMSThread.doTrace(null, "validFrom : " + this.validFrom, 2);
        SDMSThread.doTrace(null, "validTo : " + this.validTo, 2);
        this.dumpVersions(2);
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        String string = new String(stringBuffer);
        String string2 = string + "id : " + this.id + "\n" + string + "name         : " + this.name + "\n" + string + "defaultValue : " + this.defaultValue + "\n" + string + "wtId         : " + this.wtId + "\n" + string + "isSubmitPar  : " + this.isSubmitPar + "\n" + string + "type         : " + this.type + "\n" + string + "creatorUId   : " + this.creatorUId + "\n" + string + "createTs     : " + this.createTs + "\n" + string + "changerUId   : " + this.changerUId + "\n" + string + "changeTs     : " + this.changeTs + "\n" + string + "validFrom : " + this.validFrom + "\n" + string + "validTo : " + this.validTo + "\n";
        return string2;
    }

    public String toString() {
        String string = this.toString(0);
        return string;
    }
}

