/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.util;

import de.independit.scheduler.server.ConnectionEnvironment;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SerializationException;
import de.independit.scheduler.server.repository.SDMSUserProxyGeneric;
import de.independit.scheduler.server.repository.SDMSUserTable;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class AuditWriter {
    private static final SimpleDateFormat sysDateFmt = (SimpleDateFormat)SystemEnvironment.staticSystemDateFormat.clone();
    private static final SimpleDateFormat fileExtFmt = new SimpleDateFormat("yyyyMMddHHmmss", SystemEnvironment.systemLocale);
    private static PrintStream audit = null;
    private static int nrLinesWritten = 0;

    private static void openAuditFile(SystemEnvironment systemEnvironment) throws IOException {
        boolean bl = false;
        File file = new File(SystemEnvironment.auditFile);
        String string = file.getParent();
        String string2 = file.getName() + ".";
        String string3 = fileExtFmt.format(new Date(System.currentTimeMillis()));
        string2 = string2 + string3;
        File file2 = new File(string, string2);
        audit = new PrintStream(file2);
        nrLinesWritten = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String getHeader(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        Object object;
        Object object2;
        String string = null;
        if (systemEnvironment.cEnv != null) {
            object2 = systemEnvironment.cEnv.uid();
            if (object2 != null) {
                try {
                    object = SDMSUserTable.getObject(systemEnvironment, (Long)object2);
                    string = ((SDMSUserProxyGeneric)object).getName(systemEnvironment);
                }
                catch (NotFoundException notFoundException) {
                    string = systemEnvironment.cEnv.name() + "(" + object2 + ")";
                }
            } else {
                string = systemEnvironment.cEnv.name();
            }
        } else {
            string = "Unknown";
        }
        object2 = "" + l + "\t" + string;
        object = sysDateFmt;
        synchronized (object) {
            return (String)object2 + "\t[" + sysDateFmt.format(new Date(System.currentTimeMillis())) + "]\t";
        }
    }

    public static synchronized void write(SystemEnvironment systemEnvironment, ConnectionEnvironment connectionEnvironment, boolean bl) throws SDMSException {
        Long l = connectionEnvironment.tx.versionId;
        String string = connectionEnvironment.actstmt;
        String string2 = connectionEnvironment.ip();
        if (string2 == null) {
            string2 = "INTERNAL";
        }
        try {
            if (audit == null) {
                AuditWriter.openAuditFile(systemEnvironment);
            }
            audit.println("[" + string2 + "]: " + AuditWriter.getHeader(systemEnvironment, l) + string + "\n" + (bl ? "SUCCESS" : "FAILED"));
            if (++nrLinesWritten >= SystemEnvironment.auditEntries) {
                audit.close();
                audit = null;
            }
        }
        catch (IOException iOException) {
            if (audit != null) {
                audit.close();
                audit = null;
            }
        }
        catch (SerializationException serializationException) {
            throw serializationException;
        }
        catch (SDMSException sDMSException) {
            // empty catch block
        }
    }
}

