/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.shell;

import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.output.SDMSOutput;
import de.independit.scheduler.server.output.SDMSOutputRenderer;
import de.independit.scheduler.shell.IOcatcher;
import de.independit.scheduler.shell.SDMSServerConnection;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.StringTokenizer;
import java.util.Vector;

public class MiniParser {
    private int stop = 0;
    private boolean discOnError = false;
    private int retVal = 0;
    private static boolean printTime = false;
    private static boolean printCmd = true;
    private SDMSServerConnection sc = null;
    private SDMSOutputRenderer or = null;
    private String host;
    private String port;
    private String user;
    private PrintStream out = System.out;
    private boolean isDump = false;
    private static final String S_SYNTAX_ERROR = "Syntax Error";
    private static int stmtCtr = 0;
    private static Vector stmtList = new Vector();
    public static final int DISCONNECT = 257;
    public static final int S_ERROR = 258;
    public static final int WHENEVER = 259;
    public static final int CONTINUE = 260;
    public static final int HELP = 261;
    public static final int PROMPT = 262;
    public static final int EOS = 263;
    public static final int INTEGER = 264;
    public static final int NAN = 265;
    public static final int BMULTI = 266;
    public static final int EMULTI = 267;
    public static final int ECHOOFF = 268;
    public static final int ECHOON = 269;
    public static final int FILENOTFOUND = 270;
    public static final int FILESPEC = 271;
    public static final int INVALIDFILE = 272;
    public static final int ROLLBACK = 273;
    public static final int SHELLCMD = 274;
    public static final int STATEMENT = 275;
    public static final int STRING = 276;
    public static final int TIMINGON = 277;
    public static final int TIMINGOFF = 278;
    public static final int yyErrorCode = 256;
    protected static final int yyFinal = 1;
    protected static short[] yyLhs;
    protected static short[] yyLen;
    protected static short[] yyDefRed;
    protected static short[] yyDgoto;
    protected static short[] yySindex;
    protected static short[] yyRindex;
    protected static short[] yyGindex;
    protected static short[] yyTable;
    protected static short[] yyCheck;
    protected static String[] yyNames;
    protected int yyMax;

    public MiniParser() {
        if (yyLhs == null) {
            try {
                InputStream inputStream;
                Class<?> clazz = this.getClass();
                String string = clazz.getPackage().getName().replace('.', '/') + "/parser.tables";
                try {
                    inputStream = clazz.getResourceAsStream("/" + string);
                }
                catch (Exception exception) {
                    inputStream = clazz.getResourceAsStream(string);
                }
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                yyLhs = MiniParser.loadShort(bufferedReader);
                yyLen = MiniParser.loadShort(bufferedReader);
                yyDefRed = MiniParser.loadShort(bufferedReader);
                yyDgoto = MiniParser.loadShort(bufferedReader);
                yySindex = MiniParser.loadShort(bufferedReader);
                yyRindex = MiniParser.loadShort(bufferedReader);
                yyGindex = MiniParser.loadShort(bufferedReader);
                yyTable = MiniParser.loadShort(bufferedReader);
                yyCheck = MiniParser.loadShort(bufferedReader);
                StringTokenizer stringTokenizer = new StringTokenizer(bufferedReader.readLine());
                stringTokenizer.nextToken();
                yyNames = new String[Integer.parseInt(stringTokenizer.nextToken())];
                int n = Integer.parseInt(stringTokenizer.nextToken());
                for (int i = 0; i < n; ++i) {
                    stringTokenizer = new StringTokenizer(bufferedReader.readLine());
                    int n2 = Integer.parseInt(stringTokenizer.nextToken());
                    MiniParser.yyNames[n2] = stringTokenizer.nextToken("\n").substring(1);
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                throw new Error("cannot load parser tables [" + exception + "]");
            }
        }
    }

    protected static short[] loadShort(BufferedReader bufferedReader) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(bufferedReader.readLine());
        stringTokenizer.nextToken();
        short[] sArray = new short[Integer.parseInt(stringTokenizer.nextToken())];
        for (int i = 0; i < sArray.length; i += 10) {
            stringTokenizer = new StringTokenizer(bufferedReader.readLine(), ", \t\r\n");
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                sArray[i + n] = Short.valueOf(stringTokenizer.nextToken());
                ++n;
            }
        }
        return sArray;
    }

    public void yyerror(String string) {
        this.yyerror(string, null);
    }

    public void yyerror(String string, String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            System.err.print(string + ", expecting");
            for (int i = 0; i < stringArray.length; ++i) {
                System.err.print(" " + stringArray[i]);
            }
            System.err.println();
        } else {
            System.err.println(string);
        }
    }

    protected String[] yyExpecting(int n) {
        int n2;
        int n3 = 0;
        boolean[] blArray = new boolean[yyNames.length];
        int n4 = yySindex[n];
        if (n4 != 0) {
            int n5 = n2 = n4 < 0 ? -n4 : 0;
            while (n2 < yyNames.length && n4 + n2 < yyTable.length) {
                if (yyCheck[n4 + n2] == n2 && !blArray[n2] && yyNames[n2] != null) {
                    ++n3;
                    blArray[n2] = true;
                }
                ++n2;
            }
        }
        if ((n4 = yyRindex[n]) != 0) {
            int n6 = n2 = n4 < 0 ? -n4 : 0;
            while (n2 < yyNames.length && n4 + n2 < yyTable.length) {
                if (yyCheck[n4 + n2] == n2 && !blArray[n2] && yyNames[n2] != null) {
                    ++n3;
                    blArray[n2] = true;
                }
                ++n2;
            }
        }
        String[] stringArray = new String[n3];
        n2 = 0;
        n4 = 0;
        while (n4 < n3) {
            if (blArray[n2]) {
                stringArray[n4++] = yyNames[n2];
            }
            ++n2;
        }
        return stringArray;
    }

    public Object yyparse(yyInput yyInput2, Object object) throws IOException, yyException, SDMSException {
        return this.yyparse(yyInput2);
    }

    protected Object yyDefault(Object object) {
        return object;
    }

    /*
     * Exception decompiling
     */
    public Object yyparse(yyInput var1_1) throws IOException, yyException, SDMSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setServerConnection(SDMSServerConnection sDMSServerConnection) {
        this.sc = sDMSServerConnection;
    }

    public void setPrintCmd(boolean bl) {
        printCmd = bl;
    }

    public void setOutputRenderer(SDMSOutputRenderer sDMSOutputRenderer) {
        this.or = sDMSOutputRenderer;
    }

    public SDMSOutputRenderer getOutputRenderer() {
        return this.or;
    }

    public void setEnvInfo(String string, int n, String string2) {
        this.host = string;
        this.port = "" + n;
        this.user = string2;
    }

    public void render(SDMSOutput sDMSOutput) throws SDMSException {
        if (this.isDump && sDMSOutput.error == null) {
            String string = (String)((Vector)sDMSOutput.container.dataset.get(0)).get(1);
            if (string != null) {
                Object object;
                try {
                    object = new PrintStream(new FileOutputStream(string));
                    ((PrintStream)object).print((String)((Vector)sDMSOutput.container.dataset.get(0)).get(0));
                    ((PrintStream)object).close();
                    this.out.println("");
                }
                catch (IOException iOException) {
                    this.out.println(iOException.toString() + "\n");
                }
                object = new SDMSOutput();
                ((SDMSOutput)object).setFeedback("Dump to " + string + " completed");
                this.or.render(this.out, (SDMSOutput)object);
            } else {
                this.or.render(this.out, sDMSOutput);
            }
            this.isDump = false;
        } else {
            this.or.render(this.out, sDMSOutput);
        }
        if (sDMSOutput.error != null && (this.discOnError || sDMSOutput.error.code.startsWith("Desktop"))) {
            try {
                this.sc.finish();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.out.println("");
            System.exit(this.retVal);
        }
    }

    private String renderPrompt(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 1; i < n - 1; ++i) {
            if (cArray[i] == '%') {
                switch (cArray[++i]) {
                    case 'H': {
                        stringBuffer.append(this.host);
                        break;
                    }
                    case 'P': {
                        stringBuffer.append(this.port);
                        break;
                    }
                    case 'U': {
                        stringBuffer.append(this.user);
                        break;
                    }
                    case '%': {
                        stringBuffer.append('%');
                        break;
                    }
                    default: {
                        stringBuffer.append('%');
                        stringBuffer.append(cArray[i]);
                        break;
                    }
                }
                continue;
            }
            stringBuffer.append(cArray[i]);
        }
        return stringBuffer.toString();
    }

    private void process_output(InputStream inputStream, InputStream inputStream2) throws IOException {
        IOcatcher iOcatcher = new IOcatcher(inputStream, this.out);
        IOcatcher iOcatcher2 = new IOcatcher(inputStream2, System.err);
        iOcatcher.run();
        iOcatcher2.run();
        while (true) {
            try {
                iOcatcher2.join();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        while (true) {
            try {
                iOcatcher.join();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public static void setPrintTime() {
        printTime = true;
    }

    public static void resetPrintTime() {
        printTime = false;
    }

    public static void setPrintCmd() {
        printCmd = true;
    }

    public static void resetPrintCmd() {
        printCmd = false;
    }

    public void help() {
        this.out.println("Condensed Help Feature");
        this.out.println("----------------------\n");
        this.out.println("Internal sdmsh Commands:");
        this.out.println("disconnect|bye|exit|quit         -- leaves the tool");
        this.out.println("echo on|off                      -- controls whether the statementtext is printed or not");
        this.out.println("help                             -- gives this output");
        this.out.println("include '<filespec>'             -- reads sdms(h) commands from the given file");
        this.out.println("prompt '<somestring>'            -- sets to prompt to the specified value");
        this.out.println("                                    %H = hostname, %P = port, %U = user, %% = %");
        this.out.println("timing on|off                    -- controls whether the actual time is printed or not");
        this.out.println("whenever error ");
        this.out.println("  continue|disconnect <integer>  -- specifies the behaviour of the program in case of an error");
        this.out.println("!<shellcommand>                  -- executes the specified command. sdmsh has no intelligence");
        this.out.println("                                    at all regarding terminal I/O");
    }

    public void setOutputStream(PrintStream printStream) {
        this.out = printStream;
    }

    public static interface yyInput {
        public boolean advance() throws IOException, SDMSException;

        public int token();

        public Object value();
    }

    public static class yyException
    extends Exception {
        public yyException(String string) {
            super(string);
        }
    }
}

