-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE NICE_PROFILE_ENTRY (
    ID                             bigint NOT NULL
    , NP_ID                          bigint          NOT NULL
    , PREFERENCE                     integer         NOT NULL
    , FOLDER_ID                      bigint              NULL
    , IS_SUSPENDED                   integer         NOT NULL
    , RENICE                         integer         NOT NULL
    , IS_ACTIVE                      integer         NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_NICE_PROFILE_ENTRY
ON NICE_PROFILE_ENTRY(ID);
CREATE VIEW SCI_NICE_PROFILE_ENTRY AS
SELECT 
    ID 
    , NP_ID                          AS NP_ID
    , PREFERENCE                     AS PREFERENCE
    , FOLDER_ID                      AS FOLDER_ID
    , DECODE (IS_SUSPENDED, 0, 'NOSUSPEND', 1, 'SUSPEND', 2, 'ADMINSUSPEND') AS IS_SUSPENDED
    , RENICE                         AS RENICE
    , DECODE (IS_ACTIVE, 1, 'TRUE', 0, 'FALSE') AS IS_ACTIVE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM NICE_PROFILE_ENTRY;
