-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE OBJECT_EVENT (
    ID                             bigint NOT NULL
    , TR_ID                          bigint              NULL
    , OI_ID                          bigint          NOT NULL
    , EVENT_TYPE                     integer         NOT NULL
    , SME_ID                         bigint          NOT NULL
    , SE_ID                          bigint          NOT NULL
    , SUBMIT_TS                      bigint              NULL
    , FINAL_TS                       bigint              NULL
    , FINAL_ESD_ID                   bigint              NULL
    , MAIN_SME_ID                    bigint              NULL
    , MAIN_SE_ID                     bigint              NULL
    , MAIN_FINAL_TS                  bigint              NULL
    , MAIN_FINAL_ESD_ID              bigint              NULL
    , SE_VERSION                     bigint          NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_OBJECT_EVENT
ON OBJECT_EVENT(ID);
CREATE VIEW SCI_OBJECT_EVENT AS
SELECT 
    ID 
    , TR_ID                          AS TR_ID
    , OI_ID                          AS OI_ID
    , DECODE (EVENT_TYPE, 1, 'CREATE', 2, 'CHANGE', 3, 'DELETE') AS EVENT_TYPE
    , SME_ID                         AS SME_ID
    , SE_ID                          AS SE_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(SUBMIT_TS, 1125899906842624)/1000) seconds AS SUBMIT_TS
    , timestamp('1970-01-01-00.00.00') + int(mod(FINAL_TS, 1125899906842624)/1000) seconds AS FINAL_TS
    , FINAL_ESD_ID                   AS FINAL_ESD_ID
    , MAIN_SME_ID                    AS MAIN_SME_ID
    , MAIN_SE_ID                     AS MAIN_SE_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(MAIN_FINAL_TS, 1125899906842624)/1000) seconds AS MAIN_FINAL_TS
    , MAIN_FINAL_ESD_ID              AS MAIN_FINAL_ESD_ID
    , SE_VERSION                     AS SE_VERSION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM OBJECT_EVENT;
