-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE OBJECT_MONITOR (
    ID                             bigint NOT NULL
    , NAME                           varchar(64)     NOT NULL
    , OWNER_ID                       bigint          NOT NULL
    , WT_ID                          bigint          NOT NULL
    , RECREATE_HANDLING              integer         NOT NULL
    , WATCH_SE_ID                    bigint              NULL
    , DELETE_AMOUNT                  integer             NULL
    , DELETE_BASE                    integer             NULL
    , EVENT_DELETE_AMOUNT            integer             NULL
    , EVENT_DELETE_BASE              integer             NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_OBJECT_MONITOR
ON OBJECT_MONITOR(ID);
CREATE VIEW SCI_OBJECT_MONITOR AS
SELECT 
    ID 
    , NAME                           AS NAME
    , OWNER_ID                       AS OWNER_ID
    , WT_ID                          AS WT_ID
    , DECODE (RECREATE_HANDLING, 0, 'NONE', 1, 'CREATE', 2, 'CHANGE') AS RECREATE_HANDLING
    , WATCH_SE_ID                    AS WATCH_SE_ID
    , DELETE_AMOUNT                  AS DELETE_AMOUNT
    , DECODE (DELETE_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS DELETE_BASE
    , EVENT_DELETE_AMOUNT            AS EVENT_DELETE_AMOUNT
    , DECODE (EVENT_DELETE_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS EVENT_DELETE_BASE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM OBJECT_MONITOR;
