-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE SCOPE (
    ID                             bigint NOT NULL
    , NAME                           varchar(64)     NOT NULL
    , OWNER_ID                       bigint          NOT NULL
    , PARENT_ID                      bigint              NULL
    , TYPE                           integer         NOT NULL
    , IS_TERMINATE                   integer             NULL
    , HAS_ALTEREDCONFIG              integer             NULL
    , IS_SUSPENDED                   integer             NULL
    , IS_ENABLED                     integer             NULL
    , IS_REGISTERED                  integer             NULL
    , STATE                          integer             NULL
    , PASSWD                         varchar(64)         NULL
    , SALT                           varchar(64)         NULL
    , METHOD                         integer         NOT NULL
    , PID                            varchar(32)         NULL
    , NODE                           varchar(64)         NULL
    , ERRMSG                         varchar(256)        NULL
    , LAST_ACTIVE                    bigint              NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , INHERIT_PRIVS                  bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_SCOPE
ON SCOPE(ID);
CREATE VIEW SCI_SCOPE AS
SELECT 
    ID 
    , NAME                           AS NAME
    , OWNER_ID                       AS OWNER_ID
    , PARENT_ID                      AS PARENT_ID
    , DECODE (TYPE, 1, 'SCOPE', 2, 'SERVER') AS TYPE
    , DECODE (IS_TERMINATE, 1, 'TRUE', 0, 'FALSE') AS IS_TERMINATE
    , DECODE (HAS_ALTEREDCONFIG, 1, 'TRUE', 0, 'FALSE') AS HAS_ALTEREDCONFIG
    , DECODE (IS_SUSPENDED, 1, 'TRUE', 0, 'FALSE') AS IS_SUSPENDED
    , DECODE (IS_ENABLED, 1, 'TRUE', 0, 'FALSE') AS IS_ENABLED
    , DECODE (IS_REGISTERED, 1, 'TRUE', 0, 'FALSE') AS IS_REGISTERED
    , DECODE (STATE, 1, 'NOMINAL', 2, 'NONFATAL', 3, 'FATAL') AS STATE
    , PID                            AS PID
    , NODE                           AS NODE
    , ERRMSG                         AS ERRMSG
    , LAST_ACTIVE                    AS LAST_ACTIVE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
    , INHERIT_PRIVS                  AS INHERIT_PRIVS
  FROM SCOPE;
