-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE TRIGGER_QUEUE (
    ID                             bigint NOT NULL
    , SME_ID                         bigint          NOT NULL
    , TR_ID                          bigint          NOT NULL
    , NEXT_TRIGGER_TIME              bigint          NOT NULL
    , TIMES_CHECKED                  integer         NOT NULL
    , TIMES_TRIGGERED                integer         NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_TRIGGER_QUEUE
ON TRIGGER_QUEUE(ID);
CREATE VIEW SCI_TRIGGER_QUEUE AS
SELECT 
    ID 
    , SME_ID                         AS SME_ID
    , TR_ID                          AS TR_ID
    , NEXT_TRIGGER_TIME              AS NEXT_TRIGGER_TIME
    , TIMES_CHECKED                  AS TIMES_CHECKED
    , TIMES_TRIGGERED                AS TIMES_TRIGGERED
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM TRIGGER_QUEUE;
