connect to 'bicsuitedb' user 'bicsuite' using 'bicsuitepw';
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE AUDIT_TRAIL (
    ID                             bigint NOT NULL
    , USER_ID                        bigint          NOT NULL
    , TS                             bigint          NOT NULL
    , TXID                           bigint          NOT NULL
    , ACTION                         int8            NOT NULL
    , OBJECT_TYPE                    int8            NOT NULL
    , OBJECT_ID                      bigint          NOT NULL
    , ORIGIN_ID                      bigint          NOT NULL
    , IS_SET_WARNING                 integer         NOT NULL
    , ACTION_INFO                    lvarchar(1024)      NULL
    , INFO_ID                        bigint              NULL
    , ACTION_COMMENT                 lvarchar(1024)      NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_AUDIT_TRAIL
ON AUDIT_TRAIL(ID);
CREATE VIEW SCI_AUDIT_TRAIL (ID,USER_ID,TS,TXID,ACTION,OBJECT_TYPE,OBJECT_ID,ORIGIN_ID,IS_SET_WARNING,ACTION_INFO,INFO_ID,ACTION_COMMENT,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , USER_ID                        AS USER_ID
    , dbinfo ('utc_to_datetime', round(mod(TS, 1125899906842624)/1000)) AS TS
    , TXID                           AS TXID
    , DECODE (ACTION, 1, 'RERUN', 2, 'RERUN_RECURSIVE', 3, 'CANCEL', 4, 'SUSPEND', 5, 'RESUME', 6, 'SET_STATE', 7, 'SET_EXIT_STATE', 8, 'IGNORE_DEPENDENCY', 9, 'IGNORE_DEP_RECURSIVE', 10, 'IGNORE_RESOURCE', 11, 'KILL', 12, 'ALTER_RUN_PROGRAM', 13, 'ALTER_RERUN_PROGRAM', 14, 'COMMENT_JOB', 15, 'SUBMITTED', 16, 'TRIGGER_FAILED', 17, 'TRIGGER_SUBMIT', 18, 'JOB_RESTARTABLE', 19, 'CHANGE_PRIORITY', 20, 'RENICE', 21, 'SUBMIT_SUSPENDED', 22, 'IGNORE_NAMED_RESOURCE', 23, 'TIMEOUT', 24, 'SET_RESOURCE_STATE', 25, 'JOB_IN_ERROR', 26, 'CLEAR_WARNING', 27, 'SET_WARNING', 28, 'JOB_UNREACHABLE', 29, 'SET_PARAMETERS', 30, 'DISABLE', 31, 'ENABLE', 32, 'CLONE', 33, 'APPROVE', 34, 'REJECT', 35, 'APPROVAL_REQUEST', 36, 'REVIEW_REQUEST', 37, 'KILL_RECURSIVE') AS ACTION
    , DECODE (OBJECT_TYPE, 17, 'JOB') AS OBJECT_TYPE
    , OBJECT_ID                      AS OBJECT_ID
    , ORIGIN_ID                      AS ORIGIN_ID
    , DECODE (IS_SET_WARNING, 1, 'TRUE', 0, 'FALSE') AS IS_SET_WARNING
    , ACTION_INFO                    AS ACTION_INFO
    , INFO_ID                        AS INFO_ID
    , ACTION_COMMENT                 AS ACTION_COMMENT
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM AUDIT_TRAIL;
CREATE TABLE ARC_AUDIT_TRAIL (
    ID                             bigint NOT NULL
    , USER_ID                        bigint           NULL
    , TS                             bigint           NULL
    , TXID                           bigint           NULL
    , ACTION                         int8             NULL
    , OBJECT_TYPE                    int8             NULL
    , OBJECT_ID                      bigint           NULL
    , ORIGIN_ID                      bigint           NULL
    , IS_SET_WARNING                 integer          NULL
    , ACTION_INFO                    lvarchar(1024)   NULL
    , INFO_ID                        bigint           NULL
    , ACTION_COMMENT                 lvarchar(1024)   NULL
    , CREATOR_U_ID                   bigint           NULL
    , CREATE_TS                      bigint           NULL
    , CHANGER_U_ID                   bigint           NULL
    , CHANGE_TS                      bigint           NULL
);
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE CALENDAR (
    ID                             bigint NOT NULL
    , SCEV_ID                        bigint          NOT NULL
    , STARTTIME                      bigint          NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_CALENDAR
ON CALENDAR(ID);
CREATE VIEW SCI_CALENDAR (ID,SCEV_ID,STARTTIME,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , SCEV_ID                        AS SCEV_ID
    , dbinfo ('utc_to_datetime', round(mod(STARTTIME, 1125899906842624)/1000)) AS STARTTIME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM CALENDAR;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE DEPENDENCY_DEFINITION (
    ID                             bigint NOT NULL
    , SE_DEPENDENT_ID                bigint          NOT NULL
    , SE_REQUIRED_ID                 bigint          NOT NULL
    , NAME                           lvarchar(64)        NULL
    , UNRESOLVED_HANDLING            int8            NOT NULL
    , DMODE                          int8            NOT NULL
    , STATE_SELECTION                int8            NOT NULL
    , CONDITION                      lvarchar(1024)      NULL
    , RESOLVE_MODE                   int8            NOT NULL
    , EXPIRED_AMOUNT                 int8                NULL
    , EXPIRED_BASE                   int8                NULL
    , SELECT_CONDITION               lvarchar(1024)      NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , VALID_FROM                   bigint NOT NULL
    , VALID_TO                     bigint NOT NULL
);
CREATE INDEX PK_DEPENDENCY_DEFINITION
ON DEPENDENCY_DEFINITION(ID);
CREATE VIEW SCI_C_DEPENDENCY_DEFINITION (ID,SE_DEPENDENT_ID,SE_REQUIRED_ID,NAME,UNRESOLVED_HANDLING,DMODE,STATE_SELECTION,CONDITION,RESOLVE_MODE,EXPIRED_AMOUNT,EXPIRED_BASE,SELECT_CONDITION,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , SE_DEPENDENT_ID                AS SE_DEPENDENT_ID
    , SE_REQUIRED_ID                 AS SE_REQUIRED_ID
    , NAME                           AS NAME
    , DECODE (UNRESOLVED_HANDLING, 1, 'IGNORE', 2, 'ERROR', 3, 'SUSPEND', 4, 'DEFER', 5, 'DEFER_IGNORE') AS UNRESOLVED_HANDLING
    , DECODE (DMODE, 1, 'ALL_FINAL', 2, 'JOB_FINAL') AS DMODE
    , DECODE (STATE_SELECTION, 0, 'FINAL', 1, 'ALL_REACHABLE', 2, 'UNREACHABLE', 3, 'DEFAULT') AS STATE_SELECTION
    , CONDITION                      AS CONDITION
    , DECODE (RESOLVE_MODE, 0, 'INTERNAL', 1, 'EXTERNAL', 2, 'BOTH') AS RESOLVE_MODE
    , EXPIRED_AMOUNT                 AS EXPIRED_AMOUNT
    , DECODE (EXPIRED_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS EXPIRED_BASE
    , SELECT_CONDITION               AS SELECT_CONDITION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM DEPENDENCY_DEFINITION
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_DEPENDENCY_DEFINITION (ID,SE_DEPENDENT_ID,SE_REQUIRED_ID,NAME,UNRESOLVED_HANDLING,DMODE,STATE_SELECTION,CONDITION,RESOLVE_MODE,EXPIRED_AMOUNT,EXPIRED_BASE,SELECT_CONDITION,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , SE_DEPENDENT_ID                AS SE_DEPENDENT_ID
    , SE_REQUIRED_ID                 AS SE_REQUIRED_ID
    , NAME                           AS NAME
    , DECODE (UNRESOLVED_HANDLING, 1, 'IGNORE', 2, 'ERROR', 3, 'SUSPEND', 4, 'DEFER', 5, 'DEFER_IGNORE') AS UNRESOLVED_HANDLING
    , DECODE (DMODE, 1, 'ALL_FINAL', 2, 'JOB_FINAL') AS DMODE
    , DECODE (STATE_SELECTION, 0, 'FINAL', 1, 'ALL_REACHABLE', 2, 'UNREACHABLE', 3, 'DEFAULT') AS STATE_SELECTION
    , CONDITION                      AS CONDITION
    , DECODE (RESOLVE_MODE, 0, 'INTERNAL', 1, 'EXTERNAL', 2, 'BOTH') AS RESOLVE_MODE
    , EXPIRED_AMOUNT                 AS EXPIRED_AMOUNT
    , DECODE (EXPIRED_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS EXPIRED_BASE
    , SELECT_CONDITION               AS SELECT_CONDITION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM DEPENDENCY_DEFINITION;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE DEPENDENCY_INSTANCE (
    ID                             bigint NOT NULL
    , DD_ID                          bigint          NOT NULL
    , DEPENDENT_ID                   bigint          NOT NULL
    , DEPENDENT_ID_ORIG              bigint          NOT NULL
    , DEPENDENCY_OPERATION           int8            NOT NULL
    , REQUIRED_ID                    bigint          NOT NULL
    , REQUIRED_SE_ID                 bigint              NULL
    , STATE                          int8            NOT NULL
    , IGNORE                         int8            NOT NULL
    , DI_ID_ORIG                     bigint          NOT NULL
    , SE_VERSION                     bigint          NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_DEPENDENCY_INSTANCE
ON DEPENDENCY_INSTANCE(ID);
CREATE VIEW SCI_DEPENDENCY_INSTANCE (ID,DD_ID,DEPENDENT_ID,DEPENDENT_ID_ORIG,DEPENDENCY_OPERATION,REQUIRED_ID,REQUIRED_SE_ID,STATE,IGNORE,DI_ID_ORIG,SE_VERSION,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , DD_ID                          AS DD_ID
    , DEPENDENT_ID                   AS DEPENDENT_ID
    , DEPENDENT_ID_ORIG              AS DEPENDENT_ID_ORIG
    , DECODE (DEPENDENCY_OPERATION, 1, 'AND', 2, 'OR') AS DEPENDENCY_OPERATION
    , REQUIRED_ID                    AS REQUIRED_ID
    , REQUIRED_SE_ID                 AS REQUIRED_SE_ID
    , DECODE (STATE, 0, 'OPEN', 1, 'FULFILLED', 2, 'FAILED', 3, 'BROKEN', 4, 'DEFERRED', 8, 'CANCELLED') AS STATE
    , DECODE (IGNORE, 0, 'NO', 1, 'YES', 2, 'RECURSIVE') AS IGNORE
    , DI_ID_ORIG                     AS DI_ID_ORIG
    , SE_VERSION                     AS SE_VERSION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM DEPENDENCY_INSTANCE;
CREATE TABLE ARC_DEPENDENCY_INSTANCE (
    ID                             bigint NOT NULL
    , DD_ID                          bigint           NULL
    , DEPENDENT_ID                   bigint           NULL
    , DEPENDENT_ID_ORIG              bigint           NULL
    , DEPENDENCY_OPERATION           int8             NULL
    , REQUIRED_ID                    bigint           NULL
    , REQUIRED_SE_ID                 bigint           NULL
    , STATE                          int8             NULL
    , IGNORE                         int8             NULL
    , DI_ID_ORIG                     bigint           NULL
    , SE_VERSION                     bigint           NULL
    , CREATOR_U_ID                   bigint           NULL
    , CREATE_TS                      bigint           NULL
    , CHANGER_U_ID                   bigint           NULL
    , CHANGE_TS                      bigint           NULL
);
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE DEPENDENCY_STATE (
    ID                             bigint NOT NULL
    , DD_ID                          bigint          NOT NULL
    , ESD_ID                         bigint          NOT NULL
    , CONDITION                      lvarchar(1024)      NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , VALID_FROM                   bigint NOT NULL
    , VALID_TO                     bigint NOT NULL
);
CREATE INDEX PK_DEPENDENCY_STATE
ON DEPENDENCY_STATE(ID);
CREATE VIEW SCI_C_DEPENDENCY_STATE (ID,DD_ID,ESD_ID,CONDITION,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , DD_ID                          AS DD_ID
    , ESD_ID                         AS ESD_ID
    , CONDITION                      AS CONDITION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM DEPENDENCY_STATE
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_DEPENDENCY_STATE (ID,DD_ID,ESD_ID,CONDITION,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , DD_ID                          AS DD_ID
    , ESD_ID                         AS ESD_ID
    , CONDITION                      AS CONDITION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM DEPENDENCY_STATE;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE ENTITY_VARIABLE (
    ID                             bigint NOT NULL
    , SME_ID                         bigint          NOT NULL
    , NAME                           lvarchar(64)    NOT NULL
    , VALUE                          lvarchar(256)       NULL
    , IS_LOCAL                       integer         NOT NULL
    , EV_LINK                        bigint              NULL
    , IS_LONG                        integer         NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_ENTITY_VARIABLE
ON ENTITY_VARIABLE(ID);
CREATE VIEW SCI_ENTITY_VARIABLE (ID,SME_ID,NAME,VALUE,IS_LOCAL,IS_LONG,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , SME_ID                         AS SME_ID
    , NAME                           AS NAME
    , VALUE                          AS VALUE
    , DECODE (IS_LOCAL, 1, 'TRUE', 0, 'FALSE') AS IS_LOCAL
    , DECODE (IS_LONG, 1, 'TRUE', 0, 'FALSE') AS IS_LONG
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM ENTITY_VARIABLE;
CREATE TABLE ARC_ENTITY_VARIABLE (
    ID                             bigint NOT NULL
    , SME_ID                         bigint           NULL
    , NAME                           lvarchar(64)     NULL
    , VALUE                          lvarchar(256)    NULL
    , IS_LOCAL                       integer          NULL
    , EV_LINK                        bigint           NULL
    , IS_LONG                        integer          NULL
    , CREATOR_U_ID                   bigint           NULL
    , CREATE_TS                      bigint           NULL
    , CHANGER_U_ID                   bigint           NULL
    , CHANGE_TS                      bigint           NULL
);
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE ENVIRONMENT (
    ID                             bigint NOT NULL
    , NE_ID                          bigint          NOT NULL
    , NR_ID                          bigint          NOT NULL
    , CONDITION                      lvarchar(1024)      NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , VALID_FROM                   bigint NOT NULL
    , VALID_TO                     bigint NOT NULL
);
CREATE INDEX PK_ENVIRONMENT
ON ENVIRONMENT(ID);
CREATE VIEW SCI_C_ENVIRONMENT (ID,NE_ID,NR_ID,CONDITION,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NE_ID                          AS NE_ID
    , NR_ID                          AS NR_ID
    , CONDITION                      AS CONDITION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM ENVIRONMENT
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_ENVIRONMENT (ID,NE_ID,NR_ID,CONDITION,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , NE_ID                          AS NE_ID
    , NR_ID                          AS NR_ID
    , CONDITION                      AS CONDITION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM ENVIRONMENT;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE EVENT_PARAMETER (
    ID                             bigint NOT NULL
    , KEY                            lvarchar(64)    NOT NULL
    , VALUE                          lvarchar(256)   NOT NULL
    , EVT_ID                         bigint          NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_EVENT_PARAMETER
ON EVENT_PARAMETER(ID);
CREATE VIEW SCI_EVENT_PARAMETER (ID,KEY,VALUE,EVT_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , KEY                            AS KEY
    , VALUE                          AS VALUE
    , EVT_ID                         AS EVT_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM EVENT_PARAMETER;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE EVENT (
    ID                             bigint NOT NULL
    , NAME                           lvarchar(64)    NOT NULL
    , OWNER_ID                       bigint          NOT NULL
    , SE_ID                          bigint              NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_EVENT
ON EVENT(ID);
CREATE VIEW SCI_EVENT (ID,NAME,OWNER_ID,SE_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , OWNER_ID                       AS OWNER_ID
    , SE_ID                          AS SE_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM EVENT;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE EXIT_STATE_DEFINITION (
    ID                             bigint NOT NULL
    , NAME                           lvarchar(64)    NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , VALID_FROM                   bigint NOT NULL
    , VALID_TO                     bigint NOT NULL
);
CREATE INDEX PK_EXIT_STATE_DEFINITION
ON EXIT_STATE_DEFINITION(ID);
CREATE VIEW SCI_C_EXIT_STATE_DEFINITION (ID,NAME,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM EXIT_STATE_DEFINITION
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_EXIT_STATE_DEFINITION (ID,NAME,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM EXIT_STATE_DEFINITION;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE EXIT_STATE_MAPPING_PROFILE (
    ID                             bigint NOT NULL
    , NAME                           lvarchar(64)    NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , VALID_FROM                   bigint NOT NULL
    , VALID_TO                     bigint NOT NULL
);
CREATE INDEX PK_EXIT_STATE_MAPPING_PROFILE
ON EXIT_STATE_MAPPING_PROFILE(ID);
CREATE VIEW SCI_C_EXIT_STATE_MAP_PROFILE (ID,NAME,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM EXIT_STATE_MAPPING_PROFILE
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_EXIT_STATE_MAP_PROFILE (ID,NAME,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM EXIT_STATE_MAPPING_PROFILE;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE EXIT_STATE_MAPPING (
    ID                             bigint NOT NULL
    , ESMP_ID                        bigint          NOT NULL
    , ESD_ID                         bigint          NOT NULL
    , ECR_START                      bigint              NULL
    , ECR_END                        bigint              NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , VALID_FROM                   bigint NOT NULL
    , VALID_TO                     bigint NOT NULL
);
CREATE INDEX PK_EXIT_STATE_MAPPING
ON EXIT_STATE_MAPPING(ID);
CREATE VIEW SCI_C_EXIT_STATE_MAPPING (ID,ESMP_ID,ESD_ID,ECR_START,ECR_END,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , ESMP_ID                        AS ESMP_ID
    , ESD_ID                         AS ESD_ID
    , ECR_START                      AS ECR_START
    , ECR_END                        AS ECR_END
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM EXIT_STATE_MAPPING
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_EXIT_STATE_MAPPING (ID,ESMP_ID,ESD_ID,ECR_START,ECR_END,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , ESMP_ID                        AS ESMP_ID
    , ESD_ID                         AS ESD_ID
    , ECR_START                      AS ECR_START
    , ECR_END                        AS ECR_END
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM EXIT_STATE_MAPPING;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE EXIT_STATE_PROFILE (
    ID                             bigint NOT NULL
    , NAME                           lvarchar(64)    NOT NULL
    , DEFAULT_ESMP_ID                bigint              NULL
    , IS_VALID                       integer         NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , VALID_FROM                   bigint NOT NULL
    , VALID_TO                     bigint NOT NULL
);
CREATE INDEX PK_EXIT_STATE_PROFILE
ON EXIT_STATE_PROFILE(ID);
CREATE VIEW SCI_C_EXIT_STATE_PROFILE (ID,NAME,DEFAULT_ESMP_ID,IS_VALID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , DEFAULT_ESMP_ID                AS DEFAULT_ESMP_ID
    , DECODE (IS_VALID, 1, 'TRUE', 0, 'FALSE') AS IS_VALID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM EXIT_STATE_PROFILE
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_EXIT_STATE_PROFILE (ID,NAME,DEFAULT_ESMP_ID,IS_VALID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , DEFAULT_ESMP_ID                AS DEFAULT_ESMP_ID
    , DECODE (IS_VALID, 1, 'TRUE', 0, 'FALSE') AS IS_VALID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM EXIT_STATE_PROFILE;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE EXIT_STATE (
    ID                             bigint NOT NULL
    , PREFERENCE                     int8            NOT NULL
    , IS_FINAL                       integer         NOT NULL
    , IS_RESTARTABLE                 integer         NOT NULL
    , IS_UNREACHABLE                 integer         NOT NULL
    , IS_DISABLED                    integer         NOT NULL
    , IS_BROKEN                      integer         NOT NULL
    , IS_BATCH_DEFAULT               integer         NOT NULL
    , IS_DEPENDENCY_DEFAULT          integer         NOT NULL
    , ESP_ID                         bigint          NOT NULL
    , ESD_ID                         bigint          NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , VALID_FROM                   bigint NOT NULL
    , VALID_TO                     bigint NOT NULL
);
CREATE INDEX PK_EXIT_STATE
ON EXIT_STATE(ID);
CREATE VIEW SCI_C_EXIT_STATE (ID,PREFERENCE,IS_FINAL,IS_RESTARTABLE,IS_UNREACHABLE,IS_DISABLED,IS_BROKEN,IS_BATCH_DEFAULT,IS_DEPENDENCY_DEFAULT,ESP_ID,ESD_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , PREFERENCE                     AS PREFERENCE
    , DECODE (IS_FINAL, 1, 'TRUE', 0, 'FALSE') AS IS_FINAL
    , DECODE (IS_RESTARTABLE, 1, 'TRUE', 0, 'FALSE') AS IS_RESTARTABLE
    , DECODE (IS_UNREACHABLE, 1, 'TRUE', 0, 'FALSE') AS IS_UNREACHABLE
    , DECODE (IS_DISABLED, 1, 'TRUE', 0, 'FALSE') AS IS_DISABLED
    , DECODE (IS_BROKEN, 1, 'TRUE', 0, 'FALSE') AS IS_BROKEN
    , DECODE (IS_BATCH_DEFAULT, 1, 'TRUE', 0, 'FALSE') AS IS_BATCH_DEFAULT
    , DECODE (IS_DEPENDENCY_DEFAULT, 1, 'TRUE', 0, 'FALSE') AS IS_DEPENDENCY_DEFAULT
    , ESP_ID                         AS ESP_ID
    , ESD_ID                         AS ESD_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM EXIT_STATE
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_EXIT_STATE (ID,PREFERENCE,IS_FINAL,IS_RESTARTABLE,IS_UNREACHABLE,IS_DISABLED,IS_BROKEN,IS_BATCH_DEFAULT,IS_DEPENDENCY_DEFAULT,ESP_ID,ESD_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , PREFERENCE                     AS PREFERENCE
    , DECODE (IS_FINAL, 1, 'TRUE', 0, 'FALSE') AS IS_FINAL
    , DECODE (IS_RESTARTABLE, 1, 'TRUE', 0, 'FALSE') AS IS_RESTARTABLE
    , DECODE (IS_UNREACHABLE, 1, 'TRUE', 0, 'FALSE') AS IS_UNREACHABLE
    , DECODE (IS_DISABLED, 1, 'TRUE', 0, 'FALSE') AS IS_DISABLED
    , DECODE (IS_BROKEN, 1, 'TRUE', 0, 'FALSE') AS IS_BROKEN
    , DECODE (IS_BATCH_DEFAULT, 1, 'TRUE', 0, 'FALSE') AS IS_BATCH_DEFAULT
    , DECODE (IS_DEPENDENCY_DEFAULT, 1, 'TRUE', 0, 'FALSE') AS IS_DEPENDENCY_DEFAULT
    , ESP_ID                         AS ESP_ID
    , ESD_ID                         AS ESD_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM EXIT_STATE;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE EXIT_STATE_TRANSLATION (
    ID                             bigint NOT NULL
    , ESTP_ID                        bigint          NOT NULL
    , FROM_ESD_ID                    bigint          NOT NULL
    , TO_ESD_ID                      bigint          NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , VALID_FROM                   bigint NOT NULL
    , VALID_TO                     bigint NOT NULL
);
CREATE INDEX PK_EXIT_STATE_TRANSLATION
ON EXIT_STATE_TRANSLATION(ID);
CREATE VIEW SCI_C_EXIT_STATE_TRANSLATION (ID,ESTP_ID,FROM_ESD_ID,TO_ESD_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , ESTP_ID                        AS ESTP_ID
    , FROM_ESD_ID                    AS FROM_ESD_ID
    , TO_ESD_ID                      AS TO_ESD_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM EXIT_STATE_TRANSLATION
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_EXIT_STATE_TRANSLATION (ID,ESTP_ID,FROM_ESD_ID,TO_ESD_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , ESTP_ID                        AS ESTP_ID
    , FROM_ESD_ID                    AS FROM_ESD_ID
    , TO_ESD_ID                      AS TO_ESD_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM EXIT_STATE_TRANSLATION;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE EXIT_STATE_TRANS_PROFILE (
    ID                             bigint NOT NULL
    , NAME                           lvarchar(64)    NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , VALID_FROM                   bigint NOT NULL
    , VALID_TO                     bigint NOT NULL
);
CREATE INDEX PK_EXIT_STATE_TRANS_PROFILE
ON EXIT_STATE_TRANS_PROFILE(ID);
CREATE VIEW SCI_C_EXIT_STATE_TRANS_PROFILE (ID,NAME,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM EXIT_STATE_TRANS_PROFILE
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_EXIT_STATE_TRANS_PROFILE (ID,NAME,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM EXIT_STATE_TRANS_PROFILE;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE EXTENTS (
    ID                             bigint NOT NULL
    , O_ID                           bigint          NOT NULL
    , SME_ID                         bigint          NOT NULL
    , SEQUENCE                       int8            NOT NULL
    , EXTENT                         lvarchar(256)   NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_EXTENTS
ON EXTENTS(ID);
CREATE VIEW SCI_EXTENTS (ID,O_ID,SME_ID,SEQUENCE,EXTENT,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , O_ID                           AS O_ID
    , SME_ID                         AS SME_ID
    , SEQUENCE                       AS SEQUENCE
    , EXTENT                         AS EXTENT
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM EXTENTS;
CREATE TABLE ARC_EXTENTS (
    ID                             bigint NOT NULL
    , O_ID                           bigint           NULL
    , SME_ID                         bigint           NULL
    , SEQUENCE                       int8             NULL
    , EXTENT                         lvarchar(256)    NULL
    , CREATOR_U_ID                   bigint           NULL
    , CREATE_TS                      bigint           NULL
    , CHANGER_U_ID                   bigint           NULL
    , CHANGE_TS                      bigint           NULL
);
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE FOLDER (
    ID                             bigint NOT NULL
    , NAME                           lvarchar(64)    NOT NULL
    , OWNER_ID                       bigint          NOT NULL
    , ENV_ID                         bigint              NULL
    , PARENT_ID                      bigint              NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , INHERIT_PRIVS                  bigint          NOT NULL
    , VALID_FROM                   bigint NOT NULL
    , VALID_TO                     bigint NOT NULL
);
CREATE INDEX PK_FOLDER
ON FOLDER(ID);
CREATE VIEW SCI_C_FOLDER (ID,NAME,OWNER_ID,ENV_ID,PARENT_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS,INHERIT_PRIVS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , OWNER_ID                       AS OWNER_ID
    , ENV_ID                         AS ENV_ID
    , PARENT_ID                      AS PARENT_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , INHERIT_PRIVS                  AS INHERIT_PRIVS
  FROM FOLDER
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_FOLDER (ID,NAME,OWNER_ID,ENV_ID,PARENT_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS,INHERIT_PRIVS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , OWNER_ID                       AS OWNER_ID
    , ENV_ID                         AS ENV_ID
    , PARENT_ID                      AS PARENT_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , INHERIT_PRIVS                  AS INHERIT_PRIVS
    , VALID_FROM
    , VALID_TO
  FROM FOLDER;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE FOOTPRINT (
    ID                             bigint NOT NULL
    , NAME                           lvarchar(64)    NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_FOOTPRINT
ON FOOTPRINT(ID);
CREATE VIEW SCI_FOOTPRINT (ID,NAME,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM FOOTPRINT;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE GRANTS (
    ID                             bigint NOT NULL
    , OBJECT_ID                      bigint          NOT NULL
    , G_ID                           bigint          NOT NULL
    , OBJECT_TYPE                    int8            NOT NULL
    , PRIVS                          bigint          NOT NULL
    , DELETE_VERSION                 bigint              NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_GRANTS
ON GRANTS(ID);
CREATE VIEW SCI_GRANTS (ID,OBJECT_ID,G_ID,OBJECT_TYPE,PRIVS,DELETE_VERSION,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , OBJECT_ID                      AS OBJECT_ID
    , G_ID                           AS G_ID
    , DECODE (OBJECT_TYPE, 1, 'ENVIRONMENT', 18, 'EVENT', 6, 'FOLDER', 19, 'INTERVAL', 17, 'JOB', 9, 'JOB_DEFINITION', 10, 'NAMED_RESOURCE', 20, 'SCHEDULE', 22, 'SCHEDULED_EVENT', 15, 'SCOPE', 21, 'GROUP', 11, 'RESOURCE', 2, 'EXIT_STATE_DEFINITION', 31, 'NICE_PROFILE', 3, 'EXIT_STATE_PROFILE', 4, 'EXIT_STATE_MAPPING', 5, 'EXIT_STATE_TRANSLATION', 13, 'RESOURCE_STATE_DEFINITION', 14, 'RESOURCE_STATE_PROFILE', 29, 'WATCH_TYPE', 12, 'RESOURCE_STATE_MAPPING', 7, 'FOOTPRINT', 8, 'USER', 30, 'OBJECT_MONITOR', 0, 'SYSTEM') AS OBJECT_TYPE
    , PRIVS                          AS PRIVS
    , DELETE_VERSION                 AS DELETE_VERSION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM GRANTS;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE GROUPS (
    ID                             bigint NOT NULL
    , NAME                           lvarchar(64)    NOT NULL
    , DELETE_VERSION                 bigint          NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_GROUPS
ON GROUPS(ID);
CREATE VIEW SCI_GROUPS (ID,NAME,DELETE_VERSION,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , DELETE_VERSION                 AS DELETE_VERSION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM GROUPS;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE HIERARCHY_INSTANCE (
    ID                             bigint NOT NULL
    , PARENT_ID                      bigint          NOT NULL
    , CHILD_ID                       bigint          NOT NULL
    , SH_ID                          bigint          NOT NULL
    , NICE                           int8            NOT NULL
    , CHILD_ESD_ID                   bigint              NULL
    , CHILD_ES_PREFERENCE            int8                NULL
    , SE_VERSION                     bigint          NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_HIERARCHY_INSTANCE
ON HIERARCHY_INSTANCE(ID);
CREATE VIEW SCI_HIERARCHY_INSTANCE (ID,PARENT_ID,CHILD_ID,SH_ID,NICE,CHILD_ESD_ID,CHILD_ES_PREFERENCE,SE_VERSION,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , PARENT_ID                      AS PARENT_ID
    , CHILD_ID                       AS CHILD_ID
    , SH_ID                          AS SH_ID
    , NICE                           AS NICE
    , CHILD_ESD_ID                   AS CHILD_ESD_ID
    , CHILD_ES_PREFERENCE            AS CHILD_ES_PREFERENCE
    , SE_VERSION                     AS SE_VERSION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM HIERARCHY_INSTANCE;
CREATE TABLE ARC_HIERARCHY_INSTANCE (
    ID                             bigint NOT NULL
    , PARENT_ID                      bigint           NULL
    , CHILD_ID                       bigint           NULL
    , SH_ID                          bigint           NULL
    , NICE                           int8             NULL
    , CHILD_ESD_ID                   bigint           NULL
    , CHILD_ES_PREFERENCE            int8             NULL
    , SE_VERSION                     bigint           NULL
    , CREATOR_U_ID                   bigint           NULL
    , CREATE_TS                      bigint           NULL
    , CHANGER_U_ID                   bigint           NULL
    , CHANGE_TS                      bigint           NULL
);
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE IGNORED_DEPENDENCY (
    ID                             bigint NOT NULL
    , SH_ID                          bigint          NOT NULL
    , DD_NAME                        lvarchar(64)    NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , VALID_FROM                   bigint NOT NULL
    , VALID_TO                     bigint NOT NULL
);
CREATE INDEX PK_IGNORED_DEPENDENCY
ON IGNORED_DEPENDENCY(ID);
CREATE VIEW SCI_C_IGNORED_DEPENDENCY (ID,SH_ID,DD_NAME,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , SH_ID                          AS SH_ID
    , DD_NAME                        AS DD_NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM IGNORED_DEPENDENCY
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_IGNORED_DEPENDENCY (ID,SH_ID,DD_NAME,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , SH_ID                          AS SH_ID
    , DD_NAME                        AS DD_NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM IGNORED_DEPENDENCY;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE INSTANCE_VALUE (
    ID                             bigint NOT NULL
    , VALUE                          lvarchar(256)       NULL
    , OI_ID                          bigint          NOT NULL
    , WTP_ID                         bigint          NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_INSTANCE_VALUE
ON INSTANCE_VALUE(ID);
CREATE VIEW SCI_INSTANCE_VALUE (ID,VALUE,OI_ID,WTP_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , VALUE                          AS VALUE
    , OI_ID                          AS OI_ID
    , WTP_ID                         AS WTP_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM INSTANCE_VALUE;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE INTERVAL_DISPATCHER (
    ID                             bigint NOT NULL
    , INT_ID                         bigint          NOT NULL
    , SEQ_NO                         int8            NOT NULL
    , NAME                           lvarchar(64)    NOT NULL
    , SELECT_INT_ID                  bigint              NULL
    , FILTER_INT_ID                  bigint              NULL
    , IS_ENABLED                     integer         NOT NULL
    , IS_ACTIVE                      integer         NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_INTERVAL_DISPATCHER
ON INTERVAL_DISPATCHER(ID);
CREATE VIEW SCI_INTERVAL_DISPATCHER (ID,INT_ID,SEQ_NO,NAME,SELECT_INT_ID,FILTER_INT_ID,IS_ENABLED,IS_ACTIVE,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , INT_ID                         AS INT_ID
    , SEQ_NO                         AS SEQ_NO
    , NAME                           AS NAME
    , SELECT_INT_ID                  AS SELECT_INT_ID
    , FILTER_INT_ID                  AS FILTER_INT_ID
    , DECODE (IS_ENABLED, 1, 'TRUE', 0, 'FALSE') AS IS_ENABLED
    , DECODE (IS_ACTIVE, 1, 'TRUE', 0, 'FALSE') AS IS_ACTIVE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM INTERVAL_DISPATCHER;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE INTERVAL_HIERARCHY (
    ID                             bigint NOT NULL
    , CHILD_ID                       bigint          NOT NULL
    , PARENT_ID                      bigint          NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_INTERVAL_HIERARCHY
ON INTERVAL_HIERARCHY(ID);
CREATE VIEW SCI_INTERVAL_HIERARCHY (ID,CHILD_ID,PARENT_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , CHILD_ID                       AS CHILD_ID
    , PARENT_ID                      AS PARENT_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM INTERVAL_HIERARCHY;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE INTERVALL (
    ID                             bigint NOT NULL
    , NAME                           lvarchar(64)    NOT NULL
    , OWNER_ID                       bigint          NOT NULL
    , START_TIME                     bigint              NULL
    , END_TIME                       bigint              NULL
    , DELAY                          bigint              NULL
    , BASE_INTERVAL                  int8                NULL
    , BASE_INTERVAL_MULTIPLIER       int8                NULL
    , DURATION                       int8                NULL
    , DURATION_MULTIPLIER            int8                NULL
    , SYNC_TIME                      bigint          NOT NULL
    , IS_INVERSE                     integer         NOT NULL
    , IS_MERGE                       integer         NOT NULL
    , EMBEDDED_INT_ID                bigint              NULL
    , SE_ID                          bigint              NULL
    , OBJ_ID                         bigint              NULL
    , OBJ_TYPE                       int8                NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_INTERVALL
ON INTERVALL(ID);
CREATE VIEW SCI_INTERVALL (ID,NAME,OWNER_ID,START_TIME,END_TIME,DELAY,BASE_INTERVAL,BASE_INTERVAL_MULTIPLIER,DURATION,DURATION_MULTIPLIER,SYNC_TIME,IS_INVERSE,IS_MERGE,EMBEDDED_INT_ID,SE_ID,OBJ_ID,OBJ_TYPE,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , OWNER_ID                       AS OWNER_ID
    , dbinfo ('utc_to_datetime', round(mod(START_TIME, 1125899906842624)/1000)) AS START_TIME
    , dbinfo ('utc_to_datetime', round(mod(END_TIME, 1125899906842624)/1000)) AS END_TIME
    , DELAY                          AS DELAY
    , DECODE (BASE_INTERVAL, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS BASE_INTERVAL
    , BASE_INTERVAL_MULTIPLIER       AS BASE_INTERVAL_MULTIPLIER
    , DECODE (DURATION, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS DURATION
    , DURATION_MULTIPLIER            AS DURATION_MULTIPLIER
    , dbinfo ('utc_to_datetime', round(mod(SYNC_TIME, 1125899906842624)/1000)) AS SYNC_TIME
    , DECODE (IS_INVERSE, 1, 'TRUE', 0, 'FALSE') AS IS_INVERSE
    , DECODE (IS_MERGE, 1, 'TRUE', 0, 'FALSE') AS IS_MERGE
    , EMBEDDED_INT_ID                AS EMBEDDED_INT_ID
    , SE_ID                          AS SE_ID
    , OBJ_ID                         AS OBJ_ID
    , DECODE (OBJ_TYPE, 25, 'DISTRIBUTION', 8, 'USER', 9, 'JOB_DEFINITION', 11, 'RESOURCE', 15, 'SCOPE', 16, 'TRIGGER', 18, 'EVENT', 19, 'INTERVAL', 20, 'SCHEDULE', 22, 'SCHEDULED_EVENT', 28, 'RESOURCE_TEMPLATE', 88, 'INTERVAL_DISPATCHER') AS OBJ_TYPE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM INTERVALL;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE INTERVAL_SELECTION (
    ID                             bigint NOT NULL
    , INT_ID                         bigint          NOT NULL
    , VALUE                          int8                NULL
    , PERIOD_FROM                    bigint              NULL
    , PERIOD_TO                      bigint              NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_INTERVAL_SELECTION
ON INTERVAL_SELECTION(ID);
CREATE VIEW SCI_INTERVAL_SELECTION (ID,INT_ID,VALUE,PERIOD_FROM,PERIOD_TO,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , INT_ID                         AS INT_ID
    , VALUE                          AS VALUE
    , PERIOD_FROM                    AS PERIOD_FROM
    , PERIOD_TO                      AS PERIOD_TO
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM INTERVAL_SELECTION;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE KILL_JOB (
    ID                             bigint NOT NULL
    , SE_ID                          bigint          NOT NULL
    , SE_VERSION                     bigint          NOT NULL
    , SME_ID                         bigint          NOT NULL
    , SCOPE_ID                       bigint          NOT NULL
    , STATE                          int8            NOT NULL
    , EXIT_CODE                      int8                NULL
    , COMMANDLINE                    lvarchar(512)       NULL
    , LOGFILE                        lvarchar(512)       NULL
    , ERRLOGFILE                     lvarchar(512)       NULL
    , PID                            lvarchar(32)        NULL
    , EXTPID                         lvarchar(32)        NULL
    , ERROR_MSG                      lvarchar(256)       NULL
    , RUNNABLE_TS                    bigint              NULL
    , START_TS                       bigint              NULL
    , FINSH_TS                       bigint              NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_KILL_JOB
ON KILL_JOB(ID);
CREATE VIEW SCI_KILL_JOB (ID,SE_ID,SE_VERSION,SME_ID,SCOPE_ID,STATE,EXIT_CODE,COMMANDLINE,LOGFILE,ERRLOGFILE,PID,EXTPID,ERROR_MSG,RUNNABLE_TS,START_TS,FINSH_TS,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , SE_ID                          AS SE_ID
    , SE_VERSION                     AS SE_VERSION
    , SME_ID                         AS SME_ID
    , SCOPE_ID                       AS SCOPE_ID
    , DECODE (STATE, 4, 'RUNNABLE', 5, 'STARTING', 6, 'STARTED', 7, 'RUNNING', 11, 'FINISHED', 13, 'BROKEN_ACTIVE', 14, 'BROKEN_FINISHED', 15, 'ERROR') AS STATE
    , EXIT_CODE                      AS EXIT_CODE
    , COMMANDLINE                    AS COMMANDLINE
    , LOGFILE                        AS LOGFILE
    , ERRLOGFILE                     AS ERRLOGFILE
    , PID                            AS PID
    , EXTPID                         AS EXTPID
    , ERROR_MSG                      AS ERROR_MSG
    , dbinfo ('utc_to_datetime', round(mod(RUNNABLE_TS, 1125899906842624)/1000)) AS RUNNABLE_TS
    , dbinfo ('utc_to_datetime', round(mod(START_TS, 1125899906842624)/1000)) AS START_TS
    , dbinfo ('utc_to_datetime', round(mod(FINSH_TS, 1125899906842624)/1000)) AS FINSH_TS
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM KILL_JOB;
CREATE TABLE ARC_KILL_JOB (
    ID                             bigint NOT NULL
    , SE_ID                          bigint           NULL
    , SE_VERSION                     bigint           NULL
    , SME_ID                         bigint           NULL
    , SCOPE_ID                       bigint           NULL
    , STATE                          int8             NULL
    , EXIT_CODE                      int8             NULL
    , COMMANDLINE                    lvarchar(512)    NULL
    , LOGFILE                        lvarchar(512)    NULL
    , ERRLOGFILE                     lvarchar(512)    NULL
    , PID                            lvarchar(32)     NULL
    , EXTPID                         lvarchar(32)     NULL
    , ERROR_MSG                      lvarchar(256)    NULL
    , RUNNABLE_TS                    bigint           NULL
    , START_TS                       bigint           NULL
    , FINSH_TS                       bigint           NULL
    , CREATOR_U_ID                   bigint           NULL
    , CREATE_TS                      bigint           NULL
    , CHANGER_U_ID                   bigint           NULL
    , CHANGE_TS                      bigint           NULL
);
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE MEMBER (
    ID                             bigint NOT NULL
    , G_ID                           bigint          NOT NULL
    , U_ID                           bigint          NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_MEMBER
ON MEMBER(ID);
CREATE VIEW SCI_MEMBER (ID,G_ID,U_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , G_ID                           AS G_ID
    , U_ID                           AS U_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM MEMBER;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE NAMED_ENVIRONMENT (
    ID                             bigint NOT NULL
    , NAME                           lvarchar(64)    NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , VALID_FROM                   bigint NOT NULL
    , VALID_TO                     bigint NOT NULL
);
CREATE INDEX PK_NAMED_ENVIRONMENT
ON NAMED_ENVIRONMENT(ID);
CREATE VIEW SCI_C_NAMED_ENVIRONMENT (ID,NAME,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM NAMED_ENVIRONMENT
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_NAMED_ENVIRONMENT (ID,NAME,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM NAMED_ENVIRONMENT;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE NAMED_RESOURCE (
    ID                             bigint NOT NULL
    , NAME                           lvarchar(64)    NOT NULL
    , OWNER_ID                       bigint          NOT NULL
    , PARENT_ID                      bigint              NULL
    , USAGE                          int8            NOT NULL
    , RSP_ID                         bigint              NULL
    , FACTOR                         float               NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , INHERIT_PRIVS                  bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_NAMED_RESOURCE
ON NAMED_RESOURCE(ID);
CREATE VIEW SCI_NAMED_RESOURCE (ID,NAME,OWNER_ID,PARENT_ID,USAGE,RSP_ID,FACTOR,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS,INHERIT_PRIVS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , OWNER_ID                       AS OWNER_ID
    , PARENT_ID                      AS PARENT_ID
    , DECODE (USAGE, 1, 'STATIC', 2, 'SYSTEM', 4, 'SYNCHRONIZING', 8, 'CATEGORY', 3, 'POOL') AS USAGE
    , RSP_ID                         AS RSP_ID
    , FACTOR                         AS FACTOR
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , INHERIT_PRIVS                  AS INHERIT_PRIVS
  FROM NAMED_RESOURCE;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE NICE_PROFILE_ENTRY (
    ID                             bigint NOT NULL
    , NP_ID                          bigint          NOT NULL
    , PREFERENCE                     int8            NOT NULL
    , FOLDER_ID                      bigint              NULL
    , IS_SUSPENDED                   int8            NOT NULL
    , RENICE                         int8            NOT NULL
    , IS_ACTIVE                      integer         NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_NICE_PROFILE_ENTRY
ON NICE_PROFILE_ENTRY(ID);
CREATE VIEW SCI_NICE_PROFILE_ENTRY (ID,NP_ID,PREFERENCE,FOLDER_ID,IS_SUSPENDED,RENICE,IS_ACTIVE,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NP_ID                          AS NP_ID
    , PREFERENCE                     AS PREFERENCE
    , FOLDER_ID                      AS FOLDER_ID
    , DECODE (IS_SUSPENDED, 0, 'NOSUSPEND', 1, 'SUSPEND', 2, 'ADMINSUSPEND') AS IS_SUSPENDED
    , RENICE                         AS RENICE
    , DECODE (IS_ACTIVE, 1, 'TRUE', 0, 'FALSE') AS IS_ACTIVE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM NICE_PROFILE_ENTRY;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE NICE_PROFILE (
    ID                             bigint NOT NULL
    , NAME                           lvarchar(64)    NOT NULL
    , IS_ACTIVE                      integer         NOT NULL
    , ACTIVE_TS                      bigint              NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_NICE_PROFILE
ON NICE_PROFILE(ID);
CREATE VIEW SCI_NICE_PROFILE (ID,NAME,IS_ACTIVE,ACTIVE_TS,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , DECODE (IS_ACTIVE, 1, 'TRUE', 0, 'FALSE') AS IS_ACTIVE
    , ACTIVE_TS                      AS ACTIVE_TS
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM NICE_PROFILE;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE OBJECT_COMMENT (
    ID                             bigint NOT NULL
    , OBJECT_ID                      bigint          NOT NULL
    , OBJECT_TYPE                    int8            NOT NULL
    , INFO_TYPE                      int8            NOT NULL
    , SEQUENCE_NUMBER                int8            NOT NULL
    , TAG                            lvarchar(64)        NULL
    , DESCRIPTION                    lvarchar(1900)  NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , VALID_FROM                   bigint NOT NULL
    , VALID_TO                     bigint NOT NULL
);
CREATE INDEX PK_OBJECT_COMMENT
ON OBJECT_COMMENT(ID);
CREATE VIEW SCI_C_OBJECT_COMMENT (ID,OBJECT_ID,OBJECT_TYPE,INFO_TYPE,SEQUENCE_NUMBER,TAG,DESCRIPTION,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , OBJECT_ID                      AS OBJECT_ID
    , DECODE (OBJECT_TYPE, 9, 'JOB_DEFINITION', 2, 'EXIT_STATE_DEFINITION', 3, 'EXIT_STATE_PROFILE', 4, 'EXIT_STATE_MAPPING', 5, 'EXIT_STATE_TRANSLATION', 6, 'FOLDER', 15, 'SCOPE', 10, 'NAMED_RESOURCE', 31, 'NICE_PROFILE', 11, 'RESOURCE', 1, 'ENVIRONMENT', 7, 'FOOTPRINT', 13, 'RESOURCE_STATE_DEFINITION', 14, 'RESOURCE_STATE_PROFILE', 12, 'RESOURCE_STATE_MAPPING', 8, 'USER', 16, 'TRIGGER', 17, 'JOB', 18, 'EVENT', 19, 'INTERVAL', 20, 'SCHEDULE', 22, 'SCHEDULED_EVENT', 21, 'GROUP', 23, 'PARAMETER', 24, 'POOL', 25, 'DISTRIBUTION', 29, 'WATCH_TYPE', 30, 'OBJECT_MONITOR') AS OBJECT_TYPE
    , DECODE (INFO_TYPE, 0, 'TEXT', 1, 'URL') AS INFO_TYPE
    , SEQUENCE_NUMBER                AS SEQUENCE_NUMBER
    , TAG                            AS TAG
    , DESCRIPTION                    AS DESCRIPTION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM OBJECT_COMMENT
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_OBJECT_COMMENT (ID,OBJECT_ID,OBJECT_TYPE,INFO_TYPE,SEQUENCE_NUMBER,TAG,DESCRIPTION,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , OBJECT_ID                      AS OBJECT_ID
    , DECODE (OBJECT_TYPE, 9, 'JOB_DEFINITION', 2, 'EXIT_STATE_DEFINITION', 3, 'EXIT_STATE_PROFILE', 4, 'EXIT_STATE_MAPPING', 5, 'EXIT_STATE_TRANSLATION', 6, 'FOLDER', 15, 'SCOPE', 10, 'NAMED_RESOURCE', 31, 'NICE_PROFILE', 11, 'RESOURCE', 1, 'ENVIRONMENT', 7, 'FOOTPRINT', 13, 'RESOURCE_STATE_DEFINITION', 14, 'RESOURCE_STATE_PROFILE', 12, 'RESOURCE_STATE_MAPPING', 8, 'USER', 16, 'TRIGGER', 17, 'JOB', 18, 'EVENT', 19, 'INTERVAL', 20, 'SCHEDULE', 22, 'SCHEDULED_EVENT', 21, 'GROUP', 23, 'PARAMETER', 24, 'POOL', 25, 'DISTRIBUTION', 29, 'WATCH_TYPE', 30, 'OBJECT_MONITOR') AS OBJECT_TYPE
    , DECODE (INFO_TYPE, 0, 'TEXT', 1, 'URL') AS INFO_TYPE
    , SEQUENCE_NUMBER                AS SEQUENCE_NUMBER
    , TAG                            AS TAG
    , DESCRIPTION                    AS DESCRIPTION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM OBJECT_COMMENT;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE OBJECT_EVENT (
    ID                             bigint NOT NULL
    , TR_ID                          bigint              NULL
    , OI_ID                          bigint          NOT NULL
    , EVENT_TYPE                     int8            NOT NULL
    , SME_ID                         bigint          NOT NULL
    , SE_ID                          bigint          NOT NULL
    , SUBMIT_TS                      bigint              NULL
    , FINAL_TS                       bigint              NULL
    , FINAL_ESD_ID                   bigint              NULL
    , MAIN_SME_ID                    bigint              NULL
    , MAIN_SE_ID                     bigint              NULL
    , MAIN_FINAL_TS                  bigint              NULL
    , MAIN_FINAL_ESD_ID              bigint              NULL
    , SE_VERSION                     bigint          NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_OBJECT_EVENT
ON OBJECT_EVENT(ID);
CREATE VIEW SCI_OBJECT_EVENT (ID,TR_ID,OI_ID,EVENT_TYPE,SME_ID,SE_ID,SUBMIT_TS,FINAL_TS,FINAL_ESD_ID,MAIN_SME_ID,MAIN_SE_ID,MAIN_FINAL_TS,MAIN_FINAL_ESD_ID,SE_VERSION,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , TR_ID                          AS TR_ID
    , OI_ID                          AS OI_ID
    , DECODE (EVENT_TYPE, 1, 'CREATE', 2, 'CHANGE', 3, 'DELETE') AS EVENT_TYPE
    , SME_ID                         AS SME_ID
    , SE_ID                          AS SE_ID
    , dbinfo ('utc_to_datetime', round(mod(SUBMIT_TS, 1125899906842624)/1000)) AS SUBMIT_TS
    , dbinfo ('utc_to_datetime', round(mod(FINAL_TS, 1125899906842624)/1000)) AS FINAL_TS
    , FINAL_ESD_ID                   AS FINAL_ESD_ID
    , MAIN_SME_ID                    AS MAIN_SME_ID
    , MAIN_SE_ID                     AS MAIN_SE_ID
    , dbinfo ('utc_to_datetime', round(mod(MAIN_FINAL_TS, 1125899906842624)/1000)) AS MAIN_FINAL_TS
    , MAIN_FINAL_ESD_ID              AS MAIN_FINAL_ESD_ID
    , SE_VERSION                     AS SE_VERSION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM OBJECT_EVENT;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE OBJECT_INSTANCE (
    ID                             bigint NOT NULL
    , UNIQUE_NAME                    lvarchar(256)   NOT NULL
    , OM_ID                          bigint          NOT NULL
    , MODIFY_TS                      bigint              NULL
    , REMOVE_TS                      bigint              NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_OBJECT_INSTANCE
ON OBJECT_INSTANCE(ID);
CREATE VIEW SCI_OBJECT_INSTANCE (ID,UNIQUE_NAME,OM_ID,MODIFY_TS,REMOVE_TS,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , UNIQUE_NAME                    AS UNIQUE_NAME
    , OM_ID                          AS OM_ID
    , dbinfo ('utc_to_datetime', round(mod(MODIFY_TS, 1125899906842624)/1000)) AS MODIFY_TS
    , dbinfo ('utc_to_datetime', round(mod(REMOVE_TS, 1125899906842624)/1000)) AS REMOVE_TS
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM OBJECT_INSTANCE;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE OBJECT_MONITOR_PARAMETER (
    ID                             bigint NOT NULL
    , VALUE                          lvarchar(256)       NULL
    , OM_ID                          bigint          NOT NULL
    , WTP_ID                         bigint          NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_OBJECT_MONITOR_PARAMETER
ON OBJECT_MONITOR_PARAMETER(ID);
CREATE VIEW SCI_OBJECT_MONITOR_PARAMETER (ID,VALUE,OM_ID,WTP_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , VALUE                          AS VALUE
    , OM_ID                          AS OM_ID
    , WTP_ID                         AS WTP_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM OBJECT_MONITOR_PARAMETER;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE OBJECT_MONITOR (
    ID                             bigint NOT NULL
    , NAME                           lvarchar(64)    NOT NULL
    , OWNER_ID                       bigint          NOT NULL
    , WT_ID                          bigint          NOT NULL
    , RECREATE_HANDLING              int8            NOT NULL
    , WATCH_SE_ID                    bigint              NULL
    , DELETE_AMOUNT                  int8                NULL
    , DELETE_BASE                    int8                NULL
    , EVENT_DELETE_AMOUNT            int8                NULL
    , EVENT_DELETE_BASE              int8                NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_OBJECT_MONITOR
ON OBJECT_MONITOR(ID);
CREATE VIEW SCI_OBJECT_MONITOR (ID,NAME,OWNER_ID,WT_ID,RECREATE_HANDLING,WATCH_SE_ID,DELETE_AMOUNT,DELETE_BASE,EVENT_DELETE_AMOUNT,EVENT_DELETE_BASE,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , OWNER_ID                       AS OWNER_ID
    , WT_ID                          AS WT_ID
    , DECODE (RECREATE_HANDLING, 0, 'NONE', 1, 'CREATE', 2, 'CHANGE') AS RECREATE_HANDLING
    , WATCH_SE_ID                    AS WATCH_SE_ID
    , DELETE_AMOUNT                  AS DELETE_AMOUNT
    , DECODE (DELETE_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS DELETE_BASE
    , EVENT_DELETE_AMOUNT            AS EVENT_DELETE_AMOUNT
    , DECODE (EVENT_DELETE_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS EVENT_DELETE_BASE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM OBJECT_MONITOR;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE PARAMETER_DEFINITION (
    ID                             bigint NOT NULL
    , SE_ID                          bigint          NOT NULL
    , NAME                           lvarchar(64)    NOT NULL
    , TYPE                           int8            NOT NULL
    , AGG_FUNCTION                   int8            NOT NULL
    , DEFAULTVALUE                   lvarchar(256)       NULL
    , IS_LOCAL                       integer         NOT NULL
    , LINK_PD_ID                     bigint              NULL
    , EXPORT_NAME                    lvarchar(64)        NULL
    , IS_LONG                        integer         NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , VALID_FROM                   bigint NOT NULL
    , VALID_TO                     bigint NOT NULL
);
CREATE INDEX PK_PARAMETER_DEFINITION
ON PARAMETER_DEFINITION(ID);
CREATE VIEW SCI_C_PARAMETER_DEFINITION (ID,SE_ID,NAME,TYPE,AGG_FUNCTION,DEFAULTVALUE,IS_LOCAL,LINK_PD_ID,EXPORT_NAME,IS_LONG,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , SE_ID                          AS SE_ID
    , NAME                           AS NAME
    , DECODE (TYPE, 10, 'REFERENCE', 20, 'CHILDREFERENCE', 30, 'CONSTANT', 40, 'RESULT', 50, 'PARAMETER', 60, 'EXPRESSION', 70, 'IMPORT', 71, 'IMPORT_UNRESOLVED', 80, 'DYNAMIC', 81, 'DYNAMICVALUE', 90, 'LOCAL_CONSTANT', 91, 'RESOURCEREFERENCE') AS TYPE
    , DECODE (AGG_FUNCTION, 0, 'NONE', 61, 'AVG', 62, 'COUNT', 63, 'MIN', 64, 'MAX', 65, 'SUM') AS AGG_FUNCTION
    , DEFAULTVALUE                   AS DEFAULTVALUE
    , DECODE (IS_LOCAL, 1, 'TRUE', 0, 'FALSE') AS IS_LOCAL
    , LINK_PD_ID                     AS LINK_PD_ID
    , EXPORT_NAME                    AS EXPORT_NAME
    , DECODE (IS_LONG, 1, 'TRUE', 0, 'FALSE') AS IS_LONG
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM PARAMETER_DEFINITION
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_PARAMETER_DEFINITION (ID,SE_ID,NAME,TYPE,AGG_FUNCTION,DEFAULTVALUE,IS_LOCAL,LINK_PD_ID,EXPORT_NAME,IS_LONG,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , SE_ID                          AS SE_ID
    , NAME                           AS NAME
    , DECODE (TYPE, 10, 'REFERENCE', 20, 'CHILDREFERENCE', 30, 'CONSTANT', 40, 'RESULT', 50, 'PARAMETER', 60, 'EXPRESSION', 70, 'IMPORT', 71, 'IMPORT_UNRESOLVED', 80, 'DYNAMIC', 81, 'DYNAMICVALUE', 90, 'LOCAL_CONSTANT', 91, 'RESOURCEREFERENCE') AS TYPE
    , DECODE (AGG_FUNCTION, 0, 'NONE', 61, 'AVG', 62, 'COUNT', 63, 'MIN', 64, 'MAX', 65, 'SUM') AS AGG_FUNCTION
    , DEFAULTVALUE                   AS DEFAULTVALUE
    , DECODE (IS_LOCAL, 1, 'TRUE', 0, 'FALSE') AS IS_LOCAL
    , LINK_PD_ID                     AS LINK_PD_ID
    , EXPORT_NAME                    AS EXPORT_NAME
    , DECODE (IS_LONG, 1, 'TRUE', 0, 'FALSE') AS IS_LONG
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM PARAMETER_DEFINITION;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE PERSISTENT_VALUE (
    ID                             bigint NOT NULL
    , NAME                           lvarchar(64)    NOT NULL
    , INT_VALUE                      int8                NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_PERSISTENT_VALUE
ON PERSISTENT_VALUE(ID);
CREATE VIEW SCI_PERSISTENT_VALUE (ID,NAME,INT_VALUE,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , INT_VALUE                      AS INT_VALUE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM PERSISTENT_VALUE;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE POOL_DIST_CONFIG (
    ID                             bigint NOT NULL
    , PLD_ID                         bigint          NOT NULL
    , PR_ID                          bigint          NOT NULL
    , IS_MANAGED                     integer             NULL
    , NOM_PCT                        int8                NULL
    , FREE_PCT                       int8                NULL
    , MIN_PCT                        int8                NULL
    , MAX_PCT                        int8                NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_POOL_DIST_CONFIG
ON POOL_DIST_CONFIG(ID);
CREATE VIEW SCI_POOL_DIST_CONFIG (ID,PLD_ID,PR_ID,IS_MANAGED,NOM_PCT,FREE_PCT,MIN_PCT,MAX_PCT,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , PLD_ID                         AS PLD_ID
    , PR_ID                          AS PR_ID
    , DECODE (IS_MANAGED, 1, 'TRUE', 0, 'FALSE') AS IS_MANAGED
    , NOM_PCT                        AS NOM_PCT
    , FREE_PCT                       AS FREE_PCT
    , MIN_PCT                        AS MIN_PCT
    , MAX_PCT                        AS MAX_PCT
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM POOL_DIST_CONFIG;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE POOL_DISTRIBUTION (
    ID                             bigint NOT NULL
    , NAME                           lvarchar(64)    NOT NULL
    , P_ID                           bigint          NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_POOL_DISTRIBUTION
ON POOL_DISTRIBUTION(ID);
CREATE VIEW SCI_POOL_DISTRIBUTION (ID,NAME,P_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , P_ID                           AS P_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM POOL_DISTRIBUTION;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE POOLED_RESOURCE (
    ID                             bigint NOT NULL
    , P_ID                           bigint          NOT NULL
    , R_ID                           bigint          NOT NULL
    , IS_POOL                        integer         NOT NULL
    , IS_MANAGED                     integer         NOT NULL
    , NOM_PCT                        int8            NOT NULL
    , FREE_PCT                       int8            NOT NULL
    , MIN_PCT                        int8            NOT NULL
    , MAX_PCT                        int8            NOT NULL
    , ACT_IS_MANAGED                 integer         NOT NULL
    , ACT_NOM_PCT                    int8            NOT NULL
    , ACT_FREE_PCT                   int8            NOT NULL
    , ACT_MIN_PCT                    int8            NOT NULL
    , ACT_MAX_PCT                    int8            NOT NULL
    , TARGET_AMOUNT                  int8            NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_POOLED_RESOURCE
ON POOLED_RESOURCE(ID);
CREATE VIEW SCI_POOLED_RESOURCE (ID,P_ID,R_ID,IS_POOL,IS_MANAGED,NOM_PCT,FREE_PCT,MIN_PCT,MAX_PCT,ACT_IS_MANAGED,ACT_NOM_PCT,ACT_FREE_PCT,ACT_MIN_PCT,ACT_MAX_PCT,TARGET_AMOUNT,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , P_ID                           AS P_ID
    , R_ID                           AS R_ID
    , DECODE (IS_POOL, 1, 'TRUE', 0, 'FALSE') AS IS_POOL
    , DECODE (IS_MANAGED, 1, 'TRUE', 0, 'FALSE') AS IS_MANAGED
    , NOM_PCT                        AS NOM_PCT
    , FREE_PCT                       AS FREE_PCT
    , MIN_PCT                        AS MIN_PCT
    , MAX_PCT                        AS MAX_PCT
    , DECODE (ACT_IS_MANAGED, 1, 'TRUE', 0, 'FALSE') AS ACT_IS_MANAGED
    , ACT_NOM_PCT                    AS ACT_NOM_PCT
    , ACT_FREE_PCT                   AS ACT_FREE_PCT
    , ACT_MIN_PCT                    AS ACT_MIN_PCT
    , ACT_MAX_PCT                    AS ACT_MAX_PCT
    , TARGET_AMOUNT                  AS TARGET_AMOUNT
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM POOLED_RESOURCE;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE POOL (
    ID                             bigint NOT NULL
    , NR_ID                          bigint          NOT NULL
    , SCOPE_ID                       bigint          NOT NULL
    , OWNER_ID                       bigint          NOT NULL
    , MANAGER_ID                     bigint              NULL
    , DIST_ID                        bigint              NULL
    , DEFINED_AMOUNT                 int8            NOT NULL
    , AMOUNT                         int8            NOT NULL
    , FREE_AMOUNT                    int8            NOT NULL
    , CHILD_ALLOCATED                int8            NOT NULL
    , EVALUATION_CYCLE               int8                NULL
    , NEXT_EVALUATION_TIME           bigint          NOT NULL
    , TAG                            lvarchar(64)        NULL
    , TRACE_INTERVAL                 int8                NULL
    , TRACE_BASE                     int8                NULL
    , TRACE_BASE_MULTIPLIER          int8            NOT NULL
    , TD0_AVG                        float           NOT NULL
    , TD1_AVG                        float           NOT NULL
    , TD2_AVG                        float           NOT NULL
    , LW_AVG                         float           NOT NULL
    , LAST_EVAL                      bigint          NOT NULL
    , LAST_WRITE                     bigint          NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_POOL
ON POOL(ID);
CREATE VIEW SCI_POOL (ID,NR_ID,SCOPE_ID,OWNER_ID,MANAGER_ID,DIST_ID,DEFINED_AMOUNT,AMOUNT,FREE_AMOUNT,CHILD_ALLOCATED,EVALUATION_CYCLE,NEXT_EVALUATION_TIME,TAG,TRACE_INTERVAL,TRACE_BASE,TRACE_BASE_MULTIPLIER,TD0_AVG,TD1_AVG,TD2_AVG,LW_AVG,LAST_EVAL,LAST_WRITE,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NR_ID                          AS NR_ID
    , SCOPE_ID                       AS SCOPE_ID
    , OWNER_ID                       AS OWNER_ID
    , MANAGER_ID                     AS MANAGER_ID
    , DIST_ID                        AS DIST_ID
    , DEFINED_AMOUNT                 AS DEFINED_AMOUNT
    , AMOUNT                         AS AMOUNT
    , FREE_AMOUNT                    AS FREE_AMOUNT
    , CHILD_ALLOCATED                AS CHILD_ALLOCATED
    , EVALUATION_CYCLE               AS EVALUATION_CYCLE
    , NEXT_EVALUATION_TIME           AS NEXT_EVALUATION_TIME
    , TAG                            AS TAG
    , TRACE_INTERVAL                 AS TRACE_INTERVAL
    , TRACE_BASE                     AS TRACE_BASE
    , TRACE_BASE_MULTIPLIER          AS TRACE_BASE_MULTIPLIER
    , TD0_AVG                        AS TD0_AVG
    , TD1_AVG                        AS TD1_AVG
    , TD2_AVG                        AS TD2_AVG
    , LW_AVG                         AS LW_AVG
    , dbinfo ('utc_to_datetime', round(mod(LAST_EVAL, 1125899906842624)/1000)) AS LAST_EVAL
    , dbinfo ('utc_to_datetime', round(mod(LAST_WRITE, 1125899906842624)/1000)) AS LAST_WRITE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM POOL;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE RESOURCE_ALLOCATION (
    ID                             bigint NOT NULL
    , R_ID                           bigint          NOT NULL
    , SME_ID                         bigint          NOT NULL
    , NR_ID                          bigint          NOT NULL
    , AMOUNT                         int8                NULL
    , ORIG_AMOUNT                    int8                NULL
    , KEEP_MODE                      int8            NOT NULL
    , IS_STICKY                      integer         NOT NULL
    , STICKY_NAME                    lvarchar(64)        NULL
    , STICKY_PARENT                  bigint              NULL
    , ALLOCATION_TYPE                int8            NOT NULL
    , RSMP_ID                        bigint              NULL
    , LOCKMODE                       int8                NULL
    , REFCOUNT                       int8            NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_RESOURCE_ALLOCATION
ON RESOURCE_ALLOCATION(ID);
CREATE VIEW SCI_RESOURCE_ALLOCATION (ID,R_ID,SME_ID,NR_ID,AMOUNT,ORIG_AMOUNT,KEEP_MODE,IS_STICKY,STICKY_NAME,STICKY_PARENT,ALLOCATION_TYPE,RSMP_ID,LOCKMODE,REFCOUNT,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , R_ID                           AS R_ID
    , SME_ID                         AS SME_ID
    , NR_ID                          AS NR_ID
    , AMOUNT                         AS AMOUNT
    , ORIG_AMOUNT                    AS ORIG_AMOUNT
    , DECODE (KEEP_MODE, 0, 'NOKEEP', 1, 'KEEP', 2, 'KEEP_FINAL') AS KEEP_MODE
    , DECODE (IS_STICKY, 1, 'TRUE', 0, 'FALSE') AS IS_STICKY
    , STICKY_NAME                    AS STICKY_NAME
    , STICKY_PARENT                  AS STICKY_PARENT
    , DECODE (ALLOCATION_TYPE, 1, 'REQUEST', 6, 'MASTER_REQUEST', 2, 'RESERVATION', 3, 'MASTER_RESERVATION', 4, 'ALLOCATION', 5, 'IGNORE') AS ALLOCATION_TYPE
    , RSMP_ID                        AS RSMP_ID
    , DECODE (LOCKMODE, 255, 'N', 0, 'X', 2, 'SX', 4, 'S', 6, 'SC') AS LOCKMODE
    , REFCOUNT                       AS REFCOUNT
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM RESOURCE_ALLOCATION;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE RESOURCE_REQ_STATES (
    ID                             bigint NOT NULL
    , RR_ID                          bigint          NOT NULL
    , RSD_ID                         bigint          NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , VALID_FROM                   bigint NOT NULL
    , VALID_TO                     bigint NOT NULL
);
CREATE INDEX PK_RESOURCE_REQ_STATES
ON RESOURCE_REQ_STATES(ID);
CREATE VIEW SCI_C_RESOURCE_REQ_STATES (ID,RR_ID,RSD_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , RR_ID                          AS RR_ID
    , RSD_ID                         AS RSD_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM RESOURCE_REQ_STATES
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_RESOURCE_REQ_STATES (ID,RR_ID,RSD_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , RR_ID                          AS RR_ID
    , RSD_ID                         AS RSD_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM RESOURCE_REQ_STATES;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE RESOURCE_REQUIREMENT (
    ID                             bigint NOT NULL
    , NR_ID                          bigint          NOT NULL
    , SE_ID                          bigint          NOT NULL
    , AMOUNT                         int8                NULL
    , KEEP_MODE                      int8            NOT NULL
    , IS_STICKY                      integer         NOT NULL
    , STICKY_NAME                    lvarchar(64)        NULL
    , STICKY_PARENT                  bigint              NULL
    , RSMP_ID                        bigint              NULL
    , EXPIRED_AMOUNT                 int8                NULL
    , EXPIRED_BASE                   int8                NULL
    , IGNORE_ON_RERUN                integer         NOT NULL
    , LOCKMODE                       int8                NULL
    , CONDITION                      lvarchar(1024)      NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , VALID_FROM                   bigint NOT NULL
    , VALID_TO                     bigint NOT NULL
);
CREATE INDEX PK_RESOURCE_REQUIREMENT
ON RESOURCE_REQUIREMENT(ID);
CREATE VIEW SCI_C_RESOURCE_REQUIREMENT (ID,NR_ID,SE_ID,AMOUNT,KEEP_MODE,IS_STICKY,STICKY_NAME,STICKY_PARENT,RSMP_ID,EXPIRED_AMOUNT,EXPIRED_BASE,IGNORE_ON_RERUN,LOCKMODE,CONDITION,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NR_ID                          AS NR_ID
    , SE_ID                          AS SE_ID
    , AMOUNT                         AS AMOUNT
    , DECODE (KEEP_MODE, 0, 'NOKEEP', 1, 'KEEP', 2, 'KEEP_FINAL') AS KEEP_MODE
    , DECODE (IS_STICKY, 1, 'TRUE', 0, 'FALSE') AS IS_STICKY
    , STICKY_NAME                    AS STICKY_NAME
    , STICKY_PARENT                  AS STICKY_PARENT
    , RSMP_ID                        AS RSMP_ID
    , EXPIRED_AMOUNT                 AS EXPIRED_AMOUNT
    , DECODE (EXPIRED_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS EXPIRED_BASE
    , DECODE (IGNORE_ON_RERUN, 1, 'TRUE', 0, 'FALSE') AS IGNORE_ON_RERUN
    , DECODE (LOCKMODE, 255, 'N', 0, 'X', 2, 'SX', 4, 'S', 6, 'SC') AS LOCKMODE
    , CONDITION                      AS CONDITION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM RESOURCE_REQUIREMENT
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_RESOURCE_REQUIREMENT (ID,NR_ID,SE_ID,AMOUNT,KEEP_MODE,IS_STICKY,STICKY_NAME,STICKY_PARENT,RSMP_ID,EXPIRED_AMOUNT,EXPIRED_BASE,IGNORE_ON_RERUN,LOCKMODE,CONDITION,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , NR_ID                          AS NR_ID
    , SE_ID                          AS SE_ID
    , AMOUNT                         AS AMOUNT
    , DECODE (KEEP_MODE, 0, 'NOKEEP', 1, 'KEEP', 2, 'KEEP_FINAL') AS KEEP_MODE
    , DECODE (IS_STICKY, 1, 'TRUE', 0, 'FALSE') AS IS_STICKY
    , STICKY_NAME                    AS STICKY_NAME
    , STICKY_PARENT                  AS STICKY_PARENT
    , RSMP_ID                        AS RSMP_ID
    , EXPIRED_AMOUNT                 AS EXPIRED_AMOUNT
    , DECODE (EXPIRED_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS EXPIRED_BASE
    , DECODE (IGNORE_ON_RERUN, 1, 'TRUE', 0, 'FALSE') AS IGNORE_ON_RERUN
    , DECODE (LOCKMODE, 255, 'N', 0, 'X', 2, 'SX', 4, 'S', 6, 'SC') AS LOCKMODE
    , CONDITION                      AS CONDITION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM RESOURCE_REQUIREMENT;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE RESOURCE_STATE_DEFINITION (
    ID                             bigint NOT NULL
    , NAME                           lvarchar(64)    NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_RESOURCE_STATE_DEFINITION
ON RESOURCE_STATE_DEFINITION(ID);
CREATE VIEW SCI_RESOURCE_STATE_DEFINITION (ID,NAME,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM RESOURCE_STATE_DEFINITION;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE RESOURCE_STATE_MAPPING (
    ID                             bigint NOT NULL
    , RSMP_ID                        bigint          NOT NULL
    , ESD_ID                         bigint          NOT NULL
    , FROM_RSD_ID                    bigint              NULL
    , TO_RSD_ID                      bigint          NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , VALID_FROM                   bigint NOT NULL
    , VALID_TO                     bigint NOT NULL
);
CREATE INDEX PK_RESOURCE_STATE_MAPPING
ON RESOURCE_STATE_MAPPING(ID);
CREATE VIEW SCI_C_RESOURCE_STATE_MAPPING (ID,RSMP_ID,ESD_ID,FROM_RSD_ID,TO_RSD_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , RSMP_ID                        AS RSMP_ID
    , ESD_ID                         AS ESD_ID
    , FROM_RSD_ID                    AS FROM_RSD_ID
    , TO_RSD_ID                      AS TO_RSD_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM RESOURCE_STATE_MAPPING
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_RESOURCE_STATE_MAPPING (ID,RSMP_ID,ESD_ID,FROM_RSD_ID,TO_RSD_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , RSMP_ID                        AS RSMP_ID
    , ESD_ID                         AS ESD_ID
    , FROM_RSD_ID                    AS FROM_RSD_ID
    , TO_RSD_ID                      AS TO_RSD_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM RESOURCE_STATE_MAPPING;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE RESOURCE_STATE_MAP_PROF (
    ID                             bigint NOT NULL
    , NAME                           lvarchar(64)    NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , VALID_FROM                   bigint NOT NULL
    , VALID_TO                     bigint NOT NULL
);
CREATE INDEX PK_RESOURCE_STATE_MAP_PROF
ON RESOURCE_STATE_MAP_PROF(ID);
CREATE VIEW SCI_C_RESOURCE_STATE_MAP_PROF (ID,NAME,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM RESOURCE_STATE_MAP_PROF
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_RESOURCE_STATE_MAP_PROF (ID,NAME,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM RESOURCE_STATE_MAP_PROF;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE RESOURCE_STATE_PROFILE (
    ID                             bigint NOT NULL
    , NAME                           lvarchar(64)    NOT NULL
    , INITIAL_RSD_ID                 bigint              NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_RESOURCE_STATE_PROFILE
ON RESOURCE_STATE_PROFILE(ID);
CREATE VIEW SCI_RESOURCE_STATE_PROFILE (ID,NAME,INITIAL_RSD_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , INITIAL_RSD_ID                 AS INITIAL_RSD_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM RESOURCE_STATE_PROFILE;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE RESOURCE_STATE (
    ID                             bigint NOT NULL
    , RSD_ID                         bigint          NOT NULL
    , RSP_ID                         bigint          NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_RESOURCE_STATE
ON RESOURCE_STATE(ID);
CREATE VIEW SCI_RESOURCE_STATE (ID,RSD_ID,RSP_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , RSD_ID                         AS RSD_ID
    , RSP_ID                         AS RSP_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM RESOURCE_STATE;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE RESOURCE_TEMPLATE (
    ID                             bigint NOT NULL
    , NR_ID                          bigint          NOT NULL
    , SE_ID                          bigint          NOT NULL
    , OWNER_ID                       bigint          NOT NULL
    , RSD_ID                         bigint              NULL
    , REQUESTABLE_AMOUNT             int8                NULL
    , AMOUNT                         int8                NULL
    , IS_ONLINE                      integer         NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , VALID_FROM                   bigint NOT NULL
    , VALID_TO                     bigint NOT NULL
);
CREATE INDEX PK_RESOURCE_TEMPLATE
ON RESOURCE_TEMPLATE(ID);
CREATE VIEW SCI_C_RESOURCE_TEMPLATE (ID,NR_ID,SE_ID,OWNER_ID,RSD_ID,REQUESTABLE_AMOUNT,AMOUNT,IS_ONLINE,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NR_ID                          AS NR_ID
    , SE_ID                          AS SE_ID
    , OWNER_ID                       AS OWNER_ID
    , RSD_ID                         AS RSD_ID
    , REQUESTABLE_AMOUNT             AS REQUESTABLE_AMOUNT
    , AMOUNT                         AS AMOUNT
    , DECODE (IS_ONLINE, 1, 'TRUE', 0, 'FALSE') AS IS_ONLINE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM RESOURCE_TEMPLATE
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_RESOURCE_TEMPLATE (ID,NR_ID,SE_ID,OWNER_ID,RSD_ID,REQUESTABLE_AMOUNT,AMOUNT,IS_ONLINE,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , NR_ID                          AS NR_ID
    , SE_ID                          AS SE_ID
    , OWNER_ID                       AS OWNER_ID
    , RSD_ID                         AS RSD_ID
    , REQUESTABLE_AMOUNT             AS REQUESTABLE_AMOUNT
    , AMOUNT                         AS AMOUNT
    , DECODE (IS_ONLINE, 1, 'TRUE', 0, 'FALSE') AS IS_ONLINE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM RESOURCE_TEMPLATE;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE RESOURCE_TRACE (
    R_ID                           bigint          NOT NULL
    , TAG                            lvarchar(64)        NULL
    , TRACE_INTERVAL                 int8                NULL
    , TRACE_BASE                     int8                NULL
    , TRACE_BASE_MULTIPLIER          int8            NOT NULL
    , TD0_AVG                        float           NOT NULL
    , TD1_AVG                        float           NOT NULL
    , TD2_AVG                        float           NOT NULL
    , LW_AVG                         float           NOT NULL
    , WRITE_TIME                     bigint          NOT NULL
    , LAST_WRITE                     bigint          NOT NULL
);
CREATE VIEW SCI_RESOURCE_TRACE (R_ID,TAG,TRACE_INTERVAL,TRACE_BASE,TRACE_BASE_MULTIPLIER,TD0_AVG,TD1_AVG,TD2_AVG,LW_AVG,WRITE_TIME,LAST_WRITE) AS
SELECT 
    R_ID                           AS R_ID
    , TAG                            AS TAG
    , TRACE_INTERVAL                 AS TRACE_INTERVAL
    , TRACE_BASE                     AS TRACE_BASE
    , TRACE_BASE_MULTIPLIER          AS TRACE_BASE_MULTIPLIER
    , TD0_AVG                        AS TD0_AVG
    , TD1_AVG                        AS TD1_AVG
    , TD2_AVG                        AS TD2_AVG
    , LW_AVG                         AS LW_AVG
    , dbinfo ('utc_to_datetime', round(mod(WRITE_TIME, 1125899906842624)/1000)) AS WRITE_TIME
    , dbinfo ('utc_to_datetime', round(mod(LAST_WRITE, 1125899906842624)/1000)) AS LAST_WRITE
  FROM RESOURCE_TRACE;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE RESOURCE_VARIABLE (
    ID                             bigint NOT NULL
    , PD_ID                          bigint          NOT NULL
    , R_ID                           bigint          NOT NULL
    , VALUE                          lvarchar(256)   NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_RESOURCE_VARIABLE
ON RESOURCE_VARIABLE(ID);
CREATE VIEW SCI_RESOURCE_VARIABLE (ID,PD_ID,R_ID,VALUE,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , PD_ID                          AS PD_ID
    , R_ID                           AS R_ID
    , VALUE                          AS VALUE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM RESOURCE_VARIABLE;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE RESSOURCE (
    ID                             bigint NOT NULL
    , NR_ID                          bigint          NOT NULL
    , SCOPE_ID                       bigint              NULL
    , MASTER_ID                      bigint              NULL
    , OWNER_ID                       bigint          NOT NULL
    , LINK_ID                        bigint              NULL
    , MANAGER_ID                     bigint              NULL
    , TAG                            lvarchar(64)        NULL
    , RSD_ID                         bigint              NULL
    , RSD_TIME                       bigint              NULL
    , DEFINED_AMOUNT                 int8                NULL
    , REQUESTABLE_AMOUNT             int8                NULL
    , AMOUNT                         int8                NULL
    , FREE_AMOUNT                    int8                NULL
    , IS_ONLINE                      integer             NULL
    , FACTOR                         float               NULL
    , TRACE_INTERVAL                 int8                NULL
    , TRACE_BASE                     int8                NULL
    , TRACE_BASE_MULTIPLIER          int8            NOT NULL
    , TD0_AVG                        float           NOT NULL
    , TD1_AVG                        float           NOT NULL
    , TD2_AVG                        float           NOT NULL
    , LW_AVG                         float           NOT NULL
    , LAST_EVAL                      bigint          NOT NULL
    , LAST_WRITE                     bigint          NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_RESSOURCE
ON RESSOURCE(ID);
CREATE VIEW SCI_RESSOURCE (ID,NR_ID,SCOPE_ID,MASTER_ID,OWNER_ID,LINK_ID,MANAGER_ID,TAG,RSD_ID,RSD_TIME,DEFINED_AMOUNT,REQUESTABLE_AMOUNT,AMOUNT,FREE_AMOUNT,IS_ONLINE,FACTOR,TRACE_INTERVAL,TRACE_BASE,TRACE_BASE_MULTIPLIER,TD0_AVG,TD1_AVG,TD2_AVG,LW_AVG,LAST_EVAL,LAST_WRITE,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NR_ID                          AS NR_ID
    , SCOPE_ID                       AS SCOPE_ID
    , MASTER_ID                      AS MASTER_ID
    , OWNER_ID                       AS OWNER_ID
    , LINK_ID                        AS LINK_ID
    , MANAGER_ID                     AS MANAGER_ID
    , TAG                            AS TAG
    , RSD_ID                         AS RSD_ID
    , dbinfo ('utc_to_datetime', round(mod(RSD_TIME, 1125899906842624)/1000)) AS RSD_TIME
    , DEFINED_AMOUNT                 AS DEFINED_AMOUNT
    , REQUESTABLE_AMOUNT             AS REQUESTABLE_AMOUNT
    , AMOUNT                         AS AMOUNT
    , FREE_AMOUNT                    AS FREE_AMOUNT
    , DECODE (IS_ONLINE, 1, 'TRUE', 0, 'FALSE') AS IS_ONLINE
    , FACTOR                         AS FACTOR
    , TRACE_INTERVAL                 AS TRACE_INTERVAL
    , TRACE_BASE                     AS TRACE_BASE
    , TRACE_BASE_MULTIPLIER          AS TRACE_BASE_MULTIPLIER
    , TD0_AVG                        AS TD0_AVG
    , TD1_AVG                        AS TD1_AVG
    , TD2_AVG                        AS TD2_AVG
    , LW_AVG                         AS LW_AVG
    , dbinfo ('utc_to_datetime', round(mod(LAST_EVAL, 1125899906842624)/1000)) AS LAST_EVAL
    , dbinfo ('utc_to_datetime', round(mod(LAST_WRITE, 1125899906842624)/1000)) AS LAST_WRITE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM RESSOURCE;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE RUNNABLE_QUEUE (
    ID                             bigint NOT NULL
    , SME_ID                         bigint          NOT NULL
    , SCOPE_ID                       bigint              NULL
    , STATE                          int8            NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_RUNNABLE_QUEUE
ON RUNNABLE_QUEUE(ID);
CREATE VIEW SCI_RUNNABLE_QUEUE (ID,SME_ID,SCOPE_ID,STATE,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , SME_ID                         AS SME_ID
    , SCOPE_ID                       AS SCOPE_ID
    , DECODE (STATE, 1, 'DEPENDENCY_WAIT', 2, 'SYNCHRONIZE_WAIT', 3, 'RESOURCE_WAIT', 4, 'RUNNABLE', 5, 'STARTING') AS STATE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM RUNNABLE_QUEUE;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE SCHEDULED_EVENT (
    ID                             bigint NOT NULL
    , OWNER_ID                       bigint          NOT NULL
    , SCE_ID                         bigint          NOT NULL
    , EVT_ID                         bigint          NOT NULL
    , ACTIVE                         integer         NOT NULL
    , BROKEN                         integer         NOT NULL
    , ERROR_CODE                     lvarchar(32)        NULL
    , ERROR_MSG                      lvarchar(256)       NULL
    , LAST_START_TIME                bigint              NULL
    , NEXT_START_TIME                bigint              NULL
    , NEXT_IS_TRIGGER                integer             NULL
    , BACKLOG_HANDLING               int8            NOT NULL
    , SUSPEND_LIMIT                  int8                NULL
    , SUSPEND_LIMIT_MULTIPLIER       int8                NULL
    , IS_CALENDAR                    integer         NOT NULL
    , CALENDAR_HORIZON               int8                NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_SCHEDULED_EVENT
ON SCHEDULED_EVENT(ID);
CREATE VIEW SCI_SCHEDULED_EVENT (ID,OWNER_ID,SCE_ID,EVT_ID,ACTIVE,BROKEN,ERROR_CODE,ERROR_MSG,LAST_START_TIME,NEXT_START_TIME,NEXT_IS_TRIGGER,BACKLOG_HANDLING,SUSPEND_LIMIT,SUSPEND_LIMIT_MULTIPLIER,IS_CALENDAR,CALENDAR_HORIZON,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , OWNER_ID                       AS OWNER_ID
    , SCE_ID                         AS SCE_ID
    , EVT_ID                         AS EVT_ID
    , DECODE (ACTIVE, 1, 'ACTIVE', 0, 'INACTIVE') AS ACTIVE
    , DECODE (BROKEN, 1, 'BROKEN', 0, 'NOBROKEN') AS BROKEN
    , ERROR_CODE                     AS ERROR_CODE
    , ERROR_MSG                      AS ERROR_MSG
    , dbinfo ('utc_to_datetime', round(mod(LAST_START_TIME, 1125899906842624)/1000)) AS LAST_START_TIME
    , dbinfo ('utc_to_datetime', round(mod(NEXT_START_TIME, 1125899906842624)/1000)) AS NEXT_START_TIME
    , DECODE (NEXT_IS_TRIGGER, 1, 'TRUE', 0, 'FALSE') AS NEXT_IS_TRIGGER
    , DECODE (BACKLOG_HANDLING, 0, 'NONE', 1, 'LAST', 2, 'ALL') AS BACKLOG_HANDLING
    , DECODE (SUSPEND_LIMIT, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS SUSPEND_LIMIT
    , SUSPEND_LIMIT_MULTIPLIER       AS SUSPEND_LIMIT_MULTIPLIER
    , DECODE (IS_CALENDAR, 1, 'ACTIVE', 0, 'INACTIVE') AS IS_CALENDAR
    , CALENDAR_HORIZON               AS CALENDAR_HORIZON
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM SCHEDULED_EVENT;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE SCHEDULE (
    ID                             bigint NOT NULL
    , NAME                           lvarchar(64)    NOT NULL
    , OWNER_ID                       bigint          NOT NULL
    , INT_ID                         bigint              NULL
    , PARENT_ID                      bigint              NULL
    , TIME_ZONE                      lvarchar(32)    NOT NULL
    , SE_ID                          bigint              NULL
    , ACTIVE                         integer         NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , INHERIT_PRIVS                  bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_SCHEDULE
ON SCHEDULE(ID);
CREATE VIEW SCI_SCHEDULE (ID,NAME,OWNER_ID,INT_ID,PARENT_ID,TIME_ZONE,SE_ID,ACTIVE,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS,INHERIT_PRIVS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , OWNER_ID                       AS OWNER_ID
    , INT_ID                         AS INT_ID
    , PARENT_ID                      AS PARENT_ID
    , TIME_ZONE                      AS TIME_ZONE
    , SE_ID                          AS SE_ID
    , DECODE (ACTIVE, 1, 'ACTIVE', 0, 'INACTIVE') AS ACTIVE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , INHERIT_PRIVS                  AS INHERIT_PRIVS
  FROM SCHEDULE;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE SCHEDULING_ENTITY (
    ID                             bigint NOT NULL
    , NAME                           lvarchar(64)    NOT NULL
    , FOLDER_ID                      bigint          NOT NULL
    , OWNER_ID                       bigint          NOT NULL
    , TYPE                           int8            NOT NULL
    , RUN_PROGRAM                    lvarchar(512)       NULL
    , RERUN_PROGRAM                  lvarchar(512)       NULL
    , KILL_PROGRAM                   lvarchar(512)       NULL
    , WORKDIR                        lvarchar(512)       NULL
    , LOGFILE                        lvarchar(512)       NULL
    , TRUNC_LOG                      integer             NULL
    , ERRLOGFILE                     lvarchar(512)       NULL
    , TRUNC_ERRLOG                   integer             NULL
    , EXPECTED_RUNTIME               int8                NULL
    , EXPECTED_FINALTIME             int8                NULL
    , GET_EXPECTED_RUNTIME           lvarchar(32)        NULL
    , PRIORITY                       int8            NOT NULL
    , MIN_PRIORITY                   int8                NULL
    , AGING_AMOUNT                   int8                NULL
    , AGING_BASE                     int8                NULL
    , SUBMIT_SUSPENDED               integer         NOT NULL
    , RESUME_AT                      lvarchar(20)        NULL
    , RESUME_IN                      int8                NULL
    , RESUME_BASE                    int8                NULL
    , MASTER_SUBMITTABLE             integer         NOT NULL
    , TIMEOUT_AMOUNT                 int8                NULL
    , TIMEOUT_BASE                   int8                NULL
    , TIMEOUT_STATE_ID               bigint              NULL
    , SAME_NODE                      integer             NULL
    , GANG_SCHEDULE                  integer             NULL
    , DEPENDENCY_OPERATION           int8            NOT NULL
    , ESMP_ID                        bigint              NULL
    , ESP_ID                         bigint              NULL
    , QA_ID                          bigint              NULL
    , NE_ID                          bigint              NULL
    , FP_ID                          bigint              NULL
    , CANCEL_LEAD_FLAG               integer         NOT NULL
    , CANCEL_APPROVAL                int8            NOT NULL
    , RERUN_LEAD_FLAG                integer         NOT NULL
    , RERUN_APPROVAL                 int8            NOT NULL
    , ENABLE_LEAD_FLAG               integer         NOT NULL
    , ENABLE_APPROVAL                int8            NOT NULL
    , SET_STATE_LEAD_FLAG            integer         NOT NULL
    , SET_STATE_APPROVAL             int8            NOT NULL
    , IGN_DEP_LEAD_FLAG              integer         NOT NULL
    , IGN_DEP_APPROVAL               int8            NOT NULL
    , IGN_RSS_LEAD_FLAG              integer         NOT NULL
    , IGN_RSS_APPROVAL               int8            NOT NULL
    , CLONE_LEAD_FLAG                integer         NOT NULL
    , CLONE_APPROVAL                 int8            NOT NULL
    , EDIT_PARM_LEAD_FLAG            integer         NOT NULL
    , EDIT_PARM_APPROVAL             int8            NOT NULL
    , KILL_LEAD_FLAG                 integer         NOT NULL
    , KILL_APPROVAL                  int8            NOT NULL
    , SET_JOB_STATE_LEAD_FLAG        integer         NOT NULL
    , SET_JOB_STATE_APPROVAL         int8            NOT NULL
    , INHERIT_PRIVS                  bigint          NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , VALID_FROM                   bigint NOT NULL
    , VALID_TO                     bigint NOT NULL
);
CREATE INDEX PK_SCHEDULING_ENTITY
ON SCHEDULING_ENTITY(ID);
CREATE VIEW SCI_C_SCHEDULING_ENTITY (ID,NAME,FOLDER_ID,OWNER_ID,TYPE,RUN_PROGRAM,RERUN_PROGRAM,KILL_PROGRAM,WORKDIR,LOGFILE,TRUNC_LOG,ERRLOGFILE,TRUNC_ERRLOG,EXPECTED_RUNTIME,EXPECTED_FINALTIME,GET_EXPECTED_RUNTIME,PRIORITY,MIN_PRIORITY,AGING_AMOUNT,AGING_BASE,SUBMIT_SUSPENDED,RESUME_AT,RESUME_IN,RESUME_BASE,MASTER_SUBMITTABLE,TIMEOUT_AMOUNT,TIMEOUT_BASE,TIMEOUT_STATE_ID,DEPENDENCY_OPERATION,ESMP_ID,ESP_ID,NE_ID,FP_ID,CANCEL_LEAD_FLAG,CANCEL_APPROVAL,RERUN_LEAD_FLAG,RERUN_APPROVAL,ENABLE_LEAD_FLAG,ENABLE_APPROVAL,SET_STATE_LEAD_FLAG,SET_STATE_APPROVAL,IGN_DEP_LEAD_FLAG,IGN_DEP_APPROVAL,IGN_RSS_LEAD_FLAG,IGN_RSS_APPROVAL,CLONE_LEAD_FLAG,CLONE_APPROVAL,EDIT_PARM_LEAD_FLAG,EDIT_PARM_APPROVAL,KILL_LEAD_FLAG,KILL_APPROVAL,SET_JOB_STATE_LEAD_FLAG,SET_JOB_STATE_APPROVAL,INHERIT_PRIVS,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , FOLDER_ID                      AS FOLDER_ID
    , OWNER_ID                       AS OWNER_ID
    , DECODE (TYPE, 1, 'JOB', 2, 'BATCH', 3, 'MILESTONE') AS TYPE
    , RUN_PROGRAM                    AS RUN_PROGRAM
    , RERUN_PROGRAM                  AS RERUN_PROGRAM
    , KILL_PROGRAM                   AS KILL_PROGRAM
    , WORKDIR                        AS WORKDIR
    , LOGFILE                        AS LOGFILE
    , DECODE (TRUNC_LOG, 0, 'NOTRUNC', 1, 'TRUNC') AS TRUNC_LOG
    , ERRLOGFILE                     AS ERRLOGFILE
    , DECODE (TRUNC_ERRLOG, 0, 'NOTRUNC', 1, 'TRUNC') AS TRUNC_ERRLOG
    , EXPECTED_RUNTIME               AS EXPECTED_RUNTIME
    , EXPECTED_FINALTIME             AS EXPECTED_FINALTIME
    , GET_EXPECTED_RUNTIME           AS GET_EXPECTED_RUNTIME
    , PRIORITY                       AS PRIORITY
    , MIN_PRIORITY                   AS MIN_PRIORITY
    , AGING_AMOUNT                   AS AGING_AMOUNT
    , DECODE (AGING_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS AGING_BASE
    , DECODE (SUBMIT_SUSPENDED, 1, 'SUSPEND', 0, 'NOSUSPEND') AS SUBMIT_SUSPENDED
    , RESUME_AT                      AS RESUME_AT
    , RESUME_IN                      AS RESUME_IN
    , DECODE (RESUME_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS RESUME_BASE
    , DECODE (MASTER_SUBMITTABLE, 1, 'MASTER', 0, 'NOMASTER') AS MASTER_SUBMITTABLE
    , TIMEOUT_AMOUNT                 AS TIMEOUT_AMOUNT
    , DECODE (TIMEOUT_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS TIMEOUT_BASE
    , TIMEOUT_STATE_ID               AS TIMEOUT_STATE_ID
    , DECODE (DEPENDENCY_OPERATION, 1, 'AND', 2, 'OR') AS DEPENDENCY_OPERATION
    , ESMP_ID                        AS ESMP_ID
    , ESP_ID                         AS ESP_ID
    , NE_ID                          AS NE_ID
    , FP_ID                          AS FP_ID
    , DECODE (CANCEL_LEAD_FLAG, 1, 'TRUE', 0, 'FALSE') AS CANCEL_LEAD_FLAG
    , DECODE (CANCEL_APPROVAL, 0, 'DEFAULT', 1, 'PARENT', 2, 'NO', 5, 'APPROVE', 4, 'REVIEW') AS CANCEL_APPROVAL
    , DECODE (RERUN_LEAD_FLAG, 1, 'TRUE', 0, 'FALSE') AS RERUN_LEAD_FLAG
    , DECODE (RERUN_APPROVAL, 0, 'DEFAULT', 1, 'PARENT', 2, 'NO', 5, 'APPROVE', 4, 'REVIEW') AS RERUN_APPROVAL
    , DECODE (ENABLE_LEAD_FLAG, 1, 'TRUE', 0, 'FALSE') AS ENABLE_LEAD_FLAG
    , DECODE (ENABLE_APPROVAL, 0, 'DEFAULT', 1, 'PARENT', 2, 'NO', 5, 'APPROVE', 4, 'REVIEW') AS ENABLE_APPROVAL
    , DECODE (SET_STATE_LEAD_FLAG, 1, 'TRUE', 0, 'FALSE') AS SET_STATE_LEAD_FLAG
    , DECODE (SET_STATE_APPROVAL, 0, 'DEFAULT', 1, 'PARENT', 2, 'NO', 5, 'APPROVE', 4, 'REVIEW') AS SET_STATE_APPROVAL
    , DECODE (IGN_DEP_LEAD_FLAG, 1, 'TRUE', 0, 'FALSE') AS IGN_DEP_LEAD_FLAG
    , DECODE (IGN_DEP_APPROVAL, 0, 'DEFAULT', 1, 'PARENT', 2, 'NO', 5, 'APPROVE', 4, 'REVIEW') AS IGN_DEP_APPROVAL
    , DECODE (IGN_RSS_LEAD_FLAG, 1, 'TRUE', 0, 'FALSE') AS IGN_RSS_LEAD_FLAG
    , DECODE (IGN_RSS_APPROVAL, 0, 'DEFAULT', 1, 'PARENT', 2, 'NO', 5, 'APPROVE', 4, 'REVIEW') AS IGN_RSS_APPROVAL
    , DECODE (CLONE_LEAD_FLAG, 1, 'TRUE', 0, 'FALSE') AS CLONE_LEAD_FLAG
    , DECODE (CLONE_APPROVAL, 0, 'DEFAULT', 1, 'PARENT', 2, 'NO', 5, 'APPROVE', 4, 'REVIEW') AS CLONE_APPROVAL
    , DECODE (EDIT_PARM_LEAD_FLAG, 1, 'TRUE', 0, 'FALSE') AS EDIT_PARM_LEAD_FLAG
    , DECODE (EDIT_PARM_APPROVAL, 0, 'DEFAULT', 1, 'PARENT', 2, 'NO', 5, 'APPROVE', 4, 'REVIEW') AS EDIT_PARM_APPROVAL
    , DECODE (KILL_LEAD_FLAG, 1, 'TRUE', 0, 'FALSE') AS KILL_LEAD_FLAG
    , DECODE (KILL_APPROVAL, 0, 'DEFAULT', 1, 'PARENT', 2, 'NO', 5, 'APPROVE', 4, 'REVIEW') AS KILL_APPROVAL
    , DECODE (SET_JOB_STATE_LEAD_FLAG, 1, 'TRUE', 0, 'FALSE') AS SET_JOB_STATE_LEAD_FLAG
    , DECODE (SET_JOB_STATE_APPROVAL, 0, 'DEFAULT', 1, 'PARENT', 2, 'NO', 5, 'APPROVE', 4, 'REVIEW') AS SET_JOB_STATE_APPROVAL
    , INHERIT_PRIVS                  AS INHERIT_PRIVS
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM SCHEDULING_ENTITY
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_SCHEDULING_ENTITY (ID,NAME,FOLDER_ID,OWNER_ID,TYPE,RUN_PROGRAM,RERUN_PROGRAM,KILL_PROGRAM,WORKDIR,LOGFILE,TRUNC_LOG,ERRLOGFILE,TRUNC_ERRLOG,EXPECTED_RUNTIME,EXPECTED_FINALTIME,GET_EXPECTED_RUNTIME,PRIORITY,MIN_PRIORITY,AGING_AMOUNT,AGING_BASE,SUBMIT_SUSPENDED,RESUME_AT,RESUME_IN,RESUME_BASE,MASTER_SUBMITTABLE,TIMEOUT_AMOUNT,TIMEOUT_BASE,TIMEOUT_STATE_ID,DEPENDENCY_OPERATION,ESMP_ID,ESP_ID,NE_ID,FP_ID,CANCEL_LEAD_FLAG,CANCEL_APPROVAL,RERUN_LEAD_FLAG,RERUN_APPROVAL,ENABLE_LEAD_FLAG,ENABLE_APPROVAL,SET_STATE_LEAD_FLAG,SET_STATE_APPROVAL,IGN_DEP_LEAD_FLAG,IGN_DEP_APPROVAL,IGN_RSS_LEAD_FLAG,IGN_RSS_APPROVAL,CLONE_LEAD_FLAG,CLONE_APPROVAL,EDIT_PARM_LEAD_FLAG,EDIT_PARM_APPROVAL,KILL_LEAD_FLAG,KILL_APPROVAL,SET_JOB_STATE_LEAD_FLAG,SET_JOB_STATE_APPROVAL,INHERIT_PRIVS,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , FOLDER_ID                      AS FOLDER_ID
    , OWNER_ID                       AS OWNER_ID
    , DECODE (TYPE, 1, 'JOB', 2, 'BATCH', 3, 'MILESTONE') AS TYPE
    , RUN_PROGRAM                    AS RUN_PROGRAM
    , RERUN_PROGRAM                  AS RERUN_PROGRAM
    , KILL_PROGRAM                   AS KILL_PROGRAM
    , WORKDIR                        AS WORKDIR
    , LOGFILE                        AS LOGFILE
    , DECODE (TRUNC_LOG, 0, 'NOTRUNC', 1, 'TRUNC') AS TRUNC_LOG
    , ERRLOGFILE                     AS ERRLOGFILE
    , DECODE (TRUNC_ERRLOG, 0, 'NOTRUNC', 1, 'TRUNC') AS TRUNC_ERRLOG
    , EXPECTED_RUNTIME               AS EXPECTED_RUNTIME
    , EXPECTED_FINALTIME             AS EXPECTED_FINALTIME
    , GET_EXPECTED_RUNTIME           AS GET_EXPECTED_RUNTIME
    , PRIORITY                       AS PRIORITY
    , MIN_PRIORITY                   AS MIN_PRIORITY
    , AGING_AMOUNT                   AS AGING_AMOUNT
    , DECODE (AGING_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS AGING_BASE
    , DECODE (SUBMIT_SUSPENDED, 1, 'SUSPEND', 0, 'NOSUSPEND') AS SUBMIT_SUSPENDED
    , RESUME_AT                      AS RESUME_AT
    , RESUME_IN                      AS RESUME_IN
    , DECODE (RESUME_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS RESUME_BASE
    , DECODE (MASTER_SUBMITTABLE, 1, 'MASTER', 0, 'NOMASTER') AS MASTER_SUBMITTABLE
    , TIMEOUT_AMOUNT                 AS TIMEOUT_AMOUNT
    , DECODE (TIMEOUT_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS TIMEOUT_BASE
    , TIMEOUT_STATE_ID               AS TIMEOUT_STATE_ID
    , DECODE (DEPENDENCY_OPERATION, 1, 'AND', 2, 'OR') AS DEPENDENCY_OPERATION
    , ESMP_ID                        AS ESMP_ID
    , ESP_ID                         AS ESP_ID
    , NE_ID                          AS NE_ID
    , FP_ID                          AS FP_ID
    , DECODE (CANCEL_LEAD_FLAG, 1, 'TRUE', 0, 'FALSE') AS CANCEL_LEAD_FLAG
    , DECODE (CANCEL_APPROVAL, 0, 'DEFAULT', 1, 'PARENT', 2, 'NO', 5, 'APPROVE', 4, 'REVIEW') AS CANCEL_APPROVAL
    , DECODE (RERUN_LEAD_FLAG, 1, 'TRUE', 0, 'FALSE') AS RERUN_LEAD_FLAG
    , DECODE (RERUN_APPROVAL, 0, 'DEFAULT', 1, 'PARENT', 2, 'NO', 5, 'APPROVE', 4, 'REVIEW') AS RERUN_APPROVAL
    , DECODE (ENABLE_LEAD_FLAG, 1, 'TRUE', 0, 'FALSE') AS ENABLE_LEAD_FLAG
    , DECODE (ENABLE_APPROVAL, 0, 'DEFAULT', 1, 'PARENT', 2, 'NO', 5, 'APPROVE', 4, 'REVIEW') AS ENABLE_APPROVAL
    , DECODE (SET_STATE_LEAD_FLAG, 1, 'TRUE', 0, 'FALSE') AS SET_STATE_LEAD_FLAG
    , DECODE (SET_STATE_APPROVAL, 0, 'DEFAULT', 1, 'PARENT', 2, 'NO', 5, 'APPROVE', 4, 'REVIEW') AS SET_STATE_APPROVAL
    , DECODE (IGN_DEP_LEAD_FLAG, 1, 'TRUE', 0, 'FALSE') AS IGN_DEP_LEAD_FLAG
    , DECODE (IGN_DEP_APPROVAL, 0, 'DEFAULT', 1, 'PARENT', 2, 'NO', 5, 'APPROVE', 4, 'REVIEW') AS IGN_DEP_APPROVAL
    , DECODE (IGN_RSS_LEAD_FLAG, 1, 'TRUE', 0, 'FALSE') AS IGN_RSS_LEAD_FLAG
    , DECODE (IGN_RSS_APPROVAL, 0, 'DEFAULT', 1, 'PARENT', 2, 'NO', 5, 'APPROVE', 4, 'REVIEW') AS IGN_RSS_APPROVAL
    , DECODE (CLONE_LEAD_FLAG, 1, 'TRUE', 0, 'FALSE') AS CLONE_LEAD_FLAG
    , DECODE (CLONE_APPROVAL, 0, 'DEFAULT', 1, 'PARENT', 2, 'NO', 5, 'APPROVE', 4, 'REVIEW') AS CLONE_APPROVAL
    , DECODE (EDIT_PARM_LEAD_FLAG, 1, 'TRUE', 0, 'FALSE') AS EDIT_PARM_LEAD_FLAG
    , DECODE (EDIT_PARM_APPROVAL, 0, 'DEFAULT', 1, 'PARENT', 2, 'NO', 5, 'APPROVE', 4, 'REVIEW') AS EDIT_PARM_APPROVAL
    , DECODE (KILL_LEAD_FLAG, 1, 'TRUE', 0, 'FALSE') AS KILL_LEAD_FLAG
    , DECODE (KILL_APPROVAL, 0, 'DEFAULT', 1, 'PARENT', 2, 'NO', 5, 'APPROVE', 4, 'REVIEW') AS KILL_APPROVAL
    , DECODE (SET_JOB_STATE_LEAD_FLAG, 1, 'TRUE', 0, 'FALSE') AS SET_JOB_STATE_LEAD_FLAG
    , DECODE (SET_JOB_STATE_APPROVAL, 0, 'DEFAULT', 1, 'PARENT', 2, 'NO', 5, 'APPROVE', 4, 'REVIEW') AS SET_JOB_STATE_APPROVAL
    , INHERIT_PRIVS                  AS INHERIT_PRIVS
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM SCHEDULING_ENTITY;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE SCHEDULING_HIERARCHY (
    ID                             bigint NOT NULL
    , SE_PARENT_ID                   bigint              NULL
    , SE_CHILD_ID                    bigint              NULL
    , ALIAS_NAME                     lvarchar(64)        NULL
    , IS_STATIC                      integer         NOT NULL
    , IS_DISABLED                    integer         NOT NULL
    , PRIORITY                       int8            NOT NULL
    , SUSPEND                        int8            NOT NULL
    , RESUME_AT                      lvarchar(20)        NULL
    , RESUME_IN                      int8                NULL
    , RESUME_BASE                    int8                NULL
    , MERGE_MODE                     int8            NOT NULL
    , ESTP_ID                        bigint              NULL
    , INT_ID                         bigint              NULL
    , ENABLE_CONDITION               lvarchar(2048)      NULL
    , ENABLE_MODE                    int8            NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , VALID_FROM                   bigint NOT NULL
    , VALID_TO                     bigint NOT NULL
);
CREATE INDEX PK_SCHEDULING_HIERARCHY
ON SCHEDULING_HIERARCHY(ID);
CREATE VIEW SCI_C_SCHEDULING_HIERARCHY (ID,SE_PARENT_ID,SE_CHILD_ID,ALIAS_NAME,IS_STATIC,IS_DISABLED,PRIORITY,SUSPEND,RESUME_AT,RESUME_IN,RESUME_BASE,MERGE_MODE,ESTP_ID,INT_ID,ENABLE_CONDITION,ENABLE_MODE,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , SE_PARENT_ID                   AS SE_PARENT_ID
    , SE_CHILD_ID                    AS SE_CHILD_ID
    , ALIAS_NAME                     AS ALIAS_NAME
    , DECODE (IS_STATIC, 1, 'STATIC', 0, 'DYNAMIC') AS IS_STATIC
    , DECODE (IS_DISABLED, 0, 'ENABLED', 1, 'DISABLED') AS IS_DISABLED
    , PRIORITY                       AS PRIORITY
    , DECODE (SUSPEND, 1, 'CHILDSUSPEND', 2, 'NOSUSPEND', 3, 'SUSPEND') AS SUSPEND
    , RESUME_AT                      AS RESUME_AT
    , RESUME_IN                      AS RESUME_IN
    , DECODE (RESUME_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS RESUME_BASE
    , DECODE (MERGE_MODE, 1, 'MERGE_LOCAL', 2, 'MERGE_GLOBAL', 3, 'NOMERGE', 4, 'FAILURE') AS MERGE_MODE
    , ESTP_ID                        AS ESTP_ID
    , INT_ID                         AS INT_ID
    , ENABLE_CONDITION               AS ENABLE_CONDITION
    , DECODE (ENABLE_MODE, 1, 'AND', 2, 'OR') AS ENABLE_MODE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM SCHEDULING_HIERARCHY
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_SCHEDULING_HIERARCHY (ID,SE_PARENT_ID,SE_CHILD_ID,ALIAS_NAME,IS_STATIC,IS_DISABLED,PRIORITY,SUSPEND,RESUME_AT,RESUME_IN,RESUME_BASE,MERGE_MODE,ESTP_ID,INT_ID,ENABLE_CONDITION,ENABLE_MODE,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , SE_PARENT_ID                   AS SE_PARENT_ID
    , SE_CHILD_ID                    AS SE_CHILD_ID
    , ALIAS_NAME                     AS ALIAS_NAME
    , DECODE (IS_STATIC, 1, 'STATIC', 0, 'DYNAMIC') AS IS_STATIC
    , DECODE (IS_DISABLED, 0, 'ENABLED', 1, 'DISABLED') AS IS_DISABLED
    , PRIORITY                       AS PRIORITY
    , DECODE (SUSPEND, 1, 'CHILDSUSPEND', 2, 'NOSUSPEND', 3, 'SUSPEND') AS SUSPEND
    , RESUME_AT                      AS RESUME_AT
    , RESUME_IN                      AS RESUME_IN
    , DECODE (RESUME_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS RESUME_BASE
    , DECODE (MERGE_MODE, 1, 'MERGE_LOCAL', 2, 'MERGE_GLOBAL', 3, 'NOMERGE', 4, 'FAILURE') AS MERGE_MODE
    , ESTP_ID                        AS ESTP_ID
    , INT_ID                         AS INT_ID
    , ENABLE_CONDITION               AS ENABLE_CONDITION
    , DECODE (ENABLE_MODE, 1, 'AND', 2, 'OR') AS ENABLE_MODE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM SCHEDULING_HIERARCHY;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE SCOPE_CONFIG_ENVMAPPING (
    ID                             bigint NOT NULL
    , KEY                            lvarchar(64)    NOT NULL
    , VALUE                          lvarchar(256)   NOT NULL
    , S_ID                           bigint          NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_SCOPE_CONFIG_ENVMAPPING
ON SCOPE_CONFIG_ENVMAPPING(ID);
CREATE VIEW SCI_SCOPE_CONFIG_ENVMAPPING (ID,KEY,VALUE,S_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , KEY                            AS KEY
    , VALUE                          AS VALUE
    , S_ID                           AS S_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM SCOPE_CONFIG_ENVMAPPING;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE SCOPE_CONFIG (
    ID                             bigint NOT NULL
    , KEY                            lvarchar(64)    NOT NULL
    , VALUE                          lvarchar(256)   NOT NULL
    , S_ID                           bigint          NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_SCOPE_CONFIG
ON SCOPE_CONFIG(ID);
CREATE VIEW SCI_SCOPE_CONFIG (ID,KEY,VALUE,S_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , KEY                            AS KEY
    , VALUE                          AS VALUE
    , S_ID                           AS S_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM SCOPE_CONFIG;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE SCOPE (
    ID                             bigint NOT NULL
    , NAME                           lvarchar(64)    NOT NULL
    , OWNER_ID                       bigint          NOT NULL
    , PARENT_ID                      bigint              NULL
    , TYPE                           int8            NOT NULL
    , IS_TERMINATE                   integer             NULL
    , HAS_ALTEREDCONFIG              integer             NULL
    , IS_SUSPENDED                   integer             NULL
    , IS_ENABLED                     integer             NULL
    , IS_REGISTERED                  integer             NULL
    , STATE                          int8                NULL
    , PASSWD                         lvarchar(64)        NULL
    , SALT                           lvarchar(64)        NULL
    , METHOD                         int8            NOT NULL
    , PID                            lvarchar(32)        NULL
    , NODE                           lvarchar(64)        NULL
    , ERRMSG                         lvarchar(256)       NULL
    , LAST_ACTIVE                    bigint              NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , INHERIT_PRIVS                  bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_SCOPE
ON SCOPE(ID);
CREATE VIEW SCI_SCOPE (ID,NAME,OWNER_ID,PARENT_ID,TYPE,IS_TERMINATE,HAS_ALTEREDCONFIG,IS_SUSPENDED,IS_ENABLED,IS_REGISTERED,STATE,PID,NODE,ERRMSG,LAST_ACTIVE,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS,INHERIT_PRIVS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , OWNER_ID                       AS OWNER_ID
    , PARENT_ID                      AS PARENT_ID
    , DECODE (TYPE, 1, 'SCOPE', 2, 'SERVER') AS TYPE
    , DECODE (IS_TERMINATE, 1, 'TRUE', 0, 'FALSE') AS IS_TERMINATE
    , DECODE (HAS_ALTEREDCONFIG, 1, 'TRUE', 0, 'FALSE') AS HAS_ALTEREDCONFIG
    , DECODE (IS_SUSPENDED, 1, 'TRUE', 0, 'FALSE') AS IS_SUSPENDED
    , DECODE (IS_ENABLED, 1, 'TRUE', 0, 'FALSE') AS IS_ENABLED
    , DECODE (IS_REGISTERED, 1, 'TRUE', 0, 'FALSE') AS IS_REGISTERED
    , DECODE (STATE, 1, 'NOMINAL', 2, 'NONFATAL', 3, 'FATAL') AS STATE
    , PID                            AS PID
    , NODE                           AS NODE
    , ERRMSG                         AS ERRMSG
    , LAST_ACTIVE                    AS LAST_ACTIVE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , INHERIT_PRIVS                  AS INHERIT_PRIVS
  FROM SCOPE;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE SME_COUNTER (
    ID                             bigint NOT NULL
    , JAHR                           int8            NOT NULL
    , MONAT                          int8            NOT NULL
    , TAG                            int8            NOT NULL
    , ANZAHL                         int8            NOT NULL
    , CHECKSUM                       bigint          NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_SME_COUNTER
ON SME_COUNTER(ID);
CREATE VIEW SCI_SME_COUNTER (ID,JAHR,MONAT,TAG,ANZAHL,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , JAHR                           AS JAHR
    , MONAT                          AS MONAT
    , TAG                            AS TAG
    , ANZAHL                         AS ANZAHL
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM SME_COUNTER;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE SUBMITTED_ENTITY (
    ID                             bigint NOT NULL
    , ACCESS_KEY                     bigint          NOT NULL
    , MASTER_ID                      bigint          NOT NULL
    , SUBMIT_TAG                     lvarchar(32)        NULL
    , UNRESOLVED_HANDLING            int8                NULL
    , SE_ID                          bigint          NOT NULL
    , CHILD_TAG                      lvarchar(70)        NULL
    , SE_VERSION                     bigint          NOT NULL
    , OWNER_ID                       bigint          NOT NULL
    , PARENT_ID                      bigint              NULL
    , SCOPE_ID                       bigint              NULL
    , IS_STATIC                      integer         NOT NULL
    , IS_DISABLED                    integer         NOT NULL
    , OLD_STATE                      int8                NULL
    , MERGE_MODE                     int8            NOT NULL
    , STATE                          int8            NOT NULL
    , JOB_ESD_ID                     bigint              NULL
    , JOB_ESD_PREF                   int8                NULL
    , JOB_IS_FINAL                   integer         NOT NULL
    , JOB_IS_RESTARTABLE             integer         NOT NULL
    , FINAL_ESD_ID                   bigint              NULL
    , EXIT_CODE                      int8                NULL
    , COMMANDLINE                    lvarchar(512)       NULL
    , RR_COMMANDLINE                 lvarchar(512)       NULL
    , RERUN_SEQ                      int8            NOT NULL
    , IS_REPLACED                    integer         NOT NULL
    , IS_CANCELLED                   integer             NULL
    , BASE_SME_ID                    bigint              NULL
    , REASON_SME_ID                  bigint              NULL
    , FIRE_SME_ID                    bigint              NULL
    , FIRE_SE_ID                     bigint              NULL
    , TR_ID                          bigint              NULL
    , TR_SD_ID_OLD                   bigint              NULL
    , TR_SD_ID_NEW                   bigint              NULL
    , TR_SEQ                         int8            NOT NULL
    , WORKDIR                        lvarchar(512)       NULL
    , LOGFILE                        lvarchar(512)       NULL
    , ERRLOGFILE                     lvarchar(512)       NULL
    , PID                            lvarchar(32)        NULL
    , EXTPID                         lvarchar(32)        NULL
    , ERROR_MSG                      lvarchar(256)       NULL
    , KILL_ID                        bigint              NULL
    , KILL_EXIT_CODE                 int8                NULL
    , IS_SUSPENDED                   int8            NOT NULL
    , IS_SUSPENDED_LOCAL             integer             NULL
    , PRIORITY                       int8            NOT NULL
    , RAW_PRIORITY                   int8            NOT NULL
    , NICE                           int8            NOT NULL
    , NP_NICE                        int8            NOT NULL
    , MIN_PRIORITY                   int8            NOT NULL
    , AGING_AMOUNT                   int8            NOT NULL
    , PARENT_SUSPENDED               int8            NOT NULL
    , CHILD_SUSPENDED                int8            NOT NULL
    , WARN_COUNT                     int8            NOT NULL
    , WARN_LINK                      bigint              NULL
    , APPROVAL_MODE                  int8            NOT NULL
    , CHILD_APPROVAL_MODE            int8            NOT NULL
    , SUBMIT_TS                      bigint          NOT NULL
    , RESUME_TS                      bigint              NULL
    , SYNC_TS                        bigint              NULL
    , RESOURCE_TS                    bigint              NULL
    , RUNNABLE_TS                    bigint              NULL
    , START_TS                       bigint              NULL
    , FINSH_TS                       bigint              NULL
    , FINAL_TS                       bigint              NULL
    , CNT_SUBMITTED                  int8            NOT NULL
    , CNT_DEPENDENCY_WAIT            int8            NOT NULL
    , CNT_SYNCHRONIZE_WAIT           int8            NOT NULL
    , CNT_RESOURCE_WAIT              int8            NOT NULL
    , CNT_RUNNABLE                   int8            NOT NULL
    , CNT_STARTING                   int8            NOT NULL
    , CNT_STARTED                    int8            NOT NULL
    , CNT_RUNNING                    int8            NOT NULL
    , CNT_TO_KILL                    int8            NOT NULL
    , CNT_KILLED                     int8            NOT NULL
    , CNT_CANCELLED                  int8            NOT NULL
    , CNT_FINISHED                   int8            NOT NULL
    , CNT_FINAL                      int8            NOT NULL
    , CNT_BROKEN_ACTIVE              int8            NOT NULL
    , CNT_BROKEN_FINISHED            int8            NOT NULL
    , CNT_ERROR                      int8            NOT NULL
    , CNT_UNREACHABLE                int8            NOT NULL
    , CNT_RESTARTABLE                int8            NOT NULL
    , CNT_WARN                       int8            NOT NULL
    , CNT_PENDING                    int8            NOT NULL
    , IDLE_TS                        int8                NULL
    , IDLE_TIME                      int8                NULL
    , STATISTIC_TS                   int8                NULL
    , DEPENDENCY_WAIT_TIME           int8                NULL
    , SUSPEND_TIME                   int8                NULL
    , SYNC_TIME                      int8                NULL
    , RESOURCE_TIME                  int8                NULL
    , JOBSERVER_TIME                 int8                NULL
    , RESTARTABLE_TIME               int8                NULL
    , CHILD_WAIT_TIME                int8                NULL
    , OP_SUSRES_TS                   bigint              NULL
    , NPE_ID                         bigint              NULL
    , TIME_ZONE                      lvarchar(32)        NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_SUBMITTED_ENTITY
ON SUBMITTED_ENTITY(ID);
CREATE VIEW SCI_SUBMITTED_ENTITY (ID,MASTER_ID,SUBMIT_TAG,UNRESOLVED_HANDLING,SE_ID,CHILD_TAG,SE_VERSION,OWNER_ID,PARENT_ID,SCOPE_ID,IS_STATIC,IS_DISABLED,OLD_STATE,MERGE_MODE,STATE,JOB_ESD_ID,JOB_ESD_PREF,JOB_IS_FINAL,JOB_IS_RESTARTABLE,FINAL_ESD_ID,EXIT_CODE,COMMANDLINE,RR_COMMANDLINE,RERUN_SEQ,IS_REPLACED,IS_CANCELLED,BASE_SME_ID,REASON_SME_ID,FIRE_SME_ID,FIRE_SE_ID,TR_ID,TR_SD_ID_OLD,TR_SD_ID_NEW,TR_SEQ,WORKDIR,LOGFILE,ERRLOGFILE,PID,EXTPID,ERROR_MSG,KILL_ID,KILL_EXIT_CODE,IS_SUSPENDED,IS_SUSPENDED_LOCAL,PRIORITY,RAW_PRIORITY,NICE,NP_NICE,MIN_PRIORITY,AGING_AMOUNT,PARENT_SUSPENDED,CHILD_SUSPENDED,WARN_COUNT,WARN_LINK,APPROVAL_MODE,CHILD_APPROVAL_MODE,SUBMIT_TS,RESUME_TS,SYNC_TS,RESOURCE_TS,RUNNABLE_TS,START_TS,FINSH_TS,FINAL_TS,IDLE_TIME,DEPENDENCY_WAIT_TIME,SUSPEND_TIME,SYNC_TIME,RESOURCE_TIME,JOBSERVER_TIME,RESTARTABLE_TIME,CHILD_WAIT_TIME,OP_SUSRES_TS,NPE_ID,TIME_ZONE,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS,PROCESS_TIME) AS
SELECT 
    ID 
    , MASTER_ID                      AS MASTER_ID
    , SUBMIT_TAG                     AS SUBMIT_TAG
    , DECODE (UNRESOLVED_HANDLING, 1, 'UH_IGNORE', 3, 'UH_SUSPEND', 2, 'UH_ERROR') AS UNRESOLVED_HANDLING
    , SE_ID                          AS SE_ID
    , CHILD_TAG                      AS CHILD_TAG
    , SE_VERSION                     AS SE_VERSION
    , OWNER_ID                       AS OWNER_ID
    , PARENT_ID                      AS PARENT_ID
    , SCOPE_ID                       AS SCOPE_ID
    , DECODE (IS_STATIC, 1, 'TRUE', 0, 'FALSE') AS IS_STATIC
    , DECODE (IS_DISABLED, 1, 'TRUE', 0, 'FALSE') AS IS_DISABLED
    , OLD_STATE                      AS OLD_STATE
    , DECODE (MERGE_MODE, 1, 'MERGE_LOCAL', 2, 'MERGE_GLOBAL', 3, 'NOMERGE', 4, 'FAILURE') AS MERGE_MODE
    , DECODE (STATE, 0, 'SUBMITTED', 1, 'DEPENDENCY_WAIT', 2, 'SYNCHRONIZE_WAIT', 3, 'RESOURCE_WAIT', 4, 'RUNNABLE', 5, 'STARTING', 6, 'STARTED', 7, 'RUNNING', 8, 'TO_KILL', 9, 'KILLED', 10, 'CANCELLED', 11, 'FINISHED', 12, 'FINAL', 13, 'BROKEN_ACTIVE', 14, 'BROKEN_FINISHED', 15, 'ERROR', 16, 'UNREACHABLE') AS STATE
    , JOB_ESD_ID                     AS JOB_ESD_ID
    , JOB_ESD_PREF                   AS JOB_ESD_PREF
    , DECODE (JOB_IS_FINAL, 1, 'TRUE', 0, 'FALSE') AS JOB_IS_FINAL
    , DECODE (JOB_IS_RESTARTABLE, 1, 'TRUE', 0, 'FALSE') AS JOB_IS_RESTARTABLE
    , FINAL_ESD_ID                   AS FINAL_ESD_ID
    , EXIT_CODE                      AS EXIT_CODE
    , COMMANDLINE                    AS COMMANDLINE
    , RR_COMMANDLINE                 AS RR_COMMANDLINE
    , RERUN_SEQ                      AS RERUN_SEQ
    , DECODE (IS_REPLACED, 1, 'TRUE', 0, 'FALSE') AS IS_REPLACED
    , DECODE (IS_CANCELLED, 1, 'TRUE', 0, 'FALSE') AS IS_CANCELLED
    , BASE_SME_ID                    AS BASE_SME_ID
    , REASON_SME_ID                  AS REASON_SME_ID
    , FIRE_SME_ID                    AS FIRE_SME_ID
    , FIRE_SE_ID                     AS FIRE_SE_ID
    , TR_ID                          AS TR_ID
    , TR_SD_ID_OLD                   AS TR_SD_ID_OLD
    , TR_SD_ID_NEW                   AS TR_SD_ID_NEW
    , TR_SEQ                         AS TR_SEQ
    , WORKDIR                        AS WORKDIR
    , LOGFILE                        AS LOGFILE
    , ERRLOGFILE                     AS ERRLOGFILE
    , PID                            AS PID
    , EXTPID                         AS EXTPID
    , ERROR_MSG                      AS ERROR_MSG
    , KILL_ID                        AS KILL_ID
    , KILL_EXIT_CODE                 AS KILL_EXIT_CODE
    , DECODE (IS_SUSPENDED, 2, 'ADMINSUSPEND', 1, 'SUSPEND', 0, 'NOSUSPEND') AS IS_SUSPENDED
    , DECODE (IS_SUSPENDED_LOCAL, 1, 'TRUE', 0, 'FALSE') AS IS_SUSPENDED_LOCAL
    , PRIORITY                       AS PRIORITY
    , RAW_PRIORITY                   AS RAW_PRIORITY
    , NICE                           AS NICE
    , NP_NICE                        AS NP_NICE
    , MIN_PRIORITY                   AS MIN_PRIORITY
    , AGING_AMOUNT                   AS AGING_AMOUNT
    , PARENT_SUSPENDED               AS PARENT_SUSPENDED
    , CHILD_SUSPENDED                AS CHILD_SUSPENDED
    , WARN_COUNT                     AS WARN_COUNT
    , WARN_LINK                      AS WARN_LINK
    , APPROVAL_MODE                  AS APPROVAL_MODE
    , CHILD_APPROVAL_MODE            AS CHILD_APPROVAL_MODE
    , dbinfo ('utc_to_datetime', round(mod(SUBMIT_TS, 1125899906842624)/1000)) AS SUBMIT_TS
    , dbinfo ('utc_to_datetime', round(mod(RESUME_TS, 1125899906842624)/1000)) AS RESUME_TS
    , dbinfo ('utc_to_datetime', round(mod(SYNC_TS, 1125899906842624)/1000)) AS SYNC_TS
    , dbinfo ('utc_to_datetime', round(mod(RESOURCE_TS, 1125899906842624)/1000)) AS RESOURCE_TS
    , dbinfo ('utc_to_datetime', round(mod(RUNNABLE_TS, 1125899906842624)/1000)) AS RUNNABLE_TS
    , dbinfo ('utc_to_datetime', round(mod(START_TS, 1125899906842624)/1000)) AS START_TS
    , dbinfo ('utc_to_datetime', round(mod(FINSH_TS, 1125899906842624)/1000)) AS FINSH_TS
    , dbinfo ('utc_to_datetime', round(mod(FINAL_TS, 1125899906842624)/1000)) AS FINAL_TS
    , IDLE_TIME                      AS IDLE_TIME
    , DEPENDENCY_WAIT_TIME           AS DEPENDENCY_WAIT_TIME
    , SUSPEND_TIME                   AS SUSPEND_TIME
    , SYNC_TIME                      AS SYNC_TIME
    , RESOURCE_TIME                  AS RESOURCE_TIME
    , JOBSERVER_TIME                 AS JOBSERVER_TIME
    , RESTARTABLE_TIME               AS RESTARTABLE_TIME
    , CHILD_WAIT_TIME                AS CHILD_WAIT_TIME
    , OP_SUSRES_TS                   AS OP_SUSRES_TS
    , NPE_ID                         AS NPE_ID
    , TIME_ZONE                      AS TIME_ZONE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , ((NVL(FINAL_TS, dbinfo ('utc_current') * 1000) - SUBMIT_TS) / 1000) - DEPENDENCY_WAIT_TIME AS PROCESS_TIME
  FROM SUBMITTED_ENTITY;
CREATE TABLE ARC_SUBMITTED_ENTITY (
    ID                             bigint NOT NULL
    , ACCESS_KEY                     bigint           NULL
    , MASTER_ID                      bigint           NULL
    , SUBMIT_TAG                     lvarchar(32)     NULL
    , UNRESOLVED_HANDLING            int8             NULL
    , SE_ID                          bigint           NULL
    , CHILD_TAG                      lvarchar(70)     NULL
    , SE_VERSION                     bigint           NULL
    , OWNER_ID                       bigint           NULL
    , PARENT_ID                      bigint           NULL
    , SCOPE_ID                       bigint           NULL
    , IS_STATIC                      integer          NULL
    , IS_DISABLED                    integer          NULL
    , OLD_STATE                      int8             NULL
    , MERGE_MODE                     int8             NULL
    , STATE                          int8             NULL
    , JOB_ESD_ID                     bigint           NULL
    , JOB_ESD_PREF                   int8             NULL
    , JOB_IS_FINAL                   integer          NULL
    , JOB_IS_RESTARTABLE             integer          NULL
    , FINAL_ESD_ID                   bigint           NULL
    , EXIT_CODE                      int8             NULL
    , COMMANDLINE                    lvarchar(512)    NULL
    , RR_COMMANDLINE                 lvarchar(512)    NULL
    , RERUN_SEQ                      int8             NULL
    , IS_REPLACED                    integer          NULL
    , IS_CANCELLED                   integer          NULL
    , BASE_SME_ID                    bigint           NULL
    , REASON_SME_ID                  bigint           NULL
    , FIRE_SME_ID                    bigint           NULL
    , FIRE_SE_ID                     bigint           NULL
    , TR_ID                          bigint           NULL
    , TR_SD_ID_OLD                   bigint           NULL
    , TR_SD_ID_NEW                   bigint           NULL
    , TR_SEQ                         int8             NULL
    , WORKDIR                        lvarchar(512)    NULL
    , LOGFILE                        lvarchar(512)    NULL
    , ERRLOGFILE                     lvarchar(512)    NULL
    , PID                            lvarchar(32)     NULL
    , EXTPID                         lvarchar(32)     NULL
    , ERROR_MSG                      lvarchar(256)    NULL
    , KILL_ID                        bigint           NULL
    , KILL_EXIT_CODE                 int8             NULL
    , IS_SUSPENDED                   int8             NULL
    , IS_SUSPENDED_LOCAL             integer          NULL
    , PRIORITY                       int8             NULL
    , RAW_PRIORITY                   int8             NULL
    , NICE                           int8             NULL
    , NP_NICE                        int8             NULL
    , MIN_PRIORITY                   int8             NULL
    , AGING_AMOUNT                   int8             NULL
    , PARENT_SUSPENDED               int8             NULL
    , CHILD_SUSPENDED                int8             NULL
    , WARN_COUNT                     int8             NULL
    , WARN_LINK                      bigint           NULL
    , APPROVAL_MODE                  int8             NULL
    , CHILD_APPROVAL_MODE            int8             NULL
    , SUBMIT_TS                      bigint           NULL
    , RESUME_TS                      bigint           NULL
    , SYNC_TS                        bigint           NULL
    , RESOURCE_TS                    bigint           NULL
    , RUNNABLE_TS                    bigint           NULL
    , START_TS                       bigint           NULL
    , FINSH_TS                       bigint           NULL
    , FINAL_TS                       bigint           NULL
    , CNT_SUBMITTED                  int8             NULL
    , CNT_DEPENDENCY_WAIT            int8             NULL
    , CNT_SYNCHRONIZE_WAIT           int8             NULL
    , CNT_RESOURCE_WAIT              int8             NULL
    , CNT_RUNNABLE                   int8             NULL
    , CNT_STARTING                   int8             NULL
    , CNT_STARTED                    int8             NULL
    , CNT_RUNNING                    int8             NULL
    , CNT_TO_KILL                    int8             NULL
    , CNT_KILLED                     int8             NULL
    , CNT_CANCELLED                  int8             NULL
    , CNT_FINISHED                   int8             NULL
    , CNT_FINAL                      int8             NULL
    , CNT_BROKEN_ACTIVE              int8             NULL
    , CNT_BROKEN_FINISHED            int8             NULL
    , CNT_ERROR                      int8             NULL
    , CNT_UNREACHABLE                int8             NULL
    , CNT_RESTARTABLE                int8             NULL
    , CNT_WARN                       int8             NULL
    , CNT_PENDING                    int8             NULL
    , IDLE_TS                        int8             NULL
    , IDLE_TIME                      int8             NULL
    , STATISTIC_TS                   int8             NULL
    , DEPENDENCY_WAIT_TIME           int8             NULL
    , SUSPEND_TIME                   int8             NULL
    , SYNC_TIME                      int8             NULL
    , RESOURCE_TIME                  int8             NULL
    , JOBSERVER_TIME                 int8             NULL
    , RESTARTABLE_TIME               int8             NULL
    , CHILD_WAIT_TIME                int8             NULL
    , OP_SUSRES_TS                   bigint           NULL
    , NPE_ID                         bigint           NULL
    , TIME_ZONE                      lvarchar(32)     NULL
    , CREATOR_U_ID                   bigint           NULL
    , CREATE_TS                      bigint           NULL
    , CHANGER_U_ID                   bigint           NULL
    , CHANGE_TS                      bigint           NULL
);
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE SUBMITTED_ENTITY_STATS (
    ID                             bigint NOT NULL
    , SME_ID                         bigint          NOT NULL
    , RERUN_SEQ                      int8            NOT NULL
    , SCOPE_ID                       bigint              NULL
    , JOB_ESD_ID                     bigint              NULL
    , EXIT_CODE                      int8                NULL
    , COMMANDLINE                    lvarchar(512)       NULL
    , WORKDIR                        lvarchar(512)       NULL
    , LOGFILE                        lvarchar(512)       NULL
    , ERRLOGFILE                     lvarchar(512)       NULL
    , EXTPID                         lvarchar(32)        NULL
    , SYNC_TS                        bigint              NULL
    , RESOURCE_TS                    bigint              NULL
    , RUNNABLE_TS                    bigint              NULL
    , START_TS                       bigint              NULL
    , FINISH_TS                      bigint              NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_SUBMITTED_ENTITY_STATS
ON SUBMITTED_ENTITY_STATS(ID);
CREATE VIEW SCI_SUBMITTED_ENTITY_STATS (ID,SME_ID,RERUN_SEQ,SCOPE_ID,JOB_ESD_ID,EXIT_CODE,COMMANDLINE,WORKDIR,LOGFILE,ERRLOGFILE,EXTPID,SYNC_TS,RESOURCE_TS,RUNNABLE_TS,START_TS,FINISH_TS,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , SME_ID                         AS SME_ID
    , RERUN_SEQ                      AS RERUN_SEQ
    , SCOPE_ID                       AS SCOPE_ID
    , JOB_ESD_ID                     AS JOB_ESD_ID
    , EXIT_CODE                      AS EXIT_CODE
    , COMMANDLINE                    AS COMMANDLINE
    , WORKDIR                        AS WORKDIR
    , LOGFILE                        AS LOGFILE
    , ERRLOGFILE                     AS ERRLOGFILE
    , EXTPID                         AS EXTPID
    , dbinfo ('utc_to_datetime', round(mod(SYNC_TS, 1125899906842624)/1000)) AS SYNC_TS
    , dbinfo ('utc_to_datetime', round(mod(RESOURCE_TS, 1125899906842624)/1000)) AS RESOURCE_TS
    , dbinfo ('utc_to_datetime', round(mod(RUNNABLE_TS, 1125899906842624)/1000)) AS RUNNABLE_TS
    , dbinfo ('utc_to_datetime', round(mod(START_TS, 1125899906842624)/1000)) AS START_TS
    , dbinfo ('utc_to_datetime', round(mod(FINISH_TS, 1125899906842624)/1000)) AS FINISH_TS
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM SUBMITTED_ENTITY_STATS;
CREATE TABLE ARC_SUBMITTED_ENTITY_STATS (
    ID                             bigint NOT NULL
    , SME_ID                         bigint           NULL
    , RERUN_SEQ                      int8             NULL
    , SCOPE_ID                       bigint           NULL
    , JOB_ESD_ID                     bigint           NULL
    , EXIT_CODE                      int8             NULL
    , COMMANDLINE                    lvarchar(512)    NULL
    , WORKDIR                        lvarchar(512)    NULL
    , LOGFILE                        lvarchar(512)    NULL
    , ERRLOGFILE                     lvarchar(512)    NULL
    , EXTPID                         lvarchar(32)     NULL
    , SYNC_TS                        bigint           NULL
    , RESOURCE_TS                    bigint           NULL
    , RUNNABLE_TS                    bigint           NULL
    , START_TS                       bigint           NULL
    , FINISH_TS                      bigint           NULL
    , CREATOR_U_ID                   bigint           NULL
    , CREATE_TS                      bigint           NULL
    , CHANGER_U_ID                   bigint           NULL
    , CHANGE_TS                      bigint           NULL
);
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE SYSTEM_MESSAGE (
    ID                             bigint NOT NULL
    , MSG_TYPE                       int8            NOT NULL
    , SME_ID                         bigint          NOT NULL
    , MASTER_ID                      bigint          NOT NULL
    , OPERATION                      int8            NOT NULL
    , IS_MANDATORY                   integer         NOT NULL
    , REQUEST_U_ID                   bigint          NOT NULL
    , REQUEST_TS                     bigint          NOT NULL
    , REQUEST_MSG                    lvarchar(512)       NULL
    , ADDITIONAL_LONG                bigint              NULL
    , ADDITIONAL_BOOL                integer             NULL
    , SECOND_LONG                    bigint              NULL
    , COMMENT                        lvarchar(1024)      NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_SYSTEM_MESSAGE
ON SYSTEM_MESSAGE(ID);
CREATE VIEW SCI_SYSTEM_MESSAGE (ID,MSG_TYPE,SME_ID,MASTER_ID,OPERATION,IS_MANDATORY,REQUEST_U_ID,REQUEST_TS,REQUEST_MSG,ADDITIONAL_LONG,ADDITIONAL_BOOL,SECOND_LONG,COMMENT,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , DECODE (MSG_TYPE, 1, 'APPROVAL') AS MSG_TYPE
    , SME_ID                         AS SME_ID
    , MASTER_ID                      AS MASTER_ID
    , DECODE (OPERATION, 1, 'CANCEL', 2, 'RERUN', 3, 'ENABLE', 4, 'SET_STATE', 5, 'IGN_DEPENDENCY', 6, 'IGN_RESOURCE', 7, 'CLONE', 11, 'MODIFY_PARAMETER', 12, 'KILL', 23, 'DISABLE', 13, 'SET_JOB_STATE') AS OPERATION
    , DECODE (IS_MANDATORY, 1, 'TRUE', 0, 'FALSE') AS IS_MANDATORY
    , REQUEST_U_ID                   AS REQUEST_U_ID
    , dbinfo ('utc_to_datetime', round(mod(REQUEST_TS, 1125899906842624)/1000)) AS REQUEST_TS
    , REQUEST_MSG                    AS REQUEST_MSG
    , ADDITIONAL_LONG                AS ADDITIONAL_LONG
    , DECODE (ADDITIONAL_BOOL, 1, 'TRUE', 0, 'FALSE') AS ADDITIONAL_BOOL
    , SECOND_LONG                    AS SECOND_LONG
    , COMMENT                        AS COMMENT
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM SYSTEM_MESSAGE;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE TEMPLATE_VARIABLE (
    ID                             bigint NOT NULL
    , PD_ID                          bigint          NOT NULL
    , RT_ID                          bigint          NOT NULL
    , VALUE                          lvarchar(256)   NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , VALID_FROM                   bigint NOT NULL
    , VALID_TO                     bigint NOT NULL
);
CREATE INDEX PK_TEMPLATE_VARIABLE
ON TEMPLATE_VARIABLE(ID);
CREATE VIEW SCI_C_TEMPLATE_VARIABLE (ID,PD_ID,RT_ID,VALUE,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , PD_ID                          AS PD_ID
    , RT_ID                          AS RT_ID
    , VALUE                          AS VALUE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM TEMPLATE_VARIABLE
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_TEMPLATE_VARIABLE (ID,PD_ID,RT_ID,VALUE,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , PD_ID                          AS PD_ID
    , RT_ID                          AS RT_ID
    , VALUE                          AS VALUE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM TEMPLATE_VARIABLE;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE TRIGGER_DEFINITION (
    ID                             bigint NOT NULL
    , NAME                           lvarchar(64)    NOT NULL
    , FIRE_ID                        bigint          NOT NULL
    , OBJECT_TYPE                    int8            NOT NULL
    , SE_ID                          bigint          NOT NULL
    , MAIN_SE_ID                     bigint              NULL
    , PARENT_SE_ID                   bigint              NULL
    , IS_ACTIVE                      integer         NOT NULL
    , IS_INVERSE                     integer         NOT NULL
    , ACTION                         int8            NOT NULL
    , TYPE                           int8            NOT NULL
    , IS_MASTER                      integer         NOT NULL
    , IS_SUSPEND                     integer         NOT NULL
    , IS_CREATE                      integer             NULL
    , IS_CHANGE                      integer             NULL
    , IS_DELETE                      integer             NULL
    , IS_GROUP                       integer             NULL
    , RESUME_AT                      lvarchar(20)        NULL
    , RESUME_IN                      int8                NULL
    , RESUME_BASE                    int8                NULL
    , IS_WARN_ON_LIMIT               integer         NOT NULL
    , LIMIT_STATE                    bigint              NULL
    , MAX_RETRY                      int8            NOT NULL
    , SUBMIT_OWNER_ID                bigint              NULL
    , CONDITION                      lvarchar(1024)      NULL
    , CHECK_AMOUNT                   int8                NULL
    , CHECK_BASE                     int8                NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , VALID_FROM                   bigint NOT NULL
    , VALID_TO                     bigint NOT NULL
);
CREATE INDEX PK_TRIGGER_DEFINITION
ON TRIGGER_DEFINITION(ID);
CREATE VIEW SCI_C_TRIGGER_DEFINITION (ID,NAME,FIRE_ID,OBJECT_TYPE,SE_ID,MAIN_SE_ID,PARENT_SE_ID,IS_ACTIVE,IS_INVERSE,ACTION,TYPE,IS_MASTER,IS_SUSPEND,IS_CREATE,IS_CHANGE,IS_DELETE,IS_GROUP,RESUME_AT,RESUME_IN,RESUME_BASE,IS_WARN_ON_LIMIT,LIMIT_STATE,MAX_RETRY,SUBMIT_OWNER_ID,CONDITION,CHECK_AMOUNT,CHECK_BASE,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , FIRE_ID                        AS FIRE_ID
    , DECODE (OBJECT_TYPE, 0, 'JOB_DEFINITION', 1, 'RESOURCE', 2, 'NAMED_RESOURCE', 3, 'OBJECT_MONITOR') AS OBJECT_TYPE
    , SE_ID                          AS SE_ID
    , MAIN_SE_ID                     AS MAIN_SE_ID
    , PARENT_SE_ID                   AS PARENT_SE_ID
    , DECODE (IS_ACTIVE, 1, 'TRUE', 0, 'FALSE') AS IS_ACTIVE
    , DECODE (IS_INVERSE, 1, 'TRUE', 0, 'FALSE') AS IS_INVERSE
    , DECODE (ACTION, 0, 'SUBMIT', 1, 'RERUN') AS ACTION
    , DECODE (TYPE, 0, 'IMMEDIATE_LOCAL', 2, 'BEFORE_FINAL', 3, 'AFTER_FINAL', 1, 'IMMEDIATE_MERGE', 4, 'FINISH_CHILD', 5, 'UNTIL_FINISHED', 6, 'UNTIL_FINAL', 7, 'WARNING') AS TYPE
    , DECODE (IS_MASTER, 1, 'MASTER', 0, 'NOMASTER') AS IS_MASTER
    , DECODE (IS_SUSPEND, 1, 'SUSPEND', 0, 'NOSUSPEND') AS IS_SUSPEND
    , DECODE (IS_CREATE, 1, 'TRUE', 0, 'FALSE') AS IS_CREATE
    , DECODE (IS_CHANGE, 1, 'TRUE', 0, 'FALSE') AS IS_CHANGE
    , DECODE (IS_DELETE, 1, 'TRUE', 0, 'FALSE') AS IS_DELETE
    , DECODE (IS_GROUP, 1, 'TRUE', 0, 'FALSE') AS IS_GROUP
    , RESUME_AT                      AS RESUME_AT
    , RESUME_IN                      AS RESUME_IN
    , DECODE (RESUME_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS RESUME_BASE
    , DECODE (IS_WARN_ON_LIMIT, 1, 'TRUE', 0, 'FALSE') AS IS_WARN_ON_LIMIT
    , LIMIT_STATE                    AS LIMIT_STATE
    , MAX_RETRY                      AS MAX_RETRY
    , SUBMIT_OWNER_ID                AS SUBMIT_OWNER_ID
    , CONDITION                      AS CONDITION
    , CHECK_AMOUNT                   AS CHECK_AMOUNT
    , DECODE (CHECK_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS CHECK_BASE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM TRIGGER_DEFINITION
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_TRIGGER_DEFINITION (ID,NAME,FIRE_ID,OBJECT_TYPE,SE_ID,MAIN_SE_ID,PARENT_SE_ID,IS_ACTIVE,IS_INVERSE,ACTION,TYPE,IS_MASTER,IS_SUSPEND,IS_CREATE,IS_CHANGE,IS_DELETE,IS_GROUP,RESUME_AT,RESUME_IN,RESUME_BASE,IS_WARN_ON_LIMIT,LIMIT_STATE,MAX_RETRY,SUBMIT_OWNER_ID,CONDITION,CHECK_AMOUNT,CHECK_BASE,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , FIRE_ID                        AS FIRE_ID
    , DECODE (OBJECT_TYPE, 0, 'JOB_DEFINITION', 1, 'RESOURCE', 2, 'NAMED_RESOURCE', 3, 'OBJECT_MONITOR') AS OBJECT_TYPE
    , SE_ID                          AS SE_ID
    , MAIN_SE_ID                     AS MAIN_SE_ID
    , PARENT_SE_ID                   AS PARENT_SE_ID
    , DECODE (IS_ACTIVE, 1, 'TRUE', 0, 'FALSE') AS IS_ACTIVE
    , DECODE (IS_INVERSE, 1, 'TRUE', 0, 'FALSE') AS IS_INVERSE
    , DECODE (ACTION, 0, 'SUBMIT', 1, 'RERUN') AS ACTION
    , DECODE (TYPE, 0, 'IMMEDIATE_LOCAL', 2, 'BEFORE_FINAL', 3, 'AFTER_FINAL', 1, 'IMMEDIATE_MERGE', 4, 'FINISH_CHILD', 5, 'UNTIL_FINISHED', 6, 'UNTIL_FINAL', 7, 'WARNING') AS TYPE
    , DECODE (IS_MASTER, 1, 'MASTER', 0, 'NOMASTER') AS IS_MASTER
    , DECODE (IS_SUSPEND, 1, 'SUSPEND', 0, 'NOSUSPEND') AS IS_SUSPEND
    , DECODE (IS_CREATE, 1, 'TRUE', 0, 'FALSE') AS IS_CREATE
    , DECODE (IS_CHANGE, 1, 'TRUE', 0, 'FALSE') AS IS_CHANGE
    , DECODE (IS_DELETE, 1, 'TRUE', 0, 'FALSE') AS IS_DELETE
    , DECODE (IS_GROUP, 1, 'TRUE', 0, 'FALSE') AS IS_GROUP
    , RESUME_AT                      AS RESUME_AT
    , RESUME_IN                      AS RESUME_IN
    , DECODE (RESUME_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS RESUME_BASE
    , DECODE (IS_WARN_ON_LIMIT, 1, 'TRUE', 0, 'FALSE') AS IS_WARN_ON_LIMIT
    , LIMIT_STATE                    AS LIMIT_STATE
    , MAX_RETRY                      AS MAX_RETRY
    , SUBMIT_OWNER_ID                AS SUBMIT_OWNER_ID
    , CONDITION                      AS CONDITION
    , CHECK_AMOUNT                   AS CHECK_AMOUNT
    , DECODE (CHECK_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS CHECK_BASE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM TRIGGER_DEFINITION;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE TRIGGER_PARAMETER (
    ID                             bigint NOT NULL
    , NAME                           lvarchar(64)    NOT NULL
    , EXPRESSION                     lvarchar(1024)  NOT NULL
    , TRIGGER_ID                     bigint          NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , VALID_FROM                   bigint NOT NULL
    , VALID_TO                     bigint NOT NULL
);
CREATE INDEX PK_TRIGGER_PARAMETER
ON TRIGGER_PARAMETER(ID);
CREATE VIEW SCI_C_TRIGGER_PARAMETER (ID,NAME,EXPRESSION,TRIGGER_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , EXPRESSION                     AS EXPRESSION
    , TRIGGER_ID                     AS TRIGGER_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM TRIGGER_PARAMETER
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_TRIGGER_PARAMETER (ID,NAME,EXPRESSION,TRIGGER_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , EXPRESSION                     AS EXPRESSION
    , TRIGGER_ID                     AS TRIGGER_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM TRIGGER_PARAMETER;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE TRIGGER_QUEUE (
    ID                             bigint NOT NULL
    , SME_ID                         bigint          NOT NULL
    , TR_ID                          bigint          NOT NULL
    , NEXT_TRIGGER_TIME              bigint          NOT NULL
    , TIMES_CHECKED                  int8            NOT NULL
    , TIMES_TRIGGERED                int8            NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_TRIGGER_QUEUE
ON TRIGGER_QUEUE(ID);
CREATE VIEW SCI_TRIGGER_QUEUE (ID,SME_ID,TR_ID,NEXT_TRIGGER_TIME,TIMES_CHECKED,TIMES_TRIGGERED,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , SME_ID                         AS SME_ID
    , TR_ID                          AS TR_ID
    , NEXT_TRIGGER_TIME              AS NEXT_TRIGGER_TIME
    , TIMES_CHECKED                  AS TIMES_CHECKED
    , TIMES_TRIGGERED                AS TIMES_TRIGGERED
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM TRIGGER_QUEUE;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE TRIGGER_STATE (
    ID                             bigint NOT NULL
    , TRIGGER_ID                     bigint          NOT NULL
    , FROM_STATE_ID                  bigint              NULL
    , TO_STATE_ID                    bigint              NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , VALID_FROM                   bigint NOT NULL
    , VALID_TO                     bigint NOT NULL
);
CREATE INDEX PK_TRIGGER_STATE
ON TRIGGER_STATE(ID);
CREATE VIEW SCI_C_TRIGGER_STATE (ID,TRIGGER_ID,FROM_STATE_ID,TO_STATE_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , TRIGGER_ID                     AS TRIGGER_ID
    , FROM_STATE_ID                  AS FROM_STATE_ID
    , TO_STATE_ID                    AS TO_STATE_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM TRIGGER_STATE
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_TRIGGER_STATE (ID,TRIGGER_ID,FROM_STATE_ID,TO_STATE_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , TRIGGER_ID                     AS TRIGGER_ID
    , FROM_STATE_ID                  AS FROM_STATE_ID
    , TO_STATE_ID                    AS TO_STATE_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM TRIGGER_STATE;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE USER_EQUIV (
    ID                             bigint NOT NULL
    , U_ID                           bigint          NOT NULL
    , ALT_U_TYPE                     int8            NOT NULL
    , ALT_U_ID                       bigint          NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_USER_EQUIV
ON USER_EQUIV(ID);
CREATE VIEW SCI_USER_EQUIV (ID,U_ID,ALT_U_TYPE,ALT_U_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , U_ID                           AS U_ID
    , DECODE (ALT_U_TYPE, 0, 'USER', 1, 'SERVER') AS ALT_U_TYPE
    , ALT_U_ID                       AS ALT_U_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM USER_EQUIV;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE USER_EXTENTS (
    ID                             bigint NOT NULL
    , UP_ID                          bigint          NOT NULL
    , SEQUENCE                       int8            NOT NULL
    , EXTENT                         lvarchar(256)   NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_USER_EXTENTS
ON USER_EXTENTS(ID);
CREATE VIEW SCI_USER_EXTENTS (ID,UP_ID,SEQUENCE,EXTENT,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , UP_ID                          AS UP_ID
    , SEQUENCE                       AS SEQUENCE
    , EXTENT                         AS EXTENT
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM USER_EXTENTS;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE USER_PARAMETER (
    ID                             bigint NOT NULL
    , U_ID                           bigint          NOT NULL
    , NAME                           lvarchar(64)    NOT NULL
    , VALUE                          lvarchar(256)       NULL
    , IS_LONG                        integer         NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_USER_PARAMETER
ON USER_PARAMETER(ID);
CREATE VIEW SCI_USER_PARAMETER (ID,U_ID,NAME,VALUE,IS_LONG,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , U_ID                           AS U_ID
    , NAME                           AS NAME
    , VALUE                          AS VALUE
    , DECODE (IS_LONG, 1, 'TRUE', 0, 'FALSE') AS IS_LONG
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM USER_PARAMETER;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE USERS (
    ID                             bigint NOT NULL
    , NAME                           lvarchar(64)    NOT NULL
    , PASSWD                         lvarchar(64)    NOT NULL
    , SALT                           lvarchar(64)        NULL
    , METHOD                         int8            NOT NULL
    , IS_ENABLED                     integer         NOT NULL
    , DEFAULT_G_ID                   bigint          NOT NULL
    , CONNECTION_TYPE                int8            NOT NULL
    , DELETE_VERSION                 bigint          NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_USERS
ON USERS(ID);
CREATE VIEW SCI_USERS (ID,NAME,IS_ENABLED,DEFAULT_G_ID,CONNECTION_TYPE,DELETE_VERSION,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , DECODE (IS_ENABLED, 1, 'TRUE', 0, 'FALSE') AS IS_ENABLED
    , DEFAULT_G_ID                   AS DEFAULT_G_ID
    , DECODE (CONNECTION_TYPE, 0, 'PLAIN', 1, 'SSL', 2, 'SSL_AUTH') AS CONNECTION_TYPE
    , DELETE_VERSION                 AS DELETE_VERSION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM USERS;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE VERSIONED_EXTENTS (
    ID                             bigint NOT NULL
    , O_ID                           bigint          NOT NULL
    , SEQUENCE                       int8            NOT NULL
    , EXTENT                         lvarchar(256)   NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , VALID_FROM                   bigint NOT NULL
    , VALID_TO                     bigint NOT NULL
);
CREATE INDEX PK_VERSIONED_EXTENTS
ON VERSIONED_EXTENTS(ID);
CREATE VIEW SCI_C_VERSIONED_EXTENTS (ID,O_ID,SEQUENCE,EXTENT,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , O_ID                           AS O_ID
    , SEQUENCE                       AS SEQUENCE
    , EXTENT                         AS EXTENT
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM VERSIONED_EXTENTS
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_VERSIONED_EXTENTS (ID,O_ID,SEQUENCE,EXTENT,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , O_ID                           AS O_ID
    , SEQUENCE                       AS SEQUENCE
    , EXTENT                         AS EXTENT
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM VERSIONED_EXTENTS;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE WATCH_TYPE_PARAMETER (
    ID                             bigint NOT NULL
    , NAME                           lvarchar(64)    NOT NULL
    , DEFAULTVALUE                   lvarchar(256)       NULL
    , WT_ID                          bigint          NOT NULL
    , IS_SUBMIT_PAR                  integer         NOT NULL
    , TYPE                           int8            NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_WATCH_TYPE_PARAMETER
ON WATCH_TYPE_PARAMETER(ID);
CREATE VIEW SCI_WATCH_TYPE_PARAMETER (ID,NAME,DEFAULTVALUE,WT_ID,IS_SUBMIT_PAR,TYPE,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , DEFAULTVALUE                   AS DEFAULTVALUE
    , WT_ID                          AS WT_ID
    , DECODE (IS_SUBMIT_PAR, 1, 'TRUE', 0, 'FALSE') AS IS_SUBMIT_PAR
    , DECODE (TYPE, 1, 'CONFIG', 2, 'VALUE', 3, 'INFO') AS TYPE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM WATCH_TYPE_PARAMETER;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE WATCH_TYPE (
    ID                             bigint NOT NULL
    , NAME                           lvarchar(64)    NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , VALID_FROM                   bigint NOT NULL
    , VALID_TO                     bigint NOT NULL
);
CREATE INDEX PK_WATCH_TYPE
ON WATCH_TYPE(ID);
CREATE VIEW SCI_C_WATCH_TYPE (ID,NAME,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM WATCH_TYPE
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_WATCH_TYPE (ID,NAME,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM WATCH_TYPE;
/*
** $Id: OBJECTCOUNTER.sql,v 1.2 2006/02/11 00:40:46 bernhard Exp $
**
** Copyright (C) 2001 topIT Informationstechnologie GmbH
** Copyright (C) 2006 independIT Integrative Technologies GmbH
*/

CREATE TABLE objectcounter (
	lastid BIGINT NOT NULL
);
/*
** $Id: VERSIONCOUNTER.sql,v 1.2 2006/02/11 00:40:46 bernhard Exp $
**
** Copyright (C) 2001 topIT Informationstechnologie GmbH
** Copyright (C) 2006 independIT Integrative Technologies GmbH
*/

CREATE TABLE versioncounter (
	lastId	BIGINT not null
);
/*
** $Id: REPOSITORY_LOCK.sql,v 1.3 2008/02/25 15:51:55 dieter Exp $
**
** Copyright (C) 2001 topIT Informationstechnologie GmbH
** Copyright (C) 2006 independIT Integrative Technologies GmbH
*/

CREATE TABLE REPOSITORY_LOCK (
	LOCKID INTEGER NOT NULL,
	TS     DECIMAL(20) NOT NULL,
	TICKET DECIMAL(20) NOT NULL,
	IPS    VARCHAR(256)
);

CREATE UNIQUE INDEX PK_REPOSITORY_LOCK
ON REPOSITORY_LOCK (LOCKID);
/*
** $Id: MASTER_STATE.sql,v 1.3 2008/02/25 15:51:55 dieter Exp $
**
** Copyright (C) 2001 topIT Informationstechnologie GmbH
** Copyright (C) 2006 independIT Integrative Technologies GmbH
*/

CREATE VIEW MASTER_STATE ( MS_M_ID, MS_C_ID, MS_M_STATE, MS_M_FINAL_TS )
AS
SELECT M.ID, C.ID, M.STATE, M.FINAL_TS
  FROM SUBMITTED_ENTITY M,
       SUBMITTED_ENTITY C
 WHERE M.ID = C.MASTER_ID;
/*
** Copyright (C) 2013 independIT Integrative Technologies GmbH
*/

CREATE TABLE sme2load (
	id         BIGINT NOT NULL
);
/*
** Copyright (C) 2014 independIT Integrative Technologies GmbH
*/

CREATE INDEX SME2LOAD_IDX ON SME2LOAD (ID);
CREATE INDEX SME_IDX ON SUBMITTED_ENTITY (MASTER_ID, ID, STATE, FINAL_TS);
CREATE INDEX KILL_JOB_IDX ON KILL_JOB (SME_ID);
CREATE INDEX AUDIT_TRAIL_IDX ON AUDIT_TRAIL (OBJECT_ID);
CREATE INDEX ENTITY_VARIABLE_IDX ON ENTITY_VARIABLE (SME_ID);
CREATE INDEX DEPENDENCY_INSTANCE_IDX ON DEPENDENCY_INSTANCE (DEPENDENT_ID);
CREATE INDEX HIERARCHY_INSTANCE_IDX ON HIERARCHY_INSTANCE (CHILD_ID);
/*
** $Id: init.sql,v 1.8 2013/01/31 12:58:19 dieter Exp $
**
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
**
** D O N ' T   F O R G E T   T O   U P D A T E  mysql/init.sql ! ! ! ! ! ! !
**
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
**
** Copyright (C) 2001 topIT Informationstechnologie GmbH
** Copyright (C) 2006 independIT Integrative Technologies GmbH
*/

--------------------------------------------------------------------------------
--	Table "OBJECTCOUNTER"
--------------------------------------------------------------------------------

INSERT INTO OBJECTCOUNTER VALUES (1000);

--------------------------------------------------------------------------------
--	Table "VERSIONCOUNTER"
--------------------------------------------------------------------------------

INSERT INTO VERSIONCOUNTER VALUES (1);

--------------------------------------------------------------------------------
--	Table "GROUP"
--------------------------------------------------------------------------------

INSERT INTO GROUPS (ID, NAME,     DELETE_VERSION, CREATOR_U_ID, CREATE_TS, CHANGER_U_ID, CHANGE_TS)
	VALUES     (80, 'PUBLIC', 0,              0,            0,         0,            0);

-- IMPORTANT!!!
--	If this ID is changed, it also has to be changed in SDMSObject.java
INSERT INTO GROUPS (ID, NAME,    DELETE_VERSION, CREATOR_U_ID, CREATE_TS, CHANGER_U_ID, CHANGE_TS)
	VALUES     (81, 'ADMIN', 0,              0,            0,         0,            0);

--------------------------------------------------------------------------------
--	Table "user"
--------------------------------------------------------------------------------

INSERT INTO USERS (ID, NAME,           PASSWD,                                SALT, METHOD, IS_ENABLED, DEFAULT_G_ID, CONNECTION_TYPE, DELETE_VERSION, CREATOR_U_ID, CREATE_TS, CHANGER_U_ID, CHANGE_TS)
	VALUES    (0,  'SYSTEM',       'ba143b7e 75dde00e 8f0fd6f4 6cf65faf', null, 0,      1,          81,           0,               0,              0,            0,         0,            0);

INSERT INTO USERS (ID, NAME,           PASSWD,                                SALT, METHOD, IS_ENABLED, DEFAULT_G_ID, CONNECTION_TYPE, DELETE_VERSION, CREATOR_U_ID, CREATE_TS, CHANGER_U_ID, CHANGE_TS)
	VALUES    (1,  'NOBODY',       'xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx', null, 0,      0,          80,           0,               0,              0,            0,         0,            0);
 
INSERT INTO USERS (ID, NAME,           PASSWD,                                SALT, METHOD, IS_ENABLED, DEFAULT_G_ID, CONNECTION_TYPE, DELETE_VERSION, CREATOR_U_ID, CREATE_TS, CHANGER_U_ID, CHANGE_TS)
	VALUES    (2,  'INTERNAL',     'xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx', null, 0,      0,          81,           0,               0,              0,            0,         0,            0);

INSERT INTO USERS (ID, NAME,           PASSWD,                                SALT, METHOD, IS_ENABLED, DEFAULT_G_ID, CONNECTION_TYPE, DELETE_VERSION, CREATOR_U_ID, CREATE_TS, CHANGER_U_ID, CHANGE_TS)
       VALUES     (3, 'FE_PROPERTIES', 'xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx', null, 0,      0,          80,           0,               0,              0,            0,         0,            0);

--------------------------------------------------------------------------------
--	Table "SCHEDULING HIERARCHY"
--------------------------------------------------------------------------------

-- Create Dummy scheduling hierarchy for triggers without child definition
-- IMPORTANT!!!
--	If this ID is changed, it also has to be changed in SDMSObject.java
INSERT INTO SCHEDULING_HIERARCHY (
	ID, SE_PARENT_ID, SE_CHILD_ID, ALIAS_NAME, IS_STATIC, IS_DISABLED, PRIORITY, SUSPEND, MERGE_MODE, ESTP_ID, ENABLE_MODE,
	CREATOR_U_ID, CREATE_TS, CHANGER_U_ID, CHANGE_TS, VALID_FROM, VALID_TO)
VALUES (
	30, NULL,         NULL,        NULL,       0,         0,           0,        1,       3,          NULL,    1,
	0, 0, 0, 0, 0, 9223372036854775807);

--------------------------------------------------------------------------------
--	Table "FOLDER"
--------------------------------------------------------------------------------

-- Create SYSTEM folder owned by ADMIN without parent
INSERT INTO FOLDER (ID, NAME,     OWNER_ID, ENV_ID, PARENT_ID, VALID_FROM, VALID_TO,            CREATOR_U_ID, CREATE_TS, CHANGER_U_ID, CHANGE_TS, INHERIT_PRIVS)
	VALUES     (40, 'SYSTEM', 81,       NULL,   NULL,      0,          9223372036854775807, 0,            0,         0,            0,         0);

--------------------------------------------------------------------------------
--	Table "SCOPE"
--------------------------------------------------------------------------------

-- Create GLOBAL scope owned by ADMIN without parent
INSERT INTO SCOPE (ID, NAME,     OWNER_ID, TYPE, METHOD, CREATOR_U_ID, CREATE_TS, CHANGER_U_ID, CHANGE_TS, INHERIT_PRIVS)
	VALUES    (50, 'GLOBAL', 81,       1,    0,      0,            0,         0,            0,         0);

--------------------------------------------------------------------------------
--	Table "NAMED_RESOURCE"
--------------------------------------------------------------------------------

-- Create RESOURCE category owned by ADMIN without parent
INSERT INTO NAMED_RESOURCE (ID, NAME,       OWNER_ID, PARENT_ID, USAGE, RSP_ID, CREATOR_U_ID, CREATE_TS, CHANGER_U_ID, CHANGE_TS, INHERIT_PRIVS)
	VALUES             (60, 'RESOURCE', 81,       NULL,      8,     NULL,   0,            0,         0,            0,         0);

--------------------------------------------------------------------------------
--	Table "SCHEDULE"
--------------------------------------------------------------------------------

-- Create ROOT schedule owned by ADMIN without parent
-- IMPORTANT!!!
--	If this ID is changed, it also has to be changed in BICsuite!web SDMS/SDMSDesigner/Schedules/NavigatorQueryMethod
INSERT INTO SCHEDULE (ID, NAME,   OWNER_ID, INT_ID, PARENT_ID, CREATOR_U_ID, CREATE_TS, CHANGER_U_ID, CHANGE_TS, ACTIVE, INHERIT_PRIVS, TIME_ZONE)
	VALUES       (70, 'ROOT', 81,       NULL,   NULL,      0,            0,         0,            0,         1,      0,             'GMT');

--------------------------------------------------------------------------------
--	Table "MEMBER"
--------------------------------------------------------------------------------

INSERT INTO MEMBER (ID, G_ID, U_ID, CREATOR_U_ID, CREATE_TS, CHANGER_U_ID, CHANGE_TS)
	VALUES     (90, 81,   0,    0,            0,         0,            0);

INSERT INTO MEMBER (ID, G_ID, U_ID, CREATOR_U_ID, CREATE_TS, CHANGER_U_ID, CHANGE_TS)
	VALUES     (91, 80,   0,    0,            0,         0,            0);

INSERT INTO MEMBER (ID, G_ID, U_ID, CREATOR_U_ID, CREATE_TS, CHANGER_U_ID, CHANGE_TS)
	VALUES     (92, 80,   1,    0,            0,         0,            0);

INSERT INTO MEMBER (ID, G_ID, U_ID, CREATOR_U_ID, CREATE_TS, CHANGER_U_ID, CHANGE_TS)
	VALUES     (93, 81,   2,    0,            0,         0,            0);

INSERT INTO MEMBER (ID, G_ID, U_ID, CREATOR_U_ID, CREATE_TS, CHANGER_U_ID, CHANGE_TS)
        VALUES     (94, 80,   3,    0,            0,         0,            0);
-- in case it's not there...
/*
CREATE FUNCTION quarter(dt date)
RETURNS integer
WITH(NOT VARIANT)

-- specified month of the year, zero based and divided by 4 plus 1 yields quarter in { 1, 2, 3, 4 }
RETURN 1 + (MONTH(dt) - 1) / 3;

END FUNCTION;
*/

CREATE VIEW sme_quarter_sum (jahr, quartal, anzahl) AS
SELECT jahr, trunc((monat-1)/3)+1, sum(anzahl) FROM sme_counter GROUP BY 1, 2;

CREATE VIEW sci_sme_quarter (jahr, quartal, anzahl, expected_anzahl, avg_anzahl_pro_tag) AS
SELECT jahr, quartal, anzahl,
       DECODE(TRIM(TO_CHAR(jahr))||TRIM(TO_CHAR(quartal)),
              TRIM(TO_CHAR(DATE(CURRENT),'%Y'))||TRIM(TO_CHAR(QUARTER(CURRENT))),
              ROUND(anzahl *
                    (ADD_MONTHS(TO_DATE(TRIM(TO_CHAR(jahr))||TRIM(TO_CHAR((quartal - 1) * 3 + 1)),'%Y%m'), 3)
                              - TO_DATE(TRIM(TO_CHAR(jahr))||TRIM(TO_CHAR((quartal - 1) * 3 + 1)),'%Y%m'))::interval day to day::char(3)::int8
                    /
                    (TRUNC(CURRENT) - TO_DATE(TRIM(TO_CHAR(jahr))||TRIM(TO_CHAR((quartal - 1) * 3 + 1)),'%Y%m'))::interval day to day::char(3)::int8
              ),
              anzahl
       ),
       DECODE(TRIM(TO_CHAR(jahr))||TRIM(TO_CHAR(quartal)),
              TRIM(TO_CHAR(DATE(CURRENT),'%Y'))||TRIM(TO_CHAR(QUARTER(CURRENT))),
              ROUND(anzahl /
                    (TRUNC(CURRENT) - TO_DATE(TRIM(TO_CHAR(jahr))||TRIM(TO_CHAR((quartal - 1) * 3 + 1)),'%Y%m'))::interval day to day::char(3)::int8
                    , 2
              ),
              ROUND(anzahl /
                    (ADD_MONTHS(TO_DATE(TRIM(TO_CHAR(jahr))||TRIM(TO_CHAR((quartal - 1) * 3 + 1)),'%Y%m'), 3)
                              - TO_DATE(TRIM(TO_CHAR(jahr))||TRIM(TO_CHAR((quartal - 1) * 3 + 1)),'%Y%m'))::interval day to day::char(3)::int8
                    , 2
              )
       )
FROM sme_quarter_sum;
