-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE ENVIRONMENT (
    ID                             bigint NOT NULL
    , NE_ID                          bigint          NOT NULL
    , NR_ID                          bigint          NOT NULL
    , CONDITION                      lvarchar(1024)      NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , VALID_FROM                   bigint NOT NULL
    , VALID_TO                     bigint NOT NULL
);
CREATE INDEX PK_ENVIRONMENT
ON ENVIRONMENT(ID);
CREATE VIEW SCI_C_ENVIRONMENT (ID,NE_ID,NR_ID,CONDITION,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NE_ID                          AS NE_ID
    , NR_ID                          AS NR_ID
    , CONDITION                      AS CONDITION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM ENVIRONMENT
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_ENVIRONMENT (ID,NE_ID,NR_ID,CONDITION,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , NE_ID                          AS NE_ID
    , NR_ID                          AS NR_ID
    , CONDITION                      AS CONDITION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM ENVIRONMENT;
