-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE VERSIONED_EXTENTS (
    ID                             decimal(20) NOT NULL
    , O_ID                           decimal(20)     NOT NULL
    , SEQUENCE                       integer         NOT NULL
    , EXTENT                         varchar(256)    NOT NULL
    , CREATOR_U_ID                   decimal(20)     NOT NULL
    , CREATE_TS                      decimal(20)     NOT NULL
    , CHANGER_U_ID                   decimal(20)     NOT NULL
    , CHANGE_TS                      decimal(20)     NOT NULL
    , VALID_FROM                   decimal(20) NOT NULL
    , VALID_TO                     decimal(20) NOT NULL
);\g
CREATE INDEX PK_VERSIONED_EXTENTS
ON VERSIONED_EXTENTS(ID) WITH STRUCTURE = BTREE;\g
CREATE VIEW SCI_C_VERSIONED_EXTENTS AS
SELECT 
    ID 
    , O_ID                           AS O_ID
    , SEQUENCE                       AS SEQUENCE
    , EXTENT                         AS EXTENT
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , '01-JAN-1970 00:00:00 GMT' + date(char(decimal((CREATE_TS- decimal(CREATE_TS/1125899906842624, 18, 0)*1125899906842624)/1000, 18, 0)) + ' secs') AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , '01-JAN-1970 00:00:00 GMT' + date(char(decimal((CHANGE_TS- decimal(CHANGE_TS/1125899906842624, 18, 0)*1125899906842624)/1000, 18, 0)) + ' secs') AS CHANGE_TS
  FROM VERSIONED_EXTENTS
 WHERE VALID_TO = 9223372036854775807;\g
CREATE VIEW SCI_V_VERSIONED_EXTENTS AS
SELECT 
    ID 
    , O_ID                           AS O_ID
    , SEQUENCE                       AS SEQUENCE
    , EXTENT                         AS EXTENT
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , '01-JAN-1970 00:00:00 GMT' + date(char(decimal((CREATE_TS- decimal(CREATE_TS/1125899906842624, 18, 0)*1125899906842624)/1000, 18, 0)) + ' secs') AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , '01-JAN-1970 00:00:00 GMT' + date(char(decimal((CHANGE_TS- decimal(CHANGE_TS/1125899906842624, 18, 0)*1125899906842624)/1000, 18, 0)) + ' secs') AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM VERSIONED_EXTENTS;\g
