-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE "INTERVAL_DISPATCHER" (
    "ID"                           NUMBER (38) PRIMARY KEY
    , "INT_ID"                       NUMBER (38)          NOT NULL
    , "SEQ_NO"                       NUMBER (38)          NOT NULL
    , "NAME"                         VARCHAR2 (64 CHAR)   NOT NULL
    , "SELECT_INT_ID"                NUMBER (38)              NULL
    , "FILTER_INT_ID"                NUMBER (38)              NULL
    , "IS_ENABLED"                   NUMBER (1)           NOT NULL
    , "IS_ACTIVE"                    NUMBER (1)           NOT NULL
    , "CREATOR_U_ID"                 NUMBER (38)          NOT NULL
    , "CREATE_TS"                    NUMBER (38)          NOT NULL
    , "CHANGER_U_ID"                 NUMBER (38)          NOT NULL
    , "CHANGE_TS"                    NUMBER (38)          NOT NULL
);
CREATE OR REPLACE VIEW SCI_INTERVAL_DISPATCHER AS
SELECT 
    ID 
    , "INT_ID"                       AS "INT_ID"
    , "SEQ_NO"                       AS "SEQ_NO"
    , "NAME"                         AS "NAME"
    , "SELECT_INT_ID"                AS "SELECT_INT_ID"
    , "FILTER_INT_ID"                AS "FILTER_INT_ID"
    , DECODE (IS_ENABLED, 1, 'TRUE', 0, 'FALSE') AS "IS_ENABLED"
    , DECODE (IS_ACTIVE, 1, 'TRUE', 0, 'FALSE') AS "IS_ACTIVE"
    , "CREATOR_U_ID"                 AS "CREATOR_U_ID"
    , pkg_time.gmt2local("CREATE_TS") AS "CREATE_TS"
    , "CHANGER_U_ID"                 AS "CHANGER_U_ID"
    , pkg_time.gmt2local("CHANGE_TS") AS "CHANGE_TS"
  FROM "INTERVAL_DISPATCHER";
