-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE "RESOURCE_REQUIREMENT" (
    "ID"                           NUMBER (38) NOT NULL
    , "NR_ID"                        NUMBER (38)          NOT NULL
    , "SE_ID"                        NUMBER (38)          NOT NULL
    , "AMOUNT"                       NUMBER (38)              NULL
    , "KEEP_MODE"                    NUMBER (38)          NOT NULL
    , "IS_STICKY"                    NUMBER (1)           NOT NULL
    , "STICKY_NAME"                  VARCHAR2 (64 CHAR)       NULL
    , "STICKY_PARENT"                NUMBER (38)              NULL
    , "RSMP_ID"                      NUMBER (38)              NULL
    , "EXPIRED_AMOUNT"               NUMBER (38)              NULL
    , "EXPIRED_BASE"                 NUMBER (38)              NULL
    , "IGNORE_ON_RERUN"              NUMBER (1)           NOT NULL
    , "LOCKMODE"                     NUMBER (38)              NULL
    , "CONDITION"                    VARCHAR2 (1024 CHAR)     NULL
    , "CREATOR_U_ID"                 NUMBER (38)          NOT NULL
    , "CREATE_TS"                    NUMBER (38)          NOT NULL
    , "CHANGER_U_ID"                 NUMBER (38)          NOT NULL
    , "CHANGE_TS"                    NUMBER (38)          NOT NULL
    , "VALID_FROM"                 NUMBER (38) NOT NULL
    , "VALID_TO"                   NUMBER (38) NOT NULL
    , PRIMARY KEY (ID, VALID_TO)
);
CREATE OR REPLACE VIEW SCI_C_RESOURCE_REQUIREMENT AS
SELECT 
    ID 
    , "NR_ID"                        AS "NR_ID"
    , "SE_ID"                        AS "SE_ID"
    , "AMOUNT"                       AS "AMOUNT"
    , DECODE (KEEP_MODE, 0, 'NOKEEP', 1, 'KEEP', 2, 'KEEP_FINAL') AS "KEEP_MODE"
    , DECODE (IS_STICKY, 1, 'TRUE', 0, 'FALSE') AS "IS_STICKY"
    , "STICKY_NAME"                  AS "STICKY_NAME"
    , "STICKY_PARENT"                AS "STICKY_PARENT"
    , "RSMP_ID"                      AS "RSMP_ID"
    , "EXPIRED_AMOUNT"               AS "EXPIRED_AMOUNT"
    , DECODE (EXPIRED_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS "EXPIRED_BASE"
    , DECODE (IGNORE_ON_RERUN, 1, 'TRUE', 0, 'FALSE') AS "IGNORE_ON_RERUN"
    , DECODE (LOCKMODE, 255, 'N', 0, 'X', 2, 'SX', 4, 'S', 6, 'SC') AS "LOCKMODE"
    , "CONDITION"                    AS "CONDITION"
    , "CREATOR_U_ID"                 AS "CREATOR_U_ID"
    , pkg_time.gmt2local("CREATE_TS") AS "CREATE_TS"
    , "CHANGER_U_ID"                 AS "CHANGER_U_ID"
    , pkg_time.gmt2local("CHANGE_TS") AS "CHANGE_TS"
  FROM "RESOURCE_REQUIREMENT"
 WHERE VALID_TO = 9223372036854775807;
CREATE OR REPLACE VIEW SCI_V_RESOURCE_REQUIREMENT AS
SELECT 
    ID 
    , "NR_ID"                        AS "NR_ID"
    , "SE_ID"                        AS "SE_ID"
    , "AMOUNT"                       AS "AMOUNT"
    , DECODE (KEEP_MODE, 0, 'NOKEEP', 1, 'KEEP', 2, 'KEEP_FINAL') AS "KEEP_MODE"
    , DECODE (IS_STICKY, 1, 'TRUE', 0, 'FALSE') AS "IS_STICKY"
    , "STICKY_NAME"                  AS "STICKY_NAME"
    , "STICKY_PARENT"                AS "STICKY_PARENT"
    , "RSMP_ID"                      AS "RSMP_ID"
    , "EXPIRED_AMOUNT"               AS "EXPIRED_AMOUNT"
    , DECODE (EXPIRED_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS "EXPIRED_BASE"
    , DECODE (IGNORE_ON_RERUN, 1, 'TRUE', 0, 'FALSE') AS "IGNORE_ON_RERUN"
    , DECODE (LOCKMODE, 255, 'N', 0, 'X', 2, 'SX', 4, 'S', 6, 'SC') AS "LOCKMODE"
    , "CONDITION"                    AS "CONDITION"
    , "CREATOR_U_ID"                 AS "CREATOR_U_ID"
    , pkg_time.gmt2local("CREATE_TS") AS "CREATE_TS"
    , "CHANGER_U_ID"                 AS "CHANGER_U_ID"
    , pkg_time.gmt2local("CHANGE_TS") AS "CHANGE_TS"
    , VALID_FROM
    , VALID_TO
  FROM "RESOURCE_REQUIREMENT";
