-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE "USERS" (
    "ID"                           NUMBER (38) PRIMARY KEY
    , "NAME"                         VARCHAR2 (64 CHAR)   NOT NULL
    , "PASSWD"                       VARCHAR2 (64 CHAR)   NOT NULL
    , "SALT"                         VARCHAR2 (64 CHAR)       NULL
    , "METHOD"                       NUMBER (38)          NOT NULL
    , "IS_ENABLED"                   NUMBER (1)           NOT NULL
    , "DEFAULT_G_ID"                 NUMBER (38)          NOT NULL
    , "CONNECTION_TYPE"              NUMBER (38)          NOT NULL
    , "DELETE_VERSION"               NUMBER (38)          NOT NULL
    , "CREATOR_U_ID"                 NUMBER (38)          NOT NULL
    , "CREATE_TS"                    NUMBER (38)          NOT NULL
    , "CHANGER_U_ID"                 NUMBER (38)          NOT NULL
    , "CHANGE_TS"                    NUMBER (38)          NOT NULL
);
CREATE OR REPLACE VIEW SCI_USERS AS
SELECT 
    ID 
    , "NAME"                         AS "NAME"
    , DECODE (IS_ENABLED, 1, 'TRUE', 0, 'FALSE') AS "IS_ENABLED"
    , "DEFAULT_G_ID"                 AS "DEFAULT_G_ID"
    , DECODE (CONNECTION_TYPE, 0, 'PLAIN', 1, 'SSL', 2, 'SSL_AUTH') AS "CONNECTION_TYPE"
    , "DELETE_VERSION"               AS "DELETE_VERSION"
    , "CREATOR_U_ID"                 AS "CREATOR_U_ID"
    , pkg_time.gmt2local("CREATE_TS") AS "CREATE_TS"
    , "CHANGER_U_ID"                 AS "CHANGER_U_ID"
    , pkg_time.gmt2local("CHANGE_TS") AS "CHANGE_TS"
  FROM "USERS";
