-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE "USER_PARAMETER" (
    "ID"                           NUMBER (38) PRIMARY KEY
    , "U_ID"                         NUMBER (38)          NOT NULL
    , "NAME"                         VARCHAR2 (64 CHAR)   NOT NULL
    , "VALUE"                        VARCHAR2 (256 CHAR)      NULL
    , "IS_LONG"                      NUMBER (1)           NOT NULL
    , "CREATOR_U_ID"                 NUMBER (38)          NOT NULL
    , "CREATE_TS"                    NUMBER (38)          NOT NULL
    , "CHANGER_U_ID"                 NUMBER (38)          NOT NULL
    , "CHANGE_TS"                    NUMBER (38)          NOT NULL
);
CREATE OR REPLACE VIEW SCI_USER_PARAMETER AS
SELECT 
    ID 
    , "U_ID"                         AS "U_ID"
    , "NAME"                         AS "NAME"
    , "VALUE"                        AS "VALUE"
    , DECODE (IS_LONG, 1, 'TRUE', 0, 'FALSE') AS "IS_LONG"
    , "CREATOR_U_ID"                 AS "CREATOR_U_ID"
    , pkg_time.gmt2local("CREATE_TS") AS "CREATE_TS"
    , "CHANGER_U_ID"                 AS "CHANGER_U_ID"
    , pkg_time.gmt2local("CHANGE_TS") AS "CHANGE_TS"
  FROM "USER_PARAMETER";
