/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.jobserver;

import de.independit.scheduler.jobserver.Config;
import de.independit.scheduler.jobserver.Trace;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.SocketTimeoutException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Vector;

public class HttpThread
extends Thread {
    private static HttpThread httpThread = null;
    private int port = 0;
    private final Config cfg;
    private boolean run = true;
    private boolean needFooter = false;
    private boolean gotFooter = false;
    private static final String CLGTH = "Content-Length:";
    private static final String POST = "POST";
    private static final String GET = "GET";
    private static final String FNAME = "FNAME";
    private static final String LIMIT = "LIMIT";
    private static final int defaultLimit = 100000;
    private static final int sleepInterval = 5000;
    private static final int timeoutInterval = 5000;
    private static final String DIRECTORY_UP_PATTERN = ".*[/\\\\]\\.\\.[/\\\\].*";

    private HttpThread(Config config) {
        this.setDaemon(true);
        this.cfg = config;
    }

    public static HttpThread getInstance(Config config) {
        if (httpThread == null) {
            httpThread = new HttpThread(config);
        }
        return httpThread;
    }

    private String extrPostMsg(int n, BufferedReader bufferedReader) {
        char[] cArray = new char[n];
        try {
            bufferedReader.read(cArray, 0, n);
        }
        catch (IOException iOException) {
            return "";
        }
        return new String(cArray, 0, n);
    }

    private boolean authenticate(HashMap hashMap) {
        return true;
    }

    private String getFile(RandomAccessFile randomAccessFile, long l) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        if (randomAccessFile == null) {
            return null;
        }
        long l2 = randomAccessFile.length();
        if (l2 > l) {
            stringBuffer.append("<SPAN style=\"color:#ff0000;\">\n");
            stringBuffer.append("The length of the requested file exceeds the limit of " + l + " Bytes !<BR>\n");
            stringBuffer.append("Only the last " + l + " Bytes of the file are returned.<BR>\n");
            stringBuffer.append("</SPAN>\n");
            stringBuffer.append("<HR>\n");
            randomAccessFile.seek(l2 - l);
            l2 = l;
        }
        byte[] byArray = new byte[(int)l2];
        randomAccessFile.read(byArray);
        randomAccessFile.close();
        stringBuffer.append("<PRE>\n");
        stringBuffer.append(new String(byArray));
        stringBuffer.append("\n</PRE>\n");
        return stringBuffer.toString();
    }

    private void executeQuery(String string, PrintWriter printWriter) throws UnsupportedEncodingException {
        block15: {
            Object object;
            Object object2;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String[] stringArray = string.split("\\&");
            for (int i = 0; i < stringArray.length; ++i) {
                object2 = stringArray[i].split("=");
                if (((String[])object2).length <= 1) continue;
                object = URLDecoder.decode(object2[1], "UTF-8");
                hashMap.put(object2[0], (String)object);
            }
            if (!this.authenticate(hashMap)) {
                printWriter.println("ERROR: insufficient privileges");
            } else {
                RandomAccessFile randomAccessFile = null;
                if (hashMap.containsKey(FNAME)) {
                    object2 = (String)hashMap.get(FNAME);
                    try {
                        randomAccessFile = new RandomAccessFile((String)object2, "r");
                    }
                    catch (Exception exception) {
                        try {
                            randomAccessFile.close();
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                        this.printPreamble(printWriter, 404, "Not Found");
                        printWriter.println("ERROR: couldn't open the requested file");
                        this.printFooter(printWriter);
                        printWriter.flush();
                        return;
                    }
                    object = (Vector)this.cfg.get("NAME_PATTERN_");
                    boolean bl = false;
                    if (object != null && !((String)object2).matches(DIRECTORY_UP_PATTERN)) {
                        for (int i = 0; i < ((Vector)object).size(); ++i) {
                            String string2 = (String)((Vector)object).get(i);
                            if (!((String)object2).matches(string2)) continue;
                            bl = true;
                            break;
                        }
                    }
                    if (!bl) {
                        this.printPreamble(printWriter, 403, "Forbidden");
                        printWriter.println("ERROR: The requested filename doesn't match any of the configured patterns");
                        Trace.error("[HttpThread] ERROR: Illegal file request : " + (String)object2);
                        this.printFooter(printWriter);
                        printWriter.flush();
                        return;
                    }
                    long l = hashMap.containsKey(LIMIT) ? Long.parseLong((String)hashMap.get(LIMIT)) : 100000L;
                    try {
                        String string3 = this.getFile(randomAccessFile, l);
                        if (string3 == null) {
                            this.printPreamble(printWriter, 500, "Internal Server Error");
                            Trace.error("[HttpThread] ERROR: Internal error: getFile returned null");
                            break block15;
                        }
                        this.printPreamble(printWriter, 200, "OK", (String)object2);
                        printWriter.print(string3);
                    }
                    catch (IOException iOException) {
                        this.printPreamble(printWriter, 500, "Internal Server Error");
                        Trace.error("[HttpThread] ERROR: IOEception : " + iOException.toString());
                    }
                } else {
                    this.printPreamble(printWriter, 400, "Bad Request");
                }
            }
        }
        this.printFooter(printWriter);
        printWriter.flush();
    }

    private void printPreamble(PrintWriter printWriter, int n, String string) {
        this.printPreamble(printWriter, n, string, null);
    }

    private void printPreamble(PrintWriter printWriter, int n, String string, String string2) {
        printWriter.println("HTTP/1.0 " + n + " " + string);
        printWriter.println("Content-Type: text/html");
        printWriter.println("Server: BICsuiteJobserver");
        printWriter.println("");
        if (n == 200 || n == 404) {
            printWriter.println("<!DOCTYPE HTML>");
            printWriter.println("<html>");
            String string3 = (String)this.cfg.get("HTTPLOGENCODING");
            if (string3 == null) {
                string3 = "utf-8";
            }
            if (string2 != null) {
                printWriter.println("<head>");
                printWriter.println("<meta charset=\"" + string3 + "\">");
                printWriter.println("<title>" + string2 + "</title>");
                printWriter.println("</head>");
            }
            printWriter.println("<body>");
        }
        this.needFooter = true;
    }

    private void printFooter(PrintWriter printWriter) {
        printWriter.println("</body>");
        printWriter.println("</html>");
        this.gotFooter = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public final void run() {
        var1_1 = Runtime.getRuntime();
        var2_2 = null;
        block30: while (this.run) {
            var3_3 = (Long)this.cfg.get("HTTPPORT");
            this.port = var3_3 != null ? var3_3.intValue() : 0;
            while (this.port == 0) {
                try {
                    HttpThread.sleep(5000L);
                    if (!this.run) {
                        break block30;
                    }
                }
                catch (Exception var4_5) {
                    // empty catch block
                }
                if ((var3_3 = (Long)this.cfg.get("HTTPPORT")) != null) {
                    this.port = var3_3.intValue();
                    continue;
                }
                this.port = 0;
            }
            var4_4 = null;
            try {
                var4_4 = new ServerSocket(this.port);
                var4_4.setSoTimeout(5000);
                while (true) lbl-1000:
                // 4 sources

                {
                    block52: {
                        var5_6 = null;
                        var2_2 = var4_4.accept();
                        var6_9 = var2_2.getInetAddress().getHostAddress();
                        var7_19 = new BufferedReader(new InputStreamReader(var2_2.getInputStream()));
                        var5_6 = new PrintWriter(var2_2.getOutputStream());
                        var8_20 = null;
                        var9_24 = 0;
                        var10_25 = "";
                        do {
                            var8_20 = var7_19.readLine();
                            Trace.message("[HttpThread] Got Request from " + var6_9 + " : " + var8_20);
                            if (var8_20 == null) break;
                            var11_26 = var8_20.split(" ");
                            if (var11_26[0].equals("Content-Length:")) {
                                var9_24 = Integer.parseInt(var11_26[1]);
                                continue;
                            }
                            if (var11_26[0].equals("POST")) {
                                var10_25 = this.extrPostMsg(var9_24, (BufferedReader)var7_19);
                                continue;
                            }
                            if (!var11_26[0].equals("GET")) continue;
                            if (var11_26.length > 1) {
                                var12_27 = var11_26[1].split("\\?");
                                if (var12_27.length > 1) {
                                    var10_25 = var11_26[1].split("\\?")[1];
                                    continue;
                                }
                                var10_25 = "FNAME=" + var11_26[1];
                                continue;
                            }
                            Trace.error("[HttpThread] Invalid Request : " + var8_20);
                        } while (!var8_20.equals(""));
                        this.executeQuery(var10_25, var5_6);
                        try {
                            if (var2_2 == null) break block52;
                            if (this.needFooter && !this.gotFooter && var5_6 != null) {
                                this.printFooter(var5_6);
                            }
                            var2_2.close();
                        }
                        catch (Exception var6_10) {
                            Trace.error("[HttpThread] caught Exception (250) : " + var6_10.toString());
                            var7_19 = var6_10.getStackTrace();
                            for (var8_21 = 0; var8_21 < var7_19.length; ++var8_21) {
                                Trace.error("[HttpThread] " + var7_19[var8_21].toString());
                            }
                        }
                    }
                    if ((var3_3 = (Long)this.cfg.get("HTTPPORT")) != null && var3_3.intValue() == this.port) ** GOTO lbl-1000
                    try {
                        var4_4.close();
                    }
                    catch (Exception var6_11) {}
                    break;
                    catch (SocketTimeoutException var6_12) {
                        block54: {
                            try {
                                if (var2_2 == null) break block54;
                                if (this.needFooter && !this.gotFooter && var5_6 != null) {
                                    this.printFooter(var5_6);
                                }
                                var2_2.close();
                            }
                            catch (Exception var6_13) {
                                Trace.error("[HttpThread] caught Exception (250) : " + var6_13.toString());
                                var7_19 = var6_13.getStackTrace();
                                for (var8_22 = 0; var8_22 < var7_19.length; ++var8_22) {
                                    Trace.error("[HttpThread] " + var7_19[var8_22].toString());
                                }
                            }
                        }
                        if ((var3_3 = (Long)this.cfg.get("HTTPPORT")) != null && var3_3.intValue() == this.port) ** GOTO lbl-1000
                        try {
                            var4_4.close();
                        }
                        catch (Exception var6_14) {}
                        break;
                    }
                    catch (Throwable var6_15) {
                        this.port = 0;
                        Trace.error("[HttpThread] caught Exception (243) : " + var6_15.toString());
                        var7_19 = var6_15.getStackTrace();
                        for (var8_23 = 0; var8_23 < var7_19.length; ++var8_23) {
                            Trace.error("[HttpThread] " + var7_19[var8_23].toString());
                        }
                        try {
                            if (var2_2 == null) continue;
                            if (this.needFooter && !this.gotFooter && var5_6 != null) {
                                this.printFooter(var5_6);
                            }
                            var2_2.close();
                            continue;
                        }
                        catch (Exception var6_16) {
                            Trace.error("[HttpThread] caught Exception (250) : " + var6_16.toString());
                            var7_19 = var6_16.getStackTrace();
                            for (var8_23 = 0; var8_23 < var7_19.length; ++var8_23) {
                                Trace.error("[HttpThread] " + var7_19[var8_23].toString());
                            }
                        }
                        if ((var3_3 = (Long)this.cfg.get("HTTPPORT")) != null && var3_3.intValue() == this.port) continue;
                        try {
                            var4_4.close();
                        }
                        catch (Exception var6_17) {}
                        break;
                        {
                            catch (Throwable var13_28) {
                                block55: {
                                    try {
                                        if (var2_2 == null) break block55;
                                        if (this.needFooter && !this.gotFooter && var5_6 != null) {
                                            this.printFooter(var5_6);
                                        }
                                        var2_2.close();
                                    }
                                    catch (Exception var14_30) {
                                        Trace.error("[HttpThread] caught Exception (250) : " + var14_30.toString());
                                        var15_32 = var14_30.getStackTrace();
                                        for (var16_33 = 0; var16_33 < var15_32.length; ++var16_33) {
                                            Trace.error("[HttpThread] " + var15_32[var16_33].toString());
                                        }
                                    }
                                }
                                var3_3 = (Long)this.cfg.get("HTTPPORT");
                                if (var3_3 == null || var3_3.intValue() != this.port) {
                                    try {
                                        var4_4.close();
                                    }
                                    catch (Exception var14_31) {}
                                    break;
                                }
                                throw var13_28;
                            }
                        }
                    }
                    break;
                }
            }
            catch (Exception var5_7) {
                Trace.error("[HttpThread] Something went wrong : " + var5_7.toString());
                try {
                    if (this.run) {
                        HttpThread.sleep(5000L);
                    }
                    if (var4_4 != null) {
                        var4_4.close();
                    }
                }
                catch (Exception var6_18) {
                    // empty catch block
                }
            }
            try {
                if (var4_4 == null) continue;
                var4_4.close();
            }
            catch (Exception var5_8) {}
        }
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setRun(boolean bl) {
        this.run = bl;
    }
}

