/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.proxy;

import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.util.SDMSThread;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;

final class Client
extends Thread {
    public static final String __version = "@(#) $Id: Client.java,v 1.1.18.1 2013/03/14 10:24:08 ronald Exp $";
    final Socket clientSocket;
    final Socket serverSocket;
    private final InputStream clientInput;
    private final OutputStream clientOutput;
    private final InputStream serverInput;
    private final OutputStream serverOutput;
    private final byte[] tunnelBuffer = new byte[5120];
    private Socket tunnelSocket;

    Client(Socket socket, Socket socket2) throws FatalException {
        this.clientSocket = socket;
        this.serverSocket = socket2;
        try {
            this.clientInput = socket.getInputStream();
            this.clientOutput = socket.getOutputStream();
            this.serverInput = socket2.getInputStream();
            this.serverOutput = socket2.getOutputStream();
        }
        catch (IOException iOException) {
            throw new FatalException("(04410240016) Error retrieving i/o channels: " + iOException);
        }
    }

    @Override
    public final void run() {
        SDMSThread.doTrace(null, "Established link " + this.clientSocket.getInetAddress() + " <-> " + this.serverSocket.getInetAddress(), 2);
        try {
            while (this.tunnel(this.clientSocket, this.serverSocket, this.clientInput, this.serverOutput) != -1 && this.tunnel(this.serverSocket, this.clientSocket, this.serverInput, this.clientOutput) != -1) {
            }
            SDMSThread.doTrace(null, this.tunnelSocket.getInetAddress() + ": ***EOF***", 2);
        }
        catch (IOException iOException) {
            SDMSThread.doTrace(null, "(04410240024) " + this.tunnelSocket.getInetAddress() + ": " + iOException, -1);
        }
    }

    private final int tunnel(Socket socket, Socket socket2, InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            int n;
            this.tunnelSocket = socket;
            while ((n = inputStream.read(this.tunnelBuffer)) > 0) {
                SDMSThread.doTrace(null, socket.getInetAddress() + ": " + new String(this.tunnelBuffer, 0, n), 3);
                this.tunnelSocket = socket2;
                outputStream.write(this.tunnelBuffer, 0, n);
                this.tunnelSocket = socket;
            }
            return n;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return 0;
        }
    }
}

