/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.dump;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.dump.Compare;
import de.independit.scheduler.server.dump.DumpExitStateDefinition;
import de.independit.scheduler.server.dump.DumpResourceStateDefinition;
import de.independit.scheduler.server.dump.DumpResourceStateMappingProfileGeneric;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.repository.SDMSResourceStateMapping;
import de.independit.scheduler.server.repository.SDMSResourceStateMappingProfile;
import de.independit.scheduler.server.repository.SDMSResourceStateMappingTable;
import java.util.Collections;
import java.util.Vector;

class DumpResourceStateMappingProfile
extends DumpResourceStateMappingProfileGeneric {
    public static final String __version = "@(#) $Id: DumpResourceStateMappingProfile.java,v 2.3.14.1 2013/03/14 10:24:14 ronald Exp $";
    private Vector mappingDefs;
    private SDMSResourceStateMapping rsm;

    DumpResourceStateMappingProfile(SystemEnvironment systemEnvironment, SDMSResourceStateMappingProfile sDMSResourceStateMappingProfile) throws SDMSException {
        super(systemEnvironment, sDMSResourceStateMappingProfile);
    }

    private final String getEsdName(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.rsm.getEsdId(systemEnvironment);
        return DumpExitStateDefinition.getDumpedName(systemEnvironment, l);
    }

    private final String getFromRsdName(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.rsm.getFromRsdId(systemEnvironment);
        if (l == null) {
            return "any";
        }
        return DumpResourceStateDefinition.getDumpedName(systemEnvironment, l);
    }

    private final String getToRsdName(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.rsm.getToRsdId(systemEnvironment);
        return DumpResourceStateDefinition.getDumpedName(systemEnvironment, l);
    }

    @Override
    final void collect(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector vector = SDMSResourceStateMappingTable.idx_rsmpId.getVector(systemEnvironment, this.rsmpId);
        int n = vector.size();
        this.mappingDefs = new Vector(n);
        for (int i = 0; i < n; ++i) {
            this.rsm = (SDMSResourceStateMapping)vector.get(i);
            String[] stringArray = new String[]{this.getEsdName(systemEnvironment), this.getFromRsdName(systemEnvironment), this.getToRsdName(systemEnvironment)};
            this.mappingDefs.add(stringArray);
        }
        Collections.sort(this.mappingDefs, Compare.ResourceStateMappings);
    }

    @Override
    final void render(String string) {
        Vector<String> vector = new Vector<String>(this.mappingDefs.size());
        int n = this.mappingDefs.size();
        for (int i = 0; i < n; ++i) {
            String[] stringArray = (String[])this.mappingDefs.get(i);
            vector.add(stringArray[0] + "\n" + "\t\t\t\tmaps " + stringArray[1] + "\n" + "\t\t\t\tto " + stringArray[2]);
        }
        DumpResourceStateMappingProfile.println(string + " resource_state_mapping " + this.getName());
        DumpResourceStateMappingProfile.println("\twith");
        DumpResourceStateMappingProfile.println("\t\tmap = (");
        DumpResourceStateMappingProfile.println("\t\t\t" + DumpResourceStateMappingProfile.join(",\n\t\t\t", vector) + ");");
    }
}

