/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.dump;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.dump.Compare;
import de.independit.scheduler.server.dump.Dump;
import de.independit.scheduler.server.dump.DumpExitStateTranslationProfile;
import de.independit.scheduler.server.dump.DumpSchedulingEntity;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.repository.SDMSIgnoredDependency;
import de.independit.scheduler.server.repository.SDMSIgnoredDependencyTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchy;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchyTable;
import java.util.Collections;
import java.util.Vector;

class DumpSchedulingEntityChildren
extends Dump {
    public static final String __version = "@(#) $Id: DumpSchedulingEntityChildren.java,v 2.6.14.1 2013/03/14 10:24:14 ronald Exp $";
    private Vector shList;
    private Long seId;
    private Vector childrenDefs;
    private SDMSSchedulingHierarchy sh;
    private Long shId;
    private Vector childDef;

    static final boolean getDumpedList(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (SDMSSchedulingHierarchyTable.idx_seParentId.getVector(systemEnvironment, l).isEmpty()) {
            return false;
        }
        SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l);
        new DumpSchedulingEntityChildren(systemEnvironment, sDMSSchedulingEntity);
        return true;
    }

    DumpSchedulingEntityChildren(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity) throws SDMSException {
        super(systemEnvironment, 15, sDMSSchedulingEntity);
    }

    @Override
    final String initialize(SystemEnvironment systemEnvironment) throws SDMSException {
        this.seId = this.sdmsId;
        this.shList = SDMSSchedulingHierarchyTable.idx_seParentId.getVector(systemEnvironment, this.seId);
        return DumpSchedulingEntity.getDumpedName(systemEnvironment, this.seId);
    }

    private final void loadJobName(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.sh.getSeChildId(systemEnvironment);
        this.childDef.add(DumpSchedulingEntity.getDumpedName(systemEnvironment, l));
    }

    private final void loadAliasName(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = this.sh.getAliasName(systemEnvironment);
        this.childDef.add("alias = " + (string == null ? "none" : DumpSchedulingEntityChildren.quotedName(this.shId, string)));
    }

    private final void loadStatic(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = this.sh.getIsStaticAsString(systemEnvironment);
        this.childDef.add(string.toLowerCase());
    }

    private final void loadDisabled(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = this.sh.getIsDisabled(systemEnvironment) != false ? "DISABLE" : "ENABLE";
        this.childDef.add(string);
    }

    private final void loadNicevalue(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.sh.getPriority(systemEnvironment);
        this.childDef.add("nicevalue = " + n.toString());
    }

    private final void loadSuspend(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = this.sh.getSuspendAsString(systemEnvironment);
        this.childDef.add(string.toLowerCase());
    }

    private final void loadTranslation(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.sh.getEstpId(systemEnvironment);
        if (l != null) {
            this.childDef.add("translation = " + DumpExitStateTranslationProfile.getDumpedName(systemEnvironment, l));
        }
    }

    private final void loadMergeMode(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = this.sh.getMergeModeAsString(systemEnvironment);
        this.childDef.add("merge_mode = " + string.toLowerCase());
    }

    private final void loadIgnoreDependency(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector vector = SDMSIgnoredDependencyTable.idx_shId.getVector(systemEnvironment, this.shId);
        if (vector.isEmpty()) {
            this.childDef.add("ignore_dependencies = none");
            return;
        }
        int n = vector.size();
        Vector<String> vector2 = new Vector<String>(n);
        for (int i = 0; i < n; ++i) {
            SDMSIgnoredDependency sDMSIgnoredDependency = (SDMSIgnoredDependency)vector.get(i);
            vector2.add(DumpSchedulingEntityChildren.quotedName(sDMSIgnoredDependency.getId(systemEnvironment), sDMSIgnoredDependency.getDdName(systemEnvironment)));
        }
        Collections.sort(vector2, Compare.Lexically);
        this.childDef.add(vector2);
    }

    @Override
    final void collect(SystemEnvironment systemEnvironment) throws SDMSException {
        int n = this.shList.size();
        this.childrenDefs = new Vector(n);
        for (int i = 0; i < n; ++i) {
            this.sh = (SDMSSchedulingHierarchy)this.shList.get(i);
            this.shId = this.sh.getId(systemEnvironment);
            this.childDef = new Vector();
            this.loadJobName(systemEnvironment);
            this.loadAliasName(systemEnvironment);
            this.loadStatic(systemEnvironment);
            this.loadDisabled(systemEnvironment);
            this.loadNicevalue(systemEnvironment);
            this.loadSuspend(systemEnvironment);
            this.loadTranslation(systemEnvironment);
            this.loadMergeMode(systemEnvironment);
            this.loadIgnoreDependency(systemEnvironment);
            this.childrenDefs.add(this.childDef);
        }
        Collections.sort(this.childrenDefs, Compare.Lexically_Vect0);
    }

    @Override
    final void render(String string) {
        Vector<String> vector = new Vector<String>(this.childrenDefs.size());
        int n = this.childrenDefs.size();
        for (int i = 0; i < n; ++i) {
            int n2;
            Vector vector2 = (Vector)this.childrenDefs.get(i);
            Object e = vector2.get(n2 = vector2.size() - 1);
            if (e instanceof Vector) {
                vector2.set(n2, "ignore_dependencies = (\n\t\t\t\t\t" + DumpSchedulingEntityChildren.join(",\n\t\t\t\t\t", (Vector)e) + ')');
            }
            vector.add(DumpSchedulingEntityChildren.join("\n\t\t\t\t", vector2));
        }
        DumpSchedulingEntityChildren.println("alter job_definition " + this.getName());
        DumpSchedulingEntityChildren.println("\twith");
        DumpSchedulingEntityChildren.println("\t\tchildren = (");
        DumpSchedulingEntityChildren.println("\t\t\t" + DumpSchedulingEntityChildren.join(",\n\t\t\t", vector) + ");");
    }
}

