/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.dump;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.dump.Compare;
import de.independit.scheduler.server.dump.DumpGroup;
import de.independit.scheduler.server.dump.DumpUserGeneric;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.repository.SDMSMember;
import de.independit.scheduler.server.repository.SDMSMemberTable;
import de.independit.scheduler.server.repository.SDMSUser;
import java.util.Collections;
import java.util.Vector;

class DumpUser
extends DumpUserGeneric {
    public static final String __version = "@(#) $Id: DumpUser.java,v 2.3.14.1 2013/03/14 10:24:15 ronald Exp $";
    private String passwd;
    private Boolean isEnabled;
    private Vector groupList;
    private String defaultGroup;

    DumpUser(SystemEnvironment systemEnvironment, SDMSUser sDMSUser) throws SDMSException {
        super(systemEnvironment, sDMSUser);
    }

    private final void loadGroups(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector vector = SDMSMemberTable.idx_uId.getVector(systemEnvironment, this.uId);
        int n = vector.size();
        this.groupList = new Vector(n);
        for (int i = 0; i < n; ++i) {
            SDMSMember sDMSMember = (SDMSMember)vector.get(i);
            Long l = sDMSMember.getGId(systemEnvironment);
            this.groupList.add(DumpGroup.getDumpedName(systemEnvironment, l));
        }
        Collections.sort(this.groupList, Compare.ObjectNames);
    }

    @Override
    final void collect(SystemEnvironment systemEnvironment) throws SDMSException {
        this.passwd = this.u.getPasswd(systemEnvironment);
        this.isEnabled = this.u.getIsEnabled(systemEnvironment);
        this.loadGroups(systemEnvironment);
        Long l = this.u.getDefaultGId(systemEnvironment);
        this.defaultGroup = DumpGroup.getDumpedName(systemEnvironment, l);
    }

    @Override
    final void render(String string) {
        DumpUser.println(string + " user " + this.getName());
        DumpUser.println("\twith");
        DumpUser.println("\t\trawpassword = " + DumpUser.quotedString(this.passwd) + ",");
        DumpUser.println("\t\t" + (this.isEnabled != false ? "enable" : "disable") + ",");
        if (!this.groupList.isEmpty()) {
            DumpUser.println("\t\tgroups = (");
            DumpUser.print("\t\t\t" + DumpUser.join(",\n\t\t\t", this.groupList) + ")");
        }
        DumpUser.println(",\n\t\tdefault group = " + this.defaultGroup + ';');
    }
}

