/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.DuplicateKeyException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.AlterFolder;
import de.independit.scheduler.server.parser.ManipParameters;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSFolder;
import de.independit.scheduler.server.repository.SDMSFolderTable;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSMemberTable;
import de.independit.scheduler.server.repository.SDMSNamedEnvironmentTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSUser;
import de.independit.scheduler.server.repository.SDMSUserTable;
import de.independit.scheduler.server.util.PathVector;

public class CreateFolder
extends Node {
    public static final String __version = "@(#) $Id: CreateFolder.java,v 2.10.2.2 2013/03/19 10:03:52 ronald Exp $";
    private PathVector path;
    private String name;
    private WithHash with;
    private boolean replace;
    private AlterFolder af = null;

    public CreateFolder(PathVector pathVector, WithHash withHash, Boolean bl) {
        this.with = withHash == null ? new WithHash() : withHash;
        this.replace = bl;
        this.path = pathVector;
        if (pathVector.size() == 1) {
            this.af = new AlterFolder(new ObjectURL(new Integer(377), this.path), this.with, Boolean.FALSE);
        } else {
            this.name = (String)pathVector.remove(pathVector.size() - 1);
        }
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSFolder sDMSFolder;
        Long l;
        if (this.af != null) {
            this.af.setEnv(this.env);
            this.af.go(systemEnvironment);
            this.result = this.af.result;
            return;
        }
        Long l2 = null;
        SDMSFolder sDMSFolder2 = SDMSFolderTable.getFolder(systemEnvironment, this.path);
        Long l3 = sDMSFolder2.getId(systemEnvironment);
        if (SDMSSchedulingEntityTable.idx_folderId_name.containsKey(systemEnvironment, new SDMSKey(l3, (Comparable)((Object)this.name)))) {
            throw new DuplicateKeyException(new SDMSMessage(systemEnvironment, "03201290935", "Object with name $1 already exists within $2", (Object)this.name, (Object)SDMSFolderTable.getObject(systemEnvironment, l3).pathString(systemEnvironment)));
        }
        String string = (String)this.with.get("ENVIRONMENT");
        if (string != null) {
            systemEnvironment.checkFeatureAvailability("FOLDER_ENVIRONMENTS");
            l2 = SDMSNamedEnvironmentTable.idx_name_getUnique(systemEnvironment, string).getId(systemEnvironment);
        } else {
            l2 = null;
        }
        Long l4 = this.env.uid();
        SDMSUser sDMSUser = SDMSUserTable.getObject(systemEnvironment, l4);
        if (!this.with.containsKey("GROUP")) {
            l = sDMSUser.getDefaultGId(systemEnvironment);
        } else {
            String string2 = (String)this.with.get("GROUP");
            l = SDMSGroupTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)string2), new Long(0L))).getId(systemEnvironment);
            if (!SDMSMemberTable.idx_gId_uId.containsKey(systemEnvironment, new SDMSKey(l, l4)) && !SDMSMemberTable.idx_gId_uId.containsKey(systemEnvironment, new SDMSKey(SDMSObject.adminGId, l4))) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03312162226", "User $1 does not belong to Group $2", (Object)sDMSUser.getName(systemEnvironment), (Object)string2));
            }
        }
        long l5 = 0L;
        if (this.with.containsKey("INHERIT") && this.with.get("INHERIT") != null) {
            l5 = (Long)this.with.get("INHERIT");
        } else if (sDMSFolder2.getOwnerId(systemEnvironment).equals(l)) {
            l5 = sDMSFolder2.getPrivilegeMask();
        }
        if ((sDMSFolder2.getPrivilegeMask() & l5) != l5) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03202061110", "Incompatible grant"));
        }
        Long l6 = new Long(l5);
        try {
            sDMSFolder = SDMSFolderTable.table.create(systemEnvironment, this.name, l, l2, l3, l6);
        }
        catch (DuplicateKeyException duplicateKeyException) {
            if (this.replace) {
                this.path.add(this.name);
                this.af = new AlterFolder(new ObjectURL(new Integer(377), this.path), this.with, Boolean.FALSE);
                this.af.setEnv(this.env);
                this.af.go(systemEnvironment);
                this.result = this.af.result;
                return;
            }
            throw duplicateKeyException;
        }
        ManipParameters.create(systemEnvironment, sDMSFolder.getId(systemEnvironment), (WithHash)this.with.get("PARAMETERS"));
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03201280946", "Folder created"));
    }
}

