/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.DuplicateKeyException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.AlterInterval;
import de.independit.scheduler.server.parser.IntervalUtil;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSInterval;
import de.independit.scheduler.server.repository.SDMSIntervalProxyGeneric;
import de.independit.scheduler.server.repository.SDMSIntervalTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSMemberTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSUserProxyGeneric;
import de.independit.scheduler.server.repository.SDMSUserTable;
import de.independit.scheduler.server.timer.TimerDate;
import de.independit.scheduler.server.util.DateTime;
import java.util.Date;

public class CreateInterval
extends Node {
    public static final String __version = "@(#) $Id: CreateInterval.java,v 2.10.2.1 2013/03/14 10:24:26 ronald Exp $";
    private final ObjectURL obj;
    private final WithHash with;
    private final boolean replace;
    private Long ivalId;
    private SDMSInterval ival;
    private CreateInterval embeddedInterval;
    private boolean secondsIgnore = false;

    public CreateInterval(ObjectURL objectURL, WithHash withHash, Boolean bl) {
        this.obj = objectURL;
        this.with = withHash;
        this.replace = bl;
        this.embeddedInterval = null;
    }

    public CreateInterval(String string, WithHash withHash) {
        this.obj = new ObjectURL((Integer)411, string);
        this.with = withHash;
        this.replace = true;
        this.embeddedInterval = null;
    }

    public Long getIvalId() {
        return this.ivalId;
    }

    public SDMSInterval getIval() {
        return this.ival;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.obj.toString());
        stringBuffer.append("\n");
        stringBuffer.append(this.with.toString());
        return stringBuffer.toString();
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        this.go(systemEnvironment, 0);
    }

    protected void go(SystemEnvironment systemEnvironment, int n) throws SDMSException {
        Object object;
        Object object2;
        Object object3;
        Long l = null;
        Long l2 = null;
        Long l3 = null;
        Integer n2 = null;
        Integer n3 = null;
        Integer n4 = null;
        Integer n5 = null;
        Boolean bl = Boolean.FALSE;
        Boolean bl2 = Boolean.FALSE;
        Long l4 = null;
        boolean bl3 = false;
        boolean bl4 = false;
        String string = null;
        this.secondsIgnore = false;
        DateTime dateTime = new DateTime(new Date());
        dateTime.suppressSeconds();
        Long l5 = dateTime.toLong();
        try {
            this.obj.resolve(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        if (this.with != null) {
            Cloneable cloneable;
            if (this.with.containsKey("BASE") && (cloneable = (WithHash)this.with.get("BASE")) != null) {
                n2 = (Integer)cloneable.get("INTERVAL");
                n3 = IntervalUtil.getMultiplier(systemEnvironment, cloneable);
            }
            if (this.with.containsKey("DURATION") && (cloneable = (WithHash)this.with.get("DURATION")) != null) {
                n4 = (Integer)cloneable.get("INTERVAL");
                n5 = IntervalUtil.getMultiplier(systemEnvironment, cloneable);
            }
            if (this.with.containsKey("SYNCTIME")) {
                if (IntervalUtil.getDateTime(systemEnvironment, dateTime, this.with, "SYNCTIME")) {
                    this.secondsIgnore = true;
                }
                dateTime.fixToMinDate();
                dateTime.suppressSeconds();
                l5 = dateTime.toLong();
            }
            if (this.with.containsKey("STARTTIME") && this.with.get("STARTTIME") != null) {
                if (IntervalUtil.getDateTime(systemEnvironment, dateTime, this.with, "STARTTIME")) {
                    this.secondsIgnore = true;
                }
                dateTime.fixToMinDate();
                dateTime.suppressSeconds();
                l = dateTime.toLong();
            }
            if (this.with.containsKey("ENDTIME") && this.with.get("ENDTIME") != null) {
                if (IntervalUtil.getDateTime(systemEnvironment, dateTime, this.with, "ENDTIME")) {
                    this.secondsIgnore = true;
                }
                dateTime.fixToMaxDate();
                dateTime.suppressSeconds();
                l2 = dateTime.toLong();
            }
            if (l != null && l2 != null) {
                cloneable = new TimerDate(new DateTime(l, false).toDate());
                object3 = new TimerDate(new DateTime(l2, false).toDate());
                if (((TimerDate)object3).eq((TimerDate)cloneable)) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "04210242337", "STARTTIME and ENDTIME must be different"));
                }
            }
            if (this.with.containsKey("EMBEDDED") && (cloneable = this.with.get("EMBEDDED")) != null) {
                if (cloneable instanceof String) {
                    object3 = (String)((Object)cloneable);
                    if (object3 != null) {
                        if (((String)object3).equals(this.obj.name)) {
                            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "04207191734", "interval cannot embed itself"));
                        }
                        object2 = SDMSIntervalTable.idx_name_objId_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)IntervalUtil.mapIdName((String)object3, this.obj.seId)), null));
                        l4 = ((SDMSProxy)object2).getId(systemEnvironment);
                        if (n4 != null) {
                            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "04311251854", "intervals with EMBEDDED cannot have DURATION"));
                        }
                    }
                } else {
                    this.embeddedInterval = (CreateInterval)((Object)cloneable);
                }
            }
            if (this.with.containsKey("DELAY")) {
                string = "DELAY is not longer supported";
                this.with.remove("DELAY");
            }
            if (this.with.containsKey("INVERSE")) {
                bl = (Boolean)this.with.get("INVERSE");
            }
            if (this.with.containsKey("MERGE")) {
                string = "MERGE is not longer supported";
                this.with.remove("MERGE");
            }
            if (this.with.containsKey("DISPATCH") && this.with.get("DISPATCH") != null) {
                int n6 = 1;
                if (this.with.containsKey("STARTTIME")) {
                    ++n6;
                }
                if (this.with.containsKey("ENDTIME")) {
                    ++n6;
                }
                if (this.with.containsKey("GROUP")) {
                    ++n6;
                }
                if (this.with.containsKey("FILTER") && (object3 = this.with.get("FILTER")) == null) {
                    ++n6;
                }
                if (this.with.containsKey("EMBEDDED") && (object3 = this.with.get("EMBEDDED")) == null) {
                    ++n6;
                }
                if (this.with.containsKey("SELECTION") && (object3 = this.with.get("SELECTION")) == null) {
                    ++n6;
                }
                if (this.with.containsKey("BASE") && (object3 = this.with.get("BASE")) == null) {
                    ++n6;
                }
                if (this.with.containsKey("DURATION") && (object3 = this.with.get("DURATION")) == null) {
                    ++n6;
                }
                if (this.with.size() > n6) {
                    object3 = new StringBuffer();
                    object2 = this.with.keySet().iterator();
                    String string2 = "";
                    while (object2.hasNext()) {
                        ((StringBuffer)object3).append(string2);
                        ((StringBuffer)object3).append(object2.next().toString());
                        string2 = ",";
                    }
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03808211116", "Dispatch interval definitions are not allowed to specify other attributes than STARTTIME, ENDTIME and GROUP; found " + ((StringBuffer)object3).toString()));
                }
            }
        }
        Long l6 = this.env.uid();
        object3 = SDMSUserTable.getObject(systemEnvironment, l6);
        if (this.with == null || !this.with.containsKey("GROUP")) {
            object2 = ((SDMSUserProxyGeneric)object3).getDefaultGId(systemEnvironment);
        } else {
            object = (String)this.with.get("GROUP");
            object2 = SDMSGroupTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)object, new Long(0L))).getId(systemEnvironment);
            if (!SDMSMemberTable.idx_gId_uId.containsKey(systemEnvironment, new SDMSKey((Comparable)object2, l6)) && !SDMSMemberTable.idx_gId_uId.containsKey(systemEnvironment, new SDMSKey(SDMSObject.adminGId, l6))) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03312161745", "User $1 does not belong to Group $2", (Object)((SDMSUserProxyGeneric)object3).getName(systemEnvironment), object));
            }
        }
        try {
            object = null;
            if (n != 0) {
                object = new Long(n);
            }
            this.ival = SDMSIntervalTable.table.create(systemEnvironment, this.obj.mappedName, (Long)object2, l, l2, l3, n2, n3, n4, n5, l5, bl, bl2, l4, this.obj.seId, (Long)object, null);
            this.ivalId = this.ival.getId(systemEnvironment);
        }
        catch (DuplicateKeyException duplicateKeyException) {
            if (this.replace) {
                AlterInterval alterInterval = new AlterInterval(this.obj, this.with, Boolean.FALSE);
                alterInterval.setEnv(this.env);
                alterInterval.go(systemEnvironment);
                this.result = alterInterval.result;
                return;
            }
            throw duplicateKeyException;
        }
        if (this.embeddedInterval != null) {
            this.embeddedInterval.setEnv(this.env);
            this.embeddedInterval.go(systemEnvironment, n + 1);
            this.ival.setEmbeddedIntervalId(systemEnvironment, this.embeddedInterval.getIvalId());
            object = this.embeddedInterval.getIval();
            ((SDMSIntervalProxyGeneric)object).setObjId(systemEnvironment, this.ivalId);
            ((SDMSIntervalProxyGeneric)object).setObjType(systemEnvironment, new Integer(19));
        }
        if (this.with != null) {
            if (this.with.containsKey("SELECTION")) {
                switch (IntervalUtil.createSelections(systemEnvironment, this.ivalId, this.with)) {
                    case 2: {
                        this.secondsIgnore = true;
                        break;
                    }
                    case 1: {
                        bl4 = true;
                    }
                }
            }
            if (this.with.containsKey("FILTER")) {
                bl3 = IntervalUtil.createFilter(systemEnvironment, this.ivalId, this.with, this.obj.seId, n + 1);
            }
            if (this.with.containsKey("DISPATCH")) {
                IntervalUtil.createDispatcher(systemEnvironment, this.ivalId, this.with, n + 1);
            }
        }
        if (bl3) {
            this.result.setFeedback(new SDMSMessage(systemEnvironment, "04209270107", "Interval created (WARNING: duplicate FILTER will be ignored)"));
        } else if (this.secondsIgnore) {
            this.result.setFeedback(new SDMSMessage(systemEnvironment, "04209201340", "Interval created (WARNING: seconds will be ignored)"));
        } else if (bl4) {
            this.result.setFeedback(new SDMSMessage(systemEnvironment, "04209270143", "Interval created (WARNING: upper range(s) will be ignored)"));
        } else {
            this.result.setFeedback(new SDMSMessage(systemEnvironment, "04107191714", "Interval created" + (string == null ? "" : ". " + string)));
        }
    }
}

