/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.AlterResource;
import de.independit.scheduler.server.parser.ManipResource;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSFolder;
import de.independit.scheduler.server.repository.SDMSFolderTable;
import de.independit.scheduler.server.repository.SDMSGroup;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResource;
import de.independit.scheduler.server.repository.SDMSResourceStateDefinition;
import de.independit.scheduler.server.repository.SDMSResourceStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSResourceStateProfile;
import de.independit.scheduler.server.repository.SDMSResourceStateProfileTable;
import de.independit.scheduler.server.repository.SDMSResourceStateTable;
import de.independit.scheduler.server.repository.SDMSResourceTable;
import de.independit.scheduler.server.repository.SDMSResourceTemplate;
import de.independit.scheduler.server.repository.SDMSResourceTemplateTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.repository.SDMSUser;
import de.independit.scheduler.server.repository.SDMSUserTable;
import java.util.Date;
import java.util.HashSet;
import java.util.Vector;

public class CreateResource
extends ManipResource {
    public static final String __version = "@(#) $Id: CreateResource.java,v 2.14.4.5 2013/03/26 11:59:17 ronald Exp $";
    static final Float fzero = new Float(0.0f);
    private WithHash with;
    private boolean replace;
    private WithHash parms;

    public CreateResource(Vector vector, Vector vector2, WithHash withHash, Boolean bl) {
        this.resourcepath = vector;
        this.path = vector2;
        this.with = withHash;
        this.rId = null;
        this.replace = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        Cloneable cloneable;
        Long l;
        SDMSResourceStateDefinition sDMSResourceStateDefinition = null;
        Long l2 = null;
        Long l3 = null;
        boolean bl = false;
        boolean bl2 = true;
        this.status = (String)this.with.get("STATUS");
        this.requestableAmount = (Integer)this.with.get("REQUESTABLE_AMOUNT");
        this.amount = (Integer)this.with.get("AMOUNT");
        this.online = (Boolean)this.with.get("ONLINE");
        if (this.online == null) {
            this.online = Boolean.FALSE;
        }
        this.groupname = (String)this.with.get("GROUP");
        this.parms = (WithHash)this.with.get("PARAMETERS");
        if (this.groupname != null) {
            SDMSGroup sDMSGroup = SDMSGroupTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)this.groupname), new Long(0L)));
            l = sDMSGroup.getId(systemEnvironment);
        } else {
            SDMSUser sDMSUser = SDMSUserTable.getObject(systemEnvironment, systemEnvironment.cEnv.uid());
            l = sDMSUser.getDefaultGId(systemEnvironment);
        }
        HashSet hashSet = systemEnvironment.cEnv.gid();
        if (!hashSet.contains(l) && !hashSet.contains(SDMSObject.adminGId)) {
            throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03402260151", "You cannot put a resource into a group you do not belong to"));
        }
        SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getNamedResource(systemEnvironment, this.resourcepath);
        Long l4 = sDMSNamedResource.getId(systemEnvironment);
        try {
            SDMSScope sDMSScope = SDMSScopeTable.getScope(systemEnvironment, this.path);
            l3 = sDMSScope.getId(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            bl2 = false;
            try {
                SDMSFolder sDMSFolder = SDMSFolderTable.getFolder(systemEnvironment, this.path);
                systemEnvironment.checkFeatureAvailability("FOLDER_RESOURCES");
                l3 = sDMSFolder.getId(systemEnvironment);
            }
            catch (NotFoundException notFoundException2) {
                systemEnvironment.checkFeatureAvailability("SE_RESOURCES");
                bl = true;
                SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.get(systemEnvironment, this.path, null);
                l3 = sDMSSchedulingEntity.getId(systemEnvironment);
            }
        }
        this.factor = (Float)this.with.get("FACTOR");
        this.tag = (String)this.with.get("TAG");
        this.traceInterval = (Integer)this.with.get("TRACE");
        this.traceBase = (Integer)this.with.get("BASE");
        this.baseMultiplier = (Integer)this.with.get("MULTIPLIER");
        if (this.traceInterval != null || this.traceBase != null) {
            systemEnvironment.checkFeatureAvailability("RESOURCE_TRACING");
        }
        if (this.baseMultiplier == null) {
            this.baseMultiplier = new Integer(600);
        }
        if (this.replace && (SDMSResourceTable.idx_nrId_scopeId.containsKey(systemEnvironment, cloneable = new SDMSKey(l4, l3)) || SDMSResourceTemplateTable.idx_nrId_seId.containsKey(systemEnvironment, cloneable))) {
            SDMSProxy sDMSProxy = null;
            try {
                sDMSProxy = SDMSResourceTable.idx_nrId_scopeId_getUnique(systemEnvironment, cloneable);
            }
            catch (NotFoundException notFoundException) {
                sDMSProxy = SDMSResourceTemplateTable.idx_nrId_seId_getUnique(systemEnvironment, cloneable);
            }
            AlterResource alterResource = new AlterResource(sDMSProxy, this.with, Boolean.FALSE);
            alterResource.setEnv(this.env);
            alterResource.go(systemEnvironment);
            this.result = alterResource.result;
            return;
        }
        if (this.status != null) {
            sDMSResourceStateDefinition = SDMSResourceStateDefinitionTable.idx_name_getUnique(systemEnvironment, this.status);
            l2 = sDMSResourceStateDefinition.getId(systemEnvironment);
        }
        if (this.requestableAmount == null && this.amount == null) {
            this.requestableAmount = new Integer(-1);
        }
        if (this.requestableAmount == null) {
            this.requestableAmount = this.amount;
        }
        if (this.amount == null) {
            this.amount = this.requestableAmount;
        }
        l2 = this.check_resource(systemEnvironment, sDMSNamedResource, l2, this.requestableAmount, this.amount, bl2);
        cloneable = new Date();
        Long l5 = new Long(((Date)cloneable).getTime());
        if (this.requestableAmount == -1) {
            this.requestableAmount = null;
        }
        if (this.amount == -1) {
            this.amount = null;
        }
        if (bl) {
            SDMSResourceTemplate sDMSResourceTemplate = SDMSResourceTemplateTable.table.create(systemEnvironment, l4, l3, l, l2, this.requestableAmount, this.amount, this.online);
            sDMSResourceTemplate.createVariables(systemEnvironment, this.parms);
        } else {
            SDMSResource sDMSResource = SDMSResourceTable.table.create(systemEnvironment, l4, l3, null, l, null, null, null, l2, l5, this.amount, this.requestableAmount, this.amount, this.amount, this.online, this.factor, this.traceInterval, this.traceBase, this.baseMultiplier, fzero, fzero, fzero, fzero, new Long(0L), new Long(0L));
            if (this.tag != null) {
                sDMSResource.setTag(systemEnvironment, this.tag);
            }
            sDMSResource.createVariables(systemEnvironment, this.parms);
            SystemEnvironment.sched.notifyChange(systemEnvironment, sDMSResource, l3, 1);
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03202211126", "Resource created"));
    }

    private Long check_resource(SystemEnvironment systemEnvironment, SDMSNamedResource sDMSNamedResource, Long l, Integer n, Integer n2, boolean bl) throws SDMSException {
        Long l2 = sDMSNamedResource.getRspId(systemEnvironment);
        if (l2 == null) {
            if (l != null) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03202211132", "Named Resource $1 is stateless", (Object)this.resourcepath));
            }
        } else {
            SDMSResourceStateProfile sDMSResourceStateProfile = SDMSResourceStateProfileTable.getObject(systemEnvironment, l2);
            if (l == null) {
                if (sDMSResourceStateProfile.getInitialRsdId(systemEnvironment) == null) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03202211217", "Resource must have an initial state"));
                }
                l = sDMSResourceStateProfile.getInitialRsdId(systemEnvironment);
            } else if (!SDMSResourceStateTable.idx_rsdId_rspId.containsKey(systemEnvironment, new SDMSKey(l, l2))) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03202211221", "Resource state is not defined in the profile $1", (Object)sDMSResourceStateProfile.getName(systemEnvironment)));
            }
        }
        if (sDMSNamedResource.getUsage(systemEnvironment) == 8) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03206250052", "A resource category cannot be allocated"));
        }
        if (sDMSNamedResource.getUsage(systemEnvironment) == 1) {
            if (n2 != null && n2 != -1) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03202211140", "A static resource cannot have an amount other than infinite"));
            }
            if (n != null && n != -1) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02402030932", "A static resource cannot have an requestable amount other than infinite"));
            }
            if (!bl) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03410051436", "A static resource can only be created within a scope or jobserver"));
            }
        }
        return l;
    }
}

