/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.EventParameter;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.repository.SDMSEvent;
import de.independit.scheduler.server.repository.SDMSScheduledEventTable;

public class DropEvent
extends Node {
    public static final String __version = "@(#) $Id: DropEvent.java,v 2.3.4.1 2013/03/14 10:24:29 ronald Exp $";
    private final ObjectURL obj;
    private final boolean noerr;

    public DropEvent(ObjectURL objectURL, Boolean bl) {
        this.obj = objectURL;
        this.noerr = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSEvent sDMSEvent = (SDMSEvent)this.obj.resolve(systemEnvironment);
        Long l = this.obj.objId;
        if (SDMSScheduledEventTable.idx_evtId.containsKey(systemEnvironment, l)) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "04203162027", "Event in use by Scheduled Event(s)"));
        }
        EventParameter.kill(systemEnvironment, l);
        sDMSEvent.delete(systemEnvironment);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "04203161916", "Event dropped"));
    }
}

