/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.repository.SDMSEventTable;
import de.independit.scheduler.server.repository.SDMSFolderTable;
import de.independit.scheduler.server.repository.SDMSGroup;
import de.independit.scheduler.server.repository.SDMSIntervalTable;
import de.independit.scheduler.server.repository.SDMSMember;
import de.independit.scheduler.server.repository.SDMSMemberTable;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSObjectCommentTable;
import de.independit.scheduler.server.repository.SDMSResourceTable;
import de.independit.scheduler.server.repository.SDMSScheduleTable;
import de.independit.scheduler.server.repository.SDMSScheduledEventTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import de.independit.scheduler.server.repository.SDMSTriggerTable;
import de.independit.scheduler.server.repository.SDMSUser;
import de.independit.scheduler.server.repository.SDMSUserTable;
import java.util.Vector;

public class DropGroup
extends Node {
    public static final String __version = "@(#) $Id: DropGroup.java,v 2.4.6.1 2013/03/14 10:24:30 ronald Exp $";
    private ObjectURL url;
    private boolean noerr;

    public DropGroup(ObjectURL objectURL, Boolean bl) {
        this.url = objectURL;
        this.noerr = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSGroup sDMSGroup;
        try {
            sDMSGroup = (SDMSGroup)this.url.resolve(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            if (this.noerr) {
                this.result.setFeedback(new SDMSMessage(systemEnvironment, "03312130041", "No group dropped"));
                return;
            }
            throw notFoundException;
        }
        Long l = sDMSGroup.getId(systemEnvironment);
        Vector vector = SDMSMemberTable.idx_gId.getVector(systemEnvironment, l);
        SDMSMember sDMSMember = null;
        for (int i = 0; i < vector.size(); ++i) {
            SDMSMember sDMSMember2 = (SDMSMember)vector.get(i);
            Long l2 = sDMSMember2.getUId(systemEnvironment);
            SDMSUser sDMSUser = SDMSUserTable.getObject(systemEnvironment, l2);
            if (l.equals(sDMSUser.getDefaultGId(systemEnvironment))) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03312130038", "you cannot remove a user from his default group"));
            }
            if (l2.equals(systemEnvironment.cEnv.uid())) {
                sDMSMember = sDMSMember2;
                continue;
            }
            sDMSMember2.delete(systemEnvironment);
        }
        String string = sDMSGroup.getName(systemEnvironment);
        if (SDMSEventTable.idx_ownerId.containsKey(systemEnvironment, l)) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02402181200", "One or more $1 still owned by group $2", (Object)"Event", (Object)string));
        }
        if (SDMSFolderTable.idx_ownerId.containsKey(systemEnvironment, l)) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02402181201", "One or more $1 still owned by group $2", (Object)"Folder", (Object)string));
        }
        if (SDMSIntervalTable.idx_ownerId.containsKey(systemEnvironment, l)) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02402181202", "One or more $1 still owned by group $2", (Object)"Interval", (Object)string));
        }
        if (SDMSNamedResourceTable.idx_ownerId.containsKey(systemEnvironment, l)) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02402181203", "One or more $1 still owned by group $2", (Object)"NamedResource", (Object)string));
        }
        if (SDMSScheduleTable.idx_ownerId.containsKey(systemEnvironment, l)) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02402181204", "One or more $1 still owned by group $2", (Object)"Schedule", (Object)string));
        }
        if (SDMSScheduledEventTable.idx_ownerId.containsKey(systemEnvironment, l)) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02402181205", "One or more $1 still owned by group $2", (Object)"ScheduledEvent", (Object)string));
        }
        if (SDMSSchedulingEntityTable.idx_ownerId.containsKey(systemEnvironment, l)) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02402181206", "One or more $1 still owned by group $2", (Object)"SchedulingEntity", (Object)string));
        }
        if (SDMSScopeTable.idx_ownerId.containsKey(systemEnvironment, l)) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02402181207", "One or more $1 still owned by group $2", (Object)"Scope", (Object)string));
        }
        if (SDMSSubmittedEntityTable.idx_ownerId.containsKey(systemEnvironment, l)) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02402181208", "One or more $1 still owned by group $2", (Object)"SubmittedEntity", (Object)string));
        }
        if (SDMSResourceTable.idx_ownerId.containsKey(systemEnvironment, l)) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02402270834", "One or more $1 still owned by group $2", (Object)"Resource", (Object)string));
        }
        if (SDMSTriggerTable.idx_submitOwnerId.containsKey(systemEnvironment, l)) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02402181209", "One or more Master Trigger still submits for group $1", (Object)string));
        }
        SDMSObjectCommentTable.dropComment(systemEnvironment, l);
        sDMSGroup.setDeleteVersion(systemEnvironment, new Long(systemEnvironment.tx.txId));
        if (sDMSMember != null) {
            sDMSMember.delete(systemEnvironment);
            systemEnvironment.cEnv.delGid(l);
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03312091433", "Group disabled"));
    }
}

