/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.repository.SDMSResourceStateDefinition;
import de.independit.scheduler.server.repository.SDMSResourceStateDefinitionTable;

public class DropResourceStatus
extends Node {
    public static final String __version = "@(#) $Id: DropResourceStatus.java,v 2.0.20.1 2013/03/14 10:24:31 ronald Exp $";
    private String name;
    private boolean noerr;

    public DropResourceStatus(String string, Boolean bl) {
        this.name = string;
        this.noerr = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSResourceStateDefinition sDMSResourceStateDefinition;
        try {
            sDMSResourceStateDefinition = SDMSResourceStateDefinitionTable.idx_name_getUnique(systemEnvironment, this.name);
        }
        catch (NotFoundException notFoundException) {
            if (this.noerr) {
                this.result.setFeedback(new SDMSMessage(systemEnvironment, "03311122323", "No Resource State Definition dropped"));
                return;
            }
            throw notFoundException;
        }
        sDMSResourceStateDefinition.delete(systemEnvironment);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03201100113", "Resource State Definition dropped"));
    }
}

