/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.repository.SDMSGrant;
import de.independit.scheduler.server.repository.SDMSGrantTable;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSScope;
import java.util.Vector;

public class Grant
extends Node {
    public static final String __version = "@(#) $Id: Grant.java,v 2.20.2.2 2013/03/16 10:35:53 dieter Exp $";
    private boolean isGrant;
    private Vector groupList;
    private long lpriv;
    private ObjectURL url;
    private Boolean isRecursive;
    private Boolean isForce;
    private Boolean childrenOnly;
    private int thisType;
    private static final Integer SYSTEM = new Integer(0);
    private static final Long NOPRIVS = new Long(0L);
    private static final Long ZERO = new Long(0L);

    public Grant(Boolean bl, Long l, ObjectURL objectURL, Vector vector, Boolean bl2, Boolean bl3) {
        this.isGrant = bl;
        this.groupList = vector;
        this.lpriv = l;
        this.url = objectURL;
        if (bl2 == null) {
            this.isRecursive = Boolean.FALSE;
            this.isForce = Boolean.FALSE;
        } else if (bl2.booleanValue()) {
            this.isRecursive = Boolean.TRUE;
            this.isForce = Boolean.TRUE;
        } else {
            this.isRecursive = Boolean.FALSE;
            this.isForce = Boolean.TRUE;
        }
        this.childrenOnly = bl3;
    }

    public Grant(Boolean bl, Integer n, Vector vector) {
        this.isGrant = bl;
        this.groupList = vector;
        this.childrenOnly = Boolean.FALSE;
        this.isForce = Boolean.FALSE;
        this.isRecursive = Boolean.FALSE;
        this.url = null;
        if (n != 591 && n != 445) {
            ObjectURL objectURL = new ObjectURL(n);
            this.thisType = objectURL.objType;
        } else {
            this.thisType = n == 591 ? 0 : 99;
        }
        this.lpriv = this.getManagePriv(this.thisType);
    }

    private long getManagePriv(int n) {
        switch (n) {
            case 2: {
                return 0x1000000000L;
            }
            case 3: {
                return 0x2000000000L;
            }
            case 4: {
                return 0x4000000000L;
            }
            case 5: {
                return 0x8000000000L;
            }
            case 13: {
                return 0x10000000000L;
            }
            case 14: {
                return 0x20000000000L;
            }
            case 12: {
                return 0x40000000000L;
            }
            case 7: {
                return 0x80000000000L;
            }
            case 8: {
                return 0x400000000L;
            }
            case 21: {
                return 0x800000000L;
            }
            case 1: {
                return 0x100000000000L;
            }
            case 0: {
                return 0x200000000000L;
            }
            case 99: {
                return 0x400000000000L;
            }
            case 31: {
                return 0x800000000000L;
            }
        }
        return 0L;
    }

    private void checkObjectType(SystemEnvironment systemEnvironment, int n) throws SDMSException {
        if (n == 1) {
            return;
        }
        if (n == 10) {
            return;
        }
        if (n == 6) {
            return;
        }
        if (n == 9) {
            return;
        }
        if (n == 17) {
            return;
        }
        if (n == 15) {
            return;
        }
        if (n == 18) {
            return;
        }
        if (n == 19) {
            return;
        }
        if (n == 20) {
            return;
        }
        if (n == 21) {
            return;
        }
        if (n == 11) {
            return;
        }
        if (n == 30) {
            return;
        }
        if (n == 31) {
            return;
        }
        throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03601231458", "Objecttype not supported"));
    }

    private int adjustType(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy, int n) throws SDMSException {
        if (n == 6 && sDMSProxy instanceof SDMSSchedulingEntity) {
            return 9;
        }
        return n;
    }

    private Vector makeGroupList(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector<Long> vector = new Vector<Long>();
        for (int i = 0; i < this.groupList.size(); ++i) {
            String string = (String)this.groupList.get(i);
            Long l = SDMSGroupTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)string), ZERO)).getId(systemEnvironment);
            vector.addElement(l);
        }
        return vector;
    }

    private void performGrant(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy, int n, long l, Vector vector, boolean bl, boolean bl2) throws SDMSException {
        long l2 = l;
        if (!sDMSProxy.checkPrivileges(systemEnvironment, 0x200000000L)) {
            if (bl2) {
                return;
            }
            throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03402191311", "Insufficient privileges"));
        }
        if ((sDMSProxy.getPrivilegeMask() & l) != l) {
            if (bl2) {
                l2 = sDMSProxy.getPrivilegeMask() & l;
            } else {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03402240938", "Incompatible grant"));
            }
        }
        Long l3 = sDMSProxy.getId(systemEnvironment);
        SDMSPrivilege sDMSPrivilege = new SDMSPrivilege();
        sDMSPrivilege.addPriv(systemEnvironment, l2);
        this.thisType = this.adjustType(systemEnvironment, sDMSProxy, n);
        if (this.thisType == 15 && sDMSPrivilege.can(0x100000000L)) {
            SystemEnvironment.sched.notifyChange(systemEnvironment, (SDMSScope)sDMSProxy, 2);
        }
        for (int i = 0; i < vector.size(); ++i) {
            SDMSGrant sDMSGrant;
            Long l4 = (Long)vector.get(i);
            try {
                sDMSGrant = SDMSGrantTable.idx_objectId_gId_getUnique(systemEnvironment, new SDMSKey(l3, l4));
            }
            catch (NotFoundException notFoundException) {
                sDMSGrant = SDMSGrantTable.table.create(systemEnvironment, l3, l4, new Integer(this.thisType), NOPRIVS, null);
            }
            Long l5 = sDMSGrant.getPrivs(systemEnvironment);
            if (this.isGrant) {
                sDMSPrivilege.addPriv(systemEnvironment, l5);
            } else {
                sDMSPrivilege.addPriv(systemEnvironment, l5);
                sDMSPrivilege.delPriv(systemEnvironment, l2);
            }
            if (sDMSPrivilege.isEmpty()) {
                sDMSGrant.delete(systemEnvironment);
                continue;
            }
            sDMSGrant.setPrivs(systemEnvironment, sDMSPrivilege.toLong());
        }
        if (bl) {
            Vector vector2 = sDMSProxy.getContent(systemEnvironment);
            if (vector2 == null) {
                return;
            }
            for (int i = 0; i < vector2.size(); ++i) {
                this.performGrant(systemEnvironment, (SDMSProxy)vector2.get(i), this.thisType, l, vector, bl, bl2);
            }
        }
    }

    private void performManageGrant(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        Long l = SDMSPrivilege.SYSPRIVOBJID;
        if (!systemEnvironment.cEnv.gid().contains(SDMSObject.adminGId)) {
            throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03110051520", "Insufficient privileges"));
        }
        SDMSPrivilege sDMSPrivilege = new SDMSPrivilege(systemEnvironment, this.lpriv);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSGrant sDMSGrant;
            Long l2 = (Long)vector.get(i);
            try {
                sDMSGrant = SDMSGrantTable.idx_objectId_gId_getUnique(systemEnvironment, new SDMSKey(l, l2));
            }
            catch (NotFoundException notFoundException) {
                sDMSGrant = SDMSGrantTable.table.create(systemEnvironment, l, l2, SYSTEM, NOPRIVS, null);
            }
            Long l3 = sDMSGrant.getPrivs(systemEnvironment);
            if (this.isGrant) {
                sDMSPrivilege.addPriv(systemEnvironment, l3);
            } else {
                sDMSPrivilege.addPriv(systemEnvironment, l3);
                sDMSPrivilege.delPriv(systemEnvironment, this.lpriv);
            }
            if (sDMSPrivilege.isEmpty()) {
                sDMSGrant.delete(systemEnvironment);
                continue;
            }
            sDMSGrant.setPrivs(systemEnvironment, sDMSPrivilege.toLong());
        }
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        boolean bl = this.isRecursive;
        boolean bl2 = this.isForce;
        Vector vector = this.makeGroupList(systemEnvironment);
        if (this.url == null) {
            systemEnvironment.checkFeatureAvailability("GRANTS");
            this.performManageGrant(systemEnvironment, vector);
        } else {
            SDMSProxy sDMSProxy = this.url.resolve(systemEnvironment);
            int n = this.url.objType;
            this.checkObjectType(systemEnvironment, n);
            if (n != 1) {
                systemEnvironment.checkFeatureAvailability("GRANTS");
            }
            if (this.childrenOnly.booleanValue()) {
                Vector vector2 = sDMSProxy.getContent(systemEnvironment);
                if (vector2 != null) {
                    for (int i = 0; i < vector2.size(); ++i) {
                        this.performGrant(systemEnvironment, (SDMSProxy)vector2.get(i), n, this.lpriv, vector, bl, bl2);
                    }
                }
            } else {
                this.performGrant(systemEnvironment, sDMSProxy, n, this.lpriv, vector, bl, bl2);
            }
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03402110010", (this.isGrant ? "Grant" : "Revoke") + " issued"));
    }
}

