/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.cmdline.CmdLineParser;
import de.independit.scheduler.server.parser.cmdline.CmdLineScanner;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSKillJob;
import de.independit.scheduler.server.repository.SDMSParameterDefinition;
import de.independit.scheduler.server.repository.SDMSParameterDefinitionProxyGeneric;
import de.independit.scheduler.server.repository.SDMSParameterDefinitionTable;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSRunnableQueue;
import de.independit.scheduler.server.repository.SDMSRunnableQueueTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSScopeConfig;
import de.independit.scheduler.server.repository.SDMSScopeConfigProxyGeneric;
import de.independit.scheduler.server.repository.SDMSScopeConfigTable;
import de.independit.scheduler.server.repository.SDMSScopeProxyGeneric;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import java.io.IOException;
import java.io.StringReader;
import java.util.Vector;

public abstract class JobDistribution
extends Node {
    public static final String __version = "@(#) $Id: JobDistribution.java,v 2.15.4.1 2013/03/14 10:24:34 ronald Exp $";

    public JobDistribution() {
        this.cmdtype = 2;
    }

    @Override
    public abstract void go(SystemEnvironment var1) throws SDMSException;

    boolean startJob(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, SDMSScope sDMSScope, Vector vector, Vector vector2) throws SDMSException {
        boolean bl;
        Object object;
        Object object2;
        Object object3;
        Vector vector3;
        StringReader stringReader;
        String string;
        String string2;
        String string3;
        Long l = sDMSSubmittedEntity.getId(systemEnvironment);
        Long l2 = sDMSScope.getId(systemEnvironment);
        boolean bl2 = false;
        SDMSSchedulingEntity sDMSSchedulingEntity = null;
        SDMSRunnableQueue sDMSRunnableQueue = null;
        vector2.add("STARTJOB");
        vector.add("ID");
        vector.add("DIR");
        vector.add("LOG");
        vector.add("LOGAPP");
        vector.add("ERR");
        vector.add("ERRAPP");
        vector.add("CMD");
        vector.add("ARGS");
        vector.add("ENV");
        vector.add("RUN");
        vector.add("JOBENV");
        long l3 = sDMSSubmittedEntity.getSeVersion(systemEnvironment);
        sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment), l3);
        vector2.add(l);
        sDMSSubmittedEntity.setState(systemEnvironment, new Integer(5));
        if (sDMSSubmittedEntity.getRerunSeq(systemEnvironment) > 0) {
            bl2 = true;
            string3 = sDMSSchedulingEntity.getRerunProgram(systemEnvironment);
            if (string3 == null || string3.length() == 0) {
                string3 = sDMSSchedulingEntity.getRunProgram(systemEnvironment);
            }
        } else {
            string3 = sDMSSchedulingEntity.getRunProgram(systemEnvironment);
            if (string3 == null) {
                systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
                sDMSSubmittedEntity.setToError(systemEnvironment, "Missing run program");
                this.delFromQueue(systemEnvironment, l);
                return false;
            }
        }
        sDMSSubmittedEntity.setScopeId(systemEnvironment, l2);
        String string4 = sDMSSchedulingEntity.getWorkdir(systemEnvironment);
        if (string4 != null) {
            string4 = string4.trim();
        }
        if ((string2 = sDMSSchedulingEntity.getLogfile(systemEnvironment)) != null) {
            string2 = string2.trim();
        }
        if ((string = sDMSSchedulingEntity.getErrlogfile(systemEnvironment)) != null) {
            string = string.trim();
        }
        try {
            if (string4 != null) {
                stringReader = new StringReader(string4);
                vector3 = this.cmdlineScan(systemEnvironment, stringReader, sDMSSubmittedEntity, sDMSSubmittedEntity, l, "Working Directory", "Working Directory Name is empty");
                string4 = (String)vector3.get(0);
            } else {
                object3 = l2;
                while (true) {
                    try {
                        object2 = (SDMSScopeConfig)SDMSScopeConfigTable.idx_scopeId_key.getUnique(systemEnvironment, new SDMSKey((Comparable)object3, (Comparable)((Object)"DEFAULTWORKDIR")));
                        string4 = ((SDMSScopeConfigProxyGeneric)object2).getValue(systemEnvironment).substring(1);
                    }
                    catch (NotFoundException notFoundException) {
                        if ((object3 = ((SDMSScopeProxyGeneric)(object = SDMSScopeTable.getObject(systemEnvironment, (Long)object3))).getParentId(systemEnvironment)) != null) continue;
                        systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
                        sDMSSubmittedEntity.setToError(systemEnvironment, "Default workdir not defined");
                        this.delFromQueue(systemEnvironment, l);
                        return false;
                    }
                    break;
                }
            }
            vector2.add(string4);
            sDMSSubmittedEntity.setWorkdir(systemEnvironment, string4);
            if (string2 != null) {
                stringReader = new StringReader(string2);
                vector3 = this.cmdlineScan(systemEnvironment, stringReader, sDMSSubmittedEntity, sDMSSubmittedEntity, l, "Logfile", "Logfile Name is empty");
                string2 = (String)vector3.get(0);
            }
            vector2.add(string2);
            String string5 = string2;
            sDMSSubmittedEntity.setLogfile(systemEnvironment, string2);
            Boolean bl3 = sDMSSchedulingEntity.getTruncLog(systemEnvironment);
            if (bl2) {
                vector2.add(new Boolean(true));
            } else {
                vector2.add(bl3 == null ? new Boolean(true) : new Boolean(bl3 == false));
            }
            if (string != null) {
                stringReader = new StringReader(string);
                vector3 = this.cmdlineScan(systemEnvironment, stringReader, sDMSSubmittedEntity, sDMSSubmittedEntity, l, "Error Logfile", "Error Logfile Name is empty");
                string = (String)vector3.get(0);
            }
            vector2.add(string);
            string5 = string;
            sDMSSubmittedEntity.setErrlogfile(systemEnvironment, string);
            bl3 = sDMSSchedulingEntity.getTruncErrlog(systemEnvironment);
            if (bl2) {
                vector2.add(new Boolean(true));
            } else {
                vector2.add(bl3 == null ? new Boolean(true) : new Boolean(bl3 == false));
            }
        }
        catch (CommonErrorException commonErrorException) {
            return false;
        }
        stringReader = new StringReader(string3);
        try {
            vector3 = this.cmdlineScan(systemEnvironment, stringReader, sDMSSubmittedEntity, sDMSSubmittedEntity, l, "run/rerun Program", "Run Program is missing");
        }
        catch (CommonErrorException commonErrorException) {
            return false;
        }
        object3 = (String)vector3.get(0);
        vector2.add(object3);
        vector3.remove(0);
        vector2.add(vector3);
        object2 = this.renderCmdLine((String)object3, vector3);
        if (bl2) {
            sDMSSubmittedEntity.setRrCommandline(systemEnvironment, (String)object2);
        } else {
            sDMSSubmittedEntity.setCommandline(systemEnvironment, (String)object2);
        }
        this.fillEnvironment(systemEnvironment, sDMSSubmittedEntity, vector2);
        object = SDMSRunnableQueueTable.idx_smeId.getVectorForUpdate(systemEnvironment, l);
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            sDMSRunnableQueue = (SDMSRunnableQueue)((Vector)object).get(i);
            if (sDMSRunnableQueue.getScopeId(systemEnvironment).equals(l2)) {
                sDMSRunnableQueue.setState(systemEnvironment, new Integer(5));
                continue;
            }
            sDMSRunnableQueue.delete(systemEnvironment);
        }
        vector2.add(sDMSSubmittedEntity.getRerunSeq(systemEnvironment));
        Vector<String> vector4 = new Vector<String>();
        Vector vector5 = SDMSParameterDefinitionTable.idx_seId.getVector(systemEnvironment, sDMSSchedulingEntity.getId(systemEnvironment));
        for (SDMSParameterDefinition sDMSParameterDefinition : vector5) {
            String string6 = sDMSParameterDefinition.getExportName(systemEnvironment);
            if (string6 == null) continue;
            vector4.add(string6);
            vector4.add(sDMSSubmittedEntity.getVariableValue(systemEnvironment, sDMSParameterDefinition.getName(systemEnvironment), false, "DEFAULT"));
        }
        vector2.add(vector4);
        try {
            int n = Integer.parseInt((String)object3);
            sDMSSubmittedEntity.finishJob(systemEnvironment, n, null, null);
            bl = false;
        }
        catch (NumberFormatException numberFormatException) {
            bl = true;
        }
        systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        return bl;
    }

    boolean startKillJob(SystemEnvironment systemEnvironment, SDMSKillJob sDMSKillJob, SDMSScope sDMSScope, Vector vector, Vector vector2) throws SDMSException {
        Object object2;
        Vector vector3;
        StringReader stringReader;
        String string;
        String string2;
        Long l = sDMSScope.getId(systemEnvironment);
        SDMSSchedulingEntity sDMSSchedulingEntity = null;
        SDMSSubmittedEntity sDMSSubmittedEntity = null;
        SDMSRunnableQueue sDMSRunnableQueue = null;
        vector2.add("STARTJOB");
        vector.add("ID");
        vector.add("DIR");
        vector.add("LOG");
        vector.add("LOGAPP");
        vector.add("ERR");
        vector.add("ERRAPP");
        vector.add("CMD");
        vector.add("ARGS");
        vector.add("ENV");
        vector.add("RUN");
        vector.add("JOBENV");
        Long l2 = sDMSKillJob.getId(systemEnvironment);
        long l3 = sDMSKillJob.getSeVersion(systemEnvironment);
        sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSKillJob.getSeId(systemEnvironment), l3);
        sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, sDMSKillJob.getSmeId(systemEnvironment));
        vector2.add(l2);
        String string3 = sDMSKillJob.getCommandline(systemEnvironment);
        if (string3 == null) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            sDMSKillJob.setErrorMsg(systemEnvironment, "Missing run program");
            this.delFromQueue(systemEnvironment, l2);
            return false;
        }
        String string4 = sDMSSchedulingEntity.getWorkdir(systemEnvironment);
        if (string4 != null) {
            string4 = string4.trim();
        }
        if ((string2 = sDMSKillJob.getLogfile(systemEnvironment)) != null) {
            string2 = string2.trim();
        }
        if ((string = sDMSKillJob.getErrlogfile(systemEnvironment)) != null) {
            string = string.trim();
        }
        if (string4 != null) {
            stringReader = new StringReader(string4);
            try {
                vector3 = this.cmdlineScan(systemEnvironment, stringReader, sDMSSubmittedEntity, sDMSKillJob, l2, "workdir", "Working Directory Name is empty");
            }
            catch (CommonErrorException commonErrorException) {
                return false;
            }
            string4 = (String)vector3.get(0);
        }
        vector2.add(string4);
        string2 = sDMSKillJob.getLogfile(systemEnvironment);
        vector2.add(string2);
        vector2.add(new Boolean(true));
        string = sDMSKillJob.getErrlogfile(systemEnvironment);
        vector2.add(string);
        vector2.add(new Boolean(true));
        stringReader = new StringReader(string3);
        try {
            vector3 = this.cmdlineScan(systemEnvironment, stringReader, sDMSSubmittedEntity, sDMSKillJob, l2, "run/rerun Program", "Run Program missing");
        }
        catch (CommonErrorException commonErrorException) {
            return false;
        }
        String string5 = (String)vector3.get(0);
        vector2.add(string5);
        vector3.remove(0);
        vector2.add(vector3);
        String string6 = this.renderCmdLine(string5, vector3);
        sDMSKillJob.setCommandline(systemEnvironment, string6);
        this.fillEnvironment(systemEnvironment, sDMSSubmittedEntity, vector2);
        vector2.add(new Integer(0));
        sDMSKillJob.setState(systemEnvironment, new Integer(5));
        sDMSKillJob.setScopeId(systemEnvironment, l);
        Vector<String> vector4 = new Vector<String>();
        Vector vector5 = SDMSParameterDefinitionTable.idx_seId.getVector(systemEnvironment, sDMSSchedulingEntity.getId(systemEnvironment));
        for (Object object2 : vector5) {
            String string7 = ((SDMSParameterDefinitionProxyGeneric)object2).getExportName(systemEnvironment);
            if (string7 == null) continue;
            vector4.add(string7);
            vector4.add(sDMSSubmittedEntity.getVariableValue(systemEnvironment, ((SDMSParameterDefinitionProxyGeneric)object2).getName(systemEnvironment), false, "DEFAULT"));
        }
        vector2.add(vector4);
        object2 = SDMSRunnableQueueTable.idx_smeId.getVector(systemEnvironment, l2);
        for (int i = 0; i < ((Vector)object2).size(); ++i) {
            sDMSRunnableQueue = (SDMSRunnableQueue)((Vector)object2).get(i);
            if (sDMSRunnableQueue.getScopeId(systemEnvironment).equals(l)) {
                sDMSRunnableQueue.setState(systemEnvironment, new Integer(5));
                continue;
            }
            sDMSRunnableQueue.delete(systemEnvironment);
        }
        systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        return true;
    }

    private Vector cmdlineScan(SystemEnvironment systemEnvironment, StringReader stringReader, SDMSSubmittedEntity sDMSSubmittedEntity, SDMSProxy sDMSProxy, Long l, String string, String string2) throws SDMSException {
        Vector vector = null;
        SDMSMessage sDMSMessage = null;
        boolean bl = true;
        try {
            CmdLineScanner cmdLineScanner = new CmdLineScanner(stringReader);
            CmdLineParser cmdLineParser = new CmdLineParser();
            cmdLineParser.set(systemEnvironment, sDMSSubmittedEntity);
            vector = (Vector)cmdLineParser.yyparse(cmdLineScanner);
            if (vector == null) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03808071039", "String is empty"));
            }
            bl = false;
        }
        catch (IOException iOException) {
            sDMSMessage = new SDMSMessage(systemEnvironment, "03207100213", "I/O Error parsing $1", (Object)string);
        }
        catch (NotFoundException notFoundException) {
            sDMSMessage = new SDMSMessage(systemEnvironment, "03209161709", "Error resolving Parameter: $1", (Object)notFoundException);
        }
        catch (CommonErrorException commonErrorException) {
            sDMSMessage = new SDMSMessage(systemEnvironment, "03302291400", "Error parsing $1: $2", (Object)string, (Object)commonErrorException);
        }
        catch (CmdLineParser.yyException yyException2) {
            sDMSMessage = new SDMSMessage(systemEnvironment, "03207100214", "Parse error while parsing $1", (Object)string);
        }
        catch (Error error) {
            sDMSMessage = new SDMSMessage(systemEnvironment, "03310101726", "Error Exception parsing $1", (Object)string);
        }
        catch (Exception exception) {
            sDMSMessage = new SDMSMessage(systemEnvironment, "03808071015", "Exception parsing $1", (Object)string);
        }
        if (vector == null && string2 != null && sDMSMessage == null) {
            sDMSMessage = new SDMSMessage(systemEnvironment, "03207100212", string2);
        }
        if (bl) {
            this.setToError(systemEnvironment, sDMSProxy, l, sDMSMessage);
            throw new CommonErrorException(sDMSMessage);
        }
        return vector;
    }

    void setToError(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy, Long l, SDMSMessage sDMSMessage) throws SDMSException {
        if (systemEnvironment.tx.subTxId > 0) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
        }
        if (sDMSProxy instanceof SDMSSubmittedEntity) {
            ((SDMSSubmittedEntity)sDMSProxy).setToError(systemEnvironment, sDMSMessage.toString());
        } else {
            ((SDMSKillJob)sDMSProxy).setToError(systemEnvironment, sDMSMessage.toString());
        }
        this.delFromQueue(systemEnvironment, l);
    }

    String renderCmdLine(String string, Vector vector) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        for (int i = 0; i < vector.size(); ++i) {
            stringBuffer.append(" \"");
            stringBuffer.append((String)vector.get(i));
            stringBuffer.append("\"");
        }
        return new String(stringBuffer);
    }

    void delFromQueue(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        Vector vector = SDMSRunnableQueueTable.idx_smeId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSRunnableQueue sDMSRunnableQueue = (SDMSRunnableQueue)vector.get(i);
            sDMSRunnableQueue.delete(systemEnvironment);
        }
    }

    void fillEnvironment(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, Vector vector) throws SDMSException {
        Vector vector2 = new Vector();
        for (int i = 0; i < SystemEnvironment.exportVariables.size(); ++i) {
            vector2.add(SystemEnvironment.exportVariables.get(i));
            try {
                vector2.add(sDMSSubmittedEntity.getVariableValue(systemEnvironment, (String)SystemEnvironment.exportVariables.get(i), false, "DEFAULT"));
                continue;
            }
            catch (NotFoundException notFoundException) {
                vector2.add("");
            }
        }
        vector.add(vector2);
    }

    void fillEnvironment(SystemEnvironment systemEnvironment, SDMSKillJob sDMSKillJob, Vector vector) throws SDMSException {
        Vector vector2 = new Vector();
        for (int i = 0; i < SystemEnvironment.exportVariables.size(); ++i) {
            vector2.add(SystemEnvironment.exportVariables.get(i));
            try {
                vector2.add(sDMSKillJob.getVariableValue(systemEnvironment, (String)SystemEnvironment.exportVariables.get(i)));
                continue;
            }
            catch (NotFoundException notFoundException) {
                vector2.add("");
            }
        }
        vector.add(vector2);
    }
}

