/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.repository.SDMSExitState;
import de.independit.scheduler.server.repository.SDMSExitStateDefinitionProxyGeneric;
import de.independit.scheduler.server.repository.SDMSExitStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSExitStateMapping;
import de.independit.scheduler.server.repository.SDMSExitStateMappingProfile;
import de.independit.scheduler.server.repository.SDMSExitStateMappingProfileTable;
import de.independit.scheduler.server.repository.SDMSExitStateMappingProxyGeneric;
import de.independit.scheduler.server.repository.SDMSExitStateMappingTable;
import de.independit.scheduler.server.repository.SDMSExitStateProfile;
import de.independit.scheduler.server.repository.SDMSExitStateProfileProxyGeneric;
import de.independit.scheduler.server.repository.SDMSExitStateProfileTable;
import de.independit.scheduler.server.repository.SDMSExitStateProxyGeneric;
import de.independit.scheduler.server.repository.SDMSExitStateTable;
import de.independit.scheduler.server.repository.SDMSExitStateTranslationProfile;
import de.independit.scheduler.server.repository.SDMSExitStateTranslationProfileProxyGeneric;
import de.independit.scheduler.server.repository.SDMSExitStateTranslationProfileTable;
import de.independit.scheduler.server.repository.SDMSFootprint;
import de.independit.scheduler.server.repository.SDMSFootprintProxyGeneric;
import de.independit.scheduler.server.repository.SDMSFootprintTable;
import de.independit.scheduler.server.repository.SDMSGroup;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSIgnoredDependency;
import de.independit.scheduler.server.repository.SDMSIgnoredDependencyProxyGeneric;
import de.independit.scheduler.server.repository.SDMSIgnoredDependencyTable;
import de.independit.scheduler.server.repository.SDMSInterval;
import de.independit.scheduler.server.repository.SDMSIntervalTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSNamedEnvironment;
import de.independit.scheduler.server.repository.SDMSNamedEnvironmentTable;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchy;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchyTable;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class ListJobDefinitionHierarchy
extends Node {
    Vector path;
    boolean expand;
    HashSet expandIds;
    HashMap stateStrings;

    public ListJobDefinitionHierarchy(Vector vector) {
        this.path = vector;
        this.expand = false;
        this.expandIds = null;
        this.txMode = 1;
        this.auditFlag = false;
    }

    public ListJobDefinitionHierarchy(Vector vector, HashSet hashSet) {
        this.path = vector;
        this.expand = true;
        this.expandIds = hashSet;
        this.txMode = 1;
        this.auditFlag = false;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        Object object;
        Comparable comparable;
        Comparable comparable2;
        SDMSOutputContainer sDMSOutputContainer = null;
        Vector<String> vector = new Vector<String>();
        this.stateStrings = new HashMap();
        vector.add("ID");
        vector.add("NAME");
        vector.add("OWNER");
        vector.add("TYPE");
        vector.add("RUN_PROGRAM");
        vector.add("RERUN_PROGRAM");
        vector.add("KILL_PROGRAM");
        vector.add("WORKDIR");
        vector.add("LOGFILE");
        vector.add("TRUNC_LOG");
        vector.add("ERRLOGFILE");
        vector.add("TRUNC_ERRLOG");
        vector.add("EXPECTED_RUNTIME");
        vector.add("GET_EXPECTED_RUNTIME");
        vector.add("PRIORITY");
        vector.add("SUBMIT_SUSPENDED");
        vector.add("MASTER_SUBMITTABLE");
        vector.add("SAME_NODE");
        vector.add("GANG_SCHEDULE");
        vector.add("DEPENDENCY_MODE");
        vector.add("ESP_NAME");
        vector.add("ESM_NAME");
        vector.add("ENV_NAME");
        vector.add("FP_NAME");
        vector.add("CHILDREN");
        vector.add("SH_ID");
        vector.add("IS_STATIC");
        vector.add("IS_DISABLED");
        vector.add("INT_NAME");
        vector.add("SH_PRIORITY");
        vector.add("SH_SUSPEND");
        vector.add("SH_ALIAS_NAME");
        vector.add("MERGE_MODE");
        vector.add("EST_NAME");
        vector.add("IGNORED_DEPENDENCIES");
        vector.add("HIERARCHY_PATH");
        vector.add("STATES");
        vector.add("PRIVS");
        sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, new SDMSMessage(systemEnvironment, "03201292007", "Job Definition Hierarchy"), vector);
        String string = (String)this.path.remove(this.path.size() - 1);
        SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.get(systemEnvironment, this.path, string);
        if (!sDMSSchedulingEntity.checkPrivileges(systemEnvironment, 0x10000000L)) {
            throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03402051434", "Insufficient privileges"));
        }
        Long l = sDMSSchedulingEntity.getId(systemEnvironment);
        Vector<Object> vector2 = new Vector<Object>();
        String string2 = sDMSSchedulingEntity.pathString(systemEnvironment);
        vector2.add(l);
        vector2.add(string2);
        SDMSGroup sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, sDMSSchedulingEntity.getOwnerId(systemEnvironment));
        vector2.add(sDMSGroup.getName(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getTypeAsString(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getRunProgram(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getRerunProgram(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getKillProgram(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getWorkdir(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getLogfile(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getTruncLog(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getErrlogfile(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getTruncErrlog(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getExpectedRuntime(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getGetExpectedRuntime(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getPriority(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getSubmitSuspended(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getMasterSubmittable(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getSameNode(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getGangSchedule(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getDependencyOperationAsString(systemEnvironment));
        Long l2 = sDMSSchedulingEntity.getEspId(systemEnvironment);
        SDMSExitStateProfile sDMSExitStateProfile = SDMSExitStateProfileTable.getObject(systemEnvironment, l2);
        vector2.add(sDMSExitStateProfile.getName(systemEnvironment));
        Long l3 = sDMSSchedulingEntity.getEsmpId(systemEnvironment);
        if (l3 != null) {
            comparable2 = SDMSExitStateMappingProfileTable.getObject(systemEnvironment, l3);
            vector2.add(comparable2.getName(systemEnvironment));
        } else {
            vector2.add("<default>");
        }
        comparable2 = sDMSSchedulingEntity.getNeId(systemEnvironment);
        if (comparable2 != null) {
            comparable = SDMSNamedEnvironmentTable.getObject(systemEnvironment, (Long)comparable2);
            vector2.add(comparable.getName(systemEnvironment));
        } else {
            vector2.add("<null>");
        }
        comparable = sDMSSchedulingEntity.getFpId(systemEnvironment);
        if (comparable != null) {
            object = SDMSFootprintTable.getObject(systemEnvironment, (Long)comparable);
            vector2.add(((SDMSFootprintProxyGeneric)object).getName(systemEnvironment));
        } else {
            vector2.add("<null>");
        }
        object = SDMSSchedulingHierarchyTable.idx_seParentId.getVector(systemEnvironment, l);
        vector2.add(new Integer(((Vector)object).size()));
        String string3 = "";
        vector2.add(string3);
        vector2.add(string3);
        vector2.add(string3);
        vector2.add(string3);
        vector2.add(string3);
        vector2.add(string3);
        vector2.add(string3);
        vector2.add(string3);
        vector2.add(string3);
        vector2.add(string3);
        vector2.add(string2);
        Integer n = sDMSSchedulingEntity.getType(systemEnvironment);
        SDMSKey sDMSKey = new SDMSKey(n, l2, l3, null);
        String string4 = (String)this.stateStrings.get(sDMSKey);
        if (string4 == null) {
            string4 = this.getStateString(systemEnvironment, n, l2, l3, null);
            this.stateStrings.put(sDMSKey, string4);
        }
        vector2.add(string4);
        vector2.add(sDMSSchedulingEntity.getPrivileges(systemEnvironment).toString());
        sDMSOutputContainer.addData(systemEnvironment, vector2);
        this.add_childs(systemEnvironment, sDMSOutputContainer, (Vector)object, string2);
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 34));
        this.result.setOutputContainer(sDMSOutputContainer);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "02204260958", "$1 Object(s) found", (Object)new Integer(sDMSOutputContainer.lines)));
    }

    private void add_childs(SystemEnvironment systemEnvironment, SDMSOutputContainer sDMSOutputContainer, Vector vector, String string) throws SDMSException {
        for (SDMSSchedulingHierarchy sDMSSchedulingHierarchy : vector) {
            Comparable comparable;
            Object object;
            SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSchedulingHierarchy.getSeChildId(systemEnvironment));
            String string2 = sDMSSchedulingEntity.pathString(systemEnvironment);
            Vector<Object> vector2 = new Vector<Object>();
            Long l = sDMSSchedulingEntity.getId(systemEnvironment);
            Long l2 = sDMSSchedulingHierarchy.getId(systemEnvironment);
            vector2.add(l);
            vector2.add(sDMSSchedulingEntity.pathString(systemEnvironment));
            SDMSGroup sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, sDMSSchedulingEntity.getOwnerId(systemEnvironment));
            vector2.add(sDMSGroup.getName(systemEnvironment));
            String string3 = sDMSSchedulingEntity.getTypeAsString(systemEnvironment);
            vector2.add(string3);
            vector2.add(sDMSSchedulingEntity.getRunProgram(systemEnvironment));
            vector2.add(sDMSSchedulingEntity.getRerunProgram(systemEnvironment));
            vector2.add(sDMSSchedulingEntity.getKillProgram(systemEnvironment));
            vector2.add(sDMSSchedulingEntity.getWorkdir(systemEnvironment));
            vector2.add(sDMSSchedulingEntity.getLogfile(systemEnvironment));
            vector2.add(sDMSSchedulingEntity.getTruncLog(systemEnvironment));
            vector2.add(sDMSSchedulingEntity.getErrlogfile(systemEnvironment));
            vector2.add(sDMSSchedulingEntity.getTruncErrlog(systemEnvironment));
            vector2.add(sDMSSchedulingEntity.getExpectedRuntime(systemEnvironment));
            vector2.add(sDMSSchedulingEntity.getGetExpectedRuntime(systemEnvironment));
            vector2.add(sDMSSchedulingEntity.getPriority(systemEnvironment));
            vector2.add(sDMSSchedulingEntity.getSubmitSuspended(systemEnvironment));
            vector2.add(sDMSSchedulingEntity.getMasterSubmittable(systemEnvironment));
            vector2.add(sDMSSchedulingEntity.getSameNode(systemEnvironment));
            vector2.add(sDMSSchedulingEntity.getGangSchedule(systemEnvironment));
            vector2.add(sDMSSchedulingEntity.getDependencyOperationAsString(systemEnvironment));
            Long l3 = sDMSSchedulingEntity.getEspId(systemEnvironment);
            SDMSExitStateProfile sDMSExitStateProfile = SDMSExitStateProfileTable.getObject(systemEnvironment, l3);
            vector2.add(sDMSExitStateProfile.getName(systemEnvironment));
            Long l4 = sDMSSchedulingEntity.getEsmpId(systemEnvironment);
            if (l4 != null) {
                SDMSExitStateMappingProfile sDMSExitStateMappingProfile = SDMSExitStateMappingProfileTable.getObject(systemEnvironment, l4);
                vector2.add(sDMSExitStateMappingProfile.getName(systemEnvironment));
            } else {
                vector2.add("<default>");
            }
            Long l5 = sDMSSchedulingEntity.getNeId(systemEnvironment);
            if (l5 != null) {
                SDMSNamedEnvironment sDMSNamedEnvironment = SDMSNamedEnvironmentTable.getObject(systemEnvironment, l5);
                vector2.add(sDMSNamedEnvironment.getName(systemEnvironment));
            } else {
                vector2.add("<null>");
            }
            Long l6 = sDMSSchedulingEntity.getFpId(systemEnvironment);
            if (l6 != null) {
                SDMSFootprint sDMSFootprint = SDMSFootprintTable.getObject(systemEnvironment, l6);
                vector2.add(sDMSFootprint.getName(systemEnvironment));
            } else {
                vector2.add("<null>");
            }
            Vector vector3 = SDMSSchedulingHierarchyTable.idx_seParentId.getVector(systemEnvironment, l);
            vector2.add(new Integer(vector3.size()));
            vector2.add(l2);
            vector2.add(sDMSSchedulingHierarchy.getIsStatic(systemEnvironment));
            vector2.add(sDMSSchedulingHierarchy.getIsDisabled(systemEnvironment));
            Long l7 = sDMSSchedulingHierarchy.getIntId(systemEnvironment);
            if (l7 != null) {
                SDMSInterval sDMSInterval = SDMSIntervalTable.getObject(systemEnvironment, l7);
                vector2.add(sDMSInterval.getName(systemEnvironment));
            } else {
                vector2.add("<null>");
            }
            vector2.add(sDMSSchedulingHierarchy.getPriority(systemEnvironment));
            vector2.add(sDMSSchedulingHierarchy.getSuspendAsString(systemEnvironment));
            vector2.add(sDMSSchedulingHierarchy.getAliasName(systemEnvironment));
            vector2.add(sDMSSchedulingHierarchy.getMergeModeAsString(systemEnvironment));
            Long l8 = sDMSSchedulingHierarchy.getEstpId(systemEnvironment);
            if (l8 != null) {
                object = SDMSExitStateTranslationProfileTable.getObject(systemEnvironment, l8);
                vector2.add(((SDMSExitStateTranslationProfileProxyGeneric)object).getName(systemEnvironment));
            } else {
                vector2.add("<null>");
            }
            object = SDMSIgnoredDependencyTable.idx_shId.getVector(systemEnvironment, l2);
            String string4 = "";
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                comparable = (SDMSIgnoredDependency)((Vector)object).get(i);
                stringBuffer.append(string4);
                stringBuffer.append(((SDMSIgnoredDependencyProxyGeneric)comparable).getDdName(systemEnvironment));
                string4 = ",";
            }
            vector2.add(new String(stringBuffer));
            String string5 = string + ':' + string2;
            vector2.add(string5);
            comparable = sDMSSchedulingEntity.getType(systemEnvironment);
            SDMSKey sDMSKey = new SDMSKey(comparable, l3, l4, l8);
            String string6 = (String)this.stateStrings.get(sDMSKey);
            if (string6 == null) {
                string6 = this.getStateString(systemEnvironment, (Integer)comparable, l3, l4, l8);
                this.stateStrings.put(sDMSKey, string6);
            }
            vector2.add(string6);
            SDMSPrivilege sDMSPrivilege = sDMSSchedulingEntity.getPrivileges(systemEnvironment);
            vector2.add(sDMSPrivilege.toString());
            sDMSOutputContainer.addData(systemEnvironment, vector2);
            if (!this.expand || !sDMSPrivilege.can(0x10000000L) || this.expandIds != null && !this.expandIds.contains(l2)) continue;
            this.add_childs(systemEnvironment, sDMSOutputContainer, vector3, string5);
        }
    }

    private String getStateString(SystemEnvironment systemEnvironment, int n, Long l, Long l2, Long l3) throws SDMSException {
        Object object;
        Object object2;
        Serializable serializable;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Long l4 = l2;
        HashSet<Long> hashSet = new HashSet<Long>();
        if (n == 1) {
            if (l4 == null) {
                object6 = SDMSExitStateProfileTable.getObject(systemEnvironment, l);
                l4 = ((SDMSExitStateProfileProxyGeneric)object6).getDefaultEsmpId(systemEnvironment);
            }
            object6 = SDMSExitStateMappingTable.idx_esmpId.getVector(systemEnvironment, l4);
            object5 = ((Vector)object6).iterator();
            while (object5.hasNext()) {
                object4 = (SDMSExitStateMapping)object5.next();
                hashSet.add(((SDMSExitStateMappingProxyGeneric)object4).getEsdId(systemEnvironment));
            }
        }
        object6 = SDMSExitStateTable.idx_espId.getVector(systemEnvironment, l);
        object5 = new Vector();
        object4 = null;
        SDMSExitStateTranslationProfile sDMSExitStateTranslationProfile = null;
        if (l3 != null) {
            sDMSExitStateTranslationProfile = SDMSExitStateTranslationProfileTable.getObject(systemEnvironment, l3);
        }
        Iterator iterator = ((Vector)object6).iterator();
        while (iterator.hasNext()) {
            Long l5;
            object3 = (SDMSExitState)iterator.next();
            serializable = ((SDMSExitStateProxyGeneric)object3).getEsdId(systemEnvironment);
            String string = null;
            String string2 = null;
            if (!((SDMSExitStateProxyGeneric)object3).getIsFinal(systemEnvironment).booleanValue()) continue;
            object2 = SDMSExitStateDefinitionTable.getObject(systemEnvironment, (Long)serializable);
            string = ((SDMSExitStateDefinitionProxyGeneric)object2).getName(systemEnvironment);
            if (sDMSExitStateTranslationProfile != null && !(string2 = ((SDMSExitStateDefinitionProxyGeneric)(object = SDMSExitStateDefinitionTable.getObject(systemEnvironment, l5 = sDMSExitStateTranslationProfile.translate(systemEnvironment, (Long)serializable)))).getName(systemEnvironment)).equals(string)) {
                string = string + ">" + string2;
            }
            if (!hashSet.contains(serializable)) {
                string = "(" + string + ")";
            }
            Vector<Object> vector = new Vector<Object>();
            vector.add(string);
            vector.add(((SDMSExitStateProxyGeneric)object3).getPreference(systemEnvironment));
            ((Vector)object5).add(vector);
            if (!((SDMSExitStateProxyGeneric)object3).getIsUnreachable(systemEnvironment).booleanValue()) continue;
            object4 = string;
        }
        Collections.sort(object5, new Comparator(){

            public int compare(Object object, Object object2) {
                int n;
                Vector vector = (Vector)object;
                Vector vector2 = (Vector)object2;
                int n2 = (Integer)vector.get(1);
                if (n2 != (n = ((Integer)vector2.get(1)).intValue())) {
                    if (n2 < n) {
                        return -1;
                    }
                    return 1;
                }
                return 0;
            }

            public boolean equals(Object object, Object object2) {
                int n;
                Vector vector = (Vector)object;
                Vector vector2 = (Vector)object2;
                int n2 = (Integer)vector.get(1);
                return n2 == (n = ((Integer)vector2.get(1)).intValue());
            }
        });
        object3 = "";
        object2 = "";
        object = ((Vector)object5).iterator();
        while (object.hasNext()) {
            serializable = (Vector)object.next();
            object3 = (String)object3 + (String)object2 + (String)((Vector)serializable).get(0);
            object2 = ",";
        }
        if (object4 != null) {
            object3 = (String)object3 + ":" + (String)object4;
        }
        return object3;
    }
}

