/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObjectMonitorParameter;
import de.independit.scheduler.server.repository.SDMSObjectMonitorParameterTable;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSWatchType;
import de.independit.scheduler.server.repository.SDMSWatchTypeParameterProxyGeneric;
import java.util.Vector;

public abstract class ManipObjectMonitor
extends Node {
    public static final String __version = "@(#) $Id: ManipObjectMonitor.java,v 2.1.4.2 2013/03/19 17:16:48 ronald Exp $";

    protected void processParams(SystemEnvironment systemEnvironment, WithHash withHash, Vector vector, Long l, SDMSWatchType sDMSWatchType) throws SDMSException {
        if (withHash == null) {
            withHash = new WithHash();
        }
        for (Object object : vector) {
            if (((SDMSWatchTypeParameterProxyGeneric)object).getType(systemEnvironment) != 1) continue;
            SDMSObjectMonitorParameter sDMSObjectMonitorParameter = null;
            try {
                sDMSObjectMonitorParameter = SDMSObjectMonitorParameterTable.idx_omId_wtpId_getUnique(systemEnvironment, new SDMSKey(l, ((SDMSProxy)object).getId(systemEnvironment)));
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            String string = (String)withHash.get(((SDMSWatchTypeParameterProxyGeneric)object).getName(systemEnvironment));
            if (string != null) {
                string = "=" + string;
                if (sDMSObjectMonitorParameter == null) {
                    SDMSObjectMonitorParameterTable.table.create(systemEnvironment, string, l, ((SDMSProxy)object).getId(systemEnvironment));
                } else {
                    sDMSObjectMonitorParameter.setValue(systemEnvironment, string);
                }
            } else if (withHash.containsKey(((SDMSWatchTypeParameterProxyGeneric)object).getName(systemEnvironment))) {
                if (((SDMSWatchTypeParameterProxyGeneric)object).getDefaultValue(systemEnvironment) == null) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02108241452", "config parameter $1 has no default", (Object)((SDMSWatchTypeParameterProxyGeneric)object).getName(systemEnvironment)));
                }
                if (sDMSObjectMonitorParameter != null) {
                    sDMSObjectMonitorParameter.delete(systemEnvironment);
                }
            } else if (sDMSObjectMonitorParameter == null && ((SDMSWatchTypeParameterProxyGeneric)object).getDefaultValue(systemEnvironment) == null) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02108241730", "value for config parameter $1 is missing", (Object)((SDMSWatchTypeParameterProxyGeneric)object).getName(systemEnvironment)));
            }
            withHash.remove(((SDMSWatchTypeParameterProxyGeneric)object).getName(systemEnvironment));
        }
        if (!withHash.isEmpty()) {
            Object object;
            object = (String)withHash.keySet().iterator().next();
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02108241638", "no config parameter $1 defined for watch type $2", object, (Object)sDMSWatchType.getName(systemEnvironment)));
        }
    }
}

